/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.admin.gsa;

import com.gigaspaces.grid.gsa.GSProcessOptions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class LookupServiceOptions {
    private final List<String> vmInputArguments = new ArrayList<String>();
    private boolean overrideVmInputArguments = false;
    private boolean useScript = false;
    private final Map<String, String> environmentVariables = new HashMap<String, String>();

    public LookupServiceOptions useScript() {
        this.useScript = true;
        return this;
    }

    public LookupServiceOptions overrideVmInputArguments() {
        this.overrideVmInputArguments = true;
        return this;
    }

    public LookupServiceOptions vmInputArgument(String vmInputArgument) {
        this.vmInputArguments.add(vmInputArgument);
        return this;
    }

    public LookupServiceOptions environmentVariable(String name, String value) {
        this.environmentVariables.put(name, value);
        return this;
    }

    public GSProcessOptions getOptions() {
        GSProcessOptions options = new GSProcessOptions("lus");
        options.setUseScript(this.useScript);
        if (this.overrideVmInputArguments) {
            options.setVmInputArguments(this.vmInputArguments.toArray(new String[this.vmInputArguments.size()]));
        } else {
            options.setVmAppendableInputArguments(this.vmInputArguments.toArray(new String[this.vmInputArguments.size()]));
        }
        options.setEnvironmentVariables(this.environmentVariables);
        return options;
    }
}

