/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.admin.internal.admin;

import com.gigaspaces.grid.gsa.AgentProcessesDetails;
import com.gigaspaces.grid.gsa.GSA;
import com.gigaspaces.grid.gsm.PUDetails;
import com.gigaspaces.grid.gsm.PUsDetails;
import com.gigaspaces.internal.jvm.JVMDetails;
import com.gigaspaces.internal.os.OSDetails;
import com.gigaspaces.internal.utils.StringUtils;
import com.gigaspaces.internal.utils.concurrent.GSThreadFactory;
import com.gigaspaces.lrmi.nio.info.NIODetails;
import com.gigaspaces.security.AuthenticationException;
import com.gigaspaces.security.SecurityException;
import com.gigaspaces.security.directory.CredentialsProvider;
import com.gigaspaces.security.service.SecuredService;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import net.jini.core.discovery.LookupLocator;
import net.jini.core.lookup.ServiceID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jini.rio.monitor.ProvisionLifeCycleEvent;
import org.jini.rio.monitor.ServiceFaultDetectionEvent;
import org.jini.rio.monitor.event.Event;
import org.jini.rio.monitor.event.Events;
import org.openspaces.admin.AdminEventListener;
import org.openspaces.admin.AdminException;
import org.openspaces.admin.GridComponent;
import org.openspaces.admin.alert.AlertManager;
import org.openspaces.admin.application.Application;
import org.openspaces.admin.application.Applications;
import org.openspaces.admin.dump.CompoundDumpResult;
import org.openspaces.admin.dump.DumpGeneratedListener;
import org.openspaces.admin.dump.DumpProvider;
import org.openspaces.admin.dump.DumpResult;
import org.openspaces.admin.esm.ElasticServiceManagers;
import org.openspaces.admin.gateway.Gateway;
import org.openspaces.admin.gateway.GatewayProcessingUnit;
import org.openspaces.admin.gateway.GatewayProcessingUnits;
import org.openspaces.admin.gateway.Gateways;
import org.openspaces.admin.gateway.InternalGateways;
import org.openspaces.admin.gsa.GridServiceAgent;
import org.openspaces.admin.gsa.GridServiceAgents;
import org.openspaces.admin.gsc.GridServiceContainers;
import org.openspaces.admin.gsm.GridServiceManager;
import org.openspaces.admin.gsm.GridServiceManagers;
import org.openspaces.admin.internal.admin.AdminClosedException;
import org.openspaces.admin.internal.admin.InternalAdmin;
import org.openspaces.admin.internal.alert.DefaultAlertManager;
import org.openspaces.admin.internal.application.DefaultApplication;
import org.openspaces.admin.internal.application.DefaultApplications;
import org.openspaces.admin.internal.application.InternalApplication;
import org.openspaces.admin.internal.application.InternalApplications;
import org.openspaces.admin.internal.discovery.DiscoveryService;
import org.openspaces.admin.internal.dump.InternalOverviewBuilder;
import org.openspaces.admin.internal.esm.DefaultElasticServiceManagers;
import org.openspaces.admin.internal.esm.InternalElasticServiceManager;
import org.openspaces.admin.internal.esm.InternalElasticServiceManagers;
import org.openspaces.admin.internal.gateway.DefaultGateway;
import org.openspaces.admin.internal.gateway.DefaultGatewayProcessingUnit;
import org.openspaces.admin.internal.gateway.DefaultGatewayProcessingUnits;
import org.openspaces.admin.internal.gateway.DefaultGateways;
import org.openspaces.admin.internal.gateway.InternalGatewayProcessingUnits;
import org.openspaces.admin.internal.gsa.DefaultGridServiceAgents;
import org.openspaces.admin.internal.gsa.InternalGridServiceAgent;
import org.openspaces.admin.internal.gsa.InternalGridServiceAgents;
import org.openspaces.admin.internal.gsc.DefaultGridServiceContainers;
import org.openspaces.admin.internal.gsc.InternalGridServiceContainer;
import org.openspaces.admin.internal.gsc.InternalGridServiceContainers;
import org.openspaces.admin.internal.gsm.DefaultGridServiceManagers;
import org.openspaces.admin.internal.gsm.InternalGridServiceManager;
import org.openspaces.admin.internal.gsm.InternalGridServiceManagers;
import org.openspaces.admin.internal.lus.DefaultLookupServices;
import org.openspaces.admin.internal.lus.InternalLookupService;
import org.openspaces.admin.internal.lus.InternalLookupServices;
import org.openspaces.admin.internal.machine.DefaultMachine;
import org.openspaces.admin.internal.machine.DefaultMachines;
import org.openspaces.admin.internal.machine.InternalMachine;
import org.openspaces.admin.internal.machine.InternalMachineAware;
import org.openspaces.admin.internal.machine.InternalMachines;
import org.openspaces.admin.internal.os.DefaultOperatingSystem;
import org.openspaces.admin.internal.os.DefaultOperatingSystems;
import org.openspaces.admin.internal.os.InternalOperatingSystem;
import org.openspaces.admin.internal.os.InternalOperatingSystemInfoProvider;
import org.openspaces.admin.internal.os.InternalOperatingSystems;
import org.openspaces.admin.internal.pu.DefaultAdminProcessingUnitInstances;
import org.openspaces.admin.internal.pu.DefaultProcessingUnit;
import org.openspaces.admin.internal.pu.DefaultProcessingUnitInstances;
import org.openspaces.admin.internal.pu.DefaultProcessingUnits;
import org.openspaces.admin.internal.pu.InternalProcessingUnit;
import org.openspaces.admin.internal.pu.InternalProcessingUnitInstance;
import org.openspaces.admin.internal.pu.InternalProcessingUnitInstances;
import org.openspaces.admin.internal.pu.InternalProcessingUnits;
import org.openspaces.admin.internal.pu.events.InternalProcessingUnitInstanceAddedEventManager;
import org.openspaces.admin.internal.space.DefaultSpace;
import org.openspaces.admin.internal.space.DefaultSpaces;
import org.openspaces.admin.internal.space.InternalSpace;
import org.openspaces.admin.internal.space.InternalSpaceInstance;
import org.openspaces.admin.internal.space.InternalSpaces;
import org.openspaces.admin.internal.support.EventRegistrationHelper;
import org.openspaces.admin.internal.support.InternalAgentGridComponent;
import org.openspaces.admin.internal.support.NetworkExceptionHelper;
import org.openspaces.admin.internal.transport.DefaultTransport;
import org.openspaces.admin.internal.transport.DefaultTransports;
import org.openspaces.admin.internal.transport.InternalTransport;
import org.openspaces.admin.internal.transport.InternalTransportInfoProvider;
import org.openspaces.admin.internal.transport.InternalTransports;
import org.openspaces.admin.internal.vm.DefaultVirtualMachine;
import org.openspaces.admin.internal.vm.DefaultVirtualMachines;
import org.openspaces.admin.internal.vm.InternalVirtualMachine;
import org.openspaces.admin.internal.vm.InternalVirtualMachineInfoProvider;
import org.openspaces.admin.internal.vm.InternalVirtualMachines;
import org.openspaces.admin.internal.zone.DefaultZone;
import org.openspaces.admin.internal.zone.DefaultZones;
import org.openspaces.admin.internal.zone.InternalZone;
import org.openspaces.admin.internal.zone.InternalZoneAware;
import org.openspaces.admin.internal.zone.InternalZones;
import org.openspaces.admin.lus.LookupServices;
import org.openspaces.admin.machine.Machine;
import org.openspaces.admin.machine.Machines;
import org.openspaces.admin.metrics.MetricProvider;
import org.openspaces.admin.os.OperatingSystem;
import org.openspaces.admin.os.OperatingSystems;
import org.openspaces.admin.pu.ProcessingUnit;
import org.openspaces.admin.pu.ProcessingUnitInstance;
import org.openspaces.admin.pu.ProcessingUnitInstanceStatistics;
import org.openspaces.admin.pu.ProcessingUnitType;
import org.openspaces.admin.pu.ProcessingUnits;
import org.openspaces.admin.pu.elastic.events.ElasticProcessingUnitEvent;
import org.openspaces.admin.space.Space;
import org.openspaces.admin.space.SpaceInstance;
import org.openspaces.admin.space.Spaces;
import org.openspaces.admin.transport.TransportDetails;
import org.openspaces.admin.transport.Transports;
import org.openspaces.admin.vm.VirtualMachine;
import org.openspaces.admin.vm.VirtualMachines;
import org.openspaces.admin.zone.Zone;
import org.openspaces.admin.zone.ZoneAware;
import org.openspaces.admin.zone.Zones;
import org.openspaces.core.gateway.GatewayServiceDetails;
import org.openspaces.core.gateway.GatewayUtils;
import org.openspaces.core.properties.BeanLevelProperties;
import org.openspaces.core.space.SpaceServiceDetails;
import org.openspaces.pu.container.standalone.StandaloneServiceDetails;
import org.openspaces.pu.service.ServiceMonitors;
import org.openspaces.security.AdminFilter;
import org.openspaces.security.AdminFilterHelper;

public class DefaultAdmin
implements InternalAdmin {
    private static final Log lifecycleLogger = LogFactory.getLog((String)"org.openspaces.admin.lifecycle");
    private static final Log logger = LogFactory.getLog(DefaultAdmin.class);
    private static final int DEFAULT_EVENT_LISTENER_THREADS = 10;
    private static final ThreadPoolExecutor.DiscardPolicy DEFAULT_EVENT_LISTENER_REJECTED_POLICY = new ThreadPoolExecutor.DiscardPolicy();
    private static final int DEFAULT_STATE_CHANGE_THREADS = 10;
    private final ScheduledThreadPoolExecutor scheduledExecutorService;
    private final DiscoveryService discoveryService;
    private final InternalLookupServices lookupServices = new DefaultLookupServices(this);
    private final InternalZones zones = new DefaultZones(this);
    private final InternalApplications applications = new DefaultApplications(this);
    private final InternalMachines machines = new DefaultMachines(this);
    private final InternalGridServiceAgents gridServiceAgents = new DefaultGridServiceAgents(this);
    private final InternalGridServiceManagers gridServiceManagers = new DefaultGridServiceManagers(this);
    private final InternalElasticServiceManagers elasticServiceManagers = new DefaultElasticServiceManagers(this);
    private final InternalGridServiceContainers gridServiceContainers = new DefaultGridServiceContainers(this);
    private final InternalGateways gateways = new DefaultGateways(this);
    private final InternalTransports transports = new DefaultTransports(this);
    private final InternalOperatingSystems operatingSystems = new DefaultOperatingSystems(this);
    private final InternalVirtualMachines virtualMachines = new DefaultVirtualMachines(this);
    private final InternalProcessingUnits processingUnits = new DefaultProcessingUnits(this);
    private final InternalGatewayProcessingUnits gatewayProcessingUnits = new DefaultGatewayProcessingUnits(this);
    private final InternalProcessingUnitInstances processingUnitInstances = new DefaultProcessingUnitInstances(this);
    private final Map<String, InternalAgentGridComponent> orphanedAgentGridComponents = new ConcurrentHashMap<String, InternalAgentGridComponent>();
    private final InternalSpaces spaces = new DefaultSpaces(this);
    private final ExecutorService[] eventsExecutorServices;
    private final ExecutorService longRunningExecutorService;
    private LinkedList<Runnable>[] eventsQueue;
    private LinkedList<Runnable>[] scheduleMonitorCorrelatedEventsQueue;
    private volatile long scheduledProcessingUnitMonitorInterval = 1000L;
    private volatile long scheduledAgentProcessesMonitorInterval = 5000L;
    private volatile long scheduledSpaceMonitorInterval = 1000L;
    private volatile Future<?> scheduledAgentProcessessMonitorFuture;
    private volatile Future<?> scheduledProcessingUnitMonitorFuture;
    private boolean scheduledStatisticsMonitor = false;
    private final AtomicBoolean closeStarted = new AtomicBoolean(false);
    private final AtomicBoolean closeEnded = new AtomicBoolean(false);
    private volatile CredentialsProvider credentialsProvider;
    private long defaultTimeout = Long.MAX_VALUE;
    private TimeUnit defaultTimeoutTimeUnit = TimeUnit.MILLISECONDS;
    private final boolean singleThreadedEventListeners;
    private long executorSingleThreadId;
    private volatile int statisticsHistorySize = 120;
    private volatile long statisticsInterval = 5000L;
    private final AlertManager alertManager;
    private final boolean useDaemonThreads;
    private final AtomicInteger eventListenersCount = new AtomicInteger();
    private AdminFilter adminFilter;
    private final DefaultAdminProcessingUnitInstances adminProcessingUnitInstances = new DefaultAdminProcessingUnitInstances();
    private final Map<ProcessingUnit, Space> removedSpacesPerProcessingUnit = new HashMap<ProcessingUnit, Space>();

    public DefaultAdmin(boolean useDaemonThreads, boolean singleThreadedEventListeners) {
        this.useDaemonThreads = useDaemonThreads;
        this.singleThreadedEventListeners = singleThreadedEventListeners;
        this.discoveryService = new DiscoveryService(this);
        this.alertManager = new DefaultAlertManager(this);
        this.longRunningExecutorService = this.createThreadPoolExecutor("admin-state-change-thread", 10);
        this.scheduledExecutorService = this.createScheduledThreadPoolExecutor("admin-scheduled-executor-thread", 5);
        int numberOfThreads = singleThreadedEventListeners ? 1 : 10;
        this.eventsExecutorServices = new ExecutorService[numberOfThreads];
        this.eventsQueue = new LinkedList[numberOfThreads];
        this.scheduleMonitorCorrelatedEventsQueue = new LinkedList[numberOfThreads];
        for (int i = 0; i < numberOfThreads; ++i) {
            this.eventsExecutorServices[i] = this.createThreadPoolExecutor("admin-event-executor-thread", 1, singleThreadedEventListeners);
            this.eventsQueue[i] = new LinkedList();
            this.scheduleMonitorCorrelatedEventsQueue[i] = new LinkedList();
        }
        if (lifecycleLogger.isTraceEnabled()) {
            lifecycleLogger.trace((Object)("Admin created. hashCode=" + this.hashCode() + ". Calling method stack trace:" + StringUtils.NEW_LINE + StringUtils.getCurrentStackTrace()));
        } else if (lifecycleLogger.isDebugEnabled()) {
            lifecycleLogger.debug((Object)("Admin created. hashCode=" + this.hashCode()));
        }
    }

    @Override
    public Log getAdminLogger() {
        return logger;
    }

    @Override
    public String[] getGroups() {
        return this.discoveryService.getGroups();
    }

    @Override
    public LookupLocator[] getLocators() {
        return this.discoveryService.getLocators();
    }

    @Override
    public void login(SecuredService service) throws SecurityException, RemoteException {
        if (service.isServiceSecured()) {
            if (this.credentialsProvider == null) {
                throw new AuthenticationException("No authentication details were supplied");
            }
            service.login(this.credentialsProvider);
        }
    }

    public void setCredentialsProvider(CredentialsProvider credentialsProvider) {
        this.credentialsProvider = credentialsProvider;
    }

    @Override
    public CredentialsProvider getCredentialsProvider() {
        return this.credentialsProvider;
    }

    public void addGroup(String group) {
        this.discoveryService.addGroup(group);
    }

    public void addLocator(String locator) {
        this.discoveryService.addLocator(locator);
    }

    @Override
    public void setStatisticsInterval(long interval, TimeUnit timeUnit) {
        this.statisticsInterval = timeUnit.toMillis(interval);
        this.spaces.setStatisticsInterval(interval, timeUnit);
        this.virtualMachines.setStatisticsInterval(interval, timeUnit);
        this.transports.setStatisticsInterval(interval, timeUnit);
        this.operatingSystems.setStatisticsInterval(interval, timeUnit);
        this.processingUnits.setStatisticsInterval(interval, timeUnit);
    }

    @Override
    public void setStatisticsHistorySize(int historySize) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("setStatisticsHistorySize=" + historySize));
        }
        this.statisticsHistorySize = historySize;
        this.spaces.setStatisticsHistorySize(historySize);
        this.virtualMachines.setStatisticsHistorySize(historySize);
        this.transports.setStatisticsHistorySize(historySize);
        this.operatingSystems.setStatisticsHistorySize(historySize);
        this.processingUnits.setStatisticsHistorySize(historySize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startStatisticsMonitor() {
        this.assertStateChangesPermitted();
        DefaultAdmin defaultAdmin = this;
        synchronized (defaultAdmin) {
            this.scheduledStatisticsMonitor = true;
            this.spaces.startStatisticsMonitor();
            this.virtualMachines.startStatisticsMonitor();
            this.transports.startStatisticsMonitor();
            this.operatingSystems.startStatisticsMonitor();
            this.processingUnits.startStatisticsMonitor();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopStatisticsMonitor() {
        this.assertStateChangesPermitted();
        DefaultAdmin defaultAdmin = this;
        synchronized (defaultAdmin) {
            this.scheduledStatisticsMonitor = false;
            this.spaces.stopStatisticsMonitor();
            this.virtualMachines.stopStatisticsMonitor();
            this.transports.stopStatisticsMonitor();
            this.operatingSystems.stopStatisticsMonitor();
            this.processingUnits.stopStatisticsMonitor();
        }
    }

    @Override
    public boolean isMonitoring() {
        return this.scheduledStatisticsMonitor;
    }

    public void begin() {
        this.discoveryService.start();
        this.scheduledProcessingUnitMonitorFuture = this.scheduleWithFixedDelay(new ScheduledProcessingUnitMonitor(), this.scheduledProcessingUnitMonitorInterval, this.scheduledProcessingUnitMonitorInterval, TimeUnit.MILLISECONDS);
        this.scheduledAgentProcessessMonitorFuture = this.scheduleWithFixedDelay(new ScheduledAgentProcessessMonitor(), this.scheduledAgentProcessesMonitorInterval, this.scheduledAgentProcessesMonitorInterval, TimeUnit.MILLISECONDS);
        if (lifecycleLogger.isDebugEnabled()) {
            lifecycleLogger.debug((Object)("Admin started " + this.hashCode() + " discoveryService=" + this.discoveryService.toString(true)));
        }
    }

    private ScheduledThreadPoolExecutor createScheduledThreadPoolExecutor(String threadName, int numberOfThreads) {
        final ClassLoader correctClassLoader = Thread.currentThread().getContextClassLoader();
        ScheduledThreadPoolExecutor executorService = (ScheduledThreadPoolExecutor)Executors.newScheduledThreadPool(numberOfThreads, (ThreadFactory)new GSThreadFactory(threadName, this.useDaemonThreads){

            public Thread newThread(Runnable r) {
                Thread thread = super.newThread(r);
                thread.setContextClassLoader(correctClassLoader);
                return thread;
            }
        });
        return executorService;
    }

    private ThreadPoolExecutor createThreadPoolExecutor(String threadName, int numberOfThreads) {
        return this.createThreadPoolExecutor(threadName, numberOfThreads, false);
    }

    private ThreadPoolExecutor createThreadPoolExecutor(String threadName, int numberOfThreads, final boolean updateSingleThreadId) {
        final ClassLoader correctClassLoader = Thread.currentThread().getContextClassLoader();
        ThreadPoolExecutor executorService = (ThreadPoolExecutor)Executors.newFixedThreadPool(numberOfThreads, (ThreadFactory)new GSThreadFactory(threadName, this.useDaemonThreads){

            public Thread newThread(Runnable r) {
                Thread thread = super.newThread(r);
                thread.setContextClassLoader(correctClassLoader);
                if (updateSingleThreadId) {
                    DefaultAdmin.this.executorSingleThreadId = thread.getId();
                }
                return thread;
            }
        });
        executorService.setRejectedExecutionHandler(DEFAULT_EVENT_LISTENER_REJECTED_POLICY);
        return executorService;
    }

    @Override
    public void setProcessingUnitMonitorInterval(long interval, TimeUnit timeUnit) {
        if (this.closeStarted.get()) {
            throw new AdminClosedException();
        }
        this.scheduledProcessingUnitMonitorInterval = timeUnit.toMillis(interval);
        if (this.scheduledProcessingUnitMonitorFuture != null) {
            this.scheduledProcessingUnitMonitorFuture.cancel(false);
            this.scheduledProcessingUnitMonitorFuture = this.scheduleWithFixedDelay(new ScheduledProcessingUnitMonitor(), interval, interval, timeUnit);
        }
    }

    @Override
    public void setAgentProcessessMonitorInterval(long interval, TimeUnit timeUnit) {
        if (this.closeStarted.get()) {
            throw new AdminClosedException();
        }
        this.scheduledAgentProcessesMonitorInterval = timeUnit.toMillis(interval);
        if (this.scheduledAgentProcessessMonitorFuture != null) {
            this.scheduledAgentProcessessMonitorFuture.cancel(false);
            this.scheduledAgentProcessessMonitorFuture = this.scheduleWithFixedDelay(new ScheduledAgentProcessessMonitor(), interval, interval, timeUnit);
        }
    }

    @Override
    public long getScheduledSpaceMonitorInterval() {
        return this.scheduledSpaceMonitorInterval;
    }

    @Override
    public long getDefaultTimeout() {
        return this.defaultTimeout;
    }

    @Override
    public TimeUnit getDefaultTimeoutTimeUnit() {
        return this.defaultTimeoutTimeUnit;
    }

    public DiscoveryService getDiscoveryService() {
        return this.discoveryService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSpaceMonitorInterval(long interval, TimeUnit timeUnit) {
        this.assertStateChangesPermitted();
        DefaultAdmin defaultAdmin = this;
        synchronized (defaultAdmin) {
            this.scheduledSpaceMonitorInterval = timeUnit.toMillis(interval);
            this.spaces.refreshScheduledSpaceMonitors();
        }
    }

    @Override
    public ScheduledThreadPoolExecutor getScheduler() {
        return this.scheduledExecutorService;
    }

    @Override
    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
        if (this.closeStarted.get()) {
            throw new AdminClosedException();
        }
        return this.getScheduler().scheduleWithFixedDelay(this.toLoggerRunnable(command), initialDelay, delay, unit);
    }

    @Override
    public void setSchedulerCorePoolSize(int coreThreads) {
        this.scheduledExecutorService.setCorePoolSize(coreThreads);
    }

    @Override
    public void setDefaultTimeout(long timeout, TimeUnit timeUnit) {
        this.defaultTimeout = timeout;
        this.defaultTimeoutTimeUnit = timeUnit;
    }

    @Override
    public void close() {
        if (!this.closeStarted.compareAndSet(false, true)) {
            if (lifecycleLogger.isDebugEnabled()) {
                lifecycleLogger.debug((Object)("Not closing admin, since close() has already been called. hashCode()=" + this.hashCode()));
            }
            return;
        }
        if (lifecycleLogger.isDebugEnabled()) {
            lifecycleLogger.debug((Object)("Closing admin. hashCode=" + this.hashCode()));
        }
        this.discoveryService.stop();
        if (this.scheduledProcessingUnitMonitorFuture != null) {
            this.scheduledProcessingUnitMonitorFuture.cancel(true);
            this.scheduledProcessingUnitMonitorFuture = null;
        }
        if (this.scheduledAgentProcessessMonitorFuture != null) {
            this.scheduledAgentProcessessMonitorFuture.cancel(true);
            this.scheduledAgentProcessessMonitorFuture = null;
        }
        this.scheduledExecutorService.shutdownNow();
        for (ExecutorService executorService : this.eventsExecutorServices) {
            executorService.shutdownNow();
        }
        this.longRunningExecutorService.shutdownNow();
        this.closeEnded.set(true);
        if (lifecycleLogger.isDebugEnabled()) {
            lifecycleLogger.debug((Object)("Admin closed. hashCode=" + this.hashCode()));
        }
    }

    @Override
    public LookupServices getLookupServices() {
        return this.lookupServices;
    }

    @Override
    public GridServiceAgents getGridServiceAgents() {
        return this.gridServiceAgents;
    }

    @Override
    public GridServiceManagers getGridServiceManagers() {
        return this.gridServiceManagers;
    }

    @Override
    public ElasticServiceManagers getElasticServiceManagers() {
        return this.elasticServiceManagers;
    }

    @Override
    public GridServiceContainers getGridServiceContainers() {
        return this.gridServiceContainers;
    }

    @Override
    public Gateways getGateways() {
        return this.gateways;
    }

    @Override
    public GridComponent getGridComponentByUID(String uid) {
        Machine machine;
        MetricProvider component = this.getGridServiceAgents().getAgentByUID(uid);
        if (component == null && (component = this.getElasticServiceManagers().getManagerByUID(uid)) == null && (component = this.getGridServiceManagers().getManagerByUID(uid)) == null && (component = this.getGridServiceContainers().getContainerByUID(uid)) == null) {
            component = this.getLookupServices().getLookupServiceByUID(uid);
        }
        if (component == null && (machine = this.getMachines().getMachineByHostAddress(uid)) != null) {
            component = machine.getGridServiceAgent();
        }
        return component;
    }

    @Override
    public Machines getMachines() {
        return this.machines;
    }

    @Override
    public Zones getZones() {
        return this.zones;
    }

    @Override
    public Applications getApplications() {
        return this.applications;
    }

    @Override
    public Transports getTransports() {
        return this.transports;
    }

    @Override
    public VirtualMachines getVirtualMachines() {
        return this.virtualMachines;
    }

    @Override
    public OperatingSystems getOperatingSystems() {
        return this.operatingSystems;
    }

    @Override
    public ProcessingUnits getProcessingUnits() {
        return this.processingUnits;
    }

    @Override
    public GatewayProcessingUnits getGatewayProcessingUnits() {
        return this.gatewayProcessingUnits;
    }

    @Override
    public Spaces getSpaces() {
        return this.spaces;
    }

    @Override
    public AlertManager getAlertManager() {
        return this.alertManager;
    }

    @Override
    public void addEventListener(AdminEventListener eventListener) {
        this.addEventListener(eventListener, true, true);
    }

    @Override
    public void addEventListener(AdminEventListener eventListener, boolean withStatisticsHistory) {
        this.addEventListener(eventListener, withStatisticsHistory, false);
    }

    private void addEventListener(AdminEventListener eventListener, boolean withStatisticsHistory, boolean supportBackwards) {
        EventRegistrationHelper.addEventListener(this, eventListener, withStatisticsHistory, supportBackwards);
        this.eventListenersCount.incrementAndGet();
    }

    @Override
    public void removeEventListener(AdminEventListener eventListener) {
        EventRegistrationHelper.removeEventListener(this, eventListener);
        this.eventListenersCount.decrementAndGet();
    }

    @Override
    public int getEventListenersCount() {
        return this.eventListenersCount.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pushEvent(Object listener, Runnable notifier) {
        this.assertStateChangesPermitted();
        DefaultAdmin defaultAdmin = this;
        synchronized (defaultAdmin) {
            this.eventsQueue[Math.abs(listener.hashCode() % this.eventsExecutorServices.length)].add(this.toLoggerRunnable(notifier));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pushScheduleMonitorCorrelatedEvent(Object listener, Runnable notifier) {
        this.assertStateChangesPermitted();
        DefaultAdmin defaultAdmin = this;
        synchronized (defaultAdmin) {
            this.scheduleMonitorCorrelatedEventsQueue[Math.abs(listener.hashCode() % this.eventsExecutorServices.length)].add(this.toLoggerRunnable(notifier));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pushEventAsFirst(Object listener, Runnable notifier) {
        this.assertStateChangesPermitted();
        DefaultAdmin defaultAdmin = this;
        synchronized (defaultAdmin) {
            this.eventsQueue[Math.abs(listener.hashCode() % this.eventsExecutorServices.length)].addFirst(this.toLoggerRunnable(notifier));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushEvents() {
        this.assertStateChangesPermitted();
        DefaultAdmin defaultAdmin = this;
        synchronized (defaultAdmin) {
            if (this.closeStarted.get()) {
                for (LinkedList<Runnable> l : this.eventsQueue) {
                    l.clear();
                }
                return;
            }
            for (int i = 0; i < this.eventsExecutorServices.length; ++i) {
                for (Runnable notifier : this.eventsQueue[i]) {
                    this.eventsExecutorServices[i].submit(notifier);
                }
                this.eventsQueue[i].clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushScheduleMonitorCorrelatedEvents() {
        this.assertStateChangesPermitted();
        DefaultAdmin defaultAdmin = this;
        synchronized (defaultAdmin) {
            if (this.closeStarted.get()) {
                for (LinkedList<Runnable> l : this.scheduleMonitorCorrelatedEventsQueue) {
                    l.clear();
                }
                return;
            }
            for (int i = 0; i < this.eventsExecutorServices.length; ++i) {
                for (Runnable notifier : this.scheduleMonitorCorrelatedEventsQueue[i]) {
                    this.eventsExecutorServices[i].submit(notifier);
                }
                this.scheduleMonitorCorrelatedEventsQueue[i].clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void raiseEvent(Object listener, Runnable notifier) {
        DefaultAdmin defaultAdmin = this;
        synchronized (defaultAdmin) {
            this.eventsExecutorServices[Math.abs(listener.hashCode() % this.eventsExecutorServices.length)].submit(this.toLoggerRunnable(notifier));
        }
    }

    private Runnable toLoggerRunnable(Runnable command) {
        if (command instanceof LoggerRunnable) {
            return command;
        }
        return new LoggerRunnable(command);
    }

    @Override
    public void scheduleNonBlockingStateChange(Runnable command) {
        if (this.closeStarted.get()) {
            throw new AdminClosedException();
        }
        if (this.singleThreadedEventListeners) {
            this.raiseEvent(this, command);
        } else {
            command.run();
        }
    }

    @Override
    public void scheduleAdminOperation(Runnable command) {
        this.longRunningExecutorService.submit(this.toLoggerRunnable(command));
    }

    @Override
    public void assertStateChangesPermitted() {
        if (this.singleThreadedEventListeners && Thread.currentThread().getId() != this.executorSingleThreadId) {
            throw new IllegalStateException("Assertion Failure. Cannot change admin state from this thread. Call scheduleNonBlockingStateChange(runnable) instead.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addGridServiceAgent(InternalGridServiceAgent gridServiceAgent, NIODetails nioDetails, OSDetails osDetails, JVMDetails jvmDetails, String jmxUrl, String[] zones) {
        this.assertStateChangesPermitted();
        DefaultAdmin defaultAdmin = this;
        synchronized (defaultAdmin) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Adding GSA uid=" + gridServiceAgent.getUid()));
            }
            InternalOperatingSystem operatingSystem = this.processOperatingSystemOnServiceAddition(gridServiceAgent, osDetails);
            InternalVirtualMachine virtualMachine = this.processVirtualMachineOnServiceAddition(gridServiceAgent, jvmDetails, jmxUrl);
            InternalTransport transport = this.processTransportOnServiceAddition(gridServiceAgent, nioDetails, virtualMachine);
            InternalMachine machine = this.processMachineOnServiceAddition(transport.getDetails(), transport, operatingSystem, virtualMachine, virtualMachine, gridServiceAgent);
            this.processZonesOnServiceAddition(zones, gridServiceAgent.getUid(), transport, virtualMachine, machine, gridServiceAgent);
            ((InternalGridServiceAgents)machine.getGridServiceAgents()).addGridServiceAgent(gridServiceAgent);
            ((InternalGridServiceAgents)virtualMachine.getGridServiceAgents()).addGridServiceAgent(gridServiceAgent);
            for (Zone zone : gridServiceAgent.getZones().values()) {
                ((InternalGridServiceAgents)zone.getGridServiceAgents()).addGridServiceAgent(gridServiceAgent);
            }
            this.gridServiceAgents.addGridServiceAgent(gridServiceAgent);
            Iterator<Map.Entry<String, InternalAgentGridComponent>> it = this.orphanedAgentGridComponents.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<String, InternalAgentGridComponent> entry = it.next();
                InternalAgentGridComponent agentGridComponent = entry.getValue();
                if (!agentGridComponent.getAgentUid().equals(gridServiceAgent.getUid())) continue;
                agentGridComponent.setGridServiceAgent(gridServiceAgent);
                gridServiceAgent.addAgentGridComponent(agentGridComponent);
                it.remove();
            }
            this.flushEvents();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeGridServiceAgent(String uid) {
        this.assertStateChangesPermitted();
        DefaultAdmin defaultAdmin = this;
        synchronized (defaultAdmin) {
            InternalGridServiceAgent gridServiceAgent;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Removing GSA uid=" + uid));
            }
            if ((gridServiceAgent = this.gridServiceAgents.removeGridServiceAgent(uid)) != null) {
                gridServiceAgent.setDiscovered(false);
                this.processTransportOnServiceRemoval(gridServiceAgent, gridServiceAgent, gridServiceAgent);
                this.processOperatingSystemOnServiceRemoval(gridServiceAgent, gridServiceAgent);
                this.processVirtualMachineOnServiceRemoval(gridServiceAgent, gridServiceAgent, gridServiceAgent);
                ((InternalGridServiceAgents)((InternalVirtualMachine)gridServiceAgent.getVirtualMachine()).getGridServiceAgents()).removeGridServiceAgent(uid);
                this.processMachineOnServiceRemoval(gridServiceAgent, gridServiceAgent);
                ((InternalGridServiceAgents)((InternalMachine)gridServiceAgent.getMachine()).getGridServiceAgents()).removeGridServiceAgent(uid);
                this.processZonesOnServiceRemoval(uid, gridServiceAgent);
                for (Zone zone : gridServiceAgent.getZones().values()) {
                    ((InternalGridServiceAgents)zone.getGridServiceAgents()).removeGridServiceAgent(uid);
                }
                Iterator<Map.Entry<String, InternalAgentGridComponent>> it = this.orphanedAgentGridComponents.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry<String, InternalAgentGridComponent> entry = it.next();
                    if (!entry.getValue().getAgentUid().equals(gridServiceAgent.getUid())) continue;
                    it.remove();
                }
            }
            this.flushEvents();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addLookupService(InternalLookupService lookupService, NIODetails nioDetails, OSDetails osDetails, JVMDetails jvmDetails, String jmxUrl, String[] zones) {
        this.assertStateChangesPermitted();
        DefaultAdmin defaultAdmin = this;
        synchronized (defaultAdmin) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Adding LUS uid=" + lookupService.getUid()));
            }
            InternalOperatingSystem operatingSystem = this.processOperatingSystemOnServiceAddition(lookupService, osDetails);
            InternalVirtualMachine virtualMachine = this.processVirtualMachineOnServiceAddition(lookupService, jvmDetails, jmxUrl);
            InternalTransport transport = this.processTransportOnServiceAddition(lookupService, nioDetails, virtualMachine);
            InternalMachine machine = this.processMachineOnServiceAddition(transport.getDetails(), transport, operatingSystem, virtualMachine, virtualMachine, lookupService);
            this.processZonesOnServiceAddition(zones, lookupService.getUid(), transport, virtualMachine, machine, lookupService);
            this.processAgentOnServiceAddition(lookupService);
            ((InternalLookupServices)machine.getLookupServices()).addLookupService(lookupService);
            ((InternalLookupServices)virtualMachine.getLookupServices()).addLookupService(lookupService);
            for (Zone zone : lookupService.getZones().values()) {
                ((InternalLookupServices)zone.getLookupServices()).addLookupService(lookupService);
            }
            this.lookupServices.addLookupService(lookupService);
            this.flushEvents();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeLookupService(String uid) {
        this.assertStateChangesPermitted();
        DefaultAdmin defaultAdmin = this;
        synchronized (defaultAdmin) {
            InternalLookupService lookupService;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Removing LUS uid=" + uid));
            }
            if ((lookupService = this.lookupServices.removeLookupService(uid)) != null) {
                lookupService.setDiscovered(false);
                this.processTransportOnServiceRemoval(lookupService, lookupService, lookupService);
                this.processOperatingSystemOnServiceRemoval(lookupService, lookupService);
                this.processVirtualMachineOnServiceRemoval(lookupService, lookupService, lookupService);
                this.processMachineOnServiceRemoval(lookupService, lookupService);
                ((InternalLookupServices)((InternalMachine)lookupService.getMachine()).getLookupServices()).removeLookupService(uid);
                this.processZonesOnServiceRemoval(uid, lookupService);
                for (Zone zone : lookupService.getZones().values()) {
                    ((InternalLookupServices)zone.getLookupServices()).removeLookupService(uid);
                }
                this.processAgentOnServiceRemoval(lookupService);
            }
            this.flushEvents();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addGridServiceManager(InternalGridServiceManager gridServiceManager, NIODetails nioDetails, OSDetails osDetails, JVMDetails jvmDetails, String jmxUrl, String[] zones, boolean acceptVM) {
        this.assertStateChangesPermitted();
        DefaultAdmin defaultAdmin = this;
        synchronized (defaultAdmin) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Adding GSM uid=" + gridServiceManager.getUid() + (acceptVM ? "" : ". Filtered out of Admin API")));
            }
            if (acceptVM) {
                InternalOperatingSystem operatingSystem = this.processOperatingSystemOnServiceAddition(gridServiceManager, osDetails);
                InternalVirtualMachine virtualMachine = this.processVirtualMachineOnServiceAddition(gridServiceManager, jvmDetails, jmxUrl);
                InternalTransport transport = this.processTransportOnServiceAddition(gridServiceManager, nioDetails, virtualMachine);
                InternalMachine machine = this.processMachineOnServiceAddition(transport.getDetails(), transport, operatingSystem, virtualMachine, virtualMachine, gridServiceManager);
                this.processAgentOnServiceAddition(gridServiceManager);
                this.processZonesOnServiceAddition(zones, gridServiceManager.getUid(), transport, virtualMachine, machine, gridServiceManager);
                ((InternalGridServiceManagers)machine.getGridServiceManagers()).addGridServiceManager(gridServiceManager);
                ((InternalGridServiceManagers)virtualMachine.getGridServiceManagers()).addGridServiceManager(gridServiceManager);
                for (Zone zone : gridServiceManager.getZones().values()) {
                    ((InternalGridServiceManagers)zone.getGridServiceManagers()).addGridServiceManager(gridServiceManager);
                }
            }
            this.gridServiceManagers.addGridServiceManager(gridServiceManager);
            this.flushEvents();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeGridServiceManager(String uid) {
        this.assertStateChangesPermitted();
        DefaultAdmin defaultAdmin = this;
        synchronized (defaultAdmin) {
            InternalGridServiceManager gridServiceManager;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Removing GSM uid=" + uid));
            }
            if ((gridServiceManager = this.gridServiceManagers.removeGridServiceManager(uid)) != null) {
                gridServiceManager.setDiscovered(false);
                this.processTransportOnServiceRemoval(gridServiceManager, gridServiceManager, gridServiceManager);
                this.processOperatingSystemOnServiceRemoval(gridServiceManager, gridServiceManager);
                this.processVirtualMachineOnServiceRemoval(gridServiceManager, gridServiceManager, gridServiceManager);
                InternalVirtualMachine jvm = (InternalVirtualMachine)gridServiceManager.getVirtualMachine();
                if (jvm != null) {
                    ((InternalGridServiceManagers)jvm.getGridServiceManagers()).removeGridServiceManager(uid);
                }
                this.processMachineOnServiceRemoval(gridServiceManager, gridServiceManager);
                InternalMachine machine = (InternalMachine)gridServiceManager.getMachine();
                if (machine != null) {
                    ((InternalGridServiceManagers)machine.getGridServiceManagers()).removeGridServiceManager(uid);
                }
                this.processZonesOnServiceRemoval(uid, gridServiceManager);
                for (Zone zone : gridServiceManager.getZones().values()) {
                    ((InternalGridServiceManagers)zone.getGridServiceManagers()).removeGridServiceManager(uid);
                }
                this.processAgentOnServiceRemoval(gridServiceManager);
            }
            this.flushEvents();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addElasticServiceManager(InternalElasticServiceManager elasticServiceManager, NIODetails nioDetails, OSDetails osDetails, JVMDetails jvmDetails, String jmxUrl, String[] zones, boolean acceptVM) {
        this.assertStateChangesPermitted();
        DefaultAdmin defaultAdmin = this;
        synchronized (defaultAdmin) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Adding ESM uid=" + elasticServiceManager.getUid() + (acceptVM ? "" : ". Filtered out of Admin API")));
            }
            if (acceptVM) {
                InternalOperatingSystem operatingSystem = this.processOperatingSystemOnServiceAddition(elasticServiceManager, osDetails);
                InternalVirtualMachine virtualMachine = this.processVirtualMachineOnServiceAddition(elasticServiceManager, jvmDetails, jmxUrl);
                InternalTransport transport = this.processTransportOnServiceAddition(elasticServiceManager, nioDetails, virtualMachine);
                InternalMachine machine = this.processMachineOnServiceAddition(transport.getDetails(), transport, operatingSystem, virtualMachine, virtualMachine, elasticServiceManager);
                this.processAgentOnServiceAddition(elasticServiceManager);
                this.processZonesOnServiceAddition(zones, elasticServiceManager.getUid(), transport, virtualMachine, machine, elasticServiceManager);
                ((InternalElasticServiceManagers)machine.getElasticServiceManagers()).addElasticServiceManager(elasticServiceManager);
                ((InternalElasticServiceManagers)virtualMachine.getElasticServiceManagers()).addElasticServiceManager(elasticServiceManager);
                for (Zone zone : elasticServiceManager.getZones().values()) {
                    ((InternalElasticServiceManagers)zone.getElasticServiceManagers()).addElasticServiceManager(elasticServiceManager);
                }
            }
            this.elasticServiceManagers.addElasticServiceManager(elasticServiceManager);
            this.flushEvents();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeElasticServiceManager(String uid) {
        this.assertStateChangesPermitted();
        DefaultAdmin defaultAdmin = this;
        synchronized (defaultAdmin) {
            InternalElasticServiceManager elasticServiceManager;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Removing ESM uid=" + uid));
            }
            if ((elasticServiceManager = this.elasticServiceManagers.removeElasticServiceManager(uid)) != null) {
                elasticServiceManager.setDiscovered(false);
                this.processTransportOnServiceRemoval(elasticServiceManager, elasticServiceManager, elasticServiceManager);
                this.processOperatingSystemOnServiceRemoval(elasticServiceManager, elasticServiceManager);
                this.processVirtualMachineOnServiceRemoval(elasticServiceManager, elasticServiceManager, elasticServiceManager);
                ((InternalElasticServiceManagers)((InternalVirtualMachine)elasticServiceManager.getVirtualMachine()).getElasticServiceManagers()).removeElasticServiceManager(uid);
                this.processMachineOnServiceRemoval(elasticServiceManager, elasticServiceManager);
                ((InternalElasticServiceManagers)((InternalMachine)elasticServiceManager.getMachine()).getElasticServiceManagers()).removeElasticServiceManager(uid);
                this.processZonesOnServiceRemoval(uid, elasticServiceManager);
                for (Zone zone : elasticServiceManager.getZones().values()) {
                    ((InternalElasticServiceManagers)zone.getElasticServiceManagers()).removeElasticServiceManager(uid);
                }
                this.processAgentOnServiceRemoval(elasticServiceManager);
            }
            this.flushEvents();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addGridServiceContainer(InternalGridServiceContainer gridServiceContainer, NIODetails nioDetails, OSDetails osDetails, JVMDetails jvmDetails, String jmxUrl, String[] zones) {
        this.assertStateChangesPermitted();
        DefaultAdmin defaultAdmin = this;
        synchronized (defaultAdmin) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Adding GSC uid=" + gridServiceContainer.getUid()));
            }
            InternalOperatingSystem operatingSystem = this.processOperatingSystemOnServiceAddition(gridServiceContainer, osDetails);
            InternalVirtualMachine virtualMachine = this.processVirtualMachineOnServiceAddition(gridServiceContainer, jvmDetails, jmxUrl);
            InternalTransport transport = this.processTransportOnServiceAddition(gridServiceContainer, nioDetails, virtualMachine);
            InternalMachine machine = this.processMachineOnServiceAddition(transport.getDetails(), transport, operatingSystem, virtualMachine, virtualMachine, gridServiceContainer);
            this.processAgentOnServiceAddition(gridServiceContainer);
            this.processZonesOnServiceAddition(zones, gridServiceContainer.getUid(), transport, virtualMachine, machine, gridServiceContainer);
            ((InternalGridServiceContainers)machine.getGridServiceContainers()).addGridServiceContainer(gridServiceContainer);
            ((InternalGridServiceContainers)virtualMachine.getGridServiceContainers()).addGridServiceContainer(gridServiceContainer);
            for (Zone zone : gridServiceContainer.getZones().values()) {
                ((InternalGridServiceContainers)zone.getGridServiceContainers()).addGridServiceContainer(gridServiceContainer);
            }
            this.gridServiceContainers.addGridServiceContainer(gridServiceContainer);
            this.flushEvents();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeGridServiceContainer(String uid) {
        this.assertStateChangesPermitted();
        DefaultAdmin defaultAdmin = this;
        synchronized (defaultAdmin) {
            InternalGridServiceContainer gridServiceContainer;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Removing GSC uid=" + uid));
            }
            if ((gridServiceContainer = this.gridServiceContainers.removeGridServiceContainer(uid)) != null) {
                gridServiceContainer.setDiscovered(false);
                this.processTransportOnServiceRemoval(gridServiceContainer, gridServiceContainer, gridServiceContainer);
                this.processOperatingSystemOnServiceRemoval(gridServiceContainer, gridServiceContainer);
                this.processVirtualMachineOnServiceRemoval(gridServiceContainer, gridServiceContainer, gridServiceContainer);
                ((InternalGridServiceContainers)((InternalVirtualMachine)gridServiceContainer.getVirtualMachine()).getGridServiceContainers()).removeGridServiceContainer(uid);
                this.processMachineOnServiceRemoval(gridServiceContainer, gridServiceContainer);
                ((InternalGridServiceContainers)((InternalMachine)gridServiceContainer.getMachine()).getGridServiceContainers()).removeGridServiceContainer(uid);
                this.processZonesOnServiceRemoval(uid, gridServiceContainer);
                for (Zone zone : gridServiceContainer.getZones().values()) {
                    ((InternalGridServiceContainers)zone.getGridServiceContainers()).removeGridServiceContainer(uid);
                }
                this.processAgentOnServiceRemoval(gridServiceContainer);
            }
            this.flushEvents();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addProcessingUnitInstance(InternalProcessingUnitInstance processingUnitInstance, NIODetails nioDetails, OSDetails osDetails, JVMDetails jvmDetails, String jmxUrl, String[] zones) {
        this.assertStateChangesPermitted();
        DefaultAdmin defaultAdmin = this;
        synchronized (defaultAdmin) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Service Added [Processing Unit Instance] " + processingUnitInstance.getProcessingUnitInstanceName() + " with uid [" + processingUnitInstance.getUid() + "]"));
            }
            InternalOperatingSystem operatingSystem = this.processOperatingSystemOnServiceAddition(processingUnitInstance, osDetails);
            InternalVirtualMachine virtualMachine = this.processVirtualMachineOnServiceAddition(processingUnitInstance, jvmDetails, jmxUrl);
            InternalTransport transport = this.processTransportOnServiceAddition(processingUnitInstance, nioDetails, virtualMachine);
            InternalMachine machine = this.processMachineOnServiceAddition(transport.getDetails(), transport, operatingSystem, virtualMachine, virtualMachine, processingUnitInstance);
            this.processZonesOnServiceAddition(zones, processingUnitInstance.getUid(), transport, virtualMachine, machine, processingUnitInstance);
            InternalProcessingUnit processingUnit = (InternalProcessingUnit)this.processingUnits.getProcessingUnit(processingUnitInstance.getClusterInfo().getName());
            InternalGridServiceContainer gridServiceContainer = (InternalGridServiceContainer)this.gridServiceContainers.getContainerByUID(processingUnitInstance.getGridServiceContainerServiceID().toString());
            if (processingUnit == null || gridServiceContainer == null) {
                this.adminProcessingUnitInstances.addOrphaned(processingUnitInstance);
            } else {
                this.processProcessingUnitInstanceAddition(processingUnit, processingUnitInstance);
            }
            this.flushEvents();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeProcessingUnitInstance(String uid, boolean removeEmbeddedSpaces) {
        this.assertStateChangesPermitted();
        DefaultAdmin defaultAdmin = this;
        synchronized (defaultAdmin) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Removing Processing Unit Instance uid=" + uid));
            }
            this.adminProcessingUnitInstances.removeOrphaned(uid);
            InternalProcessingUnitInstance processingUnitInstance = (InternalProcessingUnitInstance)this.processingUnitInstances.removeInstance(uid);
            if (processingUnitInstance != null) {
                this.adminProcessingUnitInstances.addRemovedProcessingUnitInstance(processingUnitInstance);
                processingUnitInstance.setDiscovered(false);
                InternalProcessingUnit processingUnit = (InternalProcessingUnit)processingUnitInstance.getProcessingUnit();
                processingUnit.removeProcessingUnitInstance(uid);
                ((InternalGridServiceContainer)processingUnitInstance.getGridServiceContainer()).removeProcessingUnitInstance(uid);
                ((InternalVirtualMachine)processingUnitInstance.getVirtualMachine()).removeProcessingUnitInstance(processingUnitInstance.getUid());
                ((InternalMachine)processingUnitInstance.getMachine()).removeProcessingUnitInstance(processingUnitInstance.getUid());
                for (Zone zone : processingUnitInstance.getZones().values()) {
                    ((InternalZone)zone).removeProcessingUnitInstance(processingUnitInstance.getUid());
                }
                this.processTransportOnServiceRemoval(processingUnitInstance, processingUnitInstance, processingUnitInstance);
                this.processOperatingSystemOnServiceRemoval(processingUnitInstance, processingUnitInstance);
                this.processVirtualMachineOnServiceRemoval(processingUnitInstance, processingUnitInstance, processingUnitInstance);
                this.processMachineOnServiceRemoval(processingUnitInstance, processingUnitInstance);
                this.processZonesOnServiceRemoval(processingUnitInstance.getUid(), processingUnitInstance);
                this.processGatewaysOnProcessingUnitInstanceRemoval(processingUnitInstance.getUid(), processingUnitInstance);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("removed processing unit instance " + processingUnitInstance.getProcessingUnitInstanceName() + " uid:" + uid));
                }
                if (removeEmbeddedSpaces) {
                    for (SpaceServiceDetails serviceDetails : processingUnitInstance.getEmbeddedSpacesDetails()) {
                        this.removeSpaceInstance(serviceDetails.getServiceID().toString());
                        if (!logger.isDebugEnabled()) continue;
                        logger.debug((Object)("removed space instance " + serviceDetails.getName() + " id:" + serviceDetails.getServiceID()));
                    }
                }
                if (processingUnit.getType() == ProcessingUnitType.GATEWAY) {
                    this.gatewayProcessingUnits.removeGatewayProcessingUnit(uid);
                }
            }
            this.flushEvents();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addSpaceInstance(InternalSpaceInstance spaceInstance, NIODetails nioDetails, OSDetails osDetails, JVMDetails jvmDetails, String jmxUrl, String[] zones) {
        this.assertStateChangesPermitted();
        DefaultAdmin defaultAdmin = this;
        synchronized (defaultAdmin) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Adding Space Instance uid=" + spaceInstance.getUid()));
            }
            InternalOperatingSystem operatingSystem = this.processOperatingSystemOnServiceAddition(spaceInstance, osDetails);
            InternalVirtualMachine virtualMachine = this.processVirtualMachineOnServiceAddition(spaceInstance, jvmDetails, jmxUrl);
            InternalTransport transport = this.processTransportOnServiceAddition(spaceInstance, nioDetails, virtualMachine);
            InternalMachine machine = this.processMachineOnServiceAddition(transport.getDetails(), transport, operatingSystem, virtualMachine, virtualMachine, spaceInstance);
            this.processZonesOnServiceAddition(zones, spaceInstance.getUid(), transport, virtualMachine, machine, spaceInstance);
            InternalSpace space = (InternalSpace)this.spaces.getSpaceByName(spaceInstance.getSpaceName());
            if (space == null) {
                String spaceUid = spaceInstance.getSpaceName();
                space = (InternalSpace)this.removeRemovedSpace(spaceUid);
                if (space == null) {
                    space = new DefaultSpace(this.spaces, spaceUid, spaceInstance.getSpaceName());
                }
                this.spaces.addSpace(space);
            }
            spaceInstance.setSpace(space);
            space.addInstance(spaceInstance);
            this.spaces.addSpaceInstance(spaceInstance);
            for (ProcessingUnit processingUnit : this.processingUnits) {
                for (ProcessingUnitInstance processingUnitInstance : processingUnit) {
                    this.addSpaceInstanceIfMatching(spaceInstance, processingUnitInstance);
                }
            }
            machine.addSpaceInstance(spaceInstance);
            virtualMachine.addSpaceInstance(spaceInstance);
            for (Zone zone : spaceInstance.getZones().values()) {
                ((InternalZone)zone).addSpaceInstance(spaceInstance);
            }
            this.flushEvents();
        }
    }

    private void addSpaceInstanceIfMatching(SpaceInstance spaceInstance, ProcessingUnitInstance processingUnitInstance) {
        if (((InternalProcessingUnitInstance)processingUnitInstance).addSpaceInstanceIfMatching(spaceInstance)) {
            ((InternalProcessingUnit)processingUnitInstance.getProcessingUnit()).addEmbeddedSpace(spaceInstance.getSpace());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeSpaceInstance(String uid) {
        this.assertStateChangesPermitted();
        DefaultAdmin defaultAdmin = this;
        synchronized (defaultAdmin) {
            InternalSpaceInstance spaceInstance;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Removing Space Instance uid=" + uid));
            }
            if ((spaceInstance = (InternalSpaceInstance)this.spaces.removeSpaceInstance(uid)) != null) {
                spaceInstance.setDiscovered(false);
                InternalSpace space = (InternalSpace)this.spaces.getSpaceByName(spaceInstance.getSpaceName());
                space.removeInstance(uid);
                if (space.getSize() == 0) {
                    this.spaces.removeSpace(space.getUid());
                    ProcessingUnit processingUnit = this.processingUnits.removeEmbeddedSpace(space);
                    if (processingUnit != null) {
                        this.addRemovedSpace(space, processingUnit);
                    }
                }
                ((InternalVirtualMachine)spaceInstance.getVirtualMachine()).removeSpaceInstance(spaceInstance.getUid());
                ((InternalMachine)spaceInstance.getMachine()).removeSpaceInstance(spaceInstance.getUid());
                for (Zone zone : spaceInstance.getZones().values()) {
                    ((InternalZone)zone).removeSpaceInstance(uid);
                }
                this.processTransportOnServiceRemoval(spaceInstance, spaceInstance, spaceInstance);
                this.processOperatingSystemOnServiceRemoval(spaceInstance, spaceInstance);
                this.processVirtualMachineOnServiceRemoval(spaceInstance, spaceInstance, spaceInstance);
                this.processMachineOnServiceRemoval(spaceInstance, spaceInstance);
                this.processZonesOnServiceRemoval(uid, spaceInstance);
            }
            this.flushEvents();
        }
    }

    private void processAgentOnServiceAddition(InternalAgentGridComponent agentGridComponent) {
        if (agentGridComponent.getAgentUid() == null) {
            return;
        }
        InternalGridServiceAgent gridServiceAgent = (InternalGridServiceAgent)this.gridServiceAgents.getAgentByUID(agentGridComponent.getAgentUid());
        if (gridServiceAgent == null) {
            this.orphanedAgentGridComponents.put(agentGridComponent.getUid(), agentGridComponent);
        } else {
            agentGridComponent.setGridServiceAgent(gridServiceAgent);
            gridServiceAgent.addAgentGridComponent(agentGridComponent);
        }
    }

    private void processAgentOnServiceRemoval(InternalAgentGridComponent agentGridComponent) {
        InternalGridServiceAgent agent = (InternalGridServiceAgent)agentGridComponent.getGridServiceAgent();
        if (agent != null) {
            agent.removeAgentGridComponent(agentGridComponent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processProcessingUnitInstanceAddition(InternalProcessingUnit processingUnit, InternalProcessingUnitInstance processingUnitInstance) {
        this.assertStateChangesPermitted();
        DefaultAdmin defaultAdmin = this;
        synchronized (defaultAdmin) {
            InternalGridServiceContainer gridServiceContainer;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(processingUnitInstance.getProcessingUnitInstanceName() + " is being added"));
            }
            this.adminProcessingUnitInstances.removeOrphaned(processingUnitInstance.getUid());
            this.adminProcessingUnitInstances.delRemovedProcessingUnitInstance(processingUnitInstance);
            processingUnitInstance.setProcessingUnit(processingUnit);
            processingUnit.addProcessingUnitInstance(processingUnitInstance);
            Application application = processingUnit.getApplication();
            if (application != null) {
                ((InternalProcessingUnitInstanceAddedEventManager)application.getProcessingUnits().getProcessingUnitInstanceAdded()).processingUnitInstanceAdded(processingUnitInstance);
            }
            if ((gridServiceContainer = (InternalGridServiceContainer)this.gridServiceContainers.getContainerByUID(processingUnitInstance.getGridServiceContainerServiceID().toString())) == null) {
                throw new IllegalStateException("gridServiceContainer cloud not be null. Internal error in admin, should not happen");
            }
            processingUnitInstance.setGridServiceContainer(gridServiceContainer);
            gridServiceContainer.addProcessingUnitInstance(processingUnitInstance);
            ((InternalMachine)processingUnitInstance.getMachine()).addProcessingUnitInstance(processingUnitInstance);
            ((InternalVirtualMachine)processingUnitInstance.getVirtualMachine()).addProcessingUnitInstance(processingUnitInstance);
            for (Zone zone : processingUnitInstance.getZones().values()) {
                ((InternalZone)zone).addProcessingUnitInstance(processingUnitInstance);
            }
            for (Space space : this.spaces) {
                for (SpaceInstance spaceInstance : space) {
                    this.addSpaceInstanceIfMatching(spaceInstance, processingUnitInstance);
                }
            }
            this.processingUnitInstances.addInstance(processingUnitInstance);
            GatewayServiceDetails gatewayDetails = GatewayUtils.extractGatewayDetails(processingUnitInstance);
            if (gatewayDetails != null) {
                String gatewayName = gatewayDetails.getLocalGatewayName();
                Gateway gateway = this.gateways.getGateway(gatewayName);
                if (gateway == null) {
                    gateway = new DefaultGateway(this, gatewayName);
                    this.gateways.addGateway(gateway);
                }
                DefaultGatewayProcessingUnit gatewayProcessingUnit = new DefaultGatewayProcessingUnit(this, gateway, processingUnitInstance, gatewayDetails);
                this.gatewayProcessingUnits.addGatewayProcessingUnit(gatewayProcessingUnit);
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(processingUnitInstance.getProcessingUnitInstanceName() + " has been added"));
            }
        }
    }

    private void processZonesOnServiceAddition(String[] zonesNames, String zoneUidProvider, InternalTransport transport, VirtualMachine virtualMachine, Machine machine, InternalZoneAware ... zoneAwares) {
        if (zonesNames == null) {
            return;
        }
        for (String zoneName : zonesNames) {
            InternalZone zone = (InternalZone)this.zones.getByName(zoneName);
            if (zone == null) {
                zone = new DefaultZone(this, zoneName);
            }
            this.zones.addZone(zone, zoneUidProvider);
            ((InternalTransports)zone.getTransports()).addTransport(transport);
            ((InternalVirtualMachines)zone.getVirtualMachines()).addVirtualMachine(virtualMachine);
            ((InternalMachines)zone.getMachines()).addMachine((InternalMachine)machine);
            for (InternalZoneAware zoneAware : zoneAwares) {
                zoneAware.addZone(zone);
            }
        }
    }

    private void processApplicationsOnProcessingUnitAddition(ProcessingUnit processingUnit) {
        String applicationName = ((InternalProcessingUnit)processingUnit).getApplicationName();
        if (applicationName == null || applicationName.length() == 0) {
            return;
        }
        InternalApplication application = (InternalApplication)this.applications.getApplication(applicationName);
        if (application == null) {
            application = new DefaultApplication(this, applicationName);
            application.getProcessingUnits().setStatisticsHistorySize(this.statisticsHistorySize);
            application.getProcessingUnits().setStatisticsInterval(this.statisticsInterval, TimeUnit.MILLISECONDS);
        }
        this.applications.addApplication(application, processingUnit);
    }

    private void processZonesOnServiceRemoval(String zoneUidProvider, ZoneAware zoneAware) {
        for (Zone zone : zoneAware.getZones().values()) {
            this.zones.removeProvider(zone, zoneUidProvider);
        }
    }

    private void processApplicationsOnProcessingUnitRemoval(ProcessingUnit processingUnit) {
        this.applications.removeProcessingUnit(processingUnit);
    }

    private InternalMachine processMachineOnServiceAddition(TransportDetails transportDetails, InternalTransport transport, OperatingSystem operatingSystem, VirtualMachine virtualMachine, InternalMachineAware ... machineAwares) {
        InternalMachine machine = (InternalMachine)this.machines.getMachineByHostAddress(transportDetails.getHostAddress());
        if (machine == null) {
            machine = new DefaultMachine(this, transportDetails.getHostAddress(), transportDetails.getHostAddress());
            machine.setOperatingSystem(operatingSystem);
            this.machines.addMachine(machine);
        }
        ((InternalTransports)machine.getTransports()).addTransport(transport);
        ((InternalVirtualMachines)machine.getVirtualMachines()).addVirtualMachine(virtualMachine);
        for (InternalMachineAware machineAware : machineAwares) {
            machineAware.setMachine(machine);
        }
        return machine;
    }

    private void processMachineOnServiceRemoval(InternalMachineAware machineAware, ZoneAware zoneAware) {
        Machine machine = machineAware.getMachine();
        if (machine != null && (machine = this.machines.getMachineByUID(machine.getUid())) != null) {
            this.machines.removeMachine(machine);
            for (Zone zone : zoneAware.getZones().values()) {
                ((InternalMachines)zone.getMachines()).removeMachine(machine);
            }
        }
    }

    private InternalVirtualMachine processVirtualMachineOnServiceAddition(InternalVirtualMachineInfoProvider vmProvider, JVMDetails jvmDetails, String jmxUrl) {
        InternalVirtualMachine virtualMachine = (InternalVirtualMachine)this.virtualMachines.getVirtualMachineByUID(jvmDetails.getUid());
        if (virtualMachine == null) {
            virtualMachine = new DefaultVirtualMachine(this.virtualMachines, jvmDetails, jmxUrl);
            this.virtualMachines.addVirtualMachine(virtualMachine);
        }
        virtualMachine.addVirtualMachineInfoProvider(vmProvider);
        vmProvider.setVirtualMachine(virtualMachine);
        return virtualMachine;
    }

    private void processVirtualMachineOnServiceRemoval(InternalVirtualMachineInfoProvider vmProvider, InternalMachineAware machineAware, ZoneAware zoneAware) {
        InternalVirtualMachine virtualMachine = (InternalVirtualMachine)vmProvider.getVirtualMachine();
        if (virtualMachine != null) {
            virtualMachine.removeVirtualMachineInfoProvider(vmProvider);
            if (!virtualMachine.hasVirtualMachineInfoProviders()) {
                this.virtualMachines.removeVirtualMachine(virtualMachine.getUid());
                ((InternalVirtualMachines)machineAware.getMachine().getVirtualMachines()).removeVirtualMachine(virtualMachine.getUid());
                for (Zone zone : zoneAware.getZones().values()) {
                    ((InternalVirtualMachines)zone.getVirtualMachines()).removeVirtualMachine(virtualMachine.getUid());
                }
            }
        }
    }

    private InternalTransport processTransportOnServiceAddition(InternalTransportInfoProvider txProvider, NIODetails nioDetails, VirtualMachine virtualMachine) {
        InternalTransport transport = (InternalTransport)this.transports.getTransportByHostAndPort(nioDetails.getBindHost(), nioDetails.getPort());
        if (transport == null) {
            transport = new DefaultTransport(nioDetails, this.transports);
            transport.setVirtualMachine(virtualMachine);
            this.transports.addTransport(transport);
        }
        transport.addTransportInfoProvider(txProvider);
        txProvider.setTransport(transport);
        return transport;
    }

    private void processTransportOnServiceRemoval(InternalTransportInfoProvider txProvider, InternalMachineAware machineAware, ZoneAware zoneAware) {
        InternalTransport transport = (InternalTransport)txProvider.getTransport();
        if (transport != null) {
            transport.removeTransportInfoProvider(txProvider);
            if (!transport.hasTransportInfoProviders()) {
                this.transports.removeTransport(transport.getUid());
                ((InternalTransports)machineAware.getMachine().getTransports()).removeTransport(transport.getUid());
                for (Zone zone : zoneAware.getZones().values()) {
                    ((InternalTransports)zone.getTransports()).removeTransport(transport.getUid());
                }
            }
        }
    }

    private InternalOperatingSystem processOperatingSystemOnServiceAddition(InternalOperatingSystemInfoProvider osProvider, OSDetails osDetails) {
        InternalOperatingSystem os = (InternalOperatingSystem)this.operatingSystems.getByUID(osDetails.getUID());
        if (os == null) {
            os = new DefaultOperatingSystem(osDetails, this.operatingSystems);
            this.operatingSystems.addOperatingSystem(os);
        }
        os.addOperatingSystemInfoProvider(osProvider);
        osProvider.setOperatingSystem(os);
        return os;
    }

    private void processOperatingSystemOnServiceRemoval(InternalOperatingSystemInfoProvider osProvider, InternalMachineAware machineAware) {
        InternalOperatingSystem os = (InternalOperatingSystem)osProvider.getOperatingSystem();
        if (os != null) {
            os.removeOperatingSystemInfoProvider(osProvider);
            if (!os.hasOperatingSystemInfoProviders()) {
                this.operatingSystems.removeOperatingSystem(os.getUid());
            }
        }
    }

    private void processGatewaysOnProcessingUnitInstanceRemoval(String removedPuInstanceUid, ProcessingUnitInstance removedProcessingUnitInstance) {
        GatewayServiceDetails gatewayDetails = GatewayUtils.extractGatewayDetails(removedProcessingUnitInstance);
        if (gatewayDetails != null) {
            Gateway gateway;
            String gatewayName = gatewayDetails.getLocalGatewayName();
            GatewayProcessingUnit removedGatewayProcessingUnit = this.gatewayProcessingUnits.removeGatewayProcessingUnit(removedPuInstanceUid);
            if (logger.isDebugEnabled()) {
                if (removedGatewayProcessingUnit != null) {
                    logger.debug((Object)("Gateway Processing Unit removed with uid [" + removedPuInstanceUid + "]"));
                } else {
                    logger.debug((Object)("Gateway Processing Unit [" + removedPuInstanceUid + "] not removed"));
                }
            }
            if (removedGatewayProcessingUnit != null && (gateway = removedGatewayProcessingUnit.getGateway()).isEmpty()) {
                Gateway removedGateway = this.gateways.removeGateway(gatewayName);
                if (logger.isDebugEnabled()) {
                    if (removedGateway != null) {
                        logger.debug((Object)("Gateway [" + gatewayName + "] removed"));
                    } else {
                        logger.debug((Object)("Gateway [" + gatewayName + "] not removed"));
                    }
                }
            }
        }
    }

    @Override
    public DumpResult generateDump(final Set<DumpProvider> dumpProviders, final DumpGeneratedListener listener, final String cause, final Map<String, Object> context, final String ... processor) throws AdminException {
        CompoundDumpResult dumpResult = new CompoundDumpResult();
        ExecutorService es = Executors.newFixedThreadPool(dumpProviders.size());
        ExecutorCompletionService<DumpResult> cs = new ExecutorCompletionService<DumpResult>(es);
        final AtomicInteger counter = new AtomicInteger();
        for (final DumpProvider dumpProvider : dumpProviders) {
            cs.submit(new Callable<DumpResult>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public DumpResult call() throws Exception {
                    DumpResult result = dumpProvider.generateDump(cause, context, processor);
                    DumpGeneratedListener dumpGeneratedListener = listener;
                    synchronized (dumpGeneratedListener) {
                        listener.onGenerated(dumpProvider, result, counter.incrementAndGet(), dumpProviders.size());
                    }
                    return result;
                }
            });
        }
        for (int i = 0; i < dumpProviders.size(); ++i) {
            try {
                dumpResult.add((DumpResult)cs.take().get());
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        es.shutdown();
        return dumpResult;
    }

    @Override
    public DumpResult generateDump(String cause, Map<String, Object> context) throws AdminException {
        return this.generateDump(cause, context, (String[])null);
    }

    @Override
    public DumpResult generateDump(String cause, Map<String, Object> context, String ... processor) throws AdminException {
        CompoundDumpResult dumpResult = new CompoundDumpResult();
        if (context != null && context.containsKey("createOverviewOnly")) {
            dumpResult.addDumpFile(InternalOverviewBuilder.createOverviewDumpResult(this));
        } else {
            context = this.setIncludeOverviewToContext(context, false);
            for (Machine machine : this.machines) {
                dumpResult.add(machine.generateDump(cause, context, processor));
            }
            dumpResult.addDumpFile(InternalOverviewBuilder.createOverviewDumpResult(this));
        }
        return dumpResult;
    }

    private Map<String, Object> setIncludeOverviewToContext(Map<String, Object> context, boolean include) {
        if (context == null) {
            context = new HashMap<String, Object>();
        }
        context.put("include-overview", include);
        return context;
    }

    @Override
    public ScheduledFuture<?> scheduleWithFixedDelayNonBlockingStateChange(final Runnable command, long initialDelay, long delay, TimeUnit unit) {
        if (this.closeStarted.get()) {
            throw new AdminClosedException();
        }
        return this.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                DefaultAdmin.this.scheduleNonBlockingStateChange(DefaultAdmin.this.toLoggerRunnable(command));
            }
        }, initialDelay, delay, unit);
    }

    @Override
    public ScheduledFuture<?> scheduleOneTimeWithDelayNonBlockingStateChange(final Runnable command, long delay, TimeUnit unit) {
        if (this.closeStarted.get()) {
            throw new AdminClosedException();
        }
        return this.getScheduler().schedule(this.toLoggerRunnable(new Runnable(){

            @Override
            public void run() {
                DefaultAdmin.this.scheduleNonBlockingStateChange(command);
            }
        }), delay, unit);
    }

    @Override
    public boolean isSingleThreadedEventListeners() {
        return this.singleThreadedEventListeners;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Space removeRemovedSpace(ProcessingUnit processingUnit) {
        this.assertStateChangesPermitted();
        DefaultAdmin defaultAdmin = this;
        synchronized (defaultAdmin) {
            Space space = this.removedSpacesPerProcessingUnit.remove(processingUnit);
            return space;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Space removeRemovedSpace(String spaceUid) {
        this.assertStateChangesPermitted();
        DefaultAdmin defaultAdmin = this;
        synchronized (defaultAdmin) {
            Space space = null;
            Iterator<Map.Entry<ProcessingUnit, Space>> iterator = this.removedSpacesPerProcessingUnit.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<ProcessingUnit, Space> pair = iterator.next();
                if (!pair.getValue().getUid().equals(spaceUid)) continue;
                space = pair.getValue();
                iterator.remove();
                break;
            }
            return space;
        }
    }

    private void addRemovedSpace(InternalSpace removedSpace, ProcessingUnit processingUnit) {
        this.removedSpacesPerProcessingUnit.put(processingUnit, removedSpace);
    }

    public void setAdminFilter(AdminFilter adminFilter) {
        this.adminFilter = adminFilter;
    }

    @Override
    public AdminFilter getAdminFilter() {
        return this.adminFilter;
    }

    @Override
    public void addGatewayProcessingUnit(GatewayProcessingUnit gatewayProcessingUnit) {
        this.gatewayProcessingUnits.addGatewayProcessingUnit(gatewayProcessingUnit);
    }

    @Override
    public void removeGatewayProcessingUnit(String uid) {
        this.gatewayProcessingUnits.removeGatewayProcessingUnit(uid);
    }

    @Override
    public ProcessingUnitInstance[] getOrphanProcessingUnitInstances() {
        return this.adminProcessingUnitInstances.getOrphanProcessingUnitInstances();
    }

    public void setDiscoveryServices(Class ... discoveryServices) {
        this.discoveryService.setDiscoveryServices(discoveryServices);
    }

    private class LoggerRunnable
    implements Runnable {
        private final Runnable runnable;

        private LoggerRunnable(Runnable runnable) {
            this.runnable = runnable;
        }

        @Override
        public void run() {
            if (DefaultAdmin.this.closeEnded.get()) {
                AdminClosedException e = new AdminClosedException("Not executing: " + this.runnable + " - Admin " + this.hashCode() + " already closed. executorService.shutdownNow should have been called.");
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)e.getMessage(), (Throwable)e);
                }
                return;
            }
            try {
                this.runnable.run();
            }
            catch (Exception e) {
                if (DefaultAdmin.this.closeStarted.get()) {
                    if (logger.isDebugEnabled()) {
                        if (DefaultAdmin.this.closeEnded.get()) {
                            logger.debug((Object)("Failed to execute: " + this.runnable + " since admin " + this.hashCode() + " has already closed - " + e), (Throwable)e);
                        } else {
                            logger.debug((Object)("Failed to execute: " + this.runnable + " since admin " + this.hashCode() + " is being closed - " + e), (Throwable)e);
                        }
                    }
                } else {
                    logger.warn((Object)("Failed to execute: " + this.runnable + " - " + e), (Throwable)e);
                }
            }
            catch (Error e) {
                logger.error((Object)("Failed to execute: " + this.runnable + " - " + e), (Throwable)e);
                throw e;
            }
        }
    }

    private class ScheduledProcessingUnitMonitor
    implements Runnable {
        private static final int maxNumberOfEvents = 1000;
        private Long eventsCursor;
        private String eventsCursorEsmUid;
        private String lastHoldersStateDescription = "";

        private ScheduledProcessingUnitMonitor() {
        }

        @Override
        public void run() {
            InternalElasticServiceManager esm1;
            Events scaleStrategyEvents1;
            HashMap<String, Holder> holders;
            ArrayList<Events> eventsFromGSMs;
            block13: {
                String currentHoldersStateDescription;
                eventsFromGSMs = new ArrayList<Events>();
                holders = new HashMap<String, Holder>();
                for (GridServiceManager gsm : DefaultAdmin.this.gridServiceManagers.getManagersNonFiltered()) {
                    try {
                        PUsDetails pusDetails = ((InternalGridServiceManager)gsm).getGSM().getPUsDetails();
                        for (PUDetails detail : pusDetails.getDetails()) {
                            Holder holder = (Holder)holders.get(detail.getName());
                            if (holder == null) {
                                holder = new Holder();
                                holder.name = detail.getName();
                                holders.put(holder.name, holder);
                            }
                            if (detail.isManaging()) {
                                if (logger.isDebugEnabled() && holder.managingGSM != null) {
                                    logger.debug((Object)("Detected two managing GSMs for PU" + holder.name + ": existing GSM " + holder.managingGSM.getUid() + " is overridden by " + gsm.getUid()));
                                }
                                holder.detail = detail;
                                holder.managingGSM = gsm;
                                continue;
                            }
                            holder.backupDetail = detail;
                            holder.backupGSMs.put(gsm.getUid(), gsm);
                        }
                        Events events = ((InternalGridServiceManager)gsm).getEvents(100);
                        eventsFromGSMs.add(events);
                    }
                    catch (Exception e) {
                        if (NetworkExceptionHelper.isConnectOrCloseException(e) || DefaultAdmin.this.closeStarted.get()) continue;
                        logger.warn((Object)"Failed to get GSM details", (Throwable)e);
                    }
                }
                if (logger.isDebugEnabled() && !(currentHoldersStateDescription = StringUtils.arrayToDelimitedString((Object[])holders.values().toArray(new Holder[0]), (String)StringUtils.NEW_LINE)).equals(this.lastHoldersStateDescription)) {
                    this.lastHoldersStateDescription = currentHoldersStateDescription;
                    logger.debug((Object)("Current PUs Management state: " + StringUtils.NEW_LINE + currentHoldersStateDescription));
                }
                scaleStrategyEvents1 = null;
                esm1 = null;
                try {
                    if (DefaultAdmin.this.elasticServiceManagers.getSize() > 0) {
                        esm1 = (InternalElasticServiceManager)DefaultAdmin.this.elasticServiceManagers.getManagersNonFiltered()[0];
                        if (this.eventsCursorEsmUid == null || !esm1.getUid().equals(this.eventsCursorEsmUid)) {
                            this.eventsCursor = 0L;
                            this.eventsCursorEsmUid = esm1.getUid();
                        }
                        scaleStrategyEvents1 = esm1.getScaleStrategyEvents(this.eventsCursor, 1000);
                        long newEventsCursor = scaleStrategyEvents1.getNextCursor();
                        if (logger.isDebugEnabled() && newEventsCursor > this.eventsCursor) {
                            logger.debug((Object)("Retrieved ESM events from " + this.eventsCursor + " to " + (newEventsCursor - 1L)));
                        }
                        this.eventsCursor = newEventsCursor;
                    }
                }
                catch (AdminException e) {
                    if (e.getCause() != null && NetworkExceptionHelper.isConnectOrCloseException(e.getCause()) || DefaultAdmin.this.closeStarted.get()) break block13;
                    logger.warn((Object)"Failed to get ESM details", (Throwable)e);
                }
            }
            final Events scaleStrategyEvents = scaleStrategyEvents1;
            final InternalElasticServiceManager esm = esm1;
            DefaultAdmin.this.scheduleNonBlockingStateChange(DefaultAdmin.this.toLoggerRunnable(new Runnable(){

                @Override
                public void run() {
                    ScheduledProcessingUnitMonitor.this.updateState(holders, scaleStrategyEvents, esm);
                    ScheduledProcessingUnitMonitor.this.processEventsFromGsm(eventsFromGSMs);
                }
            }));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void updateState(Map<String, Holder> holders, Events scaleStrategyEvents, InternalElasticServiceManager esm) {
            if (scaleStrategyEvents != null && esm != null) {
                for (Event event : scaleStrategyEvents.getEvents()) {
                    if (logger.isTraceEnabled()) {
                        logger.trace((Object)("Processing ESM event:" + event));
                    }
                    DefaultAdmin.this.machines.processElasticScaleStrategyEvent((ElasticProcessingUnitEvent)event);
                    DefaultAdmin.this.gridServiceAgents.processElasticScaleStrategyEvent((ElasticProcessingUnitEvent)event);
                    DefaultAdmin.this.gridServiceContainers.processElasticScaleStrategyEvent((ElasticProcessingUnitEvent)event);
                    DefaultAdmin.this.processingUnits.processElasticScaleStrategyEvent((ElasticProcessingUnitEvent)event);
                    esm.processElasticScaleStrategyEvent((ElasticProcessingUnitEvent)event);
                }
            }
            for (ProcessingUnit processingUnit : DefaultAdmin.this.processingUnits) {
                Space space;
                if (holders.containsKey(processingUnit.getName()) || processingUnit.getInstances().length > 0 && ((InternalProcessingUnit)processingUnit).isStandaloneProcessingUnit()) continue;
                DefaultAdmin.this.processingUnits.removeProcessingUnit(processingUnit.getName());
                DefaultAdmin.this.adminProcessingUnitInstances.processRemovedOnProcessingUnitRemoval(processingUnit);
                DefaultAdmin.this.processApplicationsOnProcessingUnitRemoval(processingUnit);
                if (this.isUniversalServiceManagerProcessingUnit(processingUnit)) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Stopping statistics monitor for processing unit " + processingUnit.getName()));
                    }
                    processingUnit.stopStatisticsMonitor();
                }
                if ((space = processingUnit.getSpace()) != null) {
                    ((InternalProcessingUnit)processingUnit).removeEmbeddedSpace(space);
                }
                DefaultAdmin.this.removeRemovedSpace(processingUnit);
            }
            for (Holder holder : holders.values()) {
                PUDetails details = holder.detail;
                if (details == null) {
                    details = holder.backupDetail;
                }
                boolean newProcessingUnit = false;
                InternalProcessingUnit processingUnit = (InternalProcessingUnit)DefaultAdmin.this.processingUnits.getProcessingUnit(holder.name);
                if (processingUnit == null) {
                    BeanLevelProperties beanLevelProperties = null;
                    try {
                        beanLevelProperties = (BeanLevelProperties)details.getBeanLevelProperties().get();
                    }
                    catch (Throwable e) {
                        logger.error((Object)("Failed to get bean level properties for Processing Unit [" + holder.name + "]"), e);
                        continue;
                    }
                    if (!AdminFilterHelper.acceptProcessingUnit(DefaultAdmin.this.getAdminFilter(), beanLevelProperties)) continue;
                    processingUnit = new DefaultProcessingUnit(DefaultAdmin.this, DefaultAdmin.this.processingUnits, details, beanLevelProperties);
                    newProcessingUnit = true;
                }
                if (holder.detail == null) {
                    processingUnit.setBackupGsmInSync(false);
                } else if (holder.backupDetail == null) {
                    processingUnit.setBackupGsmInSync(false);
                } else if (holder.detail.getNumberOfInstances() != holder.backupDetail.getNumberOfInstances()) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("GSMs not in sync yet. Number of planned instances of " + processingUnit.getName() + " is " + holder.detail.getNumberOfInstances() + " but backup gsm planned still reports " + holder.backupDetail.getNumberOfInstances()));
                    }
                    processingUnit.setBackupGsmInSync(false);
                } else {
                    processingUnit.setBackupGsmInSync(true);
                }
                processingUnit.setNumberOfInstances(details.getNumberOfInstances());
                processingUnit.setNumberOfBackups(details.getNumberOfBackups());
                if (!newProcessingUnit) {
                    if (holder.managingGSM == null) {
                        if (processingUnit.isManaged()) {
                            processingUnit.addManagingGridServiceManager(null);
                        }
                    } else if (!processingUnit.isManaged() || !processingUnit.getManagingGridServiceManager().getUid().equals(holder.managingGSM.getUid())) {
                        processingUnit.addManagingGridServiceManager(holder.managingGSM);
                        if (processingUnit.getBackupGridServiceManager(holder.managingGSM.getUid()) != null) {
                            processingUnit.removeBackupGridServiceManager(holder.managingGSM.getUid());
                        }
                    }
                    for (GridServiceManager backupGSM : processingUnit.getBackupGridServiceManagers()) {
                        if (holder.backupGSMs.containsKey(backupGSM.getUid())) continue;
                        processingUnit.removeBackupGridServiceManager(backupGSM.getUid());
                    }
                    for (GridServiceManager backupGSM : holder.backupGSMs.values()) {
                        if (processingUnit.getBackupGridServiceManager(backupGSM.getUid()) != null) continue;
                        processingUnit.addBackupGridServiceManager(backupGSM);
                    }
                } else if (holder.managingGSM != null) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Discovered new PU " + processingUnit.getName()));
                    }
                    processingUnit.setManagingGridServiceManager(holder.managingGSM);
                    DefaultAdmin.this.processingUnits.addProcessingUnit(processingUnit);
                    processingUnit.addManagingGridServiceManager(holder.managingGSM);
                    for (GridServiceManager backupGSM : holder.backupGSMs.values()) {
                        processingUnit.addBackupGridServiceManager(backupGSM);
                    }
                    DefaultAdmin.this.processApplicationsOnProcessingUnitAddition(processingUnit);
                    if (this.isUniversalServiceManagerProcessingUnit(processingUnit)) {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Starting statistics monitor for processing unit " + processingUnit.getName()));
                        }
                        processingUnit.startStatisticsMonitor();
                    }
                }
                if (holder.managingGSM == null) continue;
                int status = details.getStatus();
                if (this.isUniversalServiceManagerProcessingUnit(processingUnit)) {
                    status = this.degradeUniversalServiceManagerProcessingUnitStatus(processingUnit, status);
                }
                processingUnit.setStatus(status);
            }
            DefaultAdmin.this.assertStateChangesPermitted();
            DefaultAdmin defaultAdmin = DefaultAdmin.this;
            synchronized (defaultAdmin) {
                for (ProcessingUnitInstance orphanedX : DefaultAdmin.this.adminProcessingUnitInstances.getOrphanProcessingUnitInstances()) {
                    StandaloneServiceDetails standaloneSvcDetails;
                    InternalProcessingUnitInstance orphaned = (InternalProcessingUnitInstance)orphanedX;
                    InternalProcessingUnit processingUnit = (InternalProcessingUnit)DefaultAdmin.this.processingUnits.getProcessingUnit(orphaned.getName());
                    InternalGridServiceContainer gridServiceContainer = (InternalGridServiceContainer)DefaultAdmin.this.gridServiceContainers.getContainerByUID(orphaned.getGridServiceContainerServiceID().toString());
                    if (processingUnit != null && gridServiceContainer != null) {
                        DefaultAdmin.this.processProcessingUnitInstanceAddition(processingUnit, orphaned);
                    }
                    if ((standaloneSvcDetails = (StandaloneServiceDetails)orphaned.getServiceDetailsByServiceId("Standalone")) == null) continue;
                    PUDetails standalonePuDetails = new PUDetails(orphaned.getName(), 2, false, orphaned.getClusterInfo().getNumberOfInstances().intValue(), orphaned.getClusterInfo().getNumberOfBackups().intValue(), standaloneSvcDetails.getProcessingUnitType(), standaloneSvcDetails.getBeanLevelProperties(), standaloneSvcDetails.getSla(), Collections.emptyMap(), 1, null, null, null, null);
                    DefaultProcessingUnit standaloneProcessingUnit = new DefaultProcessingUnit(DefaultAdmin.this, DefaultAdmin.this.processingUnits, standalonePuDetails, standaloneSvcDetails.getUnMarshalledBeanLevelPropertiesOrNull());
                    standaloneProcessingUnit.setStatus(standalonePuDetails.getStatus());
                    DefaultAdmin.this.processingUnits.addProcessingUnit(standaloneProcessingUnit);
                    DefaultAdmin.this.processProcessingUnitInstanceAddition(standaloneProcessingUnit, orphaned);
                }
                DefaultAdmin.this.flushEvents();
                DefaultAdmin.this.flushScheduleMonitorCorrelatedEvents();
            }
        }

        private boolean isUniversalServiceManagerProcessingUnit(ProcessingUnit processingUnit) {
            return ProcessingUnitType.UNIVERSAL.equals((Object)processingUnit.getType());
        }

        private void processEventsFromGsm(List<Events> eventsFromGSMs) {
            for (Events events : eventsFromGSMs) {
                for (Event event : events.getEvents()) {
                    if (event instanceof ServiceFaultDetectionEvent) {
                        ServiceFaultDetectionEvent serviceFaultDetectionEvent = (ServiceFaultDetectionEvent)event;
                        ServiceID serviceID = serviceFaultDetectionEvent.getServiceID();
                        String serviceIdAsString = serviceID.toString();
                        ProcessingUnitInstance puInstanceByUID = DefaultAdmin.this.processingUnitInstances.getInstanceByUID(serviceIdAsString);
                        if (puInstanceByUID != null) {
                            ((InternalProcessingUnitInstance)puInstanceByUID).setMemberAliveIndicatorStatus(serviceFaultDetectionEvent);
                            if (!serviceFaultDetectionEvent.isDetectedFailure()) continue;
                            DefaultAdmin.this.adminProcessingUnitInstances.delRemovedProcessingUnitInstance(puInstanceByUID);
                            continue;
                        }
                        ProcessingUnitInstance removedProcessingUnitInstance = DefaultAdmin.this.adminProcessingUnitInstances.getRemovedProcessingUnitInstance(serviceIdAsString);
                        if (removedProcessingUnitInstance == null) continue;
                        ((InternalProcessingUnitInstance)removedProcessingUnitInstance).setMemberAliveIndicatorStatus(serviceFaultDetectionEvent);
                        if (!serviceFaultDetectionEvent.isDetectedFailure()) continue;
                        DefaultAdmin.this.adminProcessingUnitInstances.delRemovedProcessingUnitInstance(removedProcessingUnitInstance);
                        continue;
                    }
                    if (!(event instanceof ProvisionLifeCycleEvent)) continue;
                    ProvisionLifeCycleEvent provEvent = (ProvisionLifeCycleEvent)event;
                    String processingUnitName = provEvent.getProcessingUnitName();
                    ProcessingUnit processingUnit = DefaultAdmin.this.processingUnits.getProcessingUnit(processingUnitName);
                    if (processingUnit == null) continue;
                    ((InternalProcessingUnit)processingUnit).processProvisionEvent(provEvent);
                }
            }
        }

        private int degradeUniversalServiceManagerProcessingUnitStatus(InternalProcessingUnit processingUnit, int status) {
            if (status == 5) {
                String CloudifyConstants_USM_MONITORS_SERVICE_ID = "USM";
                String CloudifyConstants_USM_MONITORS_STATE_ID = "USM_State";
                Integer USMState_RUNNING = 2;
                for (ProcessingUnitInstance instance : processingUnit.getProcessingUnitInstances()) {
                    ProcessingUnitInstanceStatistics statistics = ((InternalProcessingUnitInstance)instance).getLastStatistics();
                    if (statistics == null) {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("processing unit " + processingUnit.getName() + " state is scheduled because there are no statistics for instance " + instance.getUid()));
                        }
                        status = 1;
                        break;
                    }
                    ServiceMonitors serviceMonitors = statistics.getMonitors().get("USM");
                    if (serviceMonitors == null) {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("processing unit " + processingUnit.getName() + " state is scheduled because there is no " + "USM" + " service monitor for instance " + instance.getUid()));
                        }
                        status = 1;
                        break;
                    }
                    Integer state = (Integer)serviceMonitors.getMonitors().get("USM_State");
                    if (USMState_RUNNING.equals(state)) continue;
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("processing unit " + processingUnit.getName() + " state is scheduled because the USM state is " + state + " instead of " + USMState_RUNNING + " for instance " + instance.getUid()));
                    }
                    status = 1;
                    break;
                }
            }
            return status;
        }

        private class Holder {
            String name;
            PUDetails detail;
            PUDetails backupDetail;
            GridServiceManager managingGSM;
            Map<String, GridServiceManager> backupGSMs = new HashMap<String, GridServiceManager>();

            private Holder() {
            }

            public String toString() {
                StringBuilder sb = new StringBuilder().append("name: ").append(this.name).append(", ").append("managingGSM: ").append(this.managingGSM != null ? this.managingGSM.getUid() : "null").append(", ").append("backupGSMs: ");
                if (this.backupGSMs == null) {
                    sb.append("null");
                } else {
                    TreeSet<String> uids = new TreeSet<String>(this.backupGSMs.keySet());
                    sb.append(uids.toString());
                }
                return sb.toString();
            }
        }
    }

    private class ScheduledAgentProcessessMonitor
    implements Runnable {
        private ScheduledAgentProcessessMonitor() {
        }

        @Override
        public void run() {
            final HashMap<InternalGridServiceAgent, AgentProcessesDetails> newdetails = new HashMap<InternalGridServiceAgent, AgentProcessesDetails>();
            for (GridServiceAgent gridServiceAgent : DefaultAdmin.this.gridServiceAgents) {
                GSA gsa = ((InternalGridServiceAgent)gridServiceAgent).getGSA();
                try {
                    newdetails.put((InternalGridServiceAgent)gridServiceAgent, gsa.getDetails());
                }
                catch (Exception exception) {}
            }
            DefaultAdmin.this.scheduleNonBlockingStateChange(new Runnable(){

                @Override
                public void run() {
                    ScheduledAgentProcessessMonitor.this.updateState(newdetails);
                }
            });
        }

        private void updateState(Map<InternalGridServiceAgent, AgentProcessesDetails> newdetails) {
            for (Map.Entry<InternalGridServiceAgent, AgentProcessesDetails> entry : newdetails.entrySet()) {
                entry.getKey().setProcessesDetails(entry.getValue());
            }
        }
    }
}

