/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.admin.internal.alert;

import java.util.Map;
import org.openspaces.admin.Admin;
import org.openspaces.admin.alert.Alert;
import org.openspaces.admin.alert.AlertConfigurationException;
import org.openspaces.admin.alert.AlertStatus;
import org.openspaces.admin.alert.config.AlertConfiguration;
import org.openspaces.admin.alert.events.AlertTriggeredEventManager;
import org.openspaces.admin.bean.BeanConfig;
import org.openspaces.admin.bean.BeanConfigNotFoundException;
import org.openspaces.admin.bean.BeanConfigPropertiesManager;
import org.openspaces.admin.internal.alert.AlertRepository;
import org.openspaces.admin.internal.alert.DefaultAlertRepository;
import org.openspaces.admin.internal.alert.InternalAlertManager;
import org.openspaces.admin.internal.alert.events.DefaultAlertEventManager;
import org.openspaces.admin.internal.alert.events.InternalAlertTriggeredEventManager;
import org.openspaces.core.bean.DefaultBeanServer;

public class DefaultAlertManager
implements InternalAlertManager {
    private final Admin admin;
    private final InternalAlertTriggeredEventManager alertEventManager;
    private final AlertRepository alertRepository;
    private final BeanConfigPropertiesManager beanConfigPropertiesManager;

    public DefaultAlertManager(Admin admin) {
        this.admin = admin;
        this.alertEventManager = new DefaultAlertEventManager(this);
        this.alertRepository = new DefaultAlertRepository();
        this.beanConfigPropertiesManager = new DefaultBeanServer(admin);
    }

    @Override
    public AlertRepository getAlertRepository() {
        return this.alertRepository;
    }

    @Override
    public AlertTriggeredEventManager getAlertTriggered() {
        return this.alertEventManager;
    }

    @Override
    public AlertStatus getAlertStatusByGroupId(String groupUid) {
        Alert[] alertsByGroupUid = this.alertRepository.getAlertsByGroupUid(groupUid);
        if (alertsByGroupUid.length == 0) {
            return AlertStatus.NA;
        }
        return alertsByGroupUid[0].getStatus();
    }

    @Override
    public void triggerAlert(Alert alert) {
        this.alertRepository.addAlert(alert);
        this.alertEventManager.alertTriggered(alert);
    }

    @Override
    public Admin getAdmin() {
        return this.admin;
    }

    @Override
    public BeanConfigPropertiesManager getBeanConfigPropertiesManager() {
        return this.beanConfigPropertiesManager;
    }

    @Override
    public void disableAlert(Class<? extends AlertConfiguration> clazz) throws AlertConfigurationException {
        try {
            AlertConfiguration configInstance = this.getConfigInstance(clazz);
            this.beanConfigPropertiesManager.disableBean(configInstance.getBeanClassName());
        }
        catch (Exception e) {
            throw new AlertConfigurationException("Failed to disable alert [" + clazz.getName() + "]", e);
        }
    }

    @Override
    public void enableAlert(Class<? extends AlertConfiguration> clazz) throws AlertConfigurationException {
        try {
            AlertConfiguration configInstance = this.getConfigInstance(clazz);
            this.beanConfigPropertiesManager.enableBean(configInstance.getBeanClassName());
        }
        catch (Exception e) {
            throw new AlertConfigurationException("Failed to enable alert [" + clazz.getName() + "]", e);
        }
    }

    @Override
    public <T extends AlertConfiguration> T getConfig(Class<T> clazz) throws AlertConfigurationException {
        try {
            AlertConfiguration configInstance = (AlertConfiguration)this.getConfigInstance(clazz);
            Map<String, String> beanProperties = this.beanConfigPropertiesManager.getBeanConfig(configInstance.getBeanClassName());
            configInstance.setProperties(beanProperties);
            configInstance.setEnabled(this.beanConfigPropertiesManager.isBeanEnabled(configInstance.getBeanClassName()));
            return (T)configInstance;
        }
        catch (Exception e) {
            throw new AlertConfigurationException("Failed to get alert configuration [" + clazz.getName() + "]", e);
        }
    }

    @Override
    public boolean removeConfig(Class<? extends AlertConfiguration> clazz) throws AlertConfigurationException {
        try {
            AlertConfiguration configInstance = this.getConfigInstance(clazz);
            return this.beanConfigPropertiesManager.removeBeanConfig(configInstance.getBeanClassName());
        }
        catch (Exception e) {
            throw new AlertConfigurationException("Failed to remove alert configuration [" + clazz.getName() + "]", e);
        }
    }

    @Override
    public void setConfig(AlertConfiguration config) throws AlertConfigurationException {
        try {
            this.beanConfigPropertiesManager.setBeanConfig(config.getBeanClassName(), config.getProperties());
        }
        catch (Exception e) {
            throw new AlertConfigurationException("Failed to set alert configuration [" + config.getClass().getName() + "]", e);
        }
    }

    @Override
    public boolean isAlertEnabled(Class<? extends AlertConfiguration> clazz) {
        try {
            AlertConfiguration configInstance = this.getConfigInstance(clazz);
            return this.beanConfigPropertiesManager.isBeanEnabled(configInstance.getBeanClassName());
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public void configure(AlertConfiguration ... configurations) throws AlertConfigurationException {
        for (AlertConfiguration configuration : configurations) {
            block3: {
                try {
                    this.disableAlert(configuration.getClass());
                }
                catch (AlertConfigurationException e) {
                    if (e.getCause() instanceof BeanConfigNotFoundException) break block3;
                    throw e;
                }
            }
            this.setConfig(configuration);
            if (!configuration.isEnabled()) continue;
            this.enableAlert(configuration.getClass());
        }
    }

    private <T extends BeanConfig> T getConfigInstance(Class<T> clazz) {
        try {
            BeanConfig newInstance = (BeanConfig)clazz.newInstance();
            return (T)newInstance;
        }
        catch (Exception e) {
            throw new BeanConfigNotFoundException("Unable to extract bean name from " + clazz, e);
        }
    }
}

