/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.admin.internal.alert;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import org.openspaces.admin.alert.Alert;
import org.openspaces.admin.alert.AlertStatus;
import org.openspaces.admin.alert.alerts.AbstractAlert;
import org.openspaces.admin.internal.alert.InternalAlert;
import org.openspaces.admin.internal.alert.InternalAlertRepository;

public class DefaultAlertRepository
implements InternalAlertRepository {
    private int storeLimit = 200;
    private int incrementalAlertUid = 0;
    private final HashMap<String, AlertGroup> alertGroupByGroupUidMapping = new HashMap();
    private final LinkedList<AlertGroup> alertGroupList = new LinkedList();

    @Override
    public synchronized void setStoreLimit(int limit) {
        this.storeLimit = limit;
    }

    @Override
    public synchronized void addAlert(Alert alert) {
        this.setAlertUid(alert);
        this.mapAlertByGroupUid(alert);
        this.ensureStoreLimit();
    }

    private void setAlertUid(Alert alert) {
        InternalAlert internalAlert = null;
        if (alert instanceof AbstractAlert) {
            alert = ((AbstractAlert)alert).getAlert();
        }
        if (alert instanceof InternalAlert) {
            internalAlert = (InternalAlert)alert;
        }
        if (internalAlert == null) {
            throw new IllegalStateException("Can't set alert Uid, Alert must implement InternalAlert interface.");
        }
        ++this.incrementalAlertUid;
        internalAlert.setAlertUid(this.incrementalAlertUid + "@" + Integer.toHexString(System.identityHashCode(alert)));
    }

    private void mapAlertByGroupUid(Alert alert) {
        boolean needsNewAlertGroup;
        AlertGroup alertGroup = this.alertGroupByGroupUidMapping.get(alert.getGroupUid());
        boolean bl = needsNewAlertGroup = alertGroup != null && alertGroup.isResolved();
        if (alertGroup == null || needsNewAlertGroup) {
            alertGroup = new AlertGroup();
            alertGroup.addAlert(alert);
            this.alertGroupByGroupUidMapping.put(alert.getGroupUid(), alertGroup);
            this.alertGroupList.addFirst(alertGroup);
        } else {
            alertGroup.addAlert(alert);
            this.alertGroupList.remove(alertGroup);
            this.alertGroupList.addFirst(alertGroup);
        }
    }

    private void ensureStoreLimit() {
        AlertGroup lastAlertGroup;
        AlertGroup mappedAlertGroup;
        if (this.size() <= this.storeLimit) {
            return;
        }
        boolean removed = false;
        for (int i = this.alertGroupList.size() - 1; i >= 0; --i) {
            AlertGroup alertGroup = this.alertGroupList.get(i);
            if (!alertGroup.isUnResolved()) continue;
            for (int j = alertGroup.alertsInGroupList.size() - 2; j > 0; j -= 2) {
                alertGroup.alertsInGroupList.remove(j);
                removed = true;
            }
            if (removed) break;
        }
        if (!removed && (mappedAlertGroup = this.alertGroupByGroupUidMapping.get((lastAlertGroup = this.alertGroupList.removeLast()).getGroupUid())) == lastAlertGroup) {
            this.alertGroupByGroupUidMapping.remove(lastAlertGroup.getGroupUid());
        }
    }

    @Override
    public synchronized Alert getAlertByAlertUid(String alertUid) {
        for (AlertGroup alertGroup : this.alertGroupList) {
            for (Alert alert : alertGroup.alertsInGroupList) {
                if (!alert.getAlertUid().equals(alertUid)) continue;
                return alert;
            }
        }
        return null;
    }

    @Override
    public synchronized Alert[] getAlertsByGroupUid(String groupUid) {
        for (AlertGroup alertGroup : this.alertGroupList) {
            if (!alertGroup.getGroupUid().equals(groupUid)) continue;
            return alertGroup.toArray();
        }
        return new Alert[0];
    }

    @Override
    public synchronized Iterable<Alert> iterateFifo() {
        ArrayList<Alert> list = new ArrayList<Alert>(Math.max(10, this.alertGroupList.size()));
        for (int i = this.alertGroupList.size() - 1; i >= 0; --i) {
            AlertGroup alertGroup = this.alertGroupList.get(i);
            for (int j = alertGroup.alertsInGroupList.size() - 1; j >= 0; --j) {
                Alert alert = (Alert)alertGroup.alertsInGroupList.get(j);
                list.add(alert);
            }
        }
        return list;
    }

    @Override
    public synchronized Iterable<Alert> iterateLifo() {
        ArrayList<Alert> list = new ArrayList<Alert>(Math.max(10, this.alertGroupList.size()));
        for (int i = 0; i < this.alertGroupList.size(); ++i) {
            AlertGroup alertGroup = this.alertGroupList.get(i);
            for (int j = 0; j < alertGroup.alertsInGroupList.size(); ++j) {
                Alert alert = (Alert)alertGroup.alertsInGroupList.get(j);
                list.add(alert);
            }
        }
        return list;
    }

    @Override
    public synchronized Iterable<Iterable<Alert>> list() {
        ArrayList<Iterable<Alert>> list = new ArrayList<Iterable<Alert>>(Math.max(10, this.alertGroupList.size()));
        for (int i = 0; i < this.alertGroupList.size(); ++i) {
            AlertGroup alertGroup = this.alertGroupList.get(i);
            ArrayList alertsInGroup = new ArrayList(alertGroup.alertsInGroupList);
            list.add(alertsInGroup);
        }
        return list;
    }

    @Override
    public synchronized int size() {
        int size = 0;
        for (AlertGroup alertGroup : this.alertGroupList) {
            size += alertGroup.alertsInGroupList.size();
        }
        return size;
    }

    public static class AlertGroup {
        private final ArrayList<Alert> alertsInGroupList = new ArrayList();

        public void addAlert(Alert alert) {
            this.alertsInGroupList.add(0, alert);
        }

        public boolean isResolved() {
            return this.alertsInGroupList.get(0).getStatus().isResolved();
        }

        public boolean isUnResolved() {
            return this.alertsInGroupList.get(0).getStatus().getValue() > AlertStatus.RESOLVED.getValue();
        }

        public String getGroupUid() {
            return this.alertsInGroupList.get(0).getGroupUid();
        }

        public Alert[] toArray() {
            return this.alertsInGroupList.toArray(new Alert[this.alertsInGroupList.size()]);
        }
    }
}

