/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.admin.internal.alert.bean;

import java.util.ArrayList;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openspaces.admin.Admin;
import org.openspaces.admin.alert.Alert;
import org.openspaces.admin.alert.AlertFactory;
import org.openspaces.admin.alert.AlertSeverity;
import org.openspaces.admin.alert.AlertStatus;
import org.openspaces.admin.internal.alert.bean.AlertBean;
import org.openspaces.admin.internal.zone.config.ZonesConfigUtils;
import org.openspaces.admin.pu.elastic.events.ElasticProcessingUnitEvent;
import org.openspaces.admin.pu.elastic.events.ElasticProcessingUnitFailureEvent;
import org.openspaces.admin.pu.elastic.events.ElasticProcessingUnitProgressChangedEvent;

@Deprecated
public abstract class AbstractElasticProcessingUnitAlertBean
implements AlertBean {
    private final Log logger = LogFactory.getLog(this.getClass());
    private String beanUid;
    private String alertName;
    private AlertSeverity alertSeverity;
    private String resolvedAlertDescriptionFormat;
    Admin admin;
    Map<String, String> properties;

    public void setBeanUid(String beanUid) {
        this.beanUid = beanUid;
    }

    public void setAlertSeverity(AlertSeverity alertSeverity) {
        this.alertSeverity = alertSeverity;
    }

    public void setAlertName(String alertName) {
        this.alertName = alertName;
    }

    public void setResolvedAlertDescriptionFormat(String resolvedAlertDescriptionFormat) {
        this.resolvedAlertDescriptionFormat = resolvedAlertDescriptionFormat;
    }

    @Override
    public void setAdmin(Admin admin) {
        this.admin = admin;
    }

    @Override
    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    @Override
    public Map<String, String> getProperties() {
        return this.properties;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)(this.getClass() + " started"));
        }
    }

    @Override
    public void destroy() throws Exception {
    }

    protected Alert[] createResolvedAlerts(ElasticProcessingUnitProgressChangedEvent event) {
        if (!event.isComplete()) {
            return new Alert[0];
        }
        ArrayList<Alert> alerts = new ArrayList<Alert>();
        String groupUid = this.generateGroupUid(event);
        if (this.admin.getAlertManager().getAlertStatusByGroupId(groupUid).isUnresolved()) {
            alerts.add(this.createAlert(AlertStatus.RESOLVED, event));
        }
        return alerts.toArray(new Alert[alerts.size()]);
    }

    protected Alert createRaisedAlert(ElasticProcessingUnitFailureEvent event) {
        return this.createAlert(AlertStatus.RAISED, event);
    }

    private String generateGroupUid(ElasticProcessingUnitEvent event) {
        String groupUid = this.beanUid.concat("-").concat(event.getProcessingUnitName());
        if (event.getGridServiceAgentZones() != null) {
            groupUid = groupUid.concat(ZonesConfigUtils.zonesToString(event.getGridServiceAgentZones()));
        }
        return groupUid;
    }

    private Alert createAlert(AlertStatus status, ElasticProcessingUnitEvent event) {
        String alertDescription = status.equals(AlertStatus.RESOLVED) ? String.format(this.resolvedAlertDescriptionFormat, event.getProcessingUnitName()) : event.toString();
        String groupUid = this.generateGroupUid(event);
        String zonesDescription = event.getGridServiceAgentZones() != null ? " in zones " + event.getGridServiceAgentZones() : "";
        return new AlertFactory().name(this.alertName).severity(this.alertSeverity).description(alertDescription).status(status).componentUid(event.getProcessingUnitName()).componentDescription(event.getProcessingUnitName() + zonesDescription).groupUid(groupUid).create();
    }

    public void raiseAlert(Alert alert) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Triggering alert:" + alert.getDescription()));
        }
        this.admin.getAlertManager().triggerAlert(alert);
    }
}

