/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.admin.internal.alert.bean;

import java.text.NumberFormat;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jini.rio.resources.util.TimeUtil;
import org.openspaces.admin.Admin;
import org.openspaces.admin.alert.Alert;
import org.openspaces.admin.alert.AlertFactory;
import org.openspaces.admin.alert.AlertSeverity;
import org.openspaces.admin.alert.AlertStatus;
import org.openspaces.admin.alert.alerts.CpuUtilizationAlert;
import org.openspaces.admin.alert.config.CpuUtilizationAlertConfiguration;
import org.openspaces.admin.bean.BeanConfigurationException;
import org.openspaces.admin.internal.alert.bean.AlertBean;
import org.openspaces.admin.internal.alert.bean.util.AlertBeanUtils;
import org.openspaces.admin.internal.alert.bean.util.MovingAverageStatistics;
import org.openspaces.admin.machine.Machine;
import org.openspaces.admin.machine.events.MachineRemovedEventListener;
import org.openspaces.admin.os.events.OperatingSystemStatisticsChangedEvent;
import org.openspaces.admin.os.events.OperatingSystemStatisticsChangedEventListener;

public class CpuUtilizationAlertBean
implements AlertBean,
OperatingSystemStatisticsChangedEventListener,
MachineRemovedEventListener {
    private static final Logger logger = Logger.getLogger(CpuUtilizationAlert.class.getName());
    public static final String beanUID = "d7f14ccb-774a468d-29dd-4c23-b7de-d0ae9aaec204";
    public static final String ALERT_NAME = "CPU Utilization";
    private final CpuUtilizationAlertConfiguration config = new CpuUtilizationAlertConfiguration();
    private Admin admin;
    private static final NumberFormat NUMBER_FORMAT = NumberFormat.getInstance();
    private MovingAverageStatistics movingAverageStatistics;

    public CpuUtilizationAlertBean() {
        NUMBER_FORMAT.setMinimumFractionDigits(1);
        NUMBER_FORMAT.setMaximumFractionDigits(2);
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        this.validateProperties();
        long measurementPeriod = this.config.getMeasurementPeriod();
        int period = (int)(measurementPeriod / 5000L);
        this.movingAverageStatistics = new MovingAverageStatistics(period);
        this.admin.getMachines().getMachineRemoved().add(this);
        this.admin.getOperatingSystems().getOperatingSystemStatisticsChanged().add(this);
        this.admin.getOperatingSystems().startStatisticsMonitor();
    }

    @Override
    public void destroy() throws Exception {
        this.movingAverageStatistics.clear();
        this.admin.getMachines().getMachineRemoved().remove(this);
        this.admin.getOperatingSystems().getOperatingSystemStatisticsChanged().remove(this);
        this.admin.getOperatingSystems().stopStatisticsMonitor();
    }

    @Override
    public Map<String, String> getProperties() {
        return this.config.getProperties();
    }

    @Override
    public void setAdmin(Admin admin) {
        this.admin = admin;
    }

    @Override
    public void setProperties(Map<String, String> properties) {
        this.config.setProperties(properties);
    }

    private void validateProperties() {
        if (this.config.getHighThresholdPerc() == null) {
            throw new BeanConfigurationException("High threshold property is null");
        }
        if (this.config.getLowThresholdPerc() == null) {
            throw new BeanConfigurationException("Low threshold property is null");
        }
        if (this.config.getMeasurementPeriod() == null) {
            throw new BeanConfigurationException("Measurement period property is null");
        }
        if (this.config.getHighThresholdPerc() < this.config.getLowThresholdPerc()) {
            throw new BeanConfigurationException("Low threshold [" + this.config.getLowThresholdPerc() + "%] must be less than high threshold value [" + this.config.getHighThresholdPerc() + "%]");
        }
        if (this.config.getHighThresholdPerc() < 0) {
            throw new BeanConfigurationException("High threshold [" + this.config.getHighThresholdPerc() + "%] must greater than zero");
        }
        if (this.config.getLowThresholdPerc() < 0) {
            throw new BeanConfigurationException("Low threshold [" + this.config.getLowThresholdPerc() + "%] must greater or equal to zero");
        }
        if (this.config.getMeasurementPeriod() < 5000L) {
            throw new BeanConfigurationException("Measurement period [" + this.config.getMeasurementPeriod() + " ms] must be greater than [" + 5000L + " ms]");
        }
    }

    @Override
    public void machineRemoved(Machine machine) {
        this.movingAverageStatistics.clear(machine.getOperatingSystem().getUid());
        String groupUid = this.generateGroupUid(machine.getOperatingSystem().getUid());
        if (this.admin.getAlertManager().getAlertStatusByGroupId(groupUid).isUnresolved()) {
            AlertFactory factory = new AlertFactory();
            factory.name(ALERT_NAME);
            factory.groupUid(groupUid);
            factory.description("CPU measurement is unavailable; machine has been removed");
            factory.severity(AlertSeverity.WARNING);
            factory.status(AlertStatus.NA);
            factory.componentUid(machine.getOperatingSystem().getUid());
            factory.componentDescription(AlertBeanUtils.getMachineDescription(machine));
            factory.config(this.config.getProperties());
            Alert alert = factory.toAlert();
            this.admin.getAlertManager().triggerAlert(new CpuUtilizationAlert(alert));
        }
    }

    @Override
    public void operatingSystemStatisticsChanged(OperatingSystemStatisticsChangedEvent event) {
        int highThreshold = this.config.getHighThresholdPerc();
        int lowThreshold = this.config.getLowThresholdPerc();
        double cpuAvg = this.calcAverageWithinPeriod(event);
        if (cpuAvg < 0.0) {
            return;
        }
        if (cpuAvg > (double)highThreshold) {
            String groupUid = this.generateGroupUid(event.getOperatingSystem().getUid());
            AlertFactory factory = new AlertFactory();
            factory.name(ALERT_NAME);
            factory.groupUid(groupUid);
            factory.description("CPU crossed above a " + highThreshold + "% threshold, for a period of " + TimeUtil.format((long)this.config.getMeasurementPeriod()) + ", with an average CPU of " + NUMBER_FORMAT.format(cpuAvg) + "%");
            factory.severity(AlertSeverity.WARNING);
            factory.status(AlertStatus.RAISED);
            factory.componentUid(event.getOperatingSystem().getUid());
            factory.componentDescription(AlertBeanUtils.getMachineDescription(event.getStatistics().getDetails()));
            factory.config(this.config.getProperties());
            factory.putProperty("cpu-utilization", String.valueOf(event.getStatistics().getCpuPerc() * 100.0));
            factory.putProperty("host-name", event.getStatistics().getDetails().getHostName());
            factory.putProperty("host-address", event.getStatistics().getDetails().getHostAddress());
            Alert alert = factory.toAlert();
            this.admin.getAlertManager().triggerAlert(new CpuUtilizationAlert(alert));
        } else if (cpuAvg < (double)lowThreshold) {
            String groupUid = this.generateGroupUid(event.getOperatingSystem().getUid());
            if (this.admin.getAlertManager().getAlertStatusByGroupId(groupUid).isUnresolved()) {
                AlertFactory factory = new AlertFactory();
                factory.name(ALERT_NAME);
                factory.groupUid(groupUid);
                factory.description("CPU crossed below a " + lowThreshold + "% threshold, for a period of " + TimeUtil.format((long)this.config.getMeasurementPeriod()) + ", with an average CPU of " + NUMBER_FORMAT.format(cpuAvg) + "%");
                factory.severity(AlertSeverity.WARNING);
                factory.status(AlertStatus.RESOLVED);
                factory.componentUid(event.getOperatingSystem().getUid());
                factory.componentDescription(AlertBeanUtils.getMachineDescription(event.getStatistics().getDetails()));
                factory.config(this.config.getProperties());
                factory.putProperty("cpu-utilization", String.valueOf(event.getStatistics().getCpuPerc() * 100.0));
                factory.putProperty("host-name", event.getStatistics().getDetails().getHostName());
                factory.putProperty("host-address", event.getStatistics().getDetails().getHostAddress());
                Alert alert = factory.toAlert();
                this.admin.getAlertManager().triggerAlert(new CpuUtilizationAlert(alert));
            }
        }
    }

    private String generateGroupUid(String uid) {
        return beanUID.concat("-").concat(uid);
    }

    private double calcAverageWithinPeriod(OperatingSystemStatisticsChangedEvent event) {
        if (event.getStatistics().isNA()) {
            return -1.0;
        }
        String key = event.getOperatingSystem().getUid();
        this.movingAverageStatistics.addStatistics(key, event.getStatistics().getCpuPerc() * 100.0);
        double average = this.movingAverageStatistics.getAverageAndReset(key);
        if (average != -1.0 && logger.isLoggable(Level.FINE)) {
            logger.fine("host=[" + event.getOperatingSystem().getDetails().getHostName() + "] cpu used=[" + event.getStatistics().getCpuPerc() * 100.0 + "%] average=[" + average + "%] values: " + this.movingAverageStatistics.toString(key));
        }
        return average;
    }
}

