/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.admin.internal.alert.bean;

import java.text.NumberFormat;
import java.util.Map;
import org.jini.rio.resources.util.TimeUtil;
import org.openspaces.admin.Admin;
import org.openspaces.admin.alert.Alert;
import org.openspaces.admin.alert.AlertFactory;
import org.openspaces.admin.alert.AlertSeverity;
import org.openspaces.admin.alert.AlertStatus;
import org.openspaces.admin.alert.alerts.GarbageCollectionAlert;
import org.openspaces.admin.alert.config.GarbageCollectionAlertConfiguration;
import org.openspaces.admin.bean.BeanConfigurationException;
import org.openspaces.admin.internal.alert.bean.AlertBean;
import org.openspaces.admin.internal.alert.bean.util.AlertBeanUtils;
import org.openspaces.admin.vm.VirtualMachine;
import org.openspaces.admin.vm.events.VirtualMachineRemovedEventListener;
import org.openspaces.admin.vm.events.VirtualMachineStatisticsChangedEvent;
import org.openspaces.admin.vm.events.VirtualMachineStatisticsChangedEventListener;

public class GarbageCollectionAlertBean
implements AlertBean,
VirtualMachineStatisticsChangedEventListener,
VirtualMachineRemovedEventListener {
    public static final String beanUID = "94e663d9-0e2877c3-beb0-473f-a5bb-8fe965cd8751";
    public static final String ALERT_NAME = "Garbage Collection";
    private final GarbageCollectionAlertConfiguration config = new GarbageCollectionAlertConfiguration();
    private Admin admin;
    private static final NumberFormat NUMBER_FORMAT = NumberFormat.getInstance();

    public GarbageCollectionAlertBean() {
        NUMBER_FORMAT.setMinimumFractionDigits(1);
        NUMBER_FORMAT.setMaximumFractionDigits(2);
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        this.validateProperties();
        this.admin.getVirtualMachines().getVirtualMachineRemoved().add(this);
        this.admin.getVirtualMachines().getVirtualMachineStatisticsChanged().add(this);
        this.admin.getVirtualMachines().startStatisticsMonitor();
    }

    @Override
    public void destroy() throws Exception {
        this.admin.getVirtualMachines().getVirtualMachineRemoved().remove(this);
        this.admin.getVirtualMachines().getVirtualMachineStatisticsChanged().remove(this);
        this.admin.getVirtualMachines().stopStatisticsMonitor();
    }

    @Override
    public Map<String, String> getProperties() {
        return this.config.getProperties();
    }

    @Override
    public void setAdmin(Admin admin) {
        this.admin = admin;
    }

    @Override
    public void setProperties(Map<String, String> properties) {
        this.config.setProperties(properties);
    }

    private void validateProperties() {
        if (this.config.getLongGcPausePeriod() == null) {
            throw new BeanConfigurationException("Long GC pause period property is null");
        }
        if (this.config.getShortGcPausePeriod() == null) {
            throw new BeanConfigurationException("Short GC pause period property is null");
        }
        if (this.config.getLongGcPausePeriod() < this.config.getShortGcPausePeriod()) {
            throw new BeanConfigurationException("Long GC period [" + this.config.getLongGcPausePeriod() + " ms] must be greater than the short GC period [" + this.config.getShortGcPausePeriod() + " ms]");
        }
        if (this.config.getShortGcPausePeriod() < 0L) {
            throw new BeanConfigurationException("Measurement period [" + this.config.getShortGcPausePeriod() + " ms] must be greater than zero");
        }
    }

    @Override
    public void virtualMachineRemoved(VirtualMachine virtualMachine) {
        String groupUid = this.generateGroupUid(virtualMachine.getUid());
        if (this.admin.getAlertManager().getAlertStatusByGroupId(groupUid).isUnresolved()) {
            AlertFactory factory = new AlertFactory();
            factory.name(ALERT_NAME);
            factory.groupUid(groupUid);
            factory.description(AlertBeanUtils.getGridComponentShortName(virtualMachine) + " GC reading is unavailable; JVM has been removed");
            factory.severity(AlertSeverity.WARNING);
            factory.status(AlertStatus.NA);
            factory.componentUid(virtualMachine.getUid());
            factory.componentDescription(AlertBeanUtils.getGridComponentDescription(virtualMachine));
            factory.config(this.config.getProperties());
            Alert alert = factory.toAlert();
            this.admin.getAlertManager().triggerAlert(new GarbageCollectionAlert(alert));
        }
    }

    @Override
    public void virtualMachineStatisticsChanged(VirtualMachineStatisticsChangedEvent event) {
        long longGcPausePeriod = this.config.getLongGcPausePeriod();
        long shortGcPausePeriod = this.config.getShortGcPausePeriod();
        long gcCollectionTime = event.getStatistics().getGcCollectionTime();
        if (event.getStatistics().getPrevious() == null) {
            return;
        }
        long prevGcCollectionTime = event.getStatistics().getPrevious().getGcCollectionTime();
        long diffGcCollectionTime = gcCollectionTime - prevGcCollectionTime;
        long diffGcCollectionCount = event.getStatistics().getGcCollectionCount() - event.getStatistics().getPrevious().getGcCollectionCount();
        if (diffGcCollectionTime == 0L || diffGcCollectionCount == 0L) {
            return;
        }
        long gcPauseTime = diffGcCollectionTime / diffGcCollectionCount;
        if (gcPauseTime > longGcPausePeriod) {
            String groupUid = this.generateGroupUid(event.getVirtualMachine().getUid());
            AlertFactory factory = new AlertFactory();
            factory.name(ALERT_NAME);
            factory.groupUid(groupUid);
            factory.description(AlertBeanUtils.getGridComponentShortName(event.getVirtualMachine()) + " JVM garbage cycle collection time took " + TimeUtil.format((long)gcPauseTime));
            factory.severity(AlertSeverity.WARNING);
            factory.status(AlertStatus.RAISED);
            factory.componentUid(event.getVirtualMachine().getUid());
            factory.componentDescription(AlertBeanUtils.getGridComponentDescription(event.getVirtualMachine()));
            factory.config(this.config.getProperties());
            factory.putProperty("host-address", event.getVirtualMachine().getMachine().getHostAddress());
            factory.putProperty("host-name", event.getVirtualMachine().getMachine().getHostName());
            factory.putProperty("cpu-utilization", AlertBeanUtils.getCpuPercToString(event.getStatistics().getCpuPerc()));
            factory.putProperty("process-id", String.valueOf(event.getVirtualMachine().getDetails().getPid()));
            factory.putProperty("component-name", AlertBeanUtils.getGridComponentFullName(event.getVirtualMachine()));
            factory.putProperty("gc-duration-milliseconds", String.valueOf(gcPauseTime));
            factory.putProperty("heap-utilization", String.valueOf(event.getStatistics().getMemoryHeapUsedPerc()));
            factory.putProperty("non-heap-utilization", String.valueOf(event.getStatistics().getMemoryNonHeapUsedPerc()));
            Alert alert = factory.toAlert();
            this.admin.getAlertManager().triggerAlert(new GarbageCollectionAlert(alert));
        } else if (gcPauseTime < shortGcPausePeriod) {
            String groupUid = this.generateGroupUid(event.getVirtualMachine().getUid());
            if (this.admin.getAlertManager().getAlertStatusByGroupId(groupUid).isUnresolved()) {
                AlertFactory factory = new AlertFactory();
                factory.name(ALERT_NAME);
                factory.groupUid(groupUid);
                factory.description(AlertBeanUtils.getGridComponentShortName(event.getVirtualMachine()) + " JVM garbage cycle collection time took " + TimeUtil.format((long)gcPauseTime));
                factory.severity(AlertSeverity.WARNING);
                factory.status(AlertStatus.RESOLVED);
                factory.componentUid(event.getVirtualMachine().getUid());
                factory.componentDescription(AlertBeanUtils.getGridComponentDescription(event.getVirtualMachine()));
                factory.config(this.config.getProperties());
                factory.putProperty("host-address", event.getVirtualMachine().getMachine().getHostAddress());
                factory.putProperty("host-name", event.getVirtualMachine().getMachine().getHostName());
                factory.putProperty("cpu-utilization", AlertBeanUtils.getCpuPercToString(event.getStatistics().getCpuPerc()));
                factory.putProperty("process-id", String.valueOf(event.getVirtualMachine().getDetails().getPid()));
                factory.putProperty("component-name", AlertBeanUtils.getGridComponentFullName(event.getVirtualMachine()));
                factory.putProperty("gc-duration-milliseconds", String.valueOf(gcPauseTime));
                factory.putProperty("heap-utilization", String.valueOf(event.getStatistics().getMemoryHeapUsedPerc()));
                factory.putProperty("non-heap-utilization", String.valueOf(event.getStatistics().getMemoryNonHeapUsedPerc()));
                Alert alert = factory.toAlert();
                this.admin.getAlertManager().triggerAlert(new GarbageCollectionAlert(alert));
            }
        }
    }

    private String generateGroupUid(String uid) {
        return beanUID.concat("-").concat(uid);
    }
}

