/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.admin.internal.alert.bean;

import java.text.NumberFormat;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jini.rio.resources.util.TimeUtil;
import org.openspaces.admin.Admin;
import org.openspaces.admin.alert.Alert;
import org.openspaces.admin.alert.AlertFactory;
import org.openspaces.admin.alert.AlertSeverity;
import org.openspaces.admin.alert.AlertStatus;
import org.openspaces.admin.alert.alerts.HeapMemoryUtilizationAlert;
import org.openspaces.admin.alert.config.PhysicalMemoryUtilizationAlertConfiguration;
import org.openspaces.admin.bean.BeanConfigurationException;
import org.openspaces.admin.internal.alert.bean.AlertBean;
import org.openspaces.admin.internal.alert.bean.util.AlertBeanUtils;
import org.openspaces.admin.internal.alert.bean.util.MovingAverageStatistics;
import org.openspaces.admin.vm.VirtualMachine;
import org.openspaces.admin.vm.events.VirtualMachineRemovedEventListener;
import org.openspaces.admin.vm.events.VirtualMachineStatisticsChangedEvent;
import org.openspaces.admin.vm.events.VirtualMachineStatisticsChangedEventListener;

public class HeapMemoryUtilizationAlertBean
implements AlertBean,
VirtualMachineStatisticsChangedEventListener,
VirtualMachineRemovedEventListener {
    private static final Logger logger = Logger.getLogger(HeapMemoryUtilizationAlert.class.getName());
    public static final String beanUID = "694248f7-8a41119b-ddf9-4998-b3a0-885021e366af";
    public static final String ALERT_NAME = "Heap Memory Utilization";
    private final PhysicalMemoryUtilizationAlertConfiguration config = new PhysicalMemoryUtilizationAlertConfiguration();
    private Admin admin;
    private static final NumberFormat NUMBER_FORMAT = NumberFormat.getInstance();
    private MovingAverageStatistics movingAverageStatistics;

    public HeapMemoryUtilizationAlertBean() {
        NUMBER_FORMAT.setMinimumFractionDigits(1);
        NUMBER_FORMAT.setMaximumFractionDigits(2);
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        this.validateProperties();
        long measurementPeriod = this.config.getMeasurementPeriod();
        int period = (int)(measurementPeriod / 5000L);
        this.movingAverageStatistics = new MovingAverageStatistics(period);
        this.admin.getVirtualMachines().getVirtualMachineRemoved().add(this);
        this.admin.getVirtualMachines().getVirtualMachineStatisticsChanged().add(this);
        this.admin.getVirtualMachines().startStatisticsMonitor();
    }

    @Override
    public void destroy() throws Exception {
        this.movingAverageStatistics.clear();
        this.admin.getVirtualMachines().getVirtualMachineRemoved().remove(this);
        this.admin.getVirtualMachines().getVirtualMachineStatisticsChanged().remove(this);
        this.admin.getVirtualMachines().stopStatisticsMonitor();
    }

    @Override
    public Map<String, String> getProperties() {
        return this.config.getProperties();
    }

    @Override
    public void setAdmin(Admin admin) {
        this.admin = admin;
    }

    @Override
    public void setProperties(Map<String, String> properties) {
        this.config.setProperties(properties);
    }

    private void validateProperties() {
        if (this.config.getHighThresholdPerc() == null) {
            throw new BeanConfigurationException("High threshold property is null");
        }
        if (this.config.getLowThresholdPerc() == null) {
            throw new BeanConfigurationException("Low threshold property is null");
        }
        if (this.config.getMeasurementPeriod() == null) {
            throw new BeanConfigurationException("Measurement period property is null");
        }
        if (this.config.getHighThresholdPerc() < this.config.getLowThresholdPerc()) {
            throw new BeanConfigurationException("Low threshold [" + this.config.getLowThresholdPerc() + "%] must be less than high threshold value [" + this.config.getHighThresholdPerc() + "%]");
        }
        if (this.config.getHighThresholdPerc() < 0) {
            throw new BeanConfigurationException("High threshold [" + this.config.getHighThresholdPerc() + "%] must greater than zero");
        }
        if (this.config.getLowThresholdPerc() < 0) {
            throw new BeanConfigurationException("Low threshold [" + this.config.getLowThresholdPerc() + "%] must greater or equal to zero");
        }
        if (this.config.getMeasurementPeriod() < 5000L) {
            throw new BeanConfigurationException("Measurement period [" + this.config.getMeasurementPeriod() + " ms] must be greater than [" + 5000L + " ms]");
        }
    }

    @Override
    public void virtualMachineRemoved(VirtualMachine virtualMachine) {
        this.movingAverageStatistics.clear(virtualMachine.getUid());
        String groupUid = this.generateGroupUid(virtualMachine.getUid());
        if (this.admin.getAlertManager().getAlertStatusByGroupId(groupUid).isUnresolved()) {
            AlertFactory factory = new AlertFactory();
            factory.name(ALERT_NAME);
            factory.groupUid(groupUid);
            factory.description(AlertBeanUtils.getGridComponentShortName(virtualMachine) + " Heap memory is unavailable; JVM has been removed");
            factory.severity(AlertSeverity.WARNING);
            factory.status(AlertStatus.NA);
            factory.componentUid(virtualMachine.getUid());
            factory.componentDescription(AlertBeanUtils.getGridComponentDescription(virtualMachine));
            factory.config(this.config.getProperties());
            Alert alert = factory.toAlert();
            this.admin.getAlertManager().triggerAlert(new HeapMemoryUtilizationAlert(alert));
        }
    }

    @Override
    public void virtualMachineStatisticsChanged(VirtualMachineStatisticsChangedEvent event) {
        int highThreshold = this.config.getHighThresholdPerc();
        int lowThreshold = this.config.getLowThresholdPerc();
        double memoryAvg = this.calcAverageWithinPeriod(event);
        if (memoryAvg < 0.0) {
            return;
        }
        if (memoryAvg > (double)highThreshold) {
            String groupUid = this.generateGroupUid(event.getVirtualMachine().getUid());
            AlertFactory factory = new AlertFactory();
            factory.name(ALERT_NAME);
            factory.groupUid(groupUid);
            factory.description(AlertBeanUtils.getGridComponentShortName(event.getVirtualMachine()) + " Heap memory crossed above a " + highThreshold + "% threshold, for a period of " + TimeUtil.format((long)this.config.getMeasurementPeriod()) + ", with an average memory of " + NUMBER_FORMAT.format(memoryAvg) + "%");
            factory.severity(AlertSeverity.WARNING);
            factory.status(AlertStatus.RAISED);
            factory.componentUid(event.getVirtualMachine().getUid());
            factory.componentDescription(AlertBeanUtils.getGridComponentDescription(event.getVirtualMachine()));
            factory.config(this.config.getProperties());
            factory.putProperty("host-address", event.getVirtualMachine().getMachine().getHostAddress());
            factory.putProperty("host-name", event.getVirtualMachine().getMachine().getHostName());
            factory.putProperty("cpu-utilization", AlertBeanUtils.getCpuPercToString(event.getStatistics().getCpuPerc()));
            factory.putProperty("process-id", String.valueOf(event.getVirtualMachine().getDetails().getPid()));
            factory.putProperty("component-name", AlertBeanUtils.getGridComponentFullName(event.getVirtualMachine()));
            factory.putProperty("heap-utilization", String.valueOf(event.getStatistics().getMemoryHeapUsedPerc()));
            factory.putProperty("max-heap-in-bytes", String.valueOf(event.getVirtualMachine().getDetails().getMemoryHeapMaxInBytes()));
            Alert alert = factory.toAlert();
            this.admin.getAlertManager().triggerAlert(new HeapMemoryUtilizationAlert(alert));
        } else if (memoryAvg < (double)lowThreshold) {
            String groupUid = this.generateGroupUid(event.getVirtualMachine().getUid());
            if (this.admin.getAlertManager().getAlertStatusByGroupId(groupUid).isUnresolved()) {
                AlertFactory factory = new AlertFactory();
                factory.name(ALERT_NAME);
                factory.groupUid(groupUid);
                factory.description(AlertBeanUtils.getGridComponentShortName(event.getVirtualMachine()) + " Heap memory crossed below a " + lowThreshold + "% threshold, for a period of " + this.getPeriodOfTime(event) + ", with an average memory of " + NUMBER_FORMAT.format(memoryAvg) + "%");
                factory.severity(AlertSeverity.WARNING);
                factory.status(AlertStatus.RESOLVED);
                factory.componentUid(event.getVirtualMachine().getUid());
                factory.componentDescription(AlertBeanUtils.getGridComponentDescription(event.getVirtualMachine()));
                factory.config(this.config.getProperties());
                factory.putProperty("host-address", event.getVirtualMachine().getMachine().getHostAddress());
                factory.putProperty("host-name", event.getVirtualMachine().getMachine().getHostName());
                factory.putProperty("cpu-utilization", AlertBeanUtils.getCpuPercToString(event.getStatistics().getCpuPerc()));
                factory.putProperty("process-id", String.valueOf(event.getVirtualMachine().getDetails().getPid()));
                factory.putProperty("component-name", AlertBeanUtils.getGridComponentFullName(event.getVirtualMachine()));
                factory.putProperty("heap-utilization", String.valueOf(event.getStatistics().getMemoryHeapUsedPerc()));
                factory.putProperty("max-heap-in-bytes", String.valueOf(event.getVirtualMachine().getDetails().getMemoryHeapMaxInBytes()));
                Alert alert = factory.toAlert();
                this.admin.getAlertManager().triggerAlert(new HeapMemoryUtilizationAlert(alert));
            }
        }
    }

    private String generateGroupUid(String uid) {
        return beanUID.concat("-").concat(uid);
    }

    private double calcAverageWithinPeriod(VirtualMachineStatisticsChangedEvent event) {
        if (event.getStatistics().isNA()) {
            return -1.0;
        }
        String key = event.getVirtualMachine().getUid();
        this.movingAverageStatistics.addStatistics(key, event.getStatistics().getMemoryHeapUsedPerc());
        double average = this.movingAverageStatistics.getAverageAndReset(key);
        if (average != -1.0 && logger.isLoggable(Level.FINE)) {
            logger.fine("vm pid=[" + event.getVirtualMachine().getDetails().getPid() + "] memory used=[" + event.getStatistics().getMemoryHeapUsedPerc() + "%] average=[" + average + "%] values: " + this.movingAverageStatistics.toString(key));
        }
        return average;
    }

    private String getPeriodOfTime(VirtualMachineStatisticsChangedEvent event) {
        return TimeUtil.format((long)this.config.getMeasurementPeriod());
    }
}

