/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.admin.internal.alert.bean;

import com.gigaspaces.cluster.activeelection.SpaceMode;
import com.gigaspaces.cluster.replication.async.mirror.MirrorStatistics;
import com.j_spaces.core.filters.ReplicationStatistics;
import java.util.List;
import java.util.Map;
import org.openspaces.admin.Admin;
import org.openspaces.admin.GridComponent;
import org.openspaces.admin.alert.Alert;
import org.openspaces.admin.alert.AlertFactory;
import org.openspaces.admin.alert.AlertSeverity;
import org.openspaces.admin.alert.AlertStatus;
import org.openspaces.admin.alert.alerts.MirrorPersistenceFailureAlert;
import org.openspaces.admin.alert.config.MirrorPersistenceFailureAlertConfiguration;
import org.openspaces.admin.internal.alert.bean.AlertBean;
import org.openspaces.admin.internal.alert.bean.util.AlertBeanUtils;
import org.openspaces.admin.space.ReplicationStatus;
import org.openspaces.admin.space.ReplicationTarget;
import org.openspaces.admin.space.SpaceInstance;
import org.openspaces.admin.space.events.SpaceInstanceRemovedEventListener;
import org.openspaces.admin.space.events.SpaceInstanceStatisticsChangedEvent;
import org.openspaces.admin.space.events.SpaceInstanceStatisticsChangedEventListener;

public class MirrorPersistenceFailureAlertBean
implements AlertBean,
SpaceInstanceRemovedEventListener,
SpaceInstanceStatisticsChangedEventListener {
    public static final String beanUID = "aafb1222-f271090d-157b-4aa7-bc99-f5baec11296a";
    public static final String ALERT_NAME = "Mirror Persistence Failure";
    private final MirrorPersistenceFailureAlertConfiguration config = new MirrorPersistenceFailureAlertConfiguration();
    private Admin admin;

    @Override
    public void afterPropertiesSet() throws Exception {
        this.validateProperties();
        this.admin.getSpaces().getSpaceInstanceRemoved().add(this);
        this.admin.getSpaces().getSpaceInstanceStatisticsChanged().add(this);
        this.admin.getSpaces().startStatisticsMonitor();
    }

    @Override
    public void destroy() throws Exception {
        this.admin.getSpaces().getSpaceInstanceRemoved().remove(this);
        this.admin.getSpaces().getSpaceInstanceStatisticsChanged().remove(this);
        this.admin.getSpaces().stopStatisticsMonitor();
    }

    @Override
    public Map<String, String> getProperties() {
        return this.config.getProperties();
    }

    @Override
    public void setAdmin(Admin admin) {
        this.admin = admin;
    }

    @Override
    public void setProperties(Map<String, String> properties) {
        this.config.setProperties(properties);
    }

    private void validateProperties() {
    }

    @Override
    public void spaceInstanceRemoved(SpaceInstance spaceInstance) {
        if (!spaceInstance.getSpaceUrl().getSchema().equals("mirror")) {
            return;
        }
        String groupUid = this.generateGroupUid(spaceInstance.getUid());
        if (this.admin.getAlertManager().getAlertStatusByGroupId(groupUid).isUnresolved()) {
            AlertFactory factory = new AlertFactory();
            factory.name(ALERT_NAME);
            factory.groupUid(groupUid);
            factory.description("Mirror space " + this.getSpaceName(spaceInstance) + " is unavailable.");
            factory.severity(AlertSeverity.SEVERE);
            factory.status(AlertStatus.NA);
            factory.componentUid(spaceInstance.getUid());
            factory.componentDescription(AlertBeanUtils.getSpaceInstanceDescription(spaceInstance));
            factory.config(this.config.getProperties());
            factory.putProperty("host-name", spaceInstance.getMachine().getHostName());
            factory.putProperty("host-address", spaceInstance.getMachine().getHostAddress());
            factory.putProperty("vm-uid", spaceInstance.getVirtualMachine().getUid());
            Alert alert = factory.toAlert();
            this.admin.getAlertManager().triggerAlert(new MirrorPersistenceFailureAlert(alert));
        }
    }

    @Override
    public void spaceInstanceStatisticsChanged(SpaceInstanceStatisticsChangedEvent event) {
        MirrorStatistics mirrorStatistics;
        AlertFactory factory;
        String groupUid;
        SpaceInstance source = event.getSpaceInstance();
        ReplicationStatistics replicationStatistics = event.getStatistics().getReplicationStatistics();
        if (replicationStatistics == null) {
            return;
        }
        Boolean mirrorChannelIsInconsistent = null;
        String reason = null;
        long redoLogRetainedSize = -1L;
        GridComponent mirrorInstance = null;
        List channels = replicationStatistics.getOutgoingReplication().getChannels();
        for (ReplicationStatistics.OutgoingChannel channel : channels) {
            if (!ReplicationStatistics.ReplicationMode.MIRROR.equals((Object)channel.getReplicationMode())) continue;
            for (ReplicationTarget replicationTarget : source.getReplicationTargets()) {
                if (!replicationTarget.getMemberName().equals(channel.getTargetMemberName())) continue;
                mirrorInstance = replicationTarget.getSpaceInstance();
            }
            mirrorChannelIsInconsistent = channel.isInconsistent();
            if (!mirrorChannelIsInconsistent.booleanValue()) continue;
            reason = channel.getInconsistencyReason();
            redoLogRetainedSize = channel.getRedologRetainedSize();
            break;
        }
        if (mirrorChannelIsInconsistent == null || mirrorInstance == null) {
            return;
        }
        if (mirrorChannelIsInconsistent.booleanValue() && reason != null) {
            groupUid = this.generateGroupUid(mirrorInstance.getUid());
            factory = new AlertFactory();
            factory.name(ALERT_NAME);
            factory.groupUid(groupUid);
            factory.description("Mirror failed to persist data sent from " + this.getSpaceName(source) + " - " + this.getRootCauseMessage(reason));
            factory.severity(AlertSeverity.SEVERE);
            factory.status(AlertStatus.RAISED);
            factory.componentUid(mirrorInstance.getUid());
            factory.componentDescription(AlertBeanUtils.getSpaceInstanceDescription((SpaceInstance)mirrorInstance));
            factory.config(this.config.getProperties());
            factory.putProperty("host-name", mirrorInstance.getMachine().getHostName());
            factory.putProperty("host-address", mirrorInstance.getMachine().getHostAddress());
            factory.putProperty("vm-uid", mirrorInstance.getVirtualMachine().getUid());
            factory.putProperty("inconsistency-reason", reason);
            factory.putProperty("root-cause-message", this.getRootCauseMessage(reason));
            factory.putProperty("root-cause-trace", this.getRootCauseTrace(reason));
            factory.putProperty("replication-status", this.getReplicationStatus(source));
            factory.putProperty("redo-log-size", String.valueOf(replicationStatistics.getOutgoingReplication().getRedoLogSize()));
            factory.putProperty("redo-log-retained-size", String.valueOf(redoLogRetainedSize));
            mirrorStatistics = source.getStatistics().getMirrorStatistics();
            if (mirrorStatistics != null) {
                factory.putProperty("failed-operation-count", String.valueOf(mirrorStatistics.getFailedOperationCount()));
                factory.putProperty("in-progress-operation-count", String.valueOf(mirrorStatistics.getInProgressOperationCount()));
                factory.putProperty("discarded-operation-count", String.valueOf(mirrorStatistics.getDiscardedOperationCount()));
            }
            Alert alert = factory.toAlert();
            this.admin.getAlertManager().triggerAlert(new MirrorPersistenceFailureAlert(alert));
        } else if (!mirrorChannelIsInconsistent.booleanValue()) {
            groupUid = this.generateGroupUid(mirrorInstance.getUid());
            if (this.admin.getAlertManager().getAlertStatusByGroupId(groupUid).isUnresolved()) {
                factory = new AlertFactory();
                factory.name(ALERT_NAME);
                factory.groupUid(groupUid);
                factory.description("Mirror managed to persist data sent from  " + this.getSpaceName(source));
                factory.severity(AlertSeverity.SEVERE);
                factory.status(AlertStatus.RESOLVED);
                factory.componentUid(mirrorInstance.getUid());
                factory.componentDescription(AlertBeanUtils.getSpaceInstanceDescription((SpaceInstance)mirrorInstance));
                factory.config(this.config.getProperties());
                factory.putProperty("host-name", mirrorInstance.getMachine().getHostName());
                factory.putProperty("host-address", mirrorInstance.getMachine().getHostAddress());
                factory.putProperty("vm-uid", mirrorInstance.getVirtualMachine().getUid());
                factory.putProperty("replication-status", this.getReplicationStatus(source));
                factory.putProperty("redo-log-size", String.valueOf(replicationStatistics.getOutgoingReplication().getRedoLogSize()));
                factory.putProperty("redo-log-retained-size", String.valueOf(redoLogRetainedSize));
                mirrorStatistics = source.getStatistics().getMirrorStatistics();
                if (mirrorStatistics != null) {
                    factory.putProperty("failed-operation-count", String.valueOf(mirrorStatistics.getFailedOperationCount()));
                    factory.putProperty("in-progress-operation-count", String.valueOf(mirrorStatistics.getInProgressOperationCount()));
                    factory.putProperty("discarded-operation-count", String.valueOf(mirrorStatistics.getDiscardedOperationCount()));
                }
                Alert alert = factory.toAlert();
                this.admin.getAlertManager().triggerAlert(new MirrorPersistenceFailureAlert(alert));
            }
        }
    }

    private String getRootCauseMessage(String reason) {
        int endOfLineIndex;
        int lastIndexOfCausedBy = reason.lastIndexOf("Caused by: ");
        if (lastIndexOfCausedBy == -1) {
            lastIndexOfCausedBy = 0;
        }
        if ((endOfLineIndex = reason.indexOf("\n", lastIndexOfCausedBy)) == -1) {
            return reason.substring(0, Math.min(20, reason.length())) + "...";
        }
        String cause = reason.substring(lastIndexOfCausedBy, endOfLineIndex);
        return cause;
    }

    private String getRootCauseTrace(String reason) {
        int lastIndexOfAt;
        int lastIndexOfCausedBy = reason.lastIndexOf("Caused by: ");
        if (lastIndexOfCausedBy == -1) {
            lastIndexOfCausedBy = 0;
        }
        if ((lastIndexOfAt = reason.lastIndexOf("\tat", reason.length())) == -1) {
            return reason.substring(0, Math.min(20, reason.length())) + "...";
        }
        String cause = reason.substring(lastIndexOfCausedBy, lastIndexOfAt);
        return cause;
    }

    private String getReplicationStatus(SpaceInstance source) {
        for (ReplicationTarget target : source.getReplicationTargets()) {
            if (ReplicationStatus.ACTIVE.equals((Object)target.getReplicationStatus())) continue;
            return target.getReplicationStatus().name();
        }
        return ReplicationStatus.ACTIVE.name();
    }

    private String getSpaceName(SpaceInstance source) {
        StringBuilder sb = new StringBuilder();
        SpaceMode sourceSpaceMode = source.getMode();
        sb.append(sourceSpaceMode.toString().toLowerCase()).append(" Space ");
        sb.append(source.getSpace().getName() + "." + source.getInstanceId() + " [" + (source.getBackupId() + 1) + "]");
        return sb.toString();
    }

    private String generateGroupUid(String uid) {
        return beanUID.concat("-").concat(uid);
    }
}

