/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.admin.internal.alert.bean;

import java.text.NumberFormat;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jini.rio.resources.util.TimeUtil;
import org.openspaces.admin.Admin;
import org.openspaces.admin.alert.Alert;
import org.openspaces.admin.alert.AlertFactory;
import org.openspaces.admin.alert.AlertSeverity;
import org.openspaces.admin.alert.AlertStatus;
import org.openspaces.admin.alert.alerts.PhysicalMemoryUtilizationAlert;
import org.openspaces.admin.alert.config.PhysicalMemoryUtilizationAlertConfiguration;
import org.openspaces.admin.bean.BeanConfigurationException;
import org.openspaces.admin.internal.alert.bean.AlertBean;
import org.openspaces.admin.internal.alert.bean.util.AlertBeanUtils;
import org.openspaces.admin.internal.alert.bean.util.MovingAverageStatistics;
import org.openspaces.admin.machine.Machine;
import org.openspaces.admin.machine.events.MachineRemovedEventListener;
import org.openspaces.admin.os.events.OperatingSystemStatisticsChangedEvent;
import org.openspaces.admin.os.events.OperatingSystemStatisticsChangedEventListener;

public class PhysicalMemoryUtilizationAlertBean
implements AlertBean,
OperatingSystemStatisticsChangedEventListener,
MachineRemovedEventListener {
    private static final Logger logger = Logger.getLogger(PhysicalMemoryUtilizationAlert.class.getName());
    public static final String beanUID = "726a2752-4cae5258-f281-49d3-96b6-1e68e42bbd2c";
    public static final String ALERT_NAME = "Physical Memory Utilization";
    private final PhysicalMemoryUtilizationAlertConfiguration config = new PhysicalMemoryUtilizationAlertConfiguration();
    private Admin admin;
    private static final NumberFormat NUMBER_FORMAT = NumberFormat.getInstance();
    private MovingAverageStatistics movingAverageStatistics;

    public PhysicalMemoryUtilizationAlertBean() {
        NUMBER_FORMAT.setMinimumFractionDigits(1);
        NUMBER_FORMAT.setMaximumFractionDigits(2);
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        this.validateProperties();
        long measurementPeriod = this.config.getMeasurementPeriod();
        int period = (int)(measurementPeriod / 5000L);
        this.movingAverageStatistics = new MovingAverageStatistics(period);
        this.admin.getMachines().getMachineRemoved().add(this);
        this.admin.getOperatingSystems().getOperatingSystemStatisticsChanged().add(this);
        this.admin.getOperatingSystems().startStatisticsMonitor();
    }

    @Override
    public void destroy() throws Exception {
        this.movingAverageStatistics.clear();
        this.admin.getMachines().getMachineRemoved().remove(this);
        this.admin.getOperatingSystems().getOperatingSystemStatisticsChanged().remove(this);
        this.admin.getOperatingSystems().stopStatisticsMonitor();
    }

    @Override
    public Map<String, String> getProperties() {
        return this.config.getProperties();
    }

    @Override
    public void setAdmin(Admin admin) {
        this.admin = admin;
    }

    @Override
    public void setProperties(Map<String, String> properties) {
        this.config.setProperties(properties);
    }

    private void validateProperties() {
        if (this.config.getHighThresholdPerc() == null) {
            throw new BeanConfigurationException("High threshold property is null");
        }
        if (this.config.getLowThresholdPerc() == null) {
            throw new BeanConfigurationException("Low threshold property is null");
        }
        if (this.config.getMeasurementPeriod() == null) {
            throw new BeanConfigurationException("Measurement period property is null");
        }
        if (this.config.getHighThresholdPerc() < this.config.getLowThresholdPerc()) {
            throw new BeanConfigurationException("Low threshold [" + this.config.getLowThresholdPerc() + "%] must be less than high threshold value [" + this.config.getHighThresholdPerc() + "%]");
        }
        if (this.config.getHighThresholdPerc() < 0) {
            throw new BeanConfigurationException("High threshold [" + this.config.getHighThresholdPerc() + "%] must greater than zero");
        }
        if (this.config.getLowThresholdPerc() < 0) {
            throw new BeanConfigurationException("Low threshold [" + this.config.getLowThresholdPerc() + "%] must greater or equal to zero");
        }
        if (this.config.getMeasurementPeriod() < 5000L) {
            throw new BeanConfigurationException("Measurement period [" + this.config.getMeasurementPeriod() + " ms] must be greater than [" + 5000L + " ms]");
        }
    }

    @Override
    public void machineRemoved(Machine machine) {
        this.movingAverageStatistics.clear(machine.getOperatingSystem().getUid());
        String groupUid = this.generateGroupUid(machine.getOperatingSystem().getUid());
        if (this.admin.getAlertManager().getAlertStatusByGroupId(groupUid).isUnresolved()) {
            AlertFactory factory = new AlertFactory();
            factory.name(ALERT_NAME);
            factory.groupUid(groupUid);
            factory.description("Memory measurement is unavailable; machine has been removed");
            factory.severity(AlertSeverity.WARNING);
            factory.status(AlertStatus.NA);
            factory.componentUid(machine.getOperatingSystem().getUid());
            factory.componentDescription(AlertBeanUtils.getMachineDescription(machine));
            factory.config(this.config.getProperties());
            Alert alert = factory.toAlert();
            this.admin.getAlertManager().triggerAlert(new PhysicalMemoryUtilizationAlert(alert));
        }
    }

    @Override
    public void operatingSystemStatisticsChanged(OperatingSystemStatisticsChangedEvent event) {
        int highThreshold = this.config.getHighThresholdPerc();
        int lowThreshold = this.config.getLowThresholdPerc();
        double memoryAvg = this.calcAverageWithinPeriod(event);
        if (memoryAvg < 0.0) {
            return;
        }
        if (memoryAvg > (double)highThreshold) {
            String groupUid = this.generateGroupUid(event.getOperatingSystem().getUid());
            AlertFactory factory = new AlertFactory();
            factory.name(ALERT_NAME);
            factory.groupUid(groupUid);
            factory.description("Memory crossed above a " + highThreshold + "% threshold, for a period of " + TimeUtil.format((long)this.config.getMeasurementPeriod()) + ", with an average memory of " + NUMBER_FORMAT.format(memoryAvg) + "%");
            factory.severity(AlertSeverity.WARNING);
            factory.status(AlertStatus.RAISED);
            factory.componentUid(event.getOperatingSystem().getUid());
            factory.componentDescription(AlertBeanUtils.getMachineDescription(event.getStatistics().getDetails()));
            factory.config(this.config.getProperties());
            factory.putProperty("host-address", event.getStatistics().getDetails().getHostAddress());
            factory.putProperty("host-name", event.getStatistics().getDetails().getHostName());
            factory.putProperty("cpu-utilization", String.valueOf(event.getStatistics().getCpuPerc() * 100.0));
            factory.putProperty("memory-utilization", String.valueOf(event.getStatistics().getPhysicalMemoryUsedPerc()));
            Alert alert = factory.toAlert();
            this.admin.getAlertManager().triggerAlert(new PhysicalMemoryUtilizationAlert(alert));
        } else if (memoryAvg < (double)lowThreshold) {
            String groupUid = this.generateGroupUid(event.getOperatingSystem().getUid());
            if (this.admin.getAlertManager().getAlertStatusByGroupId(groupUid).isUnresolved()) {
                AlertFactory factory = new AlertFactory();
                factory.name(ALERT_NAME);
                factory.groupUid(groupUid);
                factory.description("Memory crossed below a " + lowThreshold + "% threshold, for a period of " + this.getPeriodOfTime(event) + ", with an average memory of " + NUMBER_FORMAT.format(memoryAvg) + "%");
                factory.severity(AlertSeverity.WARNING);
                factory.status(AlertStatus.RESOLVED);
                factory.componentUid(event.getOperatingSystem().getUid());
                factory.componentDescription(AlertBeanUtils.getMachineDescription(event.getStatistics().getDetails()));
                factory.config(this.config.getProperties());
                factory.putProperty("host-address", event.getStatistics().getDetails().getHostAddress());
                factory.putProperty("host-name", event.getStatistics().getDetails().getHostName());
                factory.putProperty("cpu-utilization", String.valueOf(event.getStatistics().getCpuPerc() * 100.0));
                factory.putProperty("memory-utilization", String.valueOf(event.getStatistics().getPhysicalMemoryUsedPerc()));
                Alert alert = factory.toAlert();
                this.admin.getAlertManager().triggerAlert(new PhysicalMemoryUtilizationAlert(alert));
            }
        }
    }

    private String generateGroupUid(String uid) {
        return beanUID.concat("-").concat(uid);
    }

    private double calcAverageWithinPeriod(OperatingSystemStatisticsChangedEvent event) {
        if (event.getStatistics().isNA()) {
            return -1.0;
        }
        String key = event.getOperatingSystem().getUid();
        this.movingAverageStatistics.addStatistics(key, event.getStatistics().getPhysicalMemoryUsedPerc());
        double average = this.movingAverageStatistics.getAverageAndReset(key);
        if (average != -1.0 && logger.isLoggable(Level.FINE)) {
            logger.fine("host=[" + event.getOperatingSystem().getDetails().getHostName() + "] memory used=[" + event.getStatistics().getPhysicalMemoryUsedPerc() + "%] average=[" + average + "%] values: " + this.movingAverageStatistics.toString(key));
        }
        return average;
    }

    private String getPeriodOfTime(OperatingSystemStatisticsChangedEvent event) {
        return TimeUtil.format((long)this.config.getMeasurementPeriod());
    }
}

