/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.admin.internal.alert.bean;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openspaces.admin.Admin;
import org.openspaces.admin.alert.Alert;
import org.openspaces.admin.alert.AlertFactory;
import org.openspaces.admin.alert.AlertSeverity;
import org.openspaces.admin.alert.AlertStatus;
import org.openspaces.admin.alert.alerts.ProcessingUnitInstanceMemberAliveIndicatorAlert;
import org.openspaces.admin.alert.config.ProcessingUnitInstanceMemberAliveIndicatorAlertConfiguration;
import org.openspaces.admin.internal.alert.InternalAlertManager;
import org.openspaces.admin.internal.alert.bean.AlertBean;
import org.openspaces.admin.pu.DeploymentStatus;
import org.openspaces.admin.pu.MemberAliveIndicatorStatus;
import org.openspaces.admin.pu.ProcessingUnit;
import org.openspaces.admin.pu.ProcessingUnitInstance;
import org.openspaces.admin.pu.events.ProcessingUnitInstanceAddedEventListener;
import org.openspaces.admin.pu.events.ProcessingUnitInstanceMemberAliveIndicatorStatusChangedEvent;
import org.openspaces.admin.pu.events.ProcessingUnitInstanceMemberAliveIndicatorStatusChangedEventListener;
import org.openspaces.admin.pu.events.ProcessingUnitRemovedEventListener;

public class ProcessingUnitInstanceMemberAliveIndicatorAlertBean
implements AlertBean,
ProcessingUnitInstanceMemberAliveIndicatorStatusChangedEventListener,
ProcessingUnitRemovedEventListener,
ProcessingUnitInstanceAddedEventListener {
    public static final String beanUID = "c5a43e4-39eaf476-fd5d-4399-8b7b-a97c3ec4f49a";
    public static final String ALERT_NAME = "Member Alive Indicator";
    private final ProcessingUnitInstanceMemberAliveIndicatorAlertConfiguration config = new ProcessingUnitInstanceMemberAliveIndicatorAlertConfiguration();
    private final Map<String, List<ProcessingUnitInstance>> mapProcessingUnitNameToProcessingUnitInstances = new HashMap<String, List<ProcessingUnitInstance>>();
    private Admin admin;

    @Override
    public void afterPropertiesSet() throws Exception {
        this.validateProperties();
        this.admin.getProcessingUnits().getProcessingUnitRemoved().add(this);
        this.admin.getProcessingUnits().getProcessingUnitInstanceAdded().add(this);
        this.admin.getProcessingUnits().getProcessingUnitInstanceMemberAliveIndicatorStatusChanged().add(this);
    }

    @Override
    public void destroy() throws Exception {
        this.admin.getProcessingUnits().getProcessingUnitRemoved().remove(this);
        this.admin.getProcessingUnits().getProcessingUnitInstanceAdded().remove(this);
        this.admin.getProcessingUnits().getProcessingUnitInstanceMemberAliveIndicatorStatusChanged().remove(this);
    }

    @Override
    public Map<String, String> getProperties() {
        return this.config.getProperties();
    }

    @Override
    public void setAdmin(Admin admin) {
        this.admin = admin;
    }

    @Override
    public void setProperties(Map<String, String> properties) {
        this.config.setProperties(properties);
    }

    private void validateProperties() {
    }

    @Override
    public void processingUnitRemoved(ProcessingUnit processingUnit) {
        List<ProcessingUnitInstance> listOfProcessingUnitInstances = this.mapProcessingUnitNameToProcessingUnitInstances.get(processingUnit.getName());
        if (listOfProcessingUnitInstances == null) {
            return;
        }
        for (ProcessingUnitInstance processingUnitInstance : listOfProcessingUnitInstances) {
            String groupUid = this.generateGroupUid(processingUnitInstance.getUid());
            if (!this.admin.getAlertManager().getAlertStatusByGroupId(groupUid).isUnresolved()) continue;
            AlertFactory factory = new AlertFactory();
            factory.name(ALERT_NAME);
            factory.groupUid(groupUid);
            if (processingUnit.getStatus().equals((Object)DeploymentStatus.UNDEPLOYED)) {
                factory.description("Processing Unit " + processingUnitInstance.getProcessingUnit().getName() + " has been undeployed");
                factory.severity(AlertSeverity.INFO);
                factory.status(AlertStatus.RESOLVED);
            } else {
                factory.description("Processing Unit " + processingUnitInstance.getProcessingUnit().getName() + " has been removed");
                factory.severity(AlertSeverity.SEVERE);
                factory.status(AlertStatus.NA);
            }
            factory.componentUid(processingUnitInstance.getUid());
            factory.componentDescription(processingUnitInstance.getProcessingUnitInstanceName());
            factory.config(this.config.getProperties());
            factory.putProperty("processing-unit-name", processingUnitInstance.getProcessingUnit().getName());
            factory.putProperty("member-alive-indicator-status", processingUnitInstance.getMemberAliveIndicatorStatus().name());
            factory.putProperty("host-address", processingUnitInstance.getMachine().getHostAddress());
            factory.putProperty("host-name", processingUnitInstance.getMachine().getHostName());
            factory.putProperty("vm-uid", processingUnitInstance.getVirtualMachine().getUid());
            factory.putProperty("cpu-utilization", String.valueOf(processingUnitInstance.getOperatingSystem().getStatistics().getCpuPerc() * 100.0));
            factory.putProperty("heap-utilization", String.valueOf(processingUnitInstance.getVirtualMachine().getStatistics().getMemoryHeapUsedPerc()));
            Alert alert = factory.toAlert();
            this.admin.getAlertManager().triggerAlert(new ProcessingUnitInstanceMemberAliveIndicatorAlert(alert));
        }
        this.mapProcessingUnitNameToProcessingUnitInstances.remove(processingUnit.getName());
    }

    @Override
    public void processingUnitInstanceAdded(ProcessingUnitInstance processingUnitInstanceAdded) {
        List<ProcessingUnitInstance> listOfProcessingUnitInstances = this.mapProcessingUnitNameToProcessingUnitInstances.get(processingUnitInstanceAdded.getProcessingUnit().getName());
        if (listOfProcessingUnitInstances == null) {
            return;
        }
        int i = listOfProcessingUnitInstances.size();
        while (--i >= 0) {
            ProcessingUnitInstance processingUnitInstance = listOfProcessingUnitInstances.get(i);
            if (!processingUnitInstanceAdded.getProcessingUnit().equals(processingUnitInstance.getProcessingUnit()) || !processingUnitInstanceAdded.getProcessingUnitInstanceName().equals(processingUnitInstance.getProcessingUnitInstanceName())) continue;
            listOfProcessingUnitInstances.remove(i);
            String prevGroupUid = this.generateGroupUid(processingUnitInstance.getUid());
            if (!this.admin.getAlertManager().getAlertStatusByGroupId(prevGroupUid).isUnresolved()) continue;
            Alert[] alertsByGroupUid = ((InternalAlertManager)this.admin.getAlertManager()).getAlertRepository().getAlertsByGroupUid(prevGroupUid);
            AlertFactory factory = new AlertFactory();
            factory.name(ALERT_NAME);
            factory.groupUid(prevGroupUid);
            factory.description("Re-provisioned " + processingUnitInstanceAdded.getProcessingUnitInstanceName() + " instance");
            factory.severity(alertsByGroupUid[0].getSeverity());
            factory.status(AlertStatus.RESOLVED);
            factory.componentUid(processingUnitInstanceAdded.getUid());
            factory.componentDescription(processingUnitInstanceAdded.getProcessingUnitInstanceName());
            factory.config(this.config.getProperties());
            factory.putProperty("processing-unit-name", processingUnitInstanceAdded.getProcessingUnit().getName());
            factory.putProperty("member-alive-indicator-status", processingUnitInstanceAdded.getMemberAliveIndicatorStatus().name());
            factory.putProperty("host-address", processingUnitInstanceAdded.getMachine().getHostAddress());
            factory.putProperty("host-name", processingUnitInstanceAdded.getMachine().getHostName());
            factory.putProperty("vm-uid", processingUnitInstanceAdded.getVirtualMachine().getUid());
            factory.putProperty("cpu-utilization", String.valueOf(processingUnitInstanceAdded.getOperatingSystem().getStatistics().getCpuPerc() * 100.0));
            factory.putProperty("heap-utilization", String.valueOf(processingUnitInstanceAdded.getVirtualMachine().getStatistics().getMemoryHeapUsedPerc()));
            Alert alert = factory.toAlert();
            this.admin.getAlertManager().triggerAlert(new ProcessingUnitInstanceMemberAliveIndicatorAlert(alert));
        }
    }

    @Override
    public void processingUnitInstanceMemberAliveIndicatorStatusChanged(ProcessingUnitInstanceMemberAliveIndicatorStatusChangedEvent event) {
        String groupUid = this.generateGroupUid(event.getProcessingUnitInstance().getUid());
        if (event.getNewStatus().equals((Object)MemberAliveIndicatorStatus.ALIVE)) {
            if (this.admin.getAlertManager().getAlertStatusByGroupId(groupUid).isUnresolved()) {
                AlertFactory factory = new AlertFactory();
                factory.name(ALERT_NAME);
                factory.groupUid(groupUid);
                if (event.getPreviousStatus() != null && event.getPreviousStatus().equals((Object)MemberAliveIndicatorStatus.SUSPECTING_FAILURE)) {
                    factory.description("Suspecting failure of " + event.getProcessingUnitInstance().getProcessingUnitInstanceName());
                    factory.severity(AlertSeverity.WARNING);
                } else {
                    factory.description("Detected failure of " + event.getProcessingUnitInstance().getProcessingUnitInstanceName());
                    factory.severity(AlertSeverity.SEVERE);
                }
                factory.status(AlertStatus.RESOLVED);
                factory.componentUid(event.getProcessingUnitInstance().getUid());
                factory.componentDescription(event.getProcessingUnitInstance().getProcessingUnitInstanceName());
                factory.config(this.config.getProperties());
                factory.putProperty("processing-unit-name", event.getProcessingUnitInstance().getProcessingUnit().getName());
                factory.putProperty("member-alive-indicator-status", event.getNewStatus().name());
                factory.putProperty("host-address", event.getProcessingUnitInstance().getMachine().getHostAddress());
                factory.putProperty("host-name", event.getProcessingUnitInstance().getMachine().getHostName());
                factory.putProperty("vm-uid", event.getProcessingUnitInstance().getVirtualMachine().getUid());
                factory.putProperty("cpu-utilization", String.valueOf(event.getProcessingUnitInstance().getOperatingSystem().getStatistics().getCpuPerc() * 100.0));
                factory.putProperty("heap-utilization", String.valueOf(event.getProcessingUnitInstance().getVirtualMachine().getStatistics().getMemoryHeapUsedPerc()));
                this.removeProcessingUnitInstanceFromMap(event);
                Alert alert = factory.toAlert();
                this.admin.getAlertManager().triggerAlert(new ProcessingUnitInstanceMemberAliveIndicatorAlert(alert));
            }
        } else {
            AlertFactory factory = new AlertFactory();
            factory.name(ALERT_NAME);
            factory.groupUid(groupUid);
            if (event.getNewStatus().equals((Object)MemberAliveIndicatorStatus.SUSPECTING_FAILURE)) {
                factory.description("Suspecting failure of " + event.getProcessingUnitInstance().getProcessingUnitInstanceName());
                factory.severity(AlertSeverity.WARNING);
            } else if (event.getNewStatus().equals((Object)MemberAliveIndicatorStatus.DETECTED_FAILURE)) {
                factory.description("Detected failure of " + event.getProcessingUnitInstance().getProcessingUnitInstanceName());
                factory.severity(AlertSeverity.SEVERE);
            }
            factory.status(AlertStatus.RAISED);
            factory.componentUid(event.getProcessingUnitInstance().getUid());
            factory.componentDescription(event.getProcessingUnitInstance().getProcessingUnitInstanceName());
            factory.config(this.config.getProperties());
            factory.putProperty("processing-unit-name", event.getProcessingUnitInstance().getProcessingUnit().getName());
            factory.putProperty("member-alive-indicator-status", event.getNewStatus().name());
            factory.putProperty("host-address", event.getProcessingUnitInstance().getMachine().getHostAddress());
            factory.putProperty("host-name", event.getProcessingUnitInstance().getMachine().getHostName());
            factory.putProperty("vm-uid", event.getProcessingUnitInstance().getVirtualMachine().getUid());
            factory.putProperty("cpu-utilization", String.valueOf(event.getProcessingUnitInstance().getOperatingSystem().getStatistics().getCpuPerc() * 100.0));
            factory.putProperty("heap-utilization", String.valueOf(event.getProcessingUnitInstance().getVirtualMachine().getStatistics().getMemoryHeapUsedPerc()));
            this.addProcessingUnitInstanceToMap(event);
            Alert alert = factory.toAlert();
            this.admin.getAlertManager().triggerAlert(new ProcessingUnitInstanceMemberAliveIndicatorAlert(alert));
        }
    }

    private void removeProcessingUnitInstanceFromMap(ProcessingUnitInstanceMemberAliveIndicatorStatusChangedEvent event) {
        String key = event.getProcessingUnitInstance().getProcessingUnit().getName();
        List<ProcessingUnitInstance> listOfProcessingUnitInstances = this.mapProcessingUnitNameToProcessingUnitInstances.get(key);
        if (listOfProcessingUnitInstances != null) {
            listOfProcessingUnitInstances.remove(event.getProcessingUnitInstance());
        }
    }

    private void addProcessingUnitInstanceToMap(ProcessingUnitInstanceMemberAliveIndicatorStatusChangedEvent event) {
        String key = event.getProcessingUnitInstance().getProcessingUnit().getName();
        List<ProcessingUnitInstance> listOfProcessingUnitInstances = this.mapProcessingUnitNameToProcessingUnitInstances.get(key);
        if (listOfProcessingUnitInstances == null) {
            listOfProcessingUnitInstances = new ArrayList<ProcessingUnitInstance>();
            listOfProcessingUnitInstances.add(event.getProcessingUnitInstance());
            this.mapProcessingUnitNameToProcessingUnitInstances.put(key, listOfProcessingUnitInstances);
        } else if (!listOfProcessingUnitInstances.contains(event.getProcessingUnitInstance())) {
            listOfProcessingUnitInstances.add(event.getProcessingUnitInstance());
        }
    }

    private String generateGroupUid(String uid) {
        return beanUID.concat("-").concat(uid);
    }
}

