/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.admin.internal.alert.bean;

import java.util.Map;
import org.openspaces.admin.Admin;
import org.openspaces.admin.alert.Alert;
import org.openspaces.admin.alert.AlertFactory;
import org.openspaces.admin.alert.AlertSeverity;
import org.openspaces.admin.alert.AlertStatus;
import org.openspaces.admin.alert.alerts.ProvisionFailureAlert;
import org.openspaces.admin.alert.config.ProvisionFailureAlertConfiguration;
import org.openspaces.admin.internal.alert.bean.AlertBean;
import org.openspaces.admin.internal.alert.bean.util.AlertBeanUtils;
import org.openspaces.admin.internal.pu.InternalProcessingUnit;
import org.openspaces.admin.pu.DeploymentStatus;
import org.openspaces.admin.pu.ProcessingUnit;
import org.openspaces.admin.pu.ProvisionStatus;
import org.openspaces.admin.pu.events.ProcessingUnitInstanceProvisionStatusChangedEvent;
import org.openspaces.admin.pu.events.ProcessingUnitInstanceProvisionStatusChangedEventListener;
import org.openspaces.admin.pu.events.ProcessingUnitRemovedEventListener;
import org.openspaces.admin.pu.events.ProcessingUnitStatusChangedEvent;
import org.openspaces.admin.pu.events.ProcessingUnitStatusChangedEventListener;

public class ProvisionFailureAlertBean
implements AlertBean,
ProcessingUnitStatusChangedEventListener,
ProcessingUnitRemovedEventListener,
ProcessingUnitInstanceProvisionStatusChangedEventListener {
    public static final String beanUID = "7d04ff97-6d49b2fc-e1f2-4805-add9-a0885a389994";
    public static final String ALERT_NAME = "Provision Failure";
    private Admin admin;
    private final ProvisionFailureAlertConfiguration config = new ProvisionFailureAlertConfiguration();

    @Override
    public void afterPropertiesSet() throws Exception {
        this.admin.getProcessingUnits().getProcessingUnitStatusChanged().add(this);
        this.admin.getProcessingUnits().getProcessingUnitRemoved().add(this);
    }

    @Override
    public void destroy() throws Exception {
        this.admin.getProcessingUnits().getProcessingUnitStatusChanged().remove(this);
        this.admin.getProcessingUnits().getProcessingUnitRemoved().remove(this);
    }

    @Override
    public Map<String, String> getProperties() {
        return this.config.getProperties();
    }

    @Override
    public void setAdmin(Admin admin) {
        this.admin = admin;
    }

    @Override
    public void setProperties(Map<String, String> properties) {
        this.config.setProperties(properties);
    }

    @Override
    public void processingUnitRemoved(ProcessingUnit processingUnit) {
        this.handleProcessingUnitEvent(processingUnit, DeploymentStatus.UNDEPLOYED, null);
    }

    @Override
    public void processingUnitStatusChanged(ProcessingUnitStatusChangedEvent event) {
        ProcessingUnit processingUnit = event.getProcessingUnit();
        if (DeploymentStatus.INTACT.equals((Object)event.getNewStatus())) {
            this.handleProcessingUnitEvent(processingUnit, DeploymentStatus.INTACT, null);
        } else {
            if (this.isElasticProcessingUnit(processingUnit)) {
                return;
            }
            if ((event.getPreviousStatus() == null || event.getPreviousStatus().equals((Object)DeploymentStatus.NA)) && event.getNewStatus().equals((Object)DeploymentStatus.BROKEN)) {
                return;
            }
            this.handleProcessingUnitEvent(processingUnit, processingUnit.getStatus(), null);
        }
    }

    private boolean isElasticProcessingUnit(ProcessingUnit processingUnit) {
        Map<String, String> elasticProperties = ((InternalProcessingUnit)processingUnit).getElasticProperties();
        return elasticProperties != null && !elasticProperties.isEmpty();
    }

    @Override
    public void processingUnitInstanceProvisionStatusChanged(ProcessingUnitInstanceProvisionStatusChangedEvent event) {
        if (ProvisionStatus.FAILURE.equals((Object)event.getNewStatus())) {
            this.handleProcessingUnitEvent(event.getProcessingUnit(), DeploymentStatus.COMPROMISED, event);
        }
    }

    private void handleProcessingUnitEvent(ProcessingUnit processingUnit, DeploymentStatus deploymentStatus, ProcessingUnitInstanceProvisionStatusChangedEvent event) {
        String groupUid = this.generateGroupUid(processingUnit.getName());
        AlertFactory factory = new AlertFactory();
        factory.name(ALERT_NAME);
        factory.groupUid(groupUid);
        factory.componentUid(processingUnit.getName());
        factory.componentDescription(AlertBeanUtils.getProcessingUnitDescription(processingUnit));
        factory.config(this.config.getProperties());
        factory.severity(AlertSeverity.SEVERE);
        switch (deploymentStatus) {
            case BROKEN: {
                factory.description("Processing unit " + processingUnit.getName() + " has zero instances running instead of " + processingUnit.getTotalNumberOfInstances());
                factory.status(AlertStatus.RAISED);
                break;
            }
            case COMPROMISED: {
                if (event != null) {
                    factory.description("Processing unit " + processingUnit.getName() + " has encountered a failure instantiating " + event.getProcessingUnitInstanceName());
                } else {
                    factory.description("Processing unit " + processingUnit.getName() + " has less than " + processingUnit.getTotalNumberOfInstances() + " instances running");
                }
                factory.status(AlertStatus.RAISED);
                break;
            }
            case INTACT: {
                factory.description("Processing unit " + processingUnit.getName() + " has instantiated successfully all " + processingUnit.getTotalNumberOfInstances() + " instances");
                factory.status(AlertStatus.RESOLVED);
                break;
            }
            case UNDEPLOYED: {
                factory.description("Processing unit " + processingUnit.getName() + " has been undeployed");
                factory.status(AlertStatus.RESOLVED);
                break;
            }
            default: {
                return;
            }
        }
        Alert alert = factory.toAlert();
        boolean triggerAlert = false;
        if (alert.getStatus().isResolved()) {
            if (this.admin.getAlertManager().getAlertStatusByGroupId(groupUid).isUnresolved()) {
                triggerAlert = true;
            }
        } else {
            triggerAlert = true;
        }
        if (triggerAlert) {
            this.admin.getAlertManager().triggerAlert(new ProvisionFailureAlert(alert));
        }
    }

    private String generateGroupUid(String uid) {
        return beanUID.concat("-").concat(uid);
    }
}

