/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.admin.internal.alert.bean;

import com.gigaspaces.cluster.activeelection.SpaceMode;
import java.util.Map;
import org.openspaces.admin.Admin;
import org.openspaces.admin.alert.Alert;
import org.openspaces.admin.alert.AlertFactory;
import org.openspaces.admin.alert.AlertSeverity;
import org.openspaces.admin.alert.AlertStatus;
import org.openspaces.admin.alert.alerts.ReplicationChannelDisconnectedAlert;
import org.openspaces.admin.alert.config.ReplicationChannelDisconnectedAlertConfiguration;
import org.openspaces.admin.internal.alert.bean.AlertBean;
import org.openspaces.admin.internal.alert.bean.util.AlertBeanUtils;
import org.openspaces.admin.internal.space.InternalSpaceInstance;
import org.openspaces.admin.space.ReplicationStatus;
import org.openspaces.admin.space.ReplicationTarget;
import org.openspaces.admin.space.SpaceInstance;
import org.openspaces.admin.space.events.ReplicationStatusChangedEvent;
import org.openspaces.admin.space.events.ReplicationStatusChangedEventListener;
import org.openspaces.admin.space.events.SpaceInstanceRemovedEventListener;

public class ReplicationChannelDisconnectedAlertBean
implements AlertBean,
ReplicationStatusChangedEventListener,
SpaceInstanceRemovedEventListener {
    public static final String beanUID = "c54333ba-5d8ed065-4ac9-4f1e-a90e-236e36a1bc71";
    public static final String ALERT_NAME = "Replication Channel Disconnected";
    private final ReplicationChannelDisconnectedAlertConfiguration config = new ReplicationChannelDisconnectedAlertConfiguration();
    private Admin admin;

    @Override
    public void afterPropertiesSet() throws Exception {
        this.validateProperties();
        this.admin.getSpaces().getSpaceInstanceRemoved().add(this);
        this.admin.getSpaces().getReplicationStatusChanged().add(this);
    }

    @Override
    public void destroy() throws Exception {
        this.admin.getSpaces().getSpaceInstanceRemoved().remove(this);
        this.admin.getSpaces().getReplicationStatusChanged().remove(this);
    }

    @Override
    public Map<String, String> getProperties() {
        return this.config.getProperties();
    }

    @Override
    public void setAdmin(Admin admin) {
        this.admin = admin;
    }

    @Override
    public void setProperties(Map<String, String> properties) {
        this.config.setProperties(properties);
    }

    private void validateProperties() {
    }

    @Override
    public void spaceInstanceRemoved(SpaceInstance spaceInstance) {
        for (ReplicationTarget replicationTarget : spaceInstance.getReplicationTargets()) {
            String groupUid = this.generateGroupUid(spaceInstance.getUid() + "-" + replicationTarget.getMemberName());
            if (!this.admin.getAlertManager().getAlertStatusByGroupId(groupUid).isUnresolved()) continue;
            AlertFactory factory = new AlertFactory();
            factory.name(ALERT_NAME);
            factory.groupUid(groupUid);
            factory.description("Replication channel status is unavailable; " + spaceInstance + " has been removed.");
            factory.severity(AlertSeverity.SEVERE);
            factory.status(AlertStatus.NA);
            factory.componentUid(spaceInstance.getUid());
            factory.componentDescription(AlertBeanUtils.getSpaceInstanceDescription(spaceInstance));
            factory.config(this.config.getProperties());
            factory.putProperty("target-is-mirror", Boolean.toString(replicationTarget.isMirror()));
            Alert alert = factory.toAlert();
            this.admin.getAlertManager().triggerAlert(new ReplicationChannelDisconnectedAlert(alert));
        }
    }

    @Override
    public void replicationStatusChanged(ReplicationStatusChangedEvent event) {
        ReplicationStatus replicationStatus = event.getNewStatus();
        SpaceInstance source = event.getSpaceInstance();
        InternalSpaceInstance target = event.getReplicationTarget().getSpaceInstance();
        switch (replicationStatus) {
            case DISCONNECTED: {
                if (event.getReplicationTarget().getMemberName().contains("_LocalView_") || event.getReplicationTarget().getMemberName().contains("_LocalCache_")) {
                    return;
                }
                String groupUid = this.generateGroupUid(source.getUid() + "-" + event.getReplicationTarget().getMemberName());
                AlertFactory factory = new AlertFactory();
                factory.name(ALERT_NAME);
                factory.groupUid(groupUid);
                factory.description("A replication channel has been lost between " + this.getReplicationPath(event));
                factory.severity(AlertSeverity.SEVERE);
                factory.status(AlertStatus.RAISED);
                factory.componentUid(source.getUid());
                factory.componentDescription(AlertBeanUtils.getSpaceInstanceDescription(source));
                factory.config(this.config.getProperties());
                factory.putProperty("source-host-address", source.getMachine().getHostAddress());
                factory.putProperty("source-host-name", source.getMachine().getHostName());
                factory.putProperty("source-vm-uid", source.getVirtualMachine().getUid());
                factory.putProperty("source-cpu-utilization", String.valueOf(source.getOperatingSystem().getStatistics().getCpuPerc() * 100.0));
                factory.putProperty("source-heap-utilization", String.valueOf(source.getVirtualMachine().getStatistics().getMemoryHeapUsedPerc()));
                factory.putProperty("replication-status", replicationStatus.name());
                factory.putProperty("source-uid", source.getUid());
                factory.putProperty("target-is-mirror", Boolean.toString(event.getReplicationTarget().isMirror()));
                if (target != null) {
                    factory.putProperty("target-uid", target.getUid());
                    factory.putProperty("target-host-address", target.getMachine().getHostAddress());
                    factory.putProperty("target-host-name", target.getMachine().getHostName());
                    factory.putProperty("target-vm-uid", target.getVirtualMachine().getUid());
                    factory.putProperty("target-cpu-utilization", String.valueOf(target.getOperatingSystem().getStatistics().getCpuPerc() * 100.0));
                    factory.putProperty("target-heap-utilization", String.valueOf(target.getVirtualMachine().getStatistics().getMemoryHeapUsedPerc()));
                }
                Alert alert = factory.toAlert();
                this.admin.getAlertManager().triggerAlert(new ReplicationChannelDisconnectedAlert(alert));
                break;
            }
            case ACTIVE: {
                String groupUid = this.generateGroupUid(source.getUid() + "-" + event.getReplicationTarget().getMemberName());
                if (!this.admin.getAlertManager().getAlertStatusByGroupId(groupUid).isUnresolved()) break;
                AlertFactory factory = new AlertFactory();
                factory.name(ALERT_NAME);
                factory.groupUid(groupUid);
                factory.description("A replication channel has been restored between " + this.getReplicationPath(event));
                factory.severity(AlertSeverity.SEVERE);
                factory.status(AlertStatus.RESOLVED);
                factory.componentUid(source.getUid());
                factory.componentDescription(AlertBeanUtils.getSpaceInstanceDescription(source));
                factory.config(this.config.getProperties());
                factory.putProperty("source-host-address", source.getMachine().getHostAddress());
                factory.putProperty("source-host-name", source.getMachine().getHostName());
                factory.putProperty("source-vm-uid", source.getVirtualMachine().getUid());
                factory.putProperty("source-cpu-utilization", String.valueOf(source.getOperatingSystem().getStatistics().getCpuPerc() * 100.0));
                factory.putProperty("source-heap-utilization", String.valueOf(source.getVirtualMachine().getStatistics().getMemoryHeapUsedPerc()));
                factory.putProperty("replication-status", replicationStatus.name());
                factory.putProperty("source-uid", source.getUid());
                factory.putProperty("target-is-mirror", Boolean.toString(event.getReplicationTarget().isMirror()));
                if (target != null) {
                    factory.putProperty("target-uid", target.getUid());
                    factory.putProperty("target-host-address", target.getMachine().getHostAddress());
                    factory.putProperty("target-host-name", target.getMachine().getHostName());
                    factory.putProperty("target-vm-uid", target.getVirtualMachine().getUid());
                    factory.putProperty("target-cpu-utilization", String.valueOf(target.getOperatingSystem().getStatistics().getCpuPerc() * 100.0));
                    factory.putProperty("target-heap-utilization", String.valueOf(target.getVirtualMachine().getStatistics().getMemoryHeapUsedPerc()));
                }
                Alert alert = factory.toAlert();
                this.admin.getAlertManager().triggerAlert(new ReplicationChannelDisconnectedAlert(alert));
                break;
            }
        }
    }

    private String getReplicationPath(ReplicationStatusChangedEvent event) {
        SpaceInstance source = event.getSpaceInstance();
        InternalSpaceInstance target = event.getReplicationTarget().getSpaceInstance();
        StringBuilder sb = new StringBuilder();
        SpaceMode sourceSpaceMode = source.getMode();
        sb.append(sourceSpaceMode.toString().toLowerCase()).append(" Space ");
        sb.append(source.getSpace().getName() + "." + source.getInstanceId() + " [" + (source.getBackupId() + 1) + "]");
        sb.append(" and ");
        if (target != null) {
            String memberName = event.getReplicationTarget().getMemberName();
            if (memberName.endsWith(":" + source.getSpace().getName()) && !target.getMode().equals((Object)SpaceMode.NONE)) {
                sb.append(target.getMode().toString().toLowerCase());
            }
            sb.append("Space ").append(target.getSpace().getName() + "." + target.getInstanceId() + " [" + (target.getBackupId() + 1) + "]");
        } else {
            String memberName = event.getReplicationTarget().getMemberName();
            if (memberName.endsWith(":" + source.getSpace().getName())) {
                sb.append("Space ").append(source.getSpace().getName() + "." + source.getInstanceId() + " [" + (source.getBackupId() != 0 ? "1" : "2") + "]");
            } else {
                sb.append("Space ").append(memberName);
            }
        }
        return sb.toString();
    }

    private String generateGroupUid(String uid) {
        return beanUID.concat("-").concat(uid);
    }
}

