/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.admin.internal.alert.bean;

import com.gigaspaces.cluster.activeelection.SpaceMode;
import com.j_spaces.core.filters.ReplicationStatistics;
import java.util.Map;
import org.openspaces.admin.Admin;
import org.openspaces.admin.alert.Alert;
import org.openspaces.admin.alert.AlertFactory;
import org.openspaces.admin.alert.AlertSeverity;
import org.openspaces.admin.alert.AlertStatus;
import org.openspaces.admin.alert.alerts.ReplicationRedoLogOverflowToDiskAlert;
import org.openspaces.admin.alert.config.ReplicationRedoLogSizeAlertConfiguration;
import org.openspaces.admin.internal.alert.bean.AlertBean;
import org.openspaces.admin.internal.alert.bean.util.AlertBeanUtils;
import org.openspaces.admin.space.ReplicationStatus;
import org.openspaces.admin.space.ReplicationTarget;
import org.openspaces.admin.space.SpaceInstance;
import org.openspaces.admin.space.events.SpaceInstanceRemovedEventListener;
import org.openspaces.admin.space.events.SpaceInstanceStatisticsChangedEvent;
import org.openspaces.admin.space.events.SpaceInstanceStatisticsChangedEventListener;

public class ReplicationRedoLogOverflowToDiskAlertBean
implements AlertBean,
SpaceInstanceRemovedEventListener,
SpaceInstanceStatisticsChangedEventListener {
    public static final String beanUID = "3519ba78-08e6de85-87dc-4c10-8d08-ef03fe7b5d76";
    public static final String ALERT_NAME = "Replication Redo log Overflow";
    private final ReplicationRedoLogSizeAlertConfiguration config = new ReplicationRedoLogSizeAlertConfiguration();
    private Admin admin;

    @Override
    public void afterPropertiesSet() throws Exception {
        this.validateProperties();
        this.admin.getSpaces().getSpaceInstanceRemoved().add(this);
        this.admin.getSpaces().getSpaceInstanceStatisticsChanged().add(this);
        this.admin.getSpaces().startStatisticsMonitor();
    }

    @Override
    public void destroy() throws Exception {
        this.admin.getSpaces().getSpaceInstanceRemoved().remove(this);
        this.admin.getSpaces().getSpaceInstanceStatisticsChanged().remove(this);
        this.admin.getSpaces().stopStatisticsMonitor();
    }

    @Override
    public Map<String, String> getProperties() {
        return this.config.getProperties();
    }

    @Override
    public void setAdmin(Admin admin) {
        this.admin = admin;
    }

    @Override
    public void setProperties(Map<String, String> properties) {
        this.config.setProperties(properties);
    }

    private void validateProperties() {
    }

    @Override
    public void spaceInstanceRemoved(SpaceInstance spaceInstance) {
        String groupUid = this.generateGroupUid(spaceInstance.getUid());
        if (this.admin.getAlertManager().getAlertStatusByGroupId(groupUid).isUnresolved()) {
            AlertFactory factory = new AlertFactory();
            factory.name(ALERT_NAME);
            factory.groupUid(groupUid);
            factory.description("Replication redo log is unavailable; " + this.getSpaceName(spaceInstance) + " has been removed.");
            factory.severity(AlertSeverity.WARNING);
            factory.status(AlertStatus.NA);
            factory.componentUid(spaceInstance.getUid());
            factory.componentDescription(AlertBeanUtils.getSpaceInstanceDescription(spaceInstance));
            factory.config(this.config.getProperties());
            Alert alert = factory.toAlert();
            this.admin.getAlertManager().triggerAlert(new ReplicationRedoLogOverflowToDiskAlert(alert));
        }
    }

    @Override
    public void spaceInstanceStatisticsChanged(SpaceInstanceStatisticsChangedEvent event) {
        SpaceInstance source = event.getSpaceInstance();
        ReplicationStatistics replicationStatistics = event.getStatistics().getReplicationStatistics();
        if (replicationStatistics == null) {
            return;
        }
        ReplicationStatistics.OutgoingReplication outgoingReplication = replicationStatistics.getOutgoingReplication();
        long redoLogSize = outgoingReplication.getRedoLogSize();
        long redoLogSizeInDisk = outgoingReplication.getRedoLogExternalStoragePacketCount();
        long redoLogSizeInMemory = outgoingReplication.getRedoLogMemoryPacketCount();
        if (redoLogSizeInDisk > 0L) {
            String groupUid = this.generateGroupUid(source.getUid());
            AlertFactory factory = new AlertFactory();
            factory.name(ALERT_NAME);
            factory.groupUid(groupUid);
            factory.description("Replication redo-log has overflown to disk, for " + this.getSpaceName(source));
            factory.severity(AlertSeverity.WARNING);
            factory.status(AlertStatus.RAISED);
            factory.componentUid(source.getUid());
            factory.componentDescription(AlertBeanUtils.getSpaceInstanceDescription(source));
            factory.config(this.config.getProperties());
            factory.putProperty("host-address", source.getMachine().getHostAddress());
            factory.putProperty("host-name", source.getMachine().getHostName());
            factory.putProperty("vm-uid", source.getVirtualMachine().getUid());
            factory.putProperty("cpu-utilization", String.valueOf(source.getOperatingSystem().getStatistics().getCpuPerc() * 100.0));
            factory.putProperty("heap-utilization", String.valueOf(source.getVirtualMachine().getStatistics().getMemoryHeapUsedPerc()));
            factory.putProperty("replication-status", this.getReplicationStatus(source));
            factory.putProperty("redo-log-size", String.valueOf(redoLogSize));
            factory.putProperty("redo-log-memory-size", String.valueOf(redoLogSizeInMemory));
            factory.putProperty("redo-log-swap-size", String.valueOf(redoLogSizeInDisk));
            Alert alert = factory.toAlert();
            this.admin.getAlertManager().triggerAlert(new ReplicationRedoLogOverflowToDiskAlert(alert));
        } else if (redoLogSizeInDisk == 0L && redoLogSize >= 0L) {
            String groupUid = this.generateGroupUid(source.getUid());
            if (this.admin.getAlertManager().getAlertStatusByGroupId(groupUid).isUnresolved()) {
                AlertFactory factory = new AlertFactory();
                factory.name(ALERT_NAME);
                factory.groupUid(groupUid);
                factory.description("Replication redo-log no longer uses the disk, for " + this.getSpaceName(source));
                factory.severity(AlertSeverity.WARNING);
                factory.status(AlertStatus.RESOLVED);
                factory.componentUid(event.getSpaceInstance().getUid());
                factory.componentDescription(AlertBeanUtils.getSpaceInstanceDescription(source));
                factory.config(this.config.getProperties());
                factory.putProperty("host-address", source.getMachine().getHostAddress());
                factory.putProperty("host-name", source.getMachine().getHostName());
                factory.putProperty("vm-uid", source.getVirtualMachine().getUid());
                factory.putProperty("cpu-utilization", String.valueOf(source.getOperatingSystem().getStatistics().getCpuPerc() * 100.0));
                factory.putProperty("heap-utilization", String.valueOf(source.getVirtualMachine().getStatistics().getMemoryHeapUsedPerc()));
                factory.putProperty("replication-status", this.getReplicationStatus(source));
                factory.putProperty("redo-log-size", String.valueOf(redoLogSize));
                factory.putProperty("redo-log-memory-size", String.valueOf(redoLogSizeInMemory));
                factory.putProperty("redo-log-swap-size", String.valueOf(redoLogSizeInDisk));
                Alert alert = factory.toAlert();
                this.admin.getAlertManager().triggerAlert(new ReplicationRedoLogOverflowToDiskAlert(alert));
            }
        }
    }

    private String getReplicationStatus(SpaceInstance source) {
        for (ReplicationTarget target : source.getReplicationTargets()) {
            if (ReplicationStatus.ACTIVE.equals((Object)target.getReplicationStatus())) continue;
            return target.getReplicationStatus().name();
        }
        return ReplicationStatus.ACTIVE.name();
    }

    private String getSpaceName(SpaceInstance source) {
        StringBuilder sb = new StringBuilder();
        SpaceMode sourceSpaceMode = source.getMode();
        sb.append(sourceSpaceMode.toString().toLowerCase()).append(" Space ");
        sb.append(source.getSpace().getName() + "." + source.getInstanceId() + " [" + (source.getBackupId() + 1) + "]");
        return sb.toString();
    }

    private String generateGroupUid(String uid) {
        return beanUID.concat("-").concat(uid);
    }
}

