/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.admin.internal.alert.bean;

import com.gigaspaces.cluster.activeelection.SpaceMode;
import com.j_spaces.core.filters.ReplicationStatistics;
import java.util.Map;
import org.openspaces.admin.Admin;
import org.openspaces.admin.alert.Alert;
import org.openspaces.admin.alert.AlertFactory;
import org.openspaces.admin.alert.AlertSeverity;
import org.openspaces.admin.alert.AlertStatus;
import org.openspaces.admin.alert.alerts.ReplicationRedoLogSizeAlert;
import org.openspaces.admin.alert.config.ReplicationRedoLogSizeAlertConfiguration;
import org.openspaces.admin.bean.BeanConfigurationException;
import org.openspaces.admin.internal.alert.bean.AlertBean;
import org.openspaces.admin.internal.alert.bean.util.AlertBeanUtils;
import org.openspaces.admin.space.ReplicationStatus;
import org.openspaces.admin.space.ReplicationTarget;
import org.openspaces.admin.space.SpaceInstance;
import org.openspaces.admin.space.events.SpaceInstanceRemovedEventListener;
import org.openspaces.admin.space.events.SpaceInstanceStatisticsChangedEvent;
import org.openspaces.admin.space.events.SpaceInstanceStatisticsChangedEventListener;

public class ReplicationRedoLogSizeAlertBean
implements AlertBean,
SpaceInstanceRemovedEventListener,
SpaceInstanceStatisticsChangedEventListener {
    public static final String beanUID = "3f4bff98-52de6d72-b2b8-434b-aa18-d57c7554262a";
    public static final String ALERT_NAME = "Replication Redo log";
    private final ReplicationRedoLogSizeAlertConfiguration config = new ReplicationRedoLogSizeAlertConfiguration();
    private Admin admin;

    @Override
    public void afterPropertiesSet() throws Exception {
        this.validateProperties();
        this.admin.getSpaces().getSpaceInstanceRemoved().add(this);
        this.admin.getSpaces().getSpaceInstanceStatisticsChanged().add(this);
        this.admin.getSpaces().startStatisticsMonitor();
    }

    @Override
    public void destroy() throws Exception {
        this.admin.getSpaces().getSpaceInstanceRemoved().remove(this);
        this.admin.getSpaces().getSpaceInstanceStatisticsChanged().remove(this);
        this.admin.getSpaces().stopStatisticsMonitor();
    }

    @Override
    public Map<String, String> getProperties() {
        return this.config.getProperties();
    }

    @Override
    public void setAdmin(Admin admin) {
        this.admin = admin;
    }

    @Override
    public void setProperties(Map<String, String> properties) {
        this.config.setProperties(properties);
    }

    private void validateProperties() {
        if (this.config.getHighThresholdRedoLogSize() == null) {
            throw new BeanConfigurationException("High threshold property is null");
        }
        if (this.config.getLowThresholdRedoLogSize() == null) {
            throw new BeanConfigurationException("Low threshold property is null");
        }
        if (this.config.getHighThresholdRedoLogSize() < this.config.getLowThresholdRedoLogSize()) {
            throw new BeanConfigurationException("Low threshold [" + this.config.getLowThresholdRedoLogSize() + "] must be less than high threshold value [" + this.config.getHighThresholdRedoLogSize() + "]");
        }
        if (this.config.getHighThresholdRedoLogSize() < 0) {
            throw new BeanConfigurationException("High threshold [" + this.config.getHighThresholdRedoLogSize() + "] must greater than zero");
        }
        if (this.config.getLowThresholdRedoLogSize() < 0) {
            throw new BeanConfigurationException("Low threshold [" + this.config.getLowThresholdRedoLogSize() + "] must greater or equal to zero");
        }
    }

    @Override
    public void spaceInstanceRemoved(SpaceInstance spaceInstance) {
        String groupUid = this.generateGroupUid(spaceInstance.getUid());
        if (this.admin.getAlertManager().getAlertStatusByGroupId(groupUid).isUnresolved()) {
            AlertFactory factory = new AlertFactory();
            factory.name(ALERT_NAME);
            factory.groupUid(groupUid);
            factory.description("Replication redo log is unavailable; " + this.getSpaceName(spaceInstance) + " has been removed.");
            factory.severity(AlertSeverity.WARNING);
            factory.status(AlertStatus.NA);
            factory.componentUid(spaceInstance.getUid());
            factory.componentDescription(AlertBeanUtils.getSpaceInstanceDescription(spaceInstance));
            factory.config(this.config.getProperties());
            Alert alert = factory.toAlert();
            this.admin.getAlertManager().triggerAlert(new ReplicationRedoLogSizeAlert(alert));
        }
    }

    @Override
    public void spaceInstanceStatisticsChanged(SpaceInstanceStatisticsChangedEvent event) {
        int highThreshold = this.config.getHighThresholdRedoLogSize();
        int lowThreshold = this.config.getLowThresholdRedoLogSize();
        SpaceInstance source = event.getSpaceInstance();
        ReplicationStatistics replicationStatistics = event.getStatistics().getReplicationStatistics();
        if (replicationStatistics == null) {
            return;
        }
        long redoLogSize = replicationStatistics.getOutgoingReplication().getRedoLogSize();
        if (redoLogSize > (long)highThreshold) {
            String groupUid = this.generateGroupUid(source.getUid());
            AlertFactory factory = new AlertFactory();
            factory.name(ALERT_NAME);
            factory.groupUid(groupUid);
            factory.description("Replication redo-log size crossed above a " + highThreshold + " threshold, with a size of " + redoLogSize + " for " + this.getSpaceName(source));
            factory.severity(AlertSeverity.WARNING);
            factory.status(AlertStatus.RAISED);
            factory.componentUid(source.getUid());
            factory.componentDescription(AlertBeanUtils.getSpaceInstanceDescription(source));
            factory.config(this.config.getProperties());
            factory.putProperty("host-address", source.getMachine().getHostAddress());
            factory.putProperty("host-name", source.getMachine().getHostName());
            factory.putProperty("vm-uid", source.getVirtualMachine().getUid());
            factory.putProperty("cpu-utilization", String.valueOf(source.getOperatingSystem().getStatistics().getCpuPerc() * 100.0));
            factory.putProperty("heap-utilization", String.valueOf(source.getVirtualMachine().getStatistics().getMemoryHeapUsedPerc()));
            factory.putProperty("replication-status", this.getReplicationStatus(source));
            factory.putProperty("redo-log-size", String.valueOf(redoLogSize));
            factory.putProperty("redo-log-memory-size", String.valueOf(replicationStatistics.getOutgoingReplication().getRedoLogMemoryPacketCount()));
            factory.putProperty("redo-log-swap-size", String.valueOf(replicationStatistics.getOutgoingReplication().getRedoLogExternalStoragePacketCount()));
            Alert alert = factory.toAlert();
            this.admin.getAlertManager().triggerAlert(new ReplicationRedoLogSizeAlert(alert));
        } else if (redoLogSize <= (long)lowThreshold) {
            String groupUid = this.generateGroupUid(source.getUid());
            if (this.admin.getAlertManager().getAlertStatusByGroupId(groupUid).isUnresolved()) {
                AlertFactory factory = new AlertFactory();
                factory.name(ALERT_NAME);
                factory.groupUid(groupUid);
                factory.description("Replication redo-log size crossed below a " + lowThreshold + " threshold, with a size of " + redoLogSize + " for " + this.getSpaceName(source));
                factory.severity(AlertSeverity.WARNING);
                factory.status(AlertStatus.RESOLVED);
                factory.componentUid(event.getSpaceInstance().getUid());
                factory.componentDescription(AlertBeanUtils.getSpaceInstanceDescription(source));
                factory.config(this.config.getProperties());
                factory.putProperty("host-address", source.getMachine().getHostAddress());
                factory.putProperty("host-name", source.getMachine().getHostName());
                factory.putProperty("vm-uid", source.getVirtualMachine().getUid());
                factory.putProperty("cpu-utilization", String.valueOf(source.getOperatingSystem().getStatistics().getCpuPerc() * 100.0));
                factory.putProperty("heap-utilization", String.valueOf(source.getVirtualMachine().getStatistics().getMemoryHeapUsedPerc()));
                factory.putProperty("replication-status", this.getReplicationStatus(source));
                factory.putProperty("redo-log-size", String.valueOf(redoLogSize));
                factory.putProperty("redo-log-memory-size", String.valueOf(replicationStatistics.getOutgoingReplication().getRedoLogMemoryPacketCount()));
                factory.putProperty("redo-log-swap-size", String.valueOf(replicationStatistics.getOutgoingReplication().getRedoLogExternalStoragePacketCount()));
                Alert alert = factory.toAlert();
                this.admin.getAlertManager().triggerAlert(new ReplicationRedoLogSizeAlert(alert));
            }
        }
    }

    private String getReplicationStatus(SpaceInstance source) {
        for (ReplicationTarget target : source.getReplicationTargets()) {
            if (ReplicationStatus.ACTIVE.equals((Object)target.getReplicationStatus())) continue;
            return target.getReplicationStatus().name();
        }
        return ReplicationStatus.ACTIVE.name();
    }

    private String getSpaceName(SpaceInstance source) {
        StringBuilder sb = new StringBuilder();
        SpaceMode sourceSpaceMode = source.getMode();
        sb.append(sourceSpaceMode.toString().toLowerCase()).append(" Space ");
        sb.append(source.getSpace().getName() + "." + source.getInstanceId() + " [" + (source.getBackupId() + 1) + "]");
        return sb.toString();
    }

    private String generateGroupUid(String uid) {
        return beanUID.concat("-").concat(uid);
    }
}

