/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.admin.internal.alert.bean;

import com.gigaspaces.cluster.activeelection.SpaceMode;
import java.util.Map;
import org.openspaces.admin.Admin;
import org.openspaces.admin.alert.Alert;
import org.openspaces.admin.alert.AlertFactory;
import org.openspaces.admin.alert.AlertSeverity;
import org.openspaces.admin.alert.AlertStatus;
import org.openspaces.admin.alert.alerts.SpacePartitionSplitBrainAlert;
import org.openspaces.admin.alert.config.SpacePartitionSplitBrainAlertConfiguration;
import org.openspaces.admin.internal.alert.bean.AlertBean;
import org.openspaces.admin.internal.alert.bean.util.AlertBeanUtils;
import org.openspaces.admin.space.Space;
import org.openspaces.admin.space.SpaceInstance;
import org.openspaces.admin.space.SpacePartition;
import org.openspaces.admin.space.events.SpaceInstanceAddedEventListener;
import org.openspaces.admin.space.events.SpaceModeChangedEvent;
import org.openspaces.admin.space.events.SpaceModeChangedEventListener;
import org.openspaces.admin.space.events.SpaceRemovedEventListener;

public class SpacePartitionSplitBrainAlertBean
implements AlertBean,
SpaceInstanceAddedEventListener,
SpaceRemovedEventListener,
SpaceModeChangedEventListener {
    public static final String beanUID = "2c80074c-186b7266-9e07-448b-8464-627c746bdfaf";
    public static final String ALERT_NAME = "Space Partition Split-Brain";
    private Admin admin;
    private final SpacePartitionSplitBrainAlertConfiguration config = new SpacePartitionSplitBrainAlertConfiguration();

    @Override
    public void afterPropertiesSet() throws Exception {
        this.admin.getSpaces().getSpaceInstanceAdded().add(this);
        this.admin.getSpaces().getSpaceRemoved().add(this);
        this.admin.getSpaces().getSpaceModeChanged().add(this);
    }

    @Override
    public void destroy() throws Exception {
        this.admin.getSpaces().getSpaceInstanceAdded().remove(this);
        this.admin.getSpaces().getSpaceRemoved().remove(this);
        this.admin.getSpaces().getSpaceModeChanged().remove(this);
    }

    @Override
    public Map<String, String> getProperties() {
        return this.config.getProperties();
    }

    @Override
    public void setAdmin(Admin admin) {
        this.admin = admin;
    }

    @Override
    public void setProperties(Map<String, String> properties) {
        this.config.setProperties(properties);
    }

    @Override
    public void spaceInstanceAdded(SpaceInstance spaceInstance) {
        SpacePartition partition = spaceInstance.getPartition();
        if (partition.getInstances().length <= 1) {
            return;
        }
        int numberOfPrimaries = 0;
        int numberOfBackups = 0;
        for (SpaceInstance instance : partition.getInstances()) {
            if (instance.getMode() == SpaceMode.PRIMARY) {
                ++numberOfPrimaries;
                continue;
            }
            if (instance.getMode() != SpaceMode.BACKUP) continue;
            ++numberOfBackups;
        }
        if (numberOfPrimaries > 1) {
            this.handleSplitBrainDetection(spaceInstance, AlertStatus.RAISED);
        } else if (numberOfPrimaries == 1 && numberOfBackups > 0) {
            this.handleSplitBrainDetection(spaceInstance, AlertStatus.RESOLVED);
        }
    }

    @Override
    public void spaceModeChanged(SpaceModeChangedEvent event) {
        this.spaceInstanceAdded(event.getSpaceInstance());
    }

    @Override
    public void spaceRemoved(Space space) {
        for (SpaceInstance spaceInstance : space) {
            this.handleSplitBrainDetection(spaceInstance, AlertStatus.NA);
        }
    }

    private void handleSplitBrainDetection(SpaceInstance spaceInstance, AlertStatus alertStatus) {
        String spaceName = spaceInstance.getSpace().getName();
        String partitionName = spaceName + "." + (spaceInstance.getPartition().getPartitionId() + 1);
        String groupUid = this.generateGroupUid(partitionName);
        AlertFactory factory = new AlertFactory();
        factory.name(ALERT_NAME);
        factory.groupUid(groupUid);
        factory.componentUid(spaceInstance.getSpace().getUid());
        factory.componentDescription(this.getLocation(spaceInstance));
        factory.config(this.config.getProperties());
        factory.severity(AlertSeverity.SEVERE);
        if (alertStatus.isRaised()) {
            factory.description("Detected split-brain of Space partition " + partitionName);
        } else if (alertStatus.isResolved()) {
            factory.description("Resolved split-brain of Space partition " + partitionName);
        } else if (alertStatus.isNotAvailable()) {
            factory.description("Space " + spaceName + " is not available");
        }
        factory.status(alertStatus);
        factory.putProperty("space-name", spaceName);
        factory.putProperty("space-partition-id", String.valueOf(spaceInstance.getPartition().getPartitionId()));
        Alert alert = factory.toAlert();
        boolean alertOpen = this.admin.getAlertManager().getAlertStatusByGroupId(groupUid).isUnresolved();
        boolean triggerAlert = false;
        triggerAlert = alertStatus.isRaised() ? !alertOpen : alertOpen;
        if (triggerAlert) {
            this.admin.getAlertManager().triggerAlert(new SpacePartitionSplitBrainAlert(alert));
        }
    }

    private String getLocation(SpaceInstance spaceInstance) {
        String location = "";
        SpaceInstance[] instances = spaceInstance.getPartition().getInstances();
        int i = 0;
        for (SpaceInstance instance : instances) {
            location = location + AlertBeanUtils.getSpaceInstanceDescription(instance);
            if (++i >= instances.length) continue;
            location = location + ", ";
        }
        return location;
    }

    private String generateGroupUid(String uid) {
        return beanUID.concat("-").concat(uid);
    }
}

