/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.admin.internal.alert.bean.util;

import java.util.List;
import java.util.UUID;
import org.openspaces.admin.internal.alert.bean.AlertBean;
import org.openspaces.admin.internal.support.AbstractAgentGridComponent;
import org.openspaces.admin.machine.Machine;
import org.openspaces.admin.metrics.MetricProvider;
import org.openspaces.admin.os.OperatingSystemDetails;
import org.openspaces.admin.pu.ProcessingUnit;
import org.openspaces.admin.space.SpaceInstance;
import org.openspaces.admin.vm.VirtualMachine;

public class AlertBeanUtils {
    public static double getAverage(int period, List<Double> timeline) {
        if (period > timeline.size()) {
            return -1.0;
        }
        double average = 0.0;
        for (int i = 0; i < period && i < timeline.size(); ++i) {
            double value = timeline.get(i);
            average += value;
        }
        return average /= (double)period;
    }

    public static String generateBeanUUID(Class<? extends AlertBean> clazz) {
        return Integer.toHexString(clazz.getSimpleName().hashCode()) + "-" + UUID.randomUUID();
    }

    public static String getGridComponentShortName(VirtualMachine virtualMachine) {
        if (virtualMachine.getElasticServiceManager() != null) {
            return "ESM";
        }
        if (virtualMachine.getGridServiceManager() != null) {
            return "GSM";
        }
        if (virtualMachine.getGridServiceContainer() != null) {
            return "GSC";
        }
        if (virtualMachine.getGridServiceAgent() != null) {
            return "GSA";
        }
        if (virtualMachine.getLookupService() != null) {
            return "LUS";
        }
        return "";
    }

    public static String getGridComponentFullName(VirtualMachine virtualMachine) {
        if (virtualMachine.getElasticServiceManager() != null) {
            return "Elastic Service Manager";
        }
        if (virtualMachine.getGridServiceManager() != null) {
            return "Grid Service Manager";
        }
        if (virtualMachine.getGridServiceContainer() != null) {
            return "Grid Service Container";
        }
        if (virtualMachine.getGridServiceAgent() != null) {
            return "Grid Service Agent";
        }
        if (virtualMachine.getLookupService() != null) {
            return "Lookup Service";
        }
        return "n/a";
    }

    public static String getGridComponentDescription(VirtualMachine virtualMachine) {
        return AlertBeanUtils.getGridComponentShortName(virtualMachine) + AlertBeanUtils.getGridComponentAgentId(virtualMachine) + virtualMachine.getDetails().getPid() + " on " + AlertBeanUtils.getMachineDescription(virtualMachine.getMachine());
    }

    private static String getGridComponentAgentId(VirtualMachine virtualMachine) {
        String agentId;
        MetricProvider gridComponent = virtualMachine.getElasticServiceManager();
        if (gridComponent == null) {
            gridComponent = virtualMachine.getGridServiceManager();
        }
        if (gridComponent == null) {
            gridComponent = virtualMachine.getGridServiceContainer();
        }
        if (gridComponent == null) {
            gridComponent = virtualMachine.getGridServiceContainer();
        }
        if (gridComponent == null) {
            gridComponent = virtualMachine.getGridServiceAgent();
        }
        if (gridComponent == null) {
            gridComponent = virtualMachine.getLookupService();
        }
        if (gridComponent instanceof AbstractAgentGridComponent) {
            AbstractAgentGridComponent agentGridComponent = (AbstractAgentGridComponent)((Object)gridComponent);
            agentId = "-" + agentGridComponent.getAgentId();
        } else {
            agentId = "";
        }
        return agentId + " ";
    }

    public static String getMachineDescription(Machine machine) {
        return machine.getHostName() + " (" + machine.getHostAddress() + ")";
    }

    public static String getMachineDescription(OperatingSystemDetails details) {
        return details.getHostName() + " (" + details.getHostAddress() + ")";
    }

    public static String getSpaceInstanceDescription(SpaceInstance spaceInstance) {
        StringBuilder sb = new StringBuilder();
        if (spaceInstance.getSpaceUrl().getSchema().equals("mirror")) {
            sb.append("Mirror ").append(spaceInstance.getSpaceInstanceName()).append(" on ").append(AlertBeanUtils.getMachineDescription(spaceInstance.getMachine()));
        } else if (spaceInstance.getSpaceUrl().getSchema().equals("default")) {
            sb.append("Space ").append(spaceInstance.getSpaceInstanceName()).append(" on ").append(AlertBeanUtils.getMachineDescription(spaceInstance.getMachine()));
        } else {
            sb.append(spaceInstance.getSpace().getName()).append('.').append(spaceInstance.getInstanceId()).append(" [" + (spaceInstance.getBackupId() + 1) + "] ").append(spaceInstance.getMode()).append(" on ").append(AlertBeanUtils.getMachineDescription(spaceInstance.getMachine()));
        }
        return sb.toString();
    }

    public static String getProcessingUnitDescription(ProcessingUnit processingUnit) {
        return processingUnit.getName();
    }

    public static String getCpuPercToString(double cpuPerc) {
        return String.valueOf((cpuPerc == -1.0 ? 0.0 : cpuPerc) * 100.0);
    }
}

