/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.admin.internal.alert.bean.util;

import java.util.HashMap;
import java.util.Map;
import org.openspaces.admin.internal.alert.bean.util.StatisticsTimeLine;

public class MovingAverageStatistics {
    private Map<String, StatisticsTimeLine> map = new HashMap<String, StatisticsTimeLine>();
    private int period;

    public MovingAverageStatistics(int period) {
        this.period = period;
    }

    public void addStatistics(String key, double value) {
        StatisticsTimeLine statisticsTimeLine = this.map.get(key);
        if (statisticsTimeLine == null) {
            statisticsTimeLine = new StatisticsTimeLine(this.period);
            this.map.put(key, statisticsTimeLine);
        }
        statisticsTimeLine.addAndGet(value);
    }

    public double getAverageAndReset(String key) {
        return this.doGetAverage(key, true);
    }

    public double getAverage(String key) {
        return this.doGetAverage(key, false);
    }

    private double doGetAverage(String key, boolean reset) {
        StatisticsTimeLine statisticsTimeLine = this.map.get(key);
        if (statisticsTimeLine == null) {
            return -1.0;
        }
        if (!statisticsTimeLine.isAvailable()) {
            return -1.0;
        }
        double average = this.calculateAverage(statisticsTimeLine.getTimeLine());
        if (reset) {
            statisticsTimeLine.restartTimeLine();
        }
        return average;
    }

    private double calculateAverage(double[] values) {
        double sum = 0.0;
        for (int i = 0; i < values.length; ++i) {
            sum += values[i];
        }
        return sum / (double)values.length;
    }

    public void clear(String key) {
        this.map.remove(key);
    }

    public void clear() {
        this.map.clear();
    }

    public String toString() {
        return this.map.toString();
    }

    public String toString(String key) {
        return String.valueOf(this.map.get(key));
    }
}

