/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.admin.internal.application;

import com.gigaspaces.time.SystemTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.openspaces.admin.AdminException;
import org.openspaces.admin.internal.admin.InternalAdmin;
import org.openspaces.admin.internal.application.InternalApplication;
import org.openspaces.admin.internal.gsm.InternalGridServiceManagers;
import org.openspaces.admin.internal.pu.DefaultProcessingUnits;
import org.openspaces.admin.internal.pu.InternalProcessingUnits;
import org.openspaces.admin.pu.ProcessingUnit;
import org.openspaces.admin.pu.ProcessingUnits;
import org.openspaces.admin.pu.topology.ProcessingUnitDeploymentTopology;

public class DefaultApplication
implements InternalApplication {
    private final InternalProcessingUnits processingUnits;
    private final String name;
    private final InternalAdmin admin;

    public DefaultApplication(InternalAdmin admin, String name) {
        if (name == null) {
            throw new IllegalArgumentException("Application name cannot be null");
        }
        if (name.length() == 0) {
            throw new IllegalArgumentException("Application name cannot be empty");
        }
        this.processingUnits = new DefaultProcessingUnits(admin);
        this.name = name;
        this.admin = admin;
    }

    @Override
    public ProcessingUnits getProcessingUnits() {
        return this.processingUnits;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultApplication that = (DefaultApplication)o;
        return this.name.equals(that.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    @Override
    public void setStatisticsHistorySize(int historySize) {
        this.processingUnits.setStatisticsHistorySize(historySize);
    }

    @Override
    public void undeployAndWait() {
        this.undeployAndWait(this.admin.getDefaultTimeout(), this.admin.getDefaultTimeoutTimeUnit());
    }

    @Override
    public boolean undeployAndWait(long timeout, TimeUnit timeUnit) {
        boolean timedOut;
        block4: {
            long remaining;
            ArrayList<ProcessingUnit> pusToUndeploy;
            InternalGridServiceManagers gsms;
            long end = SystemTime.timeMillis() + timeUnit.toMillis(timeout);
            timedOut = false;
            Map<String, List<String>> puReverseDependencies = this.getReverseDependencies();
            do {
                pusToUndeploy = new ArrayList<ProcessingUnit>();
                for (ProcessingUnit pu : this.getProcessingUnits()) {
                    boolean postponeUndeployment = false;
                    for (String dependantPuName : puReverseDependencies.get(pu.getName())) {
                        ProcessingUnit dependantPu = this.admin.getProcessingUnits().getProcessingUnit(dependantPuName);
                        if (dependantPu == null || dependantPu.getApplication() == null || !dependantPu.getApplication().getName().equals(this.getName())) continue;
                        postponeUndeployment = true;
                    }
                    if (postponeUndeployment) continue;
                    pusToUndeploy.add(pu);
                }
                if (this.getProcessingUnits().getSize() == 0) break block4;
                if (pusToUndeploy.isEmpty()) {
                    throw new AdminException("Application undeployment does not support cyclic dependencies");
                }
                remaining = end - SystemTime.timeMillis();
                if (remaining > 0L) continue;
                timedOut = true;
                break block4;
            } while ((gsms = (InternalGridServiceManagers)this.admin.getGridServiceManagers()).undeployProcessingUnitsAndWait(pusToUndeploy.toArray(new ProcessingUnit[pusToUndeploy.size()]), remaining, TimeUnit.MILLISECONDS));
            timedOut = true;
        }
        return !timedOut;
    }

    private Map<String, List<String>> getReverseDependencies() {
        ProcessingUnit[] processingUnits = this.getProcessingUnits().getProcessingUnits();
        HashMap<String, List<String>> puReverseDependencies = new HashMap<String, List<String>>();
        for (ProcessingUnit pu : processingUnits) {
            if (puReverseDependencies.containsKey(pu.getName())) continue;
            puReverseDependencies.put(pu.getName(), new LinkedList());
        }
        for (ProcessingUnit pu : processingUnits) {
            String dependantPuName = pu.getName();
            for (String requiredPuName : pu.getDependencies().getDependenciesRequiredProcessingUnitNames()) {
                List dependantPUs = (List)puReverseDependencies.get(requiredPuName);
                if (dependantPUs == null || dependantPUs.contains(dependantPuName)) continue;
                dependantPUs.add(dependantPuName);
            }
        }
        return puReverseDependencies;
    }

    @Override
    public ProcessingUnit deployProcessingUnit(ProcessingUnitDeploymentTopology puDeployment, long timeout, TimeUnit timeUnit) {
        return ((InternalGridServiceManagers)this.admin.getGridServiceManagers()).deploy(this, puDeployment, timeout, timeUnit);
    }

    @Override
    public ProcessingUnit deployProcessingUnit(ProcessingUnitDeploymentTopology puDeployment) {
        return this.deployProcessingUnit(puDeployment, this.admin.getDefaultTimeout(), this.admin.getDefaultTimeoutTimeUnit());
    }
}

