/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.admin.internal.application;

import com.j_spaces.kernel.SizeConcurrentHashMap;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.openspaces.admin.Admin;
import org.openspaces.admin.application.Application;
import org.openspaces.admin.application.events.ApplicationAddedEventListener;
import org.openspaces.admin.application.events.ApplicationAddedEventManager;
import org.openspaces.admin.application.events.ApplicationLifecycleEventListener;
import org.openspaces.admin.application.events.ApplicationRemovedEventManager;
import org.openspaces.admin.internal.admin.InternalAdmin;
import org.openspaces.admin.internal.application.InternalApplicationAware;
import org.openspaces.admin.internal.application.InternalApplications;
import org.openspaces.admin.internal.application.events.DefaultApplicationAddedEventManager;
import org.openspaces.admin.internal.application.events.DefaultApplicationRemovedEventManager;
import org.openspaces.admin.internal.application.events.InternalApplicationAddedEventManager;
import org.openspaces.admin.internal.application.events.InternalApplicationRemovedEventManager;
import org.openspaces.admin.internal.pu.InternalProcessingUnits;
import org.openspaces.admin.pu.ProcessingUnit;

public class DefaultApplications
implements InternalApplications {
    private final InternalAdmin admin;
    private final Map<String, Application> applicationsByName = new SizeConcurrentHashMap();
    private final InternalApplicationAddedEventManager applicationAddedEventManager;
    private final InternalApplicationRemovedEventManager applicationRemovedEventManager;

    public DefaultApplications(InternalAdmin admin) {
        this.admin = admin;
        this.applicationAddedEventManager = new DefaultApplicationAddedEventManager(this);
        this.applicationRemovedEventManager = new DefaultApplicationRemovedEventManager(this);
    }

    @Override
    public Application[] getApplications() {
        Collection<Application> applications = this.applicationsByName.values();
        return applications.toArray(new Application[applications.size()]);
    }

    @Override
    public int getSize() {
        return this.applicationsByName.size();
    }

    @Override
    public boolean isEmpty() {
        return this.applicationsByName.isEmpty();
    }

    @Override
    public Application getApplication(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        return this.applicationsByName.get(name);
    }

    @Override
    public Map<String, Application> getNames() {
        return Collections.unmodifiableMap(this.applicationsByName);
    }

    @Override
    public Application waitFor(String applicationName) {
        return this.waitFor(applicationName, this.admin.getDefaultTimeout(), this.admin.getDefaultTimeoutTimeUnit());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Application waitFor(final String applicationName, long timeout, TimeUnit timeUnit) {
        final CountDownLatch latch = new CountDownLatch(1);
        final AtomicReference ref = new AtomicReference();
        ApplicationAddedEventListener added = new ApplicationAddedEventListener(){

            @Override
            public void applicationAdded(Application application) {
                if (application.getName().equals(applicationName)) {
                    ref.set(application);
                    latch.countDown();
                }
            }
        };
        this.getApplicationAdded().add(added);
        try {
            latch.await(timeout, timeUnit);
            Application application = (Application)ref.get();
            return application;
        }
        catch (InterruptedException e) {
            Application application = null;
            return application;
        }
        finally {
            this.getApplicationAdded().remove(added);
        }
    }

    @Override
    public ApplicationAddedEventManager getApplicationAdded() {
        return this.applicationAddedEventManager;
    }

    @Override
    public ApplicationRemovedEventManager getApplicationRemoved() {
        return this.applicationRemovedEventManager;
    }

    @Override
    public void addLifecycleListener(ApplicationLifecycleEventListener eventListener) {
        this.getApplicationAdded().add(eventListener);
        this.getApplicationRemoved().add(eventListener);
    }

    @Override
    public void removeLifecycleListener(ApplicationLifecycleEventListener eventListener) {
        this.getApplicationAdded().remove(eventListener);
        this.getApplicationRemoved().remove(eventListener);
    }

    @Override
    public Iterator<Application> iterator() {
        return Collections.unmodifiableCollection(this.applicationsByName.values()).iterator();
    }

    @Override
    public Admin getAdmin() {
        return this.admin;
    }

    @Override
    public void addApplication(Application application, ProcessingUnit processingUnit) {
        this.assertStateChangesPermitted();
        if (!this.applicationsByName.containsKey(application.getName())) {
            this.applicationsByName.put(application.getName(), application);
        }
        application = this.getApplication(application.getName());
        ((InternalApplicationAware)((Object)processingUnit)).setApplication(application);
        InternalProcessingUnits processingUnits = (InternalProcessingUnits)application.getProcessingUnits();
        processingUnits.addProcessingUnit(processingUnit);
        if (processingUnits.getSize() == 1) {
            this.applicationAddedEventManager.applicationAdded(application);
        }
    }

    @Override
    public void removeProcessingUnit(ProcessingUnit processingUnit) {
        Application application = processingUnit.getApplication();
        if (application != null) {
            Application existingApplication;
            this.assertStateChangesPermitted();
            InternalProcessingUnits processingUnits = (InternalProcessingUnits)application.getProcessingUnits();
            processingUnits.removeProcessingUnit(processingUnit.getName());
            if (processingUnits.isEmpty() && (existingApplication = this.applicationsByName.remove(application.getName())) != null) {
                this.applicationRemovedEventManager.applicationRemoved(existingApplication);
            }
        }
    }

    private void assertStateChangesPermitted() {
        this.admin.assertStateChangesPermitted();
    }
}

