/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.admin.internal.application.events;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.openspaces.admin.application.Application;
import org.openspaces.admin.application.events.ApplicationAddedEventListener;
import org.openspaces.admin.internal.admin.InternalAdmin;
import org.openspaces.admin.internal.application.InternalApplications;
import org.openspaces.admin.internal.application.events.ClosureApplicationAddedEventListener;
import org.openspaces.admin.internal.application.events.InternalApplicationAddedEventManager;
import org.openspaces.admin.internal.support.GroovyHelper;

public class DefaultApplicationAddedEventManager
implements InternalApplicationAddedEventManager {
    private final InternalApplications applications;
    private final InternalAdmin admin;
    private final List<ApplicationAddedEventListener> applicationAddedEventListeners = new CopyOnWriteArrayList<ApplicationAddedEventListener>();

    public DefaultApplicationAddedEventManager(InternalApplications applications) {
        this.applications = applications;
        this.admin = (InternalAdmin)applications.getAdmin();
    }

    @Override
    public void applicationAdded(final Application application) {
        for (final ApplicationAddedEventListener listener : this.applicationAddedEventListeners) {
            this.admin.pushScheduleMonitorCorrelatedEvent(listener, new Runnable(){

                @Override
                public void run() {
                    listener.applicationAdded(application);
                }
            });
        }
    }

    public void add(final ApplicationAddedEventListener eventListener, boolean includeExisting) {
        if (includeExisting) {
            this.admin.raiseEvent(eventListener, new Runnable(){

                @Override
                public void run() {
                    for (Application application : DefaultApplicationAddedEventManager.this.applications) {
                        eventListener.applicationAdded(application);
                    }
                }
            });
        }
        this.applicationAddedEventListeners.add(eventListener);
    }

    @Override
    public void add(ApplicationAddedEventListener eventListener) {
        this.add(eventListener, true);
    }

    @Override
    public void remove(ApplicationAddedEventListener eventListener) {
        this.applicationAddedEventListeners.remove(eventListener);
    }

    public void plus(Object eventListener) {
        if (GroovyHelper.isClosure(eventListener)) {
            this.add(new ClosureApplicationAddedEventListener(eventListener));
        } else {
            this.add((ApplicationAddedEventListener)eventListener);
        }
    }

    public void leftShift(Object eventListener) {
        this.plus(eventListener);
    }

    public void minus(Object eventListener) {
        if (GroovyHelper.isClosure(eventListener)) {
            this.remove(new ClosureApplicationAddedEventListener(eventListener));
        } else {
            this.remove((ApplicationAddedEventListener)eventListener);
        }
    }

    public void rightShift(Object eventListener) {
        this.minus(eventListener);
    }
}

