/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.admin.internal.application.events;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.openspaces.admin.application.Application;
import org.openspaces.admin.application.events.ApplicationRemovedEventListener;
import org.openspaces.admin.internal.admin.InternalAdmin;
import org.openspaces.admin.internal.application.InternalApplications;
import org.openspaces.admin.internal.application.events.ClosureApplicationRemovedEventListener;
import org.openspaces.admin.internal.application.events.InternalApplicationRemovedEventManager;
import org.openspaces.admin.internal.support.GroovyHelper;

public class DefaultApplicationRemovedEventManager
implements InternalApplicationRemovedEventManager {
    private final InternalApplications applications;
    private final InternalAdmin admin;
    private final List<ApplicationRemovedEventListener> applicationRemovedEventListeners = new CopyOnWriteArrayList<ApplicationRemovedEventListener>();

    public DefaultApplicationRemovedEventManager(InternalApplications applications) {
        this.applications = applications;
        this.admin = (InternalAdmin)applications.getAdmin();
    }

    @Override
    public void applicationRemoved(final Application application) {
        for (final ApplicationRemovedEventListener listener : this.applicationRemovedEventListeners) {
            this.admin.pushScheduleMonitorCorrelatedEvent(listener, new Runnable(){

                @Override
                public void run() {
                    listener.applicationRemoved(application);
                }
            });
        }
    }

    @Override
    public void add(ApplicationRemovedEventListener eventListener) {
        this.applicationRemovedEventListeners.add(eventListener);
    }

    @Override
    public void remove(ApplicationRemovedEventListener eventListener) {
        this.applicationRemovedEventListeners.remove(eventListener);
    }

    public void plus(Object eventListener) {
        if (GroovyHelper.isClosure(eventListener)) {
            this.add(new ClosureApplicationRemovedEventListener(eventListener));
        } else {
            this.add((ApplicationRemovedEventListener)eventListener);
        }
    }

    public void leftShift(Object eventListener) {
        this.plus(eventListener);
    }

    public void minus(Object eventListener) {
        if (GroovyHelper.isClosure(eventListener)) {
            this.remove(new ClosureApplicationRemovedEventListener(eventListener));
        } else {
            this.remove((ApplicationRemovedEventListener)eventListener);
        }
    }

    public void rightShift(Object eventListener) {
        this.minus(eventListener);
    }
}

