/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.admin.internal.discovery;

import com.gigaspaces.grid.gsa.AgentIdAware;
import com.gigaspaces.grid.gsa.AgentProcessesDetails;
import com.gigaspaces.grid.gsa.GSA;
import com.gigaspaces.grid.gsc.GSC;
import com.gigaspaces.grid.gsm.GSM;
import com.gigaspaces.grid.zone.GridZoneProvider;
import com.gigaspaces.internal.client.spaceproxy.ISpaceProxy;
import com.gigaspaces.internal.jmx.JMXUtilities;
import com.gigaspaces.internal.jvm.JVMDetails;
import com.gigaspaces.internal.jvm.JVMInfoProvider;
import com.gigaspaces.internal.os.OSDetails;
import com.gigaspaces.internal.utils.StringUtils;
import com.gigaspaces.lrmi.nio.info.NIODetails;
import com.gigaspaces.management.entry.JMXConnection;
import com.gigaspaces.security.service.SecuredService;
import com.gigaspaces.start.SystemInfo;
import com.j_spaces.core.IJSpace;
import com.j_spaces.core.admin.IInternalRemoteJSpaceAdmin;
import com.j_spaces.core.jini.SharedDiscoveryManagement;
import com.sun.jini.constants.ThrowableConstants;
import com.sun.jini.reggie.Registrar;
import java.io.IOException;
import java.rmi.ConnectException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.jini.core.discovery.LookupLocator;
import net.jini.core.entry.Entry;
import net.jini.core.lookup.ServiceID;
import net.jini.core.lookup.ServiceItem;
import net.jini.core.lookup.ServiceRegistrar;
import net.jini.core.lookup.ServiceTemplate;
import net.jini.discovery.DiscoveryEvent;
import net.jini.discovery.DiscoveryListener;
import net.jini.discovery.DiscoveryLocatorManagement;
import net.jini.discovery.DiscoveryManagement;
import net.jini.discovery.LookupDiscoveryManager;
import net.jini.discovery.dynamic.DynamicLookupLocatorDiscovery;
import net.jini.lookup.LookupCache;
import net.jini.lookup.ServiceDiscoveryEvent;
import net.jini.lookup.ServiceDiscoveryListener;
import net.jini.lookup.ServiceDiscoveryManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jini.rio.boot.BootUtil;
import org.jini.rio.resources.servicecore.Service;
import org.openspaces.admin.AdminException;
import org.openspaces.admin.esm.ElasticServiceManager;
import org.openspaces.admin.gsa.GridServiceAgent;
import org.openspaces.admin.gsc.GridServiceContainer;
import org.openspaces.admin.gsm.GridServiceManager;
import org.openspaces.admin.internal.admin.AdminClosedException;
import org.openspaces.admin.internal.admin.InternalAdmin;
import org.openspaces.admin.internal.esm.DefaultElasticServiceManager;
import org.openspaces.admin.internal.gsa.DefaultGridServiceAgent;
import org.openspaces.admin.internal.gsc.DefaultGridServiceContainer;
import org.openspaces.admin.internal.gsm.DefaultGridServiceManager;
import org.openspaces.admin.internal.lus.DefaultLookupService;
import org.openspaces.admin.internal.pu.DefaultProcessingUnitInstance;
import org.openspaces.admin.internal.space.DefaultSpaceInstance;
import org.openspaces.admin.pu.ProcessingUnit;
import org.openspaces.admin.space.Space;
import org.openspaces.core.space.SpaceServiceDetails;
import org.openspaces.grid.esm.ESM;
import org.openspaces.pu.container.servicegrid.PUDetails;
import org.openspaces.pu.container.servicegrid.PUServiceBean;
import org.openspaces.security.AdminFilterHelper;

public class DiscoveryService
implements DiscoveryListener,
ServiceDiscoveryListener {
    private static final Log logger = LogFactory.getLog(DiscoveryService.class);
    private List<String> groups = null;
    private String locators = null;
    private final InternalAdmin admin;
    private boolean discoverUnmanagedSpaces = false;
    private volatile boolean started = false;
    private ServiceDiscoveryManager sdm;
    private LookupCache serviceCache;
    private LookupCache spaceCache;
    private Class[] services = new Class[]{Service.class};

    public DiscoveryService(InternalAdmin admin) {
        this.admin = admin;
    }

    public void setDiscoveryServices(Class ... services) {
        if (services == null || services.length == 0) {
            return;
        }
        this.services = new Class[services.length];
        for (int i = 0; i < services.length; ++i) {
            if (GridServiceAgent.class.isAssignableFrom(services[i])) {
                this.services[i] = GSA.class;
                continue;
            }
            if (GridServiceManager.class.isAssignableFrom(services[i])) {
                this.services[i] = GSM.class;
                continue;
            }
            if (GridServiceContainer.class.isAssignableFrom(services[i])) {
                this.services[i] = GSC.class;
                continue;
            }
            if (ElasticServiceManager.class.isAssignableFrom(services[i])) {
                this.services[i] = ESM.class;
                continue;
            }
            if (ProcessingUnit.class.isAssignableFrom(services[i])) {
                this.services[i] = PUServiceBean.class;
                continue;
            }
            if (Space.class.isAssignableFrom(services[i])) {
                this.services[i] = IJSpace.class;
                continue;
            }
            throw new IllegalArgumentException("Illegal discovery type - " + services[i]);
        }
    }

    public void addGroup(String group) {
        if (this.groups == null) {
            this.groups = new ArrayList<String>();
        }
        this.groups.add(group);
    }

    public void addLocator(String locator) {
        this.locators = this.locators == null ? locator : this.locators + "," + locator;
    }

    public void discoverUnmanagedSpaces() {
        this.discoverUnmanagedSpaces = true;
    }

    public void start() {
        ServiceTemplate template;
        if (this.started) {
            return;
        }
        this.started = true;
        try {
            this.sdm = SharedDiscoveryManagement.getServiceDiscoveryManager((String[])this.getGroups(), (LookupLocator[])this.getInitialLocators(), (DiscoveryListener)this);
        }
        catch (Exception e) {
            throw new AdminException("Failed to start discovery service, Service Discovery Manager failed to start", e);
        }
        try {
            template = new ServiceTemplate(null, this.services, null);
            this.serviceCache = this.sdm.createLookupCache(template, null, (ServiceDiscoveryListener)this);
        }
        catch (Exception e) {
            this.sdm.terminate();
            throw new AdminException("Failed to start discovery service, Lookup Cache failed to start", e);
        }
        if (this.discoverUnmanagedSpaces) {
            try {
                template = new ServiceTemplate(null, new Class[]{IJSpace.class}, null);
                this.spaceCache = this.sdm.createLookupCache(template, null, (ServiceDiscoveryListener)this);
            }
            catch (Exception e) {
                this.serviceCache.terminate();
                this.sdm.terminate();
                throw new AdminException("Failed to start discovery service, Lookup Cache failed to start", e);
            }
        }
    }

    public void stop() {
        if (!this.started) {
            return;
        }
        this.started = false;
        this.serviceCache.terminate();
        if (this.spaceCache != null) {
            this.spaceCache.terminate();
        }
        this.sdm.terminate();
    }

    public void discovered(DiscoveryEvent disEvent) {
        for (ServiceRegistrar registrar : disEvent.getRegistrars()) {
            ServiceID serviceID = registrar.getServiceID();
            try {
                Object registrarObj = registrar.getRegistrar();
                final JVMDetails jvmDetails = ((JVMInfoProvider)registrarObj).getJVMDetails();
                if (!AdminFilterHelper.acceptJvm(this.admin.getAdminFilter(), jvmDetails) || !(registrarObj instanceof AgentIdAware)) continue;
                final DefaultLookupService lookupService = new DefaultLookupService(registrar, serviceID, this.admin, ((AgentIdAware)registrarObj).getAgentId(), ((AgentIdAware)registrarObj).getGSAServiceID(), jvmDetails);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Service Added [LUS] with uid [" + serviceID + "]"));
                }
                final NIODetails nioDetails = lookupService.getNIODetails();
                final OSDetails osDetails = lookupService.getOSDetails();
                final String[] zones = ((GridZoneProvider)registrarObj).getZones();
                final Entry[] attributeSets = ((Registrar)registrarObj).getLookupAttributes();
                this.admin.scheduleNonBlockingStateChange(new Runnable(){

                    @Override
                    public void run() {
                        String jmxUrl = DiscoveryService.getJMXConnection(attributeSets);
                        DiscoveryService.this.admin.addLookupService(lookupService, nioDetails, osDetails, jvmDetails, jmxUrl, zones);
                    }
                });
            }
            catch (AdminClosedException e) {
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)("Failed to add lookup service with id [" + serviceID + "] since admin is already closed"), (Throwable)e);
            }
            catch (Exception e) {
                logger.warn((Object)("Failed to add lookup service with id [" + serviceID + "]"), (Throwable)e);
            }
        }
    }

    public void discarded(DiscoveryEvent e) {
        for (ServiceRegistrar registrar : e.getRegistrars()) {
            final String serviceId = registrar.getServiceID().toString();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Service Removed [LUS] with uid [" + serviceId + "]"));
            }
            try {
                this.admin.scheduleNonBlockingStateChange(new Runnable(){

                    @Override
                    public void run() {
                        DiscoveryService.this.admin.removeLookupService(serviceId);
                    }
                });
            }
            catch (AdminClosedException ex) {
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)("Failed to remove lookup service with id [" + serviceId + "] since admin is already closed"), (Throwable)ex);
            }
        }
    }

    public void serviceAdded(ServiceDiscoveryEvent event) {
        ServiceItem serviceItem = event.getPostEventServiceItem();
        Object service = serviceItem.service;
        if (service instanceof GSM) {
            this.initGSM((GSM)service, serviceItem.serviceID, serviceItem, true);
        } else if (service instanceof ESM) {
            this.initESM((ESM)service, serviceItem.serviceID, serviceItem, true);
        } else if (service instanceof GSA) {
            this.initGSA((GSA)service, serviceItem.serviceID, serviceItem, true);
        } else if (service instanceof GSC) {
            this.initGSC((GSC)service, serviceItem.serviceID, serviceItem, true);
        } else if (service instanceof PUServiceBean) {
            this.initPU((PUServiceBean)service, serviceItem.serviceID, serviceItem, true);
        } else if (service instanceof IJSpace) {
            this.initSpaceProxy((ISpaceProxy)service, serviceItem.serviceID, true);
        }
    }

    private void initSpaceProxy(ISpaceProxy clusteredIjspace, ServiceID serviceID, boolean retryable) {
        block6: {
            String svcToString = "Space Instance [" + clusteredIjspace + "], ServiceID [" + serviceID + "]";
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Add " + svcToString));
            }
            try {
                this.admin.login((SecuredService)clusteredIjspace);
                ISpaceProxy direcyIjspace = (ISpaceProxy)clusteredIjspace.getDirectProxy().getNonClusteredProxy();
                this.admin.login((SecuredService)direcyIjspace);
                IInternalRemoteJSpaceAdmin spaceAdmin = (IInternalRemoteJSpaceAdmin)direcyIjspace.getAdmin();
                final JVMDetails jvmDetails = spaceAdmin.getJVMDetails();
                if (!AdminFilterHelper.acceptJvm(this.admin.getAdminFilter(), jvmDetails)) {
                    return;
                }
                final DefaultSpaceInstance spaceInstance = new DefaultSpaceInstance(serviceID, (IJSpace)direcyIjspace, spaceAdmin, this.admin, jvmDetails);
                final NIODetails nioDetails = spaceInstance.getNIODetails();
                final OSDetails osDetails = spaceInstance.getOSDetails();
                String jmxServiceURL = null;
                try {
                    jmxServiceURL = JMXUtilities.createJMXUrl((String)direcyIjspace.getDirectProxy().getContainerConfig().jndiUrl);
                }
                catch (RemoteException re) {
                    logger.warn((Object)"Failed to fetch jndi url from space container", (Throwable)re);
                }
                final String optionalJmxServiceURL = jmxServiceURL;
                final String[] zones = spaceAdmin.getZones();
                this.admin.scheduleNonBlockingStateChange(new Runnable(){

                    @Override
                    public void run() {
                        DiscoveryService.this.admin.addSpaceInstance(spaceInstance, nioDetails, osDetails, jvmDetails, optionalJmxServiceURL, zones);
                    }
                });
            }
            catch (Exception ex) {
                if (!this.handleAddException(ex, svcToString, retryable)) break block6;
                this.initSpaceProxy(clusteredIjspace, serviceID, false);
            }
        }
    }

    private void initPU(final PUServiceBean puServiceBean, ServiceID serviceID, final ServiceItem serviceItem, boolean retryable) {
        block8: {
            String svcToString = "Processing Unit Instance [" + puServiceBean + "], ServiceID [" + serviceID + "]";
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Add " + svcToString));
            }
            try {
                PUDetails puDetails = puServiceBean.getPUDetails();
                if (puDetails == null) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Failed to add " + svcToString + " with empty details"));
                    }
                } else {
                    final JVMDetails jvmDetails = puServiceBean.getJVMDetails();
                    if (!AdminFilterHelper.acceptJvm(this.admin.getAdminFilter(), jvmDetails)) {
                        return;
                    }
                    final DefaultProcessingUnitInstance processingUnitInstance = new DefaultProcessingUnitInstance(serviceID, puDetails, puServiceBean, this.admin, jvmDetails);
                    final NIODetails nioDetails = processingUnitInstance.getNIODetails();
                    final OSDetails osDetails = processingUnitInstance.getOSDetails();
                    final String[] zones = puServiceBean.getZones();
                    this.admin.scheduleNonBlockingStateChange(new Runnable(){

                        @Override
                        public void run() {
                            String jmxUrl = DiscoveryService.getJMXConnection(serviceItem.attributeSets);
                            DiscoveryService.this.admin.addProcessingUnitInstance(processingUnitInstance, nioDetails, osDetails, jvmDetails, jmxUrl, zones);
                            if (!DiscoveryService.this.discoverUnmanagedSpaces) {
                                for (SpaceServiceDetails serviceDetails : processingUnitInstance.getEmbeddedSpacesDetails()) {
                                    DefaultSpaceInstance spaceInstance = new DefaultSpaceInstance(puServiceBean, serviceDetails, DiscoveryService.this.admin, jvmDetails);
                                    DiscoveryService.this.admin.addSpaceInstance(spaceInstance, nioDetails, osDetails, jvmDetails, jmxUrl, zones);
                                }
                            }
                        }
                    });
                    if (!retryable) {
                        logger.info((Object)("Successfully added " + svcToString));
                    }
                }
            }
            catch (Exception ex) {
                if (!this.handleAddException(ex, svcToString, retryable)) break block8;
                this.initPU(puServiceBean, serviceID, serviceItem, false);
            }
        }
    }

    private void initGSC(GSC gsc, ServiceID serviceID, final ServiceItem serviceItem, boolean retryable) {
        block5: {
            String svcToString = "GSC [" + gsc + "], ServiceID [" + serviceID + "]";
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Add " + svcToString));
            }
            try {
                final JVMDetails jvmDetails = gsc.getJVMDetails();
                if (!AdminFilterHelper.acceptJvm(this.admin.getAdminFilter(), jvmDetails)) {
                    return;
                }
                this.admin.login((SecuredService)gsc);
                final DefaultGridServiceContainer gridServiceContainer = new DefaultGridServiceContainer(serviceID, gsc, this.admin, gsc.getAgentId(), gsc.getGSAServiceID(), jvmDetails);
                final NIODetails nioDetails = gridServiceContainer.getNIODetails();
                final OSDetails osDetails = gridServiceContainer.getOSDetails();
                final String[] zones = gsc.getZones();
                this.admin.scheduleNonBlockingStateChange(new Runnable(){

                    @Override
                    public void run() {
                        String jmxUrl = DiscoveryService.getJMXConnection(serviceItem.attributeSets);
                        DiscoveryService.this.admin.addGridServiceContainer(gridServiceContainer, nioDetails, osDetails, jvmDetails, jmxUrl, zones);
                    }
                });
                if (!retryable) {
                    logger.info((Object)("Retry Successful - Added " + svcToString));
                }
            }
            catch (Exception ex) {
                if (!this.handleAddException(ex, svcToString, retryable)) break block5;
                this.initGSC(gsc, serviceID, serviceItem, false);
            }
        }
    }

    private void initGSA(GSA gsa, ServiceID serviceID, final ServiceItem serviceItem, boolean retryable) {
        block4: {
            String svcToString = "GSA [" + gsa + "], ServiceID [" + serviceID + "]";
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Add " + svcToString));
            }
            try {
                final JVMDetails jvmDetails = gsa.getJVMDetails();
                if (!AdminFilterHelper.acceptJvm(this.admin.getAdminFilter(), jvmDetails)) {
                    return;
                }
                this.admin.login((SecuredService)gsa);
                AgentProcessesDetails processesDetails = gsa.getDetails();
                final DefaultGridServiceAgent gridServiceAgent = new DefaultGridServiceAgent(serviceID, gsa, this.admin, processesDetails, jvmDetails);
                final NIODetails nioDetails = gridServiceAgent.getNIODetails();
                final OSDetails osDetails = gridServiceAgent.getOSDetails();
                final String[] zones = gsa.getZones();
                this.admin.scheduleNonBlockingStateChange(new Runnable(){

                    @Override
                    public void run() {
                        String jmxUrl = DiscoveryService.getJMXConnection(serviceItem.attributeSets);
                        DiscoveryService.this.admin.addGridServiceAgent(gridServiceAgent, nioDetails, osDetails, jvmDetails, jmxUrl, zones);
                    }
                });
            }
            catch (Exception ex) {
                if (!this.handleAddException(ex, svcToString, retryable)) break block4;
                this.initGSA(gsa, serviceID, serviceItem, false);
            }
        }
    }

    private void initESM(ESM esm, ServiceID serviceID, final ServiceItem serviceItem, boolean retryable) {
        block3: {
            String svcToString = "ESM [" + esm + "], ServiceID [" + serviceID + "]";
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Add " + svcToString));
            }
            try {
                this.admin.login((SecuredService)esm);
                final JVMDetails jvmDetails = esm.getJVMDetails();
                final DefaultElasticServiceManager elasticServiceManager = new DefaultElasticServiceManager(serviceID, esm, this.admin, esm.getAgentId(), esm.getGSAServiceID(), jvmDetails);
                final NIODetails nioDetails = elasticServiceManager.getNIODetails();
                final OSDetails osDetails = elasticServiceManager.getOSDetails();
                final String[] zones = esm.getZones();
                this.admin.scheduleNonBlockingStateChange(new Runnable(){

                    @Override
                    public void run() {
                        String jmxUrl = DiscoveryService.getJMXConnection(serviceItem.attributeSets);
                        boolean acceptVM = AdminFilterHelper.acceptJvm(DiscoveryService.this.admin.getAdminFilter(), jvmDetails);
                        DiscoveryService.this.admin.addElasticServiceManager(elasticServiceManager, nioDetails, osDetails, jvmDetails, jmxUrl, zones, acceptVM);
                    }
                });
            }
            catch (Exception ex) {
                if (!this.handleAddException(ex, svcToString, retryable)) break block3;
                this.initESM(esm, serviceID, serviceItem, false);
            }
        }
    }

    private void initGSM(GSM gsm, ServiceID serviceID, final ServiceItem serviceItem, boolean retryable) {
        block3: {
            String svcToString = "GSM [" + gsm + "], ServiceID [" + serviceID + "]";
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Add " + svcToString));
            }
            try {
                this.admin.login((SecuredService)gsm);
                final JVMDetails jvmDetails = gsm.getJVMDetails();
                final DefaultGridServiceManager gridServiceManager = new DefaultGridServiceManager(serviceID, gsm, this.admin, gsm.getAgentId(), gsm.getGSAServiceID(), jvmDetails);
                final NIODetails nioDetails = gridServiceManager.getNIODetails();
                final OSDetails osDetails = gridServiceManager.getOSDetails();
                final String[] zones = gsm.getZones();
                this.admin.scheduleNonBlockingStateChange(new Runnable(){

                    @Override
                    public void run() {
                        String jmxUrl = DiscoveryService.getJMXConnection(serviceItem.attributeSets);
                        boolean acceptVM = AdminFilterHelper.acceptJvm(DiscoveryService.this.admin.getAdminFilter(), jvmDetails);
                        DiscoveryService.this.admin.addGridServiceManager(gridServiceManager, nioDetails, osDetails, jvmDetails, jmxUrl, zones, acceptVM);
                    }
                });
            }
            catch (Exception ex) {
                if (!this.handleAddException(ex, svcToString, retryable)) break block3;
                this.initGSM(gsm, serviceID, serviceItem, false);
            }
        }
    }

    private boolean handleAddException(Exception ex, String svcToString, boolean retryable) {
        if (ex instanceof SecurityException) {
            logger.warn((Object)("Secured invocation - Failed to add " + svcToString), (Throwable)ex);
        } else if (ex instanceof RemoteException) {
            if (this.UnrecoverableRemoteException(ex)) {
                logger.warn((Object)("Unrecoverable invocation - Failed to add " + svcToString), (Throwable)ex);
            } else {
                if (retryable) {
                    logger.warn((Object)("Retryable invocation - Failed to add " + svcToString), (Throwable)ex);
                    return true;
                }
                logger.warn((Object)("Retry unsuccessful - Failed to add " + svcToString), (Throwable)ex);
            }
        } else if (ex instanceof AdminClosedException) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Admin closed - Failed to add " + svcToString), (Throwable)ex);
            }
        } else {
            logger.warn((Object)("Failed to add " + svcToString), (Throwable)ex);
        }
        return false;
    }

    private boolean UnrecoverableRemoteException(Exception ex) {
        if (ex instanceof ConnectException && ex.getCause() instanceof IOException) {
            return false;
        }
        int category = ThrowableConstants.retryable((Throwable)ex);
        return category == 1 || category == 2;
    }

    public static String getJMXConnection(Entry[] attrs) {
        String jmxConn = null;
        for (int x = 0; x < attrs.length; ++x) {
            if (!(attrs[x] instanceof JMXConnection)) continue;
            jmxConn = ((JMXConnection)attrs[x]).jmxServiceURL;
            break;
        }
        return jmxConn;
    }

    public void serviceRemoved(ServiceDiscoveryEvent event) {
        block2: {
            final Object service = event.getPreEventServiceItem().service;
            final ServiceID serviceID = event.getPreEventServiceItem().serviceID;
            try {
                this.admin.scheduleNonBlockingStateChange(new Runnable(){

                    @Override
                    public void run() {
                        if (service instanceof GSM) {
                            if (logger.isDebugEnabled()) {
                                logger.debug((Object)("Remove GSM [" + service + "], ServiceID [" + serviceID + "]"));
                            }
                            DiscoveryService.this.admin.removeGridServiceManager(serviceID.toString());
                        } else if (service instanceof ESM) {
                            if (logger.isDebugEnabled()) {
                                logger.debug((Object)("Remove ESM [" + service + "], ServiceID [" + serviceID + "]"));
                            }
                            DiscoveryService.this.admin.removeElasticServiceManager(serviceID.toString());
                        } else if (service instanceof GSA) {
                            if (logger.isDebugEnabled()) {
                                logger.debug((Object)("Remove GSA [" + service + "], ServiceID [" + serviceID + "]"));
                            }
                            DiscoveryService.this.admin.removeGridServiceAgent(serviceID.toString());
                        } else if (service instanceof GSC) {
                            if (logger.isDebugEnabled()) {
                                logger.debug((Object)("Remove GSC [" + service + "], ServiceID [" + serviceID + "]"));
                            }
                            DiscoveryService.this.admin.removeGridServiceContainer(serviceID.toString());
                        } else if (service instanceof PUServiceBean) {
                            if (logger.isDebugEnabled()) {
                                logger.debug((Object)("Remove Processing Unit Instance [" + service + "], ServiceID [" + serviceID + "]"));
                            }
                            DiscoveryService.this.admin.removeProcessingUnitInstance(serviceID.toString(), !DiscoveryService.this.discoverUnmanagedSpaces);
                        } else if (service instanceof IJSpace) {
                            if (logger.isDebugEnabled()) {
                                logger.debug((Object)("Remove Space Instance [" + service + "], ServiceID [" + serviceID + "]"));
                            }
                            DiscoveryService.this.admin.removeSpaceInstance(serviceID.toString());
                        }
                    }
                });
            }
            catch (AdminClosedException e) {
                if (!logger.isDebugEnabled()) break block2;
                logger.debug((Object)("Failed to remove service " + service.getClass() + " id " + serviceID + " since admin is already closed"), (Throwable)e);
            }
        }
    }

    public void serviceChanged(ServiceDiscoveryEvent event) {
    }

    public String[] getGroups() {
        String groupsProperty;
        String[] groups = this.groups == null ? ((groupsProperty = SystemInfo.singleton().lookup().groups()) != null ? StringUtils.commaDelimitedListToStringArray((String)groupsProperty) : new String[]{SystemInfo.singleton().lookup().defaultGroups()}) : this.groups.toArray(new String[this.groups.size()]);
        return groups;
    }

    public LookupLocator[] getLocators() {
        LookupLocator[] result = !this.isDynamicLocatorsEnabled() ? this.getInitialLocators() : this.getDynamicLocators();
        return result;
    }

    public boolean isDynamicLocatorsEnabled() {
        if (this.started && this.sdm != null && this.sdm.getDiscoveryManager() instanceof LookupDiscoveryManager) {
            LookupDiscoveryManager ldm = (LookupDiscoveryManager)this.sdm.getDiscoveryManager();
            return DynamicLookupLocatorDiscovery.dynamicLocatorsEnabled() || ldm.getDynamicLocatorDiscovery().isInitialized();
        }
        return false;
    }

    private LookupLocator[] getDynamicLocators() {
        try {
            return ((DiscoveryLocatorManagement)this.sdm.getDiscoveryManager()).getLocators();
        }
        catch (Exception e) {
            if (logger.isWarnEnabled()) {
                logger.warn((Object)"Failed retrieving dynamic locators from admin, returning initial locators", (Throwable)e);
            }
            return this.getInitialLocators();
        }
    }

    private LookupLocator[] getInitialLocators() {
        String locatorsProperty;
        if (this.locators == null && (locatorsProperty = SystemInfo.singleton().lookup().locators()) != null) {
            this.locators = locatorsProperty;
        }
        return BootUtil.toLookupLocators((String)this.locators);
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean verbose) {
        DiscoveryManagement ldm = this.sdm.getDiscoveryManager();
        String message = super.toString() + " sdm=" + Integer.toHexString(this.sdm.hashCode()) + " ldm=" + Integer.toHexString(ldm.hashCode());
        if (verbose) {
            message = message + " groups=" + Arrays.toString(this.getGroups()) + " locators=" + Arrays.toString(this.getLocators());
        }
        return message;
    }
}

