/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.admin.internal.dump;

import com.gigaspaces.internal.license.LicenseManager;
import com.gigaspaces.internal.version.PlatformVersion;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.openspaces.admin.Admin;
import org.openspaces.admin.esm.ElasticServiceManagers;
import org.openspaces.admin.gsa.GridServiceAgents;
import org.openspaces.admin.gsc.GridServiceContainer;
import org.openspaces.admin.gsc.GridServiceContainers;
import org.openspaces.admin.gsm.GridServiceManagers;
import org.openspaces.admin.lus.LookupServices;
import org.openspaces.admin.machine.Machine;
import org.openspaces.admin.machine.Machines;
import org.openspaces.admin.os.OperatingSystemStatistics;
import org.openspaces.admin.pu.ProcessingUnit;
import org.openspaces.admin.pu.ProcessingUnits;
import org.openspaces.admin.support.StatisticsUtils;
import org.openspaces.admin.vm.VirtualMachine;
import org.openspaces.admin.vm.VirtualMachineDetails;
import org.openspaces.admin.vm.VirtualMachineStatistics;
import org.springframework.util.Assert;

public class InternalOverviewBuilder {
    private static SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
    private static NumberFormat doubleNumFormatter = new DecimalFormat("#0");
    private static final String fileName = "overview.txt";
    private static final String TIMESTAMP = "timestamp";
    private static final String FORMAT = "%-8s %-30s %-45s";
    private static final String FORMAT_ONE_COLUMN = "%-8s %-45s";
    private static final String FORMAT_ONE_COLUMN_GSC = "%-20s %-50s";
    private static final String FORMAT_DETAILS = "%-12s %-20s %-45s";

    public static File createOverviewDumpResult(Admin admin) {
        File file = new File(fileName);
        try {
            StringBuilder strBuilder = new StringBuilder();
            strBuilder.append("Overview");
            strBuilder.append("\n");
            strBuilder.append(InternalOverviewBuilder.getOverviewFormattedDate());
            strBuilder.append("\n");
            strBuilder.append(InternalOverviewBuilder.getBuild());
            strBuilder.append("\n");
            strBuilder.append(InternalOverviewBuilder.getXapVersion());
            strBuilder.append("\n");
            strBuilder.append(InternalOverviewBuilder.getLicense());
            strBuilder.append("\n");
            strBuilder.append(InternalOverviewBuilder.getNumOfMachines(admin));
            strBuilder.append("\n");
            strBuilder.append(InternalOverviewBuilder.getGridServicesCount(admin.getGridServiceAgents(), admin.getLookupServices(), admin.getGridServiceManagers(), admin.getGridServiceContainers(), admin.getElasticServiceManagers(), FORMAT));
            strBuilder.append("\n\n");
            strBuilder.append("Processing Units");
            strBuilder.append("\n");
            strBuilder.append(InternalOverviewBuilder.getProcessingUnitsInfo(admin));
            strBuilder.append("\n");
            strBuilder.append("Hosts");
            strBuilder.append("\n");
            strBuilder.append(InternalOverviewBuilder.getHostsInfo(admin));
            strBuilder.append("\n");
            int checksum = InternalOverviewBuilder.createChecksum(strBuilder.toString());
            strBuilder.append(TIMESTAMP);
            strBuilder.append(':');
            strBuilder.append((checksum + 2000) * 2);
            FileWriter fileWriter = new FileWriter(file);
            fileWriter.append(strBuilder.toString());
            fileWriter.flush();
            fileWriter.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return file;
    }

    private static String getOverviewFormattedDate() {
        String formattedDate = sdf.format(new Date());
        return String.format(FORMAT, "", "Time", formattedDate);
    }

    private static String getXapVersion() {
        return String.format(FORMAT, "", "XAP version", LicenseManager.getInstance().getLicenseType());
    }

    private static String getLicense() {
        return String.format(FORMAT, "", "Client License", LicenseManager.getInstance().getLicenseKey());
    }

    private static String getBuild() {
        return String.format(FORMAT, "", "Revision", PlatformVersion.getRevision());
    }

    private static String getNumOfMachines(Admin admin) {
        return String.format(FORMAT, "", "Number of Machines", admin.getMachines().getSize());
    }

    private static String getProcessingUnitsInfo(Admin admin) {
        StringBuilder strBuilder = new StringBuilder("");
        ProcessingUnits processingUnits = admin.getProcessingUnits();
        for (ProcessingUnit processingUnit : processingUnits) {
            strBuilder.append(String.format(FORMAT, "", "Name", processingUnit.getName()));
            strBuilder.append("\n");
            strBuilder.append(String.format(FORMAT, "", "Type", processingUnit.getType().name().toLowerCase()));
            strBuilder.append("\n");
            strBuilder.append(String.format(FORMAT, "", "SLA", "(" + processingUnit.getPlannedNumberOfPartitions() + "," + processingUnit.getNumberOfBackups() + ")"));
            strBuilder.append("\n");
        }
        return strBuilder.toString();
    }

    private static String getHostsInfo(Admin admin) {
        StringBuilder strBuilder = new StringBuilder("");
        Machines machines = admin.getMachines();
        for (Machine machine : machines) {
            strBuilder.append(String.format(FORMAT_ONE_COLUMN, "", machine.getHostName() + "[" + machine.getHostAddress() + "] Cores [" + machine.getOperatingSystem().getDetails().getAvailableProcessors() + "]"));
            strBuilder.append("\n");
            strBuilder.append(String.format(FORMAT_DETAILS, "", "JVM Version", InternalOverviewBuilder.getVmDetails(machine)));
            strBuilder.append("\n");
            strBuilder.append(InternalOverviewBuilder.getMachineUtilization(machine));
            strBuilder.append("\n");
            strBuilder.append(InternalOverviewBuilder.getGridServicesCount(machine.getGridServiceAgents(), machine.getLookupServices(), machine.getGridServiceManagers(), machine.getGridServiceContainers(), machine.getElasticServiceManagers(), FORMAT_DETAILS));
            strBuilder.append("\n");
            strBuilder.append(String.format(FORMAT_DETAILS, "", "GSCs", InternalOverviewBuilder.getGSCsMemoryInfo(machine)));
            strBuilder.append("\n");
        }
        return strBuilder.toString();
    }

    private static String getMachineUtilization(Machine machine) {
        OperatingSystemStatistics statistics = machine.getOperatingSystem().getStatistics();
        double physicalMemoryUsedPerc = statistics.getPhysicalMemoryUsedPerc();
        long actualMemoryUsed = statistics.getActualMemoryUsed();
        StringBuilder strBuilder = new StringBuilder();
        strBuilder.append("cpu[");
        strBuilder.append(statistics.getCpuPercFormatted());
        strBuilder.append("] ");
        strBuilder.append("memory[");
        double usedMemory = StatisticsUtils.convertToGB(actualMemoryUsed);
        boolean isMB = false;
        if (usedMemory < 1.0) {
            usedMemory = StatisticsUtils.convertToMB(actualMemoryUsed);
            isMB = true;
        }
        strBuilder.append(doubleNumFormatter.format(usedMemory));
        strBuilder.append(isMB ? "MB" : "GB");
        strBuilder.append(" (");
        strBuilder.append(doubleNumFormatter.format(physicalMemoryUsedPerc));
        strBuilder.append("%)");
        strBuilder.append("] ");
        return String.format(FORMAT_DETAILS, "", "Utilization", strBuilder.toString());
    }

    private static String getGSCsMemoryInfo(Machine machine) {
        StringBuilder strBuilder = new StringBuilder("");
        GridServiceContainers gridServiceContainers = machine.getGridServiceContainers();
        if (!gridServiceContainers.isEmpty()) {
            for (GridServiceContainer gsc : gridServiceContainers) {
                VirtualMachine virtualMachine = gsc.getVirtualMachine();
                VirtualMachineDetails details = virtualMachine.getDetails();
                VirtualMachineStatistics statistics = virtualMachine.getStatistics();
                double memoryHeapInitInMB = details.getMemoryHeapInitInMB();
                double memoryHeapMaxInMB = details.getMemoryHeapMaxInMB();
                double memoryHeapUsedInMB = statistics.getMemoryHeapUsedInMB();
                double memoryHeapCommittedInMB = statistics.getMemoryHeapCommittedInMB();
                strBuilder.append("\n");
                StringBuilder strBuilderMemoryDetails = new StringBuilder();
                strBuilderMemoryDetails.append("GSC[");
                strBuilderMemoryDetails.append(details.getPid());
                strBuilderMemoryDetails.append("] ");
                strBuilderMemoryDetails.append("Heap: ");
                strBuilderMemoryDetails.append("Init[");
                strBuilderMemoryDetails.append(doubleNumFormatter.format(memoryHeapInitInMB));
                strBuilderMemoryDetails.append("MB], ");
                strBuilderMemoryDetails.append("Max[");
                strBuilderMemoryDetails.append(doubleNumFormatter.format(memoryHeapMaxInMB));
                strBuilderMemoryDetails.append("MB], ");
                strBuilderMemoryDetails.append("Used[");
                strBuilderMemoryDetails.append(doubleNumFormatter.format(memoryHeapUsedInMB));
                strBuilderMemoryDetails.append("MB], ");
                strBuilderMemoryDetails.append("Committed[");
                strBuilderMemoryDetails.append(doubleNumFormatter.format(memoryHeapCommittedInMB));
                strBuilderMemoryDetails.append("MB]");
                strBuilder.append(String.format(FORMAT_ONE_COLUMN_GSC, "", strBuilderMemoryDetails.toString()));
            }
        } else {
            strBuilder.append("N/A");
        }
        return strBuilder.toString();
    }

    private static String getVmDetails(Machine machine) {
        VirtualMachine virtualMachine = null;
        if (!machine.getGridServiceAgents().isEmpty()) {
            virtualMachine = machine.getGridServiceAgents().getAgents()[0].getVirtualMachine();
        } else if (!machine.getVirtualMachines().isEmpty()) {
            virtualMachine = machine.getVirtualMachines().getVirtualMachines()[0];
        }
        return InternalOverviewBuilder.getVmDetails(virtualMachine);
    }

    private static String getVmDetails(VirtualMachine virtualMachine) {
        StringBuilder strBuilder = new StringBuilder("");
        if (virtualMachine == null) {
            strBuilder.append("N/A");
        } else {
            VirtualMachineDetails vmDetails = virtualMachine.getDetails();
            strBuilder.append(vmDetails.getVmVendor());
            strBuilder.append(" ");
            strBuilder.append(vmDetails.getVmName());
            strBuilder.append(" ");
            strBuilder.append(vmDetails.getVmVersion());
        }
        return strBuilder.toString();
    }

    private static String getGridServicesCount(GridServiceAgents gridServiceAgents, LookupServices lookupServices, GridServiceManagers gridServiceManagers, GridServiceContainers gridServiceContainers, ElasticServiceManagers elasticServiceManagers, String format) {
        StringBuilder strBuilder = new StringBuilder();
        strBuilder.append("GSA(" + gridServiceAgents.getSize() + "), ");
        strBuilder.append("LUS(" + lookupServices.getSize() + "), ");
        strBuilder.append("GSM(" + gridServiceManagers.getSize() + "), ");
        strBuilder.append("GSC(" + gridServiceContainers.getSize() + "), ");
        strBuilder.append("ESM(" + elasticServiceManagers.getSize() + ")");
        return String.format(format, "", "Grid Components", strBuilder.toString());
    }

    private static String getUserInput(String prompt) {
        String result = "";
        try {
            System.out.print(prompt);
            BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
            result = reader.readLine();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return result;
    }

    private static int createChecksum(String content) {
        return content.hashCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        String path = args.length == 0 ? InternalOverviewBuilder.getUserInput("Enter the path to overview.txt file and press Enter: ") : args[0];
        File overviewFile = new File(path = path.endsWith(fileName) ? path : path + File.separator + fileName);
        if (!overviewFile.exists()) {
            System.out.println("Unable to locate overview file according ot its provided path [" + path + "]");
            System.exit(0);
        }
        BufferedReader bufferedReader = null;
        StringBuilder fileContentStrBuilder = new StringBuilder();
        String currentLine = null;
        String lastLine = null;
        try {
            FileReader fileReader = new FileReader(overviewFile);
            bufferedReader = new BufferedReader(fileReader);
            while ((currentLine = bufferedReader.readLine()) != null) {
                lastLine = currentLine;
                fileContentStrBuilder.append(currentLine);
                fileContentStrBuilder.append(System.lineSeparator());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(0);
        }
        finally {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        String hashcodeStr = lastLine.substring("timestamp:".length());
        int foundHashcode = -1;
        System.out.println("hashcodeStr:" + hashcodeStr);
        try {
            foundHashcode = Integer.parseInt(hashcodeStr);
            System.out.println(new Date(foundHashcode));
        }
        catch (NumberFormatException nfe) {
            System.out.println("Unable to continue, Last line [" + lastLine + "] must be integer number");
            System.exit(0);
        }
        int indexOfHash = fileContentStrBuilder.indexOf(lastLine);
        foundHashcode = foundHashcode / 2 - 2000;
        String overviewWithoutHashContent = fileContentStrBuilder.substring(0, indexOfHash);
        int compareWithHashcode = overviewWithoutHashContent.hashCode();
        Assert.isTrue((foundHashcode == compareWithHashcode ? 1 : 0) != 0, (String)"Hash codes are not equal, file probably was changed!");
        System.out.println("Overview file is original");
    }
}

