/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.admin.internal.esm;

import com.gigaspaces.internal.dump.InternalDumpProvider;
import com.gigaspaces.internal.jvm.JVMDetails;
import com.gigaspaces.internal.jvm.JVMStatistics;
import com.gigaspaces.internal.os.OSDetails;
import com.gigaspaces.internal.os.OSStatistics;
import com.gigaspaces.log.LogEntries;
import com.gigaspaces.log.LogEntryMatcher;
import com.gigaspaces.log.LogProcessType;
import com.gigaspaces.lrmi.LRMIMonitoringDetails;
import com.gigaspaces.lrmi.nio.info.NIODetails;
import com.gigaspaces.lrmi.nio.info.NIOStatistics;
import java.io.IOException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import net.jini.core.lookup.ServiceID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jini.rio.monitor.event.Events;
import org.openspaces.admin.AdminException;
import org.openspaces.admin.dump.DumpResult;
import org.openspaces.admin.internal.admin.InternalAdmin;
import org.openspaces.admin.internal.dump.InternalDumpResult;
import org.openspaces.admin.internal.esm.InternalElasticServiceManager;
import org.openspaces.admin.internal.support.AbstractAgentGridComponent;
import org.openspaces.admin.pu.ProcessingUnit;
import org.openspaces.admin.pu.elastic.config.ScaleStrategyConfig;
import org.openspaces.admin.pu.elastic.events.ElasticProcessingUnitEvent;
import org.openspaces.admin.pu.elastic.events.ElasticProcessingUnitScaleProgressChangedEvent;
import org.openspaces.grid.esm.ESM;

public class DefaultElasticServiceManager
extends AbstractAgentGridComponent
implements InternalElasticServiceManager {
    private static final Log logger = LogFactory.getLog(DefaultElasticServiceManager.class);
    private final ServiceID serviceID;
    private final ESM esm;
    private final Map<String, Boolean> esmScaleIsInProgressPerProcessingUnit;

    public DefaultElasticServiceManager(ServiceID serviceID, ESM esm, InternalAdmin admin, int agentId, String agentUid, JVMDetails jvmDetails) throws RemoteException {
        super(admin, agentId, agentUid, jvmDetails);
        this.serviceID = serviceID;
        this.esm = esm;
        this.esmScaleIsInProgressPerProcessingUnit = new ConcurrentHashMap<String, Boolean>();
    }

    @Override
    public String getUid() {
        return this.serviceID.toString();
    }

    @Override
    public ServiceID getServiceID() {
        return this.serviceID;
    }

    @Override
    public ESM getESM() {
        return this.esm;
    }

    @Override
    public LogEntries logEntries(LogEntryMatcher matcher) throws AdminException {
        if (this.getGridServiceAgent() != null) {
            return this.getGridServiceAgent().logEntries(LogProcessType.ESM, this.getVirtualMachine().getDetails().getPid(), matcher);
        }
        return this.logEntriesDirect(matcher);
    }

    @Override
    public LogEntries logEntriesDirect(LogEntryMatcher matcher) throws AdminException {
        try {
            return this.esm.logEntriesDirect(matcher);
        }
        catch (IOException e) {
            throw new AdminException("Failed to get log", e);
        }
    }

    @Override
    public void reloadMetricConfiguration() throws AdminException {
        try {
            this.esm.reloadMetricConfiguration();
        }
        catch (RemoteException e) {
            throw new AdminException("Failed to reload metric configuration", e);
        }
    }

    @Override
    public DumpResult generateDump(String cause, Map<String, Object> context) throws AdminException {
        try {
            return new InternalDumpResult(this, (InternalDumpProvider)this.esm, this.esm.generateDump(cause, context));
        }
        catch (Exception e) {
            throw new AdminException("Failed to generate dump", e);
        }
    }

    @Override
    public DumpResult generateDump(String cause, Map<String, Object> context, String ... processors) throws AdminException {
        try {
            return new InternalDumpResult(this, (InternalDumpProvider)this.esm, this.esm.generateDump(cause, context, processors));
        }
        catch (Exception e) {
            throw new AdminException("Failed to generate dump", e);
        }
    }

    @Override
    public NIODetails getNIODetails() throws RemoteException {
        return this.esm.getNIODetails();
    }

    @Override
    public NIOStatistics getNIOStatistics() throws RemoteException {
        return this.esm.getNIOStatistics();
    }

    @Override
    public void enableLRMIMonitoring() throws RemoteException {
        this.esm.enableLRMIMonitoring();
    }

    @Override
    public void disableLRMIMonitoring() throws RemoteException {
        this.esm.disableLRMIMonitoring();
    }

    @Override
    public LRMIMonitoringDetails fetchLRMIMonitoringDetails() throws RemoteException {
        return this.esm.fetchLRMIMonitoringDetails();
    }

    @Override
    public long getCurrentTimeInMillis() throws RemoteException {
        return this.esm.getCurrentTimestamp();
    }

    @Override
    public OSDetails getOSDetails() throws RemoteException {
        return this.esm.getOSDetails();
    }

    @Override
    public OSStatistics getOSStatistics() throws RemoteException {
        return this.esm.getOSStatistics();
    }

    @Override
    public JVMStatistics getJVMStatistics() throws RemoteException {
        return this.esm.getJVMStatistics();
    }

    @Override
    public void runGc() throws RemoteException {
        this.esm.runGc();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultElasticServiceManager that = (DefaultElasticServiceManager)o;
        return this.serviceID.equals((Object)that.serviceID);
    }

    public int hashCode() {
        return this.serviceID.hashCode();
    }

    @Override
    public void setProcessingUnitElasticProperties(ProcessingUnit pu, Map<String, String> properties) {
        try {
            this.esm.setProcessingUnitElasticProperties(pu.getName(), properties);
        }
        catch (RemoteException e) {
            throw new AdminException("Failed to set processing unit dynamic properties", e);
        }
    }

    @Override
    public void setProcessingUnitScaleStrategyConfig(ProcessingUnit pu, ScaleStrategyConfig scaleStrategyConfig) {
        try {
            this.esm.setProcessingUnitScaleStrategy(pu.getName(), scaleStrategyConfig);
        }
        catch (RemoteException e) {
            throw new AdminException("Failed to set processing unit dynamic properties", e);
        }
    }

    @Override
    public ScaleStrategyConfig getProcessingUnitScaleStrategyConfig(ProcessingUnit pu) {
        try {
            return this.esm.getProcessingUnitScaleStrategyConfig(pu.getName());
        }
        catch (RemoteException e) {
            throw new AdminException("Failed to set processing unit dynamic properties", e);
        }
    }

    @Override
    public boolean isManagingProcessingUnit(ProcessingUnit pu) {
        return this.esmScaleIsInProgressPerProcessingUnit.containsKey(pu.getName());
    }

    @Override
    public boolean isManagingProcessingUnitAndScaleNotInProgress(ProcessingUnit pu) {
        Boolean esmScaleIsInProgress = this.esmScaleIsInProgressPerProcessingUnit.get(pu.getName());
        return esmScaleIsInProgress != null && esmScaleIsInProgress == false;
    }

    @Override
    @Deprecated
    public boolean isManagingProcessingUnitAndScaleNotInProgressNoCache(ProcessingUnit pu) {
        try {
            return this.esm.isManagingProcessingUnitAndScaleNotInProgress(pu.getName());
        }
        catch (RemoteException e) {
            throw new AdminException("Failed to check if ESM has completed managing " + pu.getName(), e);
        }
    }

    @Override
    public boolean isManagingProcessingUnitAndScaleInProgress(ProcessingUnit pu) {
        Boolean esmScaleIsInProgress = this.esmScaleIsInProgressPerProcessingUnit.get(pu.getName());
        return esmScaleIsInProgress != null && esmScaleIsInProgress != false;
    }

    @Override
    public Events getScaleStrategyEvents(long cursor, int maxNumberOfEvents) {
        try {
            return this.esm.getScaleStrategyEvents(cursor, maxNumberOfEvents);
        }
        catch (RemoteException e) {
            throw new AdminException("Failed to determine if scale strategy is enforced", e);
        }
    }

    @Override
    public void processElasticScaleStrategyEvent(ElasticProcessingUnitEvent event) {
        if (event instanceof ElasticProcessingUnitScaleProgressChangedEvent) {
            ElasticProcessingUnitScaleProgressChangedEvent progressEvent = (ElasticProcessingUnitScaleProgressChangedEvent)event;
            String puName = progressEvent.getProcessingUnitName();
            if (progressEvent.isComplete()) {
                if (progressEvent.isUndeploying()) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)(puName + " is not managed by ESM since it has undeployed"));
                    }
                    this.esmScaleIsInProgressPerProcessingUnit.remove(puName);
                } else {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)(puName + " is managed by ESM and completed deployment (not in progress)"));
                    }
                    this.esmScaleIsInProgressPerProcessingUnit.put(puName, false);
                }
            } else {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)(puName + " is managed by ESM and deployment is in progress."));
                }
                this.esmScaleIsInProgressPerProcessingUnit.put(puName, true);
            }
        }
    }

    @Override
    public Remote getRemoteApi(String processingUnitName, String apiName) {
        try {
            return this.esm.getRemoteApi(processingUnitName, apiName);
        }
        catch (RemoteException e) {
            throw new AdminException("Failed to get storage Api for processing unit " + processingUnitName, e);
        }
    }

    @Override
    public void disableAgentFailureDetection(String processingUnitName, long timeout, TimeUnit timeunit) {
        try {
            this.esm.disableAgentFailureDetection(processingUnitName, timeout, timeunit);
        }
        catch (RemoteException e) {
            throw new AdminException("Failed to disable agent failure detection." + processingUnitName, e);
        }
    }

    @Override
    public void enableAgentFailureDetection(String processingUnitName) {
        try {
            this.esm.enableAgentFailureDetection(processingUnitName);
        }
        catch (RemoteException e) {
            throw new AdminException("Failed to enable agent failure detection." + processingUnitName, e);
        }
    }
}

