/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.admin.internal.esm;

import com.gigaspaces.internal.jvm.JVMDetails;
import com.j_spaces.kernel.SizeConcurrentHashMap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.openspaces.admin.Admin;
import org.openspaces.admin.AdminException;
import org.openspaces.admin.dump.CompoundDumpResult;
import org.openspaces.admin.dump.DumpResult;
import org.openspaces.admin.esm.ElasticServiceManager;
import org.openspaces.admin.esm.events.ElasticServiceManagerAddedEventListener;
import org.openspaces.admin.esm.events.ElasticServiceManagerAddedEventManager;
import org.openspaces.admin.esm.events.ElasticServiceManagerLifecycleEventListener;
import org.openspaces.admin.esm.events.ElasticServiceManagerRemovedEventListener;
import org.openspaces.admin.esm.events.ElasticServiceManagerRemovedEventManager;
import org.openspaces.admin.internal.admin.InternalAdmin;
import org.openspaces.admin.internal.esm.InternalElasticServiceManager;
import org.openspaces.admin.internal.esm.InternalElasticServiceManagers;
import org.openspaces.admin.internal.esm.events.DefaultElasticServiceManagerAddedEventManager;
import org.openspaces.admin.internal.esm.events.DefaultElasticServiceManagerRemovedEventManager;
import org.openspaces.admin.internal.esm.events.InternalElasticServiceManagerAddedEventManager;
import org.openspaces.admin.internal.esm.events.InternalElasticServiceManagerRemovedEventManager;
import org.openspaces.security.AdminFilterHelper;

public class DefaultElasticServiceManagers
implements InternalElasticServiceManagers {
    private final InternalAdmin admin;
    private final Map<String, ElasticServiceManager> elasticServiceManagersByUID = new SizeConcurrentHashMap();
    private final InternalElasticServiceManagerAddedEventManager elasticServiceManagerAddedEventManager;
    private final InternalElasticServiceManagerRemovedEventManager elasticServiceManagerRemovedEventManager;

    public DefaultElasticServiceManagers(InternalAdmin admin) {
        this.admin = admin;
        this.elasticServiceManagerAddedEventManager = new DefaultElasticServiceManagerAddedEventManager(this);
        this.elasticServiceManagerRemovedEventManager = new DefaultElasticServiceManagerRemovedEventManager(this);
    }

    @Override
    public Admin getAdmin() {
        return this.admin;
    }

    @Override
    public ElasticServiceManager getManagerByUID(String uid) {
        ElasticServiceManager elasticServiceManager = this.elasticServiceManagersByUID.get(uid);
        if (elasticServiceManager != null && !this.accept((InternalElasticServiceManager)elasticServiceManager)) {
            elasticServiceManager = null;
        }
        return elasticServiceManager;
    }

    @Override
    public ElasticServiceManager[] getManagers() {
        Collection<ElasticServiceManager> values = this.elasticServiceManagersByUID.values();
        LinkedList<ElasticServiceManager> filteredManagers = new LinkedList<ElasticServiceManager>();
        for (ElasticServiceManager esm : values) {
            if (!this.accept((InternalElasticServiceManager)esm)) continue;
            filteredManagers.add(esm);
        }
        return filteredManagers.toArray(new ElasticServiceManager[filteredManagers.size()]);
    }

    @Override
    public int getSize() {
        return this.getManagers().length;
    }

    @Override
    public Map<String, ElasticServiceManager> getUids() {
        Set<Map.Entry<String, ElasticServiceManager>> entrySet = this.elasticServiceManagersByUID.entrySet();
        HashMap<String, ElasticServiceManager> filteredManageresMap = new HashMap<String, ElasticServiceManager>();
        for (Map.Entry<String, ElasticServiceManager> entry : entrySet) {
            ElasticServiceManager esm = entry.getValue();
            if (!this.accept((InternalElasticServiceManager)esm)) continue;
            filteredManageresMap.put(entry.getKey(), esm);
        }
        return filteredManageresMap;
    }

    @Override
    public boolean isEmpty() {
        return this.getSize() == 0;
    }

    @Override
    public Iterator<ElasticServiceManager> iterator() {
        return Collections.unmodifiableCollection(this.getUids().values()).iterator();
    }

    @Override
    public ElasticServiceManagerAddedEventManager getElasticServiceManagerAdded() {
        return this.elasticServiceManagerAddedEventManager;
    }

    @Override
    public ElasticServiceManagerRemovedEventManager getElasticServiceManagerRemoved() {
        return this.elasticServiceManagerRemovedEventManager;
    }

    @Override
    public void addElasticServiceManager(InternalElasticServiceManager elasticServiceManager) {
        this.assertStateChangesPermitted();
        if (elasticServiceManager == null) {
            throw new IllegalArgumentException("elasticServiceManager cannot be null");
        }
        InternalElasticServiceManager existingESM = (InternalElasticServiceManager)this.elasticServiceManagersByUID.put(elasticServiceManager.getUid(), elasticServiceManager);
        if (existingESM == null && this.accept(elasticServiceManager)) {
            this.elasticServiceManagerAddedEventManager.elasticServiceManagerAdded(elasticServiceManager);
        }
    }

    @Override
    public InternalElasticServiceManager removeElasticServiceManager(String uid) {
        this.assertStateChangesPermitted();
        InternalElasticServiceManager existingESM = (InternalElasticServiceManager)this.elasticServiceManagersByUID.remove(uid);
        if (existingESM != null && this.accept(existingESM)) {
            this.elasticServiceManagerRemovedEventManager.elasticServiceManagerRemoved(existingESM);
        }
        return existingESM;
    }

    @Override
    public void addLifecycleListener(ElasticServiceManagerLifecycleEventListener eventListener) {
        this.getElasticServiceManagerAdded().add(eventListener);
        this.getElasticServiceManagerRemoved().add(eventListener);
    }

    @Override
    public void removeLifecycleListener(ElasticServiceManagerLifecycleEventListener eventListener) {
        this.getElasticServiceManagerAdded().remove(eventListener);
        this.getElasticServiceManagerRemoved().remove(eventListener);
    }

    @Override
    public boolean waitFor(int numberOfElasticServiceManagers) {
        return this.waitFor(numberOfElasticServiceManagers, this.admin.getDefaultTimeout(), this.admin.getDefaultTimeoutTimeUnit());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean waitFor(int numberOfElasticServiceManagers, long timeout, TimeUnit timeUnit) {
        if (numberOfElasticServiceManagers == 0) {
            final CountDownLatch latch = new CountDownLatch(this.getSize());
            ElasticServiceManagerRemovedEventListener removed = new ElasticServiceManagerRemovedEventListener(){

                @Override
                public void elasticServiceManagerRemoved(ElasticServiceManager elasticServiceManager) {
                    latch.countDown();
                }
            };
            this.getElasticServiceManagerRemoved().add(removed);
            try {
                boolean bl = latch.await(timeout, timeUnit);
                return bl;
            }
            catch (InterruptedException e) {
                boolean bl = false;
                return bl;
            }
            finally {
                this.getElasticServiceManagerRemoved().remove(removed);
            }
        }
        final CountDownLatch latch = new CountDownLatch(numberOfElasticServiceManagers);
        ElasticServiceManagerAddedEventListener added = new ElasticServiceManagerAddedEventListener(){

            @Override
            public void elasticServiceManagerAdded(ElasticServiceManager elasticServiceManager) {
                latch.countDown();
            }
        };
        this.getElasticServiceManagerAdded().add(added);
        try {
            boolean e = latch.await(timeout, timeUnit);
            return e;
        }
        catch (InterruptedException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            this.getElasticServiceManagerAdded().remove(added);
        }
    }

    @Override
    public ElasticServiceManager waitForAtLeastOne() {
        return this.waitForAtLeastOne(this.admin.getDefaultTimeout(), this.admin.getDefaultTimeoutTimeUnit());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ElasticServiceManager waitForAtLeastOne(long timeout, TimeUnit timeUnit) {
        final CountDownLatch latch = new CountDownLatch(1);
        final AtomicReference ref = new AtomicReference();
        ElasticServiceManagerAddedEventListener added = new ElasticServiceManagerAddedEventListener(){

            @Override
            public void elasticServiceManagerAdded(ElasticServiceManager elasticServiceManager) {
                ref.set(elasticServiceManager);
                latch.countDown();
            }
        };
        this.getElasticServiceManagerAdded().add(added);
        try {
            latch.await(timeout, timeUnit);
            ElasticServiceManager elasticServiceManager = (ElasticServiceManager)ref.get();
            return elasticServiceManager;
        }
        catch (InterruptedException e) {
            ElasticServiceManager elasticServiceManager = null;
            return elasticServiceManager;
        }
        finally {
            this.getElasticServiceManagerAdded().remove(added);
        }
    }

    @Override
    public DumpResult generateDump(String cause, Map<String, Object> context) throws AdminException {
        return this.generateDump(cause, context, null);
    }

    @Override
    public DumpResult generateDump(String cause, Map<String, Object> context, String ... processor) throws AdminException {
        CompoundDumpResult dumpResult = new CompoundDumpResult();
        for (ElasticServiceManager esm : this) {
            dumpResult.add(esm.generateDump(cause, context, processor));
        }
        return dumpResult;
    }

    protected void assertStateChangesPermitted() {
        this.admin.assertStateChangesPermitted();
    }

    @Override
    public ElasticServiceManager[] getManagersNonFiltered() {
        return this.elasticServiceManagersByUID.values().toArray(new ElasticServiceManager[0]);
    }

    private boolean accept(InternalElasticServiceManager elasticServiceManager) {
        if (elasticServiceManager == null) {
            throw new IllegalArgumentException("elasticServiceManager cannot be null");
        }
        JVMDetails jvmDetails = elasticServiceManager.getJVMDetails();
        boolean isAcceptJvm = AdminFilterHelper.acceptJvm(this.admin.getAdminFilter(), jvmDetails);
        return isAcceptJvm;
    }
}

