/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.admin.internal.esm.events;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.openspaces.admin.esm.ElasticServiceManager;
import org.openspaces.admin.esm.events.ElasticServiceManagerAddedEventListener;
import org.openspaces.admin.internal.admin.InternalAdmin;
import org.openspaces.admin.internal.esm.InternalElasticServiceManagers;
import org.openspaces.admin.internal.esm.events.ClosureElasticServiceManagerAddedEventListener;
import org.openspaces.admin.internal.esm.events.InternalElasticServiceManagerAddedEventManager;
import org.openspaces.admin.internal.support.GroovyHelper;

public class DefaultElasticServiceManagerAddedEventManager
implements InternalElasticServiceManagerAddedEventManager {
    private final InternalElasticServiceManagers elasticServiceManagers;
    private final InternalAdmin admin;
    private final List<ElasticServiceManagerAddedEventListener> listeners = new CopyOnWriteArrayList<ElasticServiceManagerAddedEventListener>();

    public DefaultElasticServiceManagerAddedEventManager(InternalElasticServiceManagers elasticServiceManagers) {
        this.elasticServiceManagers = elasticServiceManagers;
        this.admin = (InternalAdmin)elasticServiceManagers.getAdmin();
    }

    @Override
    public void elasticServiceManagerAdded(final ElasticServiceManager elasticServiceManager) {
        for (final ElasticServiceManagerAddedEventListener listener : this.listeners) {
            this.admin.pushEvent(listener, new Runnable(){

                @Override
                public void run() {
                    listener.elasticServiceManagerAdded(elasticServiceManager);
                }
            });
        }
    }

    @Override
    public void add(final ElasticServiceManagerAddedEventListener eventListener, boolean includeExisting) {
        if (includeExisting) {
            this.admin.raiseEvent(eventListener, new Runnable(){

                @Override
                public void run() {
                    for (ElasticServiceManager elasticServiceManager : DefaultElasticServiceManagerAddedEventManager.this.elasticServiceManagers) {
                        eventListener.elasticServiceManagerAdded(elasticServiceManager);
                    }
                }
            });
        }
        this.listeners.add(eventListener);
    }

    @Override
    public void add(ElasticServiceManagerAddedEventListener eventListener) {
        this.add(eventListener, true);
    }

    @Override
    public void remove(ElasticServiceManagerAddedEventListener eventListener) {
        this.listeners.remove(eventListener);
    }

    public void plus(Object eventListener) {
        if (GroovyHelper.isClosure(eventListener)) {
            this.add(new ClosureElasticServiceManagerAddedEventListener(eventListener));
        } else {
            this.add((ElasticServiceManagerAddedEventListener)eventListener);
        }
    }

    public void leftShift(Object eventListener) {
        this.plus(eventListener);
    }

    public void minus(Object eventListener) {
        if (GroovyHelper.isClosure(eventListener)) {
            this.remove(new ClosureElasticServiceManagerAddedEventListener(eventListener));
        } else {
            this.remove((ElasticServiceManagerAddedEventListener)eventListener);
        }
    }

    public void rightShift(Object eventListener) {
        this.minus(eventListener);
    }
}

