/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.admin.internal.esm.events;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.openspaces.admin.esm.ElasticServiceManager;
import org.openspaces.admin.esm.events.ElasticServiceManagerRemovedEventListener;
import org.openspaces.admin.internal.admin.InternalAdmin;
import org.openspaces.admin.internal.esm.InternalElasticServiceManagers;
import org.openspaces.admin.internal.esm.events.ClosureElasticServiceManagerRemovedEventListener;
import org.openspaces.admin.internal.esm.events.InternalElasticServiceManagerRemovedEventManager;
import org.openspaces.admin.internal.support.GroovyHelper;

public class DefaultElasticServiceManagerRemovedEventManager
implements InternalElasticServiceManagerRemovedEventManager {
    private final InternalElasticServiceManagers elasticServiceManagers;
    private final InternalAdmin admin;
    private final List<ElasticServiceManagerRemovedEventListener> listeners = new CopyOnWriteArrayList<ElasticServiceManagerRemovedEventListener>();

    public DefaultElasticServiceManagerRemovedEventManager(InternalElasticServiceManagers elasticServiceManagers) {
        this.elasticServiceManagers = elasticServiceManagers;
        this.admin = (InternalAdmin)elasticServiceManagers.getAdmin();
    }

    @Override
    public void elasticServiceManagerRemoved(final ElasticServiceManager elasticServiceManager) {
        for (final ElasticServiceManagerRemovedEventListener listener : this.listeners) {
            this.admin.pushEvent(listener, new Runnable(){

                @Override
                public void run() {
                    listener.elasticServiceManagerRemoved(elasticServiceManager);
                }
            });
        }
    }

    @Override
    public void add(ElasticServiceManagerRemovedEventListener eventListener) {
        this.listeners.add(eventListener);
    }

    @Override
    public void remove(ElasticServiceManagerRemovedEventListener eventListener) {
        this.listeners.remove(eventListener);
    }

    public void plus(Object eventListener) {
        if (GroovyHelper.isClosure(eventListener)) {
            this.add(new ClosureElasticServiceManagerRemovedEventListener(eventListener));
        } else {
            this.add((ElasticServiceManagerRemovedEventListener)eventListener);
        }
    }

    public void leftShift(Object eventListener) {
        this.plus(eventListener);
    }

    public void minus(Object eventListener) {
        if (GroovyHelper.isClosure(eventListener)) {
            this.remove(new ClosureElasticServiceManagerRemovedEventListener(eventListener));
        } else {
            this.remove((ElasticServiceManagerRemovedEventListener)eventListener);
        }
    }

    public void rightShift(Object eventListener) {
        this.minus(eventListener);
    }
}

