/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.admin.internal.gateway;

import com.gigaspaces.internal.utils.concurrent.ExchangeCountDownLatch;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.openspaces.admin.gateway.Gateway;
import org.openspaces.admin.gateway.GatewayDelegator;
import org.openspaces.admin.gateway.GatewayProcessingUnit;
import org.openspaces.admin.gateway.GatewaySink;
import org.openspaces.admin.gateway.GatewaySinkSource;
import org.openspaces.admin.internal.admin.InternalAdmin;
import org.openspaces.admin.pu.ProcessingUnit;
import org.openspaces.admin.pu.ProcessingUnitInstance;
import org.openspaces.admin.pu.events.ProcessingUnitInstanceAddedEventListener;
import org.openspaces.core.gateway.GatewayUtils;

public class DefaultGateway
implements Gateway {
    private final String gatewayName;
    private final InternalAdmin admin;

    public DefaultGateway(InternalAdmin admin, String gatewayName) {
        this.admin = admin;
        this.gatewayName = gatewayName;
    }

    @Override
    public Iterator<GatewayProcessingUnit> iterator() {
        return Arrays.asList(this.getGatewayProcessingUnits()).iterator();
    }

    @Override
    public GatewayProcessingUnit[] getGatewayProcessingUnits() {
        LinkedList<GatewayProcessingUnit> result = new LinkedList<GatewayProcessingUnit>();
        for (ProcessingUnit processingUnit : this.admin.getProcessingUnits()) {
            ProcessingUnitInstance puInstance = GatewayUtils.extractInstanceIfPuOfGateway(this.gatewayName, processingUnit);
            if (puInstance == null) continue;
            GatewayProcessingUnit gatewayProcessingUnit = this.admin.getGatewayProcessingUnits().getGatewayProcessingUnit(puInstance.getUid());
            if (gatewayProcessingUnit == null) {
                throw new IllegalStateException("GatewayProcessingUnit cannot be null");
            }
            result.add(gatewayProcessingUnit);
        }
        return result.toArray(new GatewayProcessingUnit[result.size()]);
    }

    @Override
    public String getName() {
        return this.gatewayName;
    }

    @Override
    public boolean waitFor(int numberOfGatewayProcessingUnits) {
        return this.waitFor(numberOfGatewayProcessingUnits, this.admin.getDefaultTimeout(), this.admin.getDefaultTimeoutTimeUnit());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean waitFor(int numberOfGatewayProcessingUnits, long timeout, TimeUnit timeUnit) {
        final CountDownLatch latch = new CountDownLatch(numberOfGatewayProcessingUnits);
        ProcessingUnitInstanceAddedEventListener added = new ProcessingUnitInstanceAddedEventListener(){
            private final Set<String> gatewayProcessingUnitNames = new HashSet<String>();

            @Override
            public void processingUnitInstanceAdded(ProcessingUnitInstance processingUnitInstance) {
                if (GatewayUtils.isPuInstanceOfGateway(DefaultGateway.this.gatewayName, processingUnitInstance) && this.gatewayProcessingUnitNames.add(processingUnitInstance.getProcessingUnit().getName())) {
                    latch.countDown();
                }
            }
        };
        this.admin.getProcessingUnits().getProcessingUnitInstanceAdded().add(added);
        try {
            boolean bl = latch.await(timeout, timeUnit);
            return bl;
        }
        catch (InterruptedException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            this.admin.getProcessingUnits().getProcessingUnitInstanceAdded().remove(added);
        }
    }

    @Override
    public GatewayProcessingUnit waitForGatewayProcessingUnit(String processingUnitName) {
        return this.waitForGatewayProcessingUnit(processingUnitName, this.admin.getDefaultTimeout(), this.admin.getDefaultTimeoutTimeUnit());
    }

    @Override
    public GatewayProcessingUnit waitForGatewayProcessingUnit(String processingUnitName, long timeout, TimeUnit timeUnit) {
        ProcessingUnit processingUnit = this.admin.getProcessingUnits().waitFor(processingUnitName, timeout, timeUnit);
        if (processingUnit.waitFor(1, timeout, timeUnit)) {
            if (GatewayUtils.isPuInstanceOfGateway(this.gatewayName, processingUnit.getInstances()[0])) {
                GatewayProcessingUnit gatewayProcessingUnit = this.admin.getGatewayProcessingUnits().getGatewayProcessingUnit(processingUnit.getInstances()[0].getUid());
                if (gatewayProcessingUnit == null) {
                    throw new IllegalStateException("GatewayProcessingUnit cannot be null");
                }
                return gatewayProcessingUnit;
            }
            throw new IllegalArgumentException("requested processing unit is not part of this gateway [" + processingUnitName + "]");
        }
        return null;
    }

    @Override
    public GatewayProcessingUnit getGatewayProcessingUnit(String processingUnitName) {
        ProcessingUnit processingUnit = this.admin.getProcessingUnits().getProcessingUnit(processingUnitName);
        ProcessingUnitInstance[] instances = processingUnit.getInstances();
        if (instances == null || instances.length == 0) {
            return null;
        }
        if (GatewayUtils.isPuInstanceOfGateway(this.gatewayName, instances[0])) {
            GatewayProcessingUnit gatewayProcessingUnit = this.admin.getGatewayProcessingUnits().getGatewayProcessingUnit(instances[0].getUid());
            if (gatewayProcessingUnit == null) {
                throw new IllegalStateException("GatewayProcessingUnit cannot be null");
            }
            return gatewayProcessingUnit;
        }
        throw new IllegalArgumentException("requested processing unit is not part of this gateway [" + processingUnitName + "]");
    }

    @Override
    public Map<String, GatewayProcessingUnit> getNames() {
        HashMap<String, GatewayProcessingUnit> names = new HashMap<String, GatewayProcessingUnit>();
        for (GatewayProcessingUnit gatewayProcessingUnit : this) {
            names.put(gatewayProcessingUnit.getProcessingUnit().getName(), gatewayProcessingUnit);
        }
        return names;
    }

    @Override
    public GatewaySink getSink(String sourceGatewayName) {
        for (GatewayProcessingUnit gatewayProcessingUnit : this) {
            GatewaySink sink = gatewayProcessingUnit.getSink();
            if (sink == null || !sink.containsSource(sourceGatewayName)) continue;
            return sink;
        }
        return null;
    }

    @Override
    public GatewaySink waitForSink(String sourceGatewayName) {
        return this.waitForSink(sourceGatewayName, this.admin.getDefaultTimeout(), this.admin.getDefaultTimeoutTimeUnit());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GatewaySink waitForSink(final String sourceGatewayName, long timeout, TimeUnit timeUnit) {
        final ExchangeCountDownLatch latch = new ExchangeCountDownLatch();
        ProcessingUnitInstanceAddedEventListener added = new ProcessingUnitInstanceAddedEventListener(){

            @Override
            public void processingUnitInstanceAdded(ProcessingUnitInstance processingUnitInstance) {
                if (GatewayUtils.isPuInstanceOfGateway(DefaultGateway.this.gatewayName, processingUnitInstance)) {
                    GatewayProcessingUnit tempPUI = DefaultGateway.this.admin.getGatewayProcessingUnits().getGatewayProcessingUnit(processingUnitInstance.getUid());
                    if (tempPUI == null) {
                        throw new IllegalStateException("GatewayProcessingUnit cannot be null");
                    }
                    GatewaySink sink = tempPUI.getSink();
                    if (sink != null && sink.containsSource(sourceGatewayName)) {
                        latch.countDown((Object)sink);
                    }
                }
            }
        };
        this.admin.getProcessingUnits().getProcessingUnitInstanceAdded().add(added);
        try {
            if (latch.await(timeout, timeUnit)) {
                GatewaySink gatewaySink = (GatewaySink)latch.get();
                return gatewaySink;
            }
            GatewaySink gatewaySink = null;
            return gatewaySink;
        }
        catch (InterruptedException e) {
            GatewaySink gatewaySink = null;
            return gatewaySink;
        }
        finally {
            this.admin.getProcessingUnits().getProcessingUnitInstanceAdded().remove(added);
        }
    }

    @Override
    public GatewaySinkSource getSinkSource(String sourceGatewayName) {
        GatewaySink sink = this.getSink(sourceGatewayName);
        if (sink != null) {
            return sink.getSourceByName(sourceGatewayName);
        }
        return null;
    }

    @Override
    public GatewaySinkSource waitForSinkSource(String sourceGatewayName) {
        return this.waitForSinkSource(sourceGatewayName, this.admin.getDefaultTimeout(), this.admin.getDefaultTimeoutTimeUnit());
    }

    @Override
    public GatewaySinkSource waitForSinkSource(String sourceGatewayName, long timeout, TimeUnit timeUnit) {
        GatewaySink sink = this.waitForSink(sourceGatewayName, timeout, timeUnit);
        if (sink != null) {
            return sink.getSourceByName(sourceGatewayName);
        }
        return null;
    }

    @Override
    public GatewayDelegator getDelegator(String targetGatewayName) {
        for (GatewayProcessingUnit gatewayProcessingUnit : this) {
            GatewayDelegator delegator = gatewayProcessingUnit.getDelegator();
            if (delegator == null || !delegator.containsTarget(targetGatewayName)) continue;
            return delegator;
        }
        return null;
    }

    @Override
    public GatewayDelegator waitForDelegator(String targetGatewayName) {
        return this.waitForDelegator(targetGatewayName, this.admin.getDefaultTimeout(), this.admin.getDefaultTimeoutTimeUnit());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GatewayDelegator waitForDelegator(final String targetGatewayName, long timeout, TimeUnit timeUnit) {
        final ExchangeCountDownLatch latch = new ExchangeCountDownLatch();
        ProcessingUnitInstanceAddedEventListener added = new ProcessingUnitInstanceAddedEventListener(){

            @Override
            public void processingUnitInstanceAdded(ProcessingUnitInstance processingUnitInstance) {
                if (GatewayUtils.isPuInstanceOfGateway(DefaultGateway.this.gatewayName, processingUnitInstance)) {
                    GatewayProcessingUnit tempPUI = DefaultGateway.this.admin.getGatewayProcessingUnits().getGatewayProcessingUnit(processingUnitInstance.getUid());
                    if (tempPUI == null) {
                        throw new IllegalStateException("GatewayProcessingUnit cannot be null");
                    }
                    GatewayDelegator delegator = tempPUI.getDelegator();
                    if (delegator != null && delegator.containsTarget(targetGatewayName)) {
                        latch.countDown((Object)delegator);
                    }
                }
            }
        };
        this.admin.getProcessingUnits().getProcessingUnitInstanceAdded().add(added);
        try {
            if (latch.await(timeout, timeUnit)) {
                GatewayDelegator gatewayDelegator = (GatewayDelegator)latch.get();
                return gatewayDelegator;
            }
            GatewayDelegator gatewayDelegator = null;
            return gatewayDelegator;
        }
        catch (InterruptedException e) {
            GatewayDelegator gatewayDelegator = null;
            return gatewayDelegator;
        }
        finally {
            this.admin.getProcessingUnits().getProcessingUnitInstanceAdded().remove(added);
        }
    }

    @Override
    public int getSize() {
        return this.getGatewayProcessingUnits().length;
    }

    @Override
    public boolean isEmpty() {
        return this.getSize() == 0;
    }
}

