/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.admin.internal.gateway;

import com.gigaspaces.internal.utils.StringUtils;
import org.openspaces.admin.gateway.GatewayDelegator;
import org.openspaces.admin.gateway.GatewayDelegatorTarget;
import org.openspaces.admin.gateway.GatewayProcessingUnit;
import org.openspaces.admin.internal.gateway.DefaultGatewayProcessingUnit;
import org.openspaces.core.gateway.GatewayDelegation;
import org.openspaces.core.gateway.GatewayDelegatorServiceDetails;

public class DefaultGatewayDelegator
implements GatewayDelegator {
    private final DefaultGatewayProcessingUnit gatewayProcessingUnit;
    private final GatewayDelegatorServiceDetails serviceDetails;

    public DefaultGatewayDelegator(DefaultGatewayProcessingUnit gatewayProcessingUnit, GatewayDelegatorServiceDetails serviceDetails) {
        this.gatewayProcessingUnit = gatewayProcessingUnit;
        this.serviceDetails = serviceDetails;
    }

    @Override
    public GatewayProcessingUnit getGatewayProcessingUnit() {
        return this.gatewayProcessingUnit;
    }

    @Override
    public GatewayDelegatorTarget[] getDelegationTargets() {
        GatewayDelegation[] delegationTargets = this.serviceDetails.getDelegationTargets();
        GatewayDelegatorTarget[] result = new DefaultGatewayDelegatorTarget[delegationTargets.length];
        for (int i = 0; i < result.length; ++i) {
            GatewayDelegation gatewayDelegation = delegationTargets[i];
            result[i] = new DefaultGatewayDelegatorTarget(gatewayDelegation.getTarget(), gatewayDelegation.getDelegateThrough());
        }
        return result;
    }

    @Override
    public boolean containsTarget(String targetGatewayName) {
        GatewayDelegation[] delegationTargets;
        for (GatewayDelegation gatewayDelegation : delegationTargets = this.serviceDetails.getDelegationTargets()) {
            if (!gatewayDelegation.getTarget().equals(targetGatewayName)) continue;
            return true;
        }
        return false;
    }

    public class DefaultGatewayDelegatorTarget
    implements GatewayDelegatorTarget {
        private final String target;
        private final String delegateThrough;

        public DefaultGatewayDelegatorTarget(String target, String delegateThrough) {
            this.target = target;
            this.delegateThrough = delegateThrough;
        }

        @Override
        public GatewayDelegator getDelegator() {
            return DefaultGatewayDelegator.this;
        }

        @Override
        public String getTargetGatewayName() {
            return this.target;
        }

        @Override
        public boolean isDelegateThroughOtherGateway() {
            return StringUtils.hasText((String)this.getDelegateThroughGatewayName());
        }

        @Override
        public String getDelegateThroughGatewayName() {
            return this.delegateThrough;
        }
    }
}

