/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.admin.internal.gateway;

import java.util.Map;
import org.openspaces.admin.Admin;
import org.openspaces.admin.gateway.Gateway;
import org.openspaces.admin.gateway.GatewayDelegator;
import org.openspaces.admin.gateway.GatewayProcessingUnit;
import org.openspaces.admin.gateway.GatewaySink;
import org.openspaces.admin.internal.admin.InternalAdmin;
import org.openspaces.admin.internal.gateway.DefaultGatewayDelegator;
import org.openspaces.admin.internal.gateway.DefaultGatewaySink;
import org.openspaces.admin.machine.Machine;
import org.openspaces.admin.os.OperatingSystem;
import org.openspaces.admin.pu.ProcessingUnit;
import org.openspaces.admin.pu.ProcessingUnitInstance;
import org.openspaces.admin.transport.Transport;
import org.openspaces.admin.vm.VirtualMachine;
import org.openspaces.admin.zone.Zone;
import org.openspaces.core.gateway.GatewayDelegatorServiceDetails;
import org.openspaces.core.gateway.GatewayServiceDetails;
import org.openspaces.core.gateway.GatewaySinkServiceDetails;
import org.openspaces.pu.service.ServiceDetails;

public class DefaultGatewayProcessingUnit
implements GatewayProcessingUnit {
    private final Gateway gateway;
    private final ProcessingUnitInstance processingUnitInstance;
    private final InternalAdmin admin;
    private final GatewayServiceDetails gatewayServiceDetails;

    public DefaultGatewayProcessingUnit(InternalAdmin admin, Gateway gateway, ProcessingUnitInstance processingUnitInstance, GatewayServiceDetails gatewayServiceDetails) {
        this.admin = admin;
        this.gateway = gateway;
        this.processingUnitInstance = processingUnitInstance;
        this.gatewayServiceDetails = gatewayServiceDetails;
    }

    public ProcessingUnitInstance getProcessingUnitInstance() {
        return this.processingUnitInstance;
    }

    @Override
    public String getUid() {
        return this.processingUnitInstance.getUid();
    }

    @Override
    public boolean isDiscovered() {
        return this.processingUnitInstance.isDiscovered();
    }

    @Override
    public Admin getAdmin() {
        return this.admin;
    }

    @Override
    public Machine getMachine() {
        return this.processingUnitInstance.getMachine();
    }

    @Override
    public Transport getTransport() {
        return this.processingUnitInstance.getTransport();
    }

    @Override
    public OperatingSystem getOperatingSystem() {
        return this.processingUnitInstance.getOperatingSystem();
    }

    @Override
    public VirtualMachine getVirtualMachine() {
        return this.processingUnitInstance.getVirtualMachine();
    }

    @Override
    public Map<String, Zone> getZones() {
        return this.processingUnitInstance.getZones();
    }

    @Override
    public Gateway getGateway() {
        return this.gateway;
    }

    @Override
    public ProcessingUnit getProcessingUnit() {
        return this.processingUnitInstance.getProcessingUnit();
    }

    @Override
    public GatewaySink getSink() {
        ServiceDetails[] servicesDetailsByServiceType;
        for (ServiceDetails serviceDetails : servicesDetailsByServiceType = this.processingUnitInstance.getServicesDetailsByServiceType("gateway")) {
            if (!(serviceDetails instanceof GatewaySinkServiceDetails)) continue;
            return new DefaultGatewaySink(this, (GatewaySinkServiceDetails)serviceDetails);
        }
        return null;
    }

    @Override
    public GatewayDelegator getDelegator() {
        ServiceDetails[] servicesDetailsByServiceType;
        for (ServiceDetails serviceDetails : servicesDetailsByServiceType = this.processingUnitInstance.getServicesDetailsByServiceType("gateway")) {
            if (!(serviceDetails instanceof GatewayDelegatorServiceDetails)) continue;
            return new DefaultGatewayDelegator(this, (GatewayDelegatorServiceDetails)serviceDetails);
        }
        return null;
    }

    @Override
    public int getCommunicationPort() {
        return this.gatewayServiceDetails.getCommunicationPort();
    }

    @Override
    public int getDiscoveryPort() {
        return this.gatewayServiceDetails.getDiscoveryPort();
    }

    @Override
    public boolean isStartEmbeddedLus() {
        return this.gatewayServiceDetails.isStartEmbeddedLus();
    }
}

