/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.admin.internal.gateway;

import com.j_spaces.kernel.SizeConcurrentHashMap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.openspaces.admin.Admin;
import org.openspaces.admin.gateway.GatewayProcessingUnit;
import org.openspaces.admin.gateway.events.DefaultGatewayProcessingUnitAddedEventManager;
import org.openspaces.admin.gateway.events.DefaultGatewayProcessingUnitRemovedEventManager;
import org.openspaces.admin.gateway.events.GatewayProcessingUnitAddedEventListener;
import org.openspaces.admin.gateway.events.GatewayProcessingUnitAddedEventManager;
import org.openspaces.admin.gateway.events.GatewayProcessingUnitLifecycleEventListener;
import org.openspaces.admin.gateway.events.GatewayProcessingUnitRemovedEventManager;
import org.openspaces.admin.gateway.events.InternalGatewayProcessingUnitAddedEventManager;
import org.openspaces.admin.gateway.events.InternalGatewayProcessingUnitRemovedEventManager;
import org.openspaces.admin.internal.admin.DefaultAdmin;
import org.openspaces.admin.internal.admin.InternalAdmin;
import org.openspaces.admin.internal.gateway.InternalGatewayProcessingUnits;
import org.openspaces.admin.pu.ProcessingUnit;

public class DefaultGatewayProcessingUnits
implements InternalGatewayProcessingUnits {
    private final InternalAdmin admin;
    private final Map<String, GatewayProcessingUnit> gatewayProcessingUnits = new SizeConcurrentHashMap();
    private final InternalGatewayProcessingUnitAddedEventManager gatewayProcessingUnitAddedEventManager;
    private final InternalGatewayProcessingUnitRemovedEventManager gatewayProcessingUnitRemovedEventManager;

    public DefaultGatewayProcessingUnits(DefaultAdmin admin) {
        this.admin = admin;
        this.gatewayProcessingUnitAddedEventManager = new DefaultGatewayProcessingUnitAddedEventManager(this);
        this.gatewayProcessingUnitRemovedEventManager = new DefaultGatewayProcessingUnitRemovedEventManager(this);
    }

    @Override
    public void addGatewayProcessingUnit(GatewayProcessingUnit gatewayProcessingUnit) {
        this.assertStateChangesPermitted();
        String uid = gatewayProcessingUnit.getUid();
        GatewayProcessingUnit existingGatewayProcessingUnit = this.gatewayProcessingUnits.put(uid, gatewayProcessingUnit);
        if (existingGatewayProcessingUnit == null) {
            this.gatewayProcessingUnitAddedEventManager.gatewayProcessingUnitAdded(gatewayProcessingUnit);
        }
    }

    @Override
    public GatewayProcessingUnit removeGatewayProcessingUnit(String uid) {
        this.assertStateChangesPermitted();
        GatewayProcessingUnit existingGatewayProcessingUnit = this.gatewayProcessingUnits.remove(uid);
        if (existingGatewayProcessingUnit != null) {
            this.gatewayProcessingUnitRemovedEventManager.gatewayProcessingUnitRemoved(existingGatewayProcessingUnit);
        }
        return existingGatewayProcessingUnit;
    }

    private void assertStateChangesPermitted() {
        this.admin.assertStateChangesPermitted();
    }

    @Override
    public Admin getAdmin() {
        return this.admin;
    }

    @Override
    public int getSize() {
        return this.getGatewayProcessingUnits().length;
    }

    @Override
    public boolean isEmpty() {
        return this.getSize() == 0;
    }

    @Override
    public GatewayProcessingUnit[] getGatewayProcessingUnits() {
        return this.gatewayProcessingUnits.values().toArray(new GatewayProcessingUnit[this.gatewayProcessingUnits.size()]);
    }

    @Override
    public GatewayProcessingUnit getGatewayProcessingUnit(String uid) {
        return this.gatewayProcessingUnits.get(uid);
    }

    @Override
    public GatewayProcessingUnitAddedEventManager getGatewayProcessingUnitAdded() {
        return this.gatewayProcessingUnitAddedEventManager;
    }

    @Override
    public GatewayProcessingUnitRemovedEventManager getGatewayProcessingUnitRemoved() {
        return this.gatewayProcessingUnitRemovedEventManager;
    }

    @Override
    public void addLifecycleListener(GatewayProcessingUnitLifecycleEventListener eventListener) {
        this.getGatewayProcessingUnitAdded().add(eventListener);
        this.getGatewayProcessingUnitRemoved().add(eventListener);
    }

    @Override
    public void removeLifecycleListener(GatewayProcessingUnitLifecycleEventListener eventListener) {
        this.getGatewayProcessingUnitAdded().remove(eventListener);
        this.getGatewayProcessingUnitRemoved().remove(eventListener);
    }

    @Override
    public Iterator<GatewayProcessingUnit> iterator() {
        return Collections.unmodifiableCollection(this.gatewayProcessingUnits.values()).iterator();
    }

    @Override
    public Map<String, GatewayProcessingUnit> getNames() {
        Collection<GatewayProcessingUnit> values = this.gatewayProcessingUnits.values();
        HashMap<String, GatewayProcessingUnit> resultMap = new HashMap<String, GatewayProcessingUnit>();
        for (GatewayProcessingUnit gatewayProcessingUnit : values) {
            resultMap.put(this.retrieveGatewayProcessingUnitName(gatewayProcessingUnit), gatewayProcessingUnit);
        }
        return resultMap;
    }

    @Override
    public GatewayProcessingUnit waitFor(String gatewayProcessingUnitName) {
        return this.waitFor(gatewayProcessingUnitName, this.admin.getDefaultTimeout(), this.admin.getDefaultTimeoutTimeUnit());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GatewayProcessingUnit waitFor(final String gatewaysProcessingUnitName, long timeout, TimeUnit timeUnit) {
        final CountDownLatch latch = new CountDownLatch(1);
        final AtomicReference ref = new AtomicReference();
        GatewayProcessingUnitAddedEventListener added = new GatewayProcessingUnitAddedEventListener(){

            @Override
            public void gatewayProcessingUnitAdded(GatewayProcessingUnit gatewayProcessingUnit) {
                String name = DefaultGatewayProcessingUnits.this.retrieveGatewayProcessingUnitName(gatewayProcessingUnit);
                if (gatewaysProcessingUnitName.equals(name)) {
                    ref.set(gatewayProcessingUnit);
                    latch.countDown();
                }
            }
        };
        this.getGatewayProcessingUnitAdded().add(added);
        try {
            latch.await(timeout, timeUnit);
            GatewayProcessingUnit gatewayProcessingUnit = (GatewayProcessingUnit)ref.get();
            return gatewayProcessingUnit;
        }
        catch (InterruptedException e) {
            GatewayProcessingUnit gatewayProcessingUnit = null;
            return gatewayProcessingUnit;
        }
        finally {
            this.getGatewayProcessingUnitAdded().remove(added);
        }
    }

    private String retrieveGatewayProcessingUnitName(GatewayProcessingUnit gatewayProcessingUnit) {
        ProcessingUnit processingUnit = gatewayProcessingUnit.getProcessingUnit();
        return processingUnit.getName();
    }
}

