/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.admin.internal.gateway;

import java.util.Arrays;
import java.util.HashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.openspaces.admin.AdminException;
import org.openspaces.admin.gateway.BootstrapResult;
import org.openspaces.admin.gateway.GatewayProcessingUnit;
import org.openspaces.admin.gateway.GatewaySink;
import org.openspaces.admin.gateway.GatewaySinkSource;
import org.openspaces.admin.internal.admin.InternalAdmin;
import org.openspaces.admin.internal.gateway.DefaultGatewayProcessingUnit;
import org.openspaces.admin.internal.pu.InternalProcessingUnitInstance;
import org.openspaces.core.gateway.GatewaySinkServiceDetails;

public class DefaultGatewaySink
implements GatewaySink {
    private final DefaultGatewayProcessingUnit gatewayProcessingUnit;
    private final GatewaySinkServiceDetails sinkServiceDetails;

    public DefaultGatewaySink(DefaultGatewayProcessingUnit gatewayProcessingUnit, GatewaySinkServiceDetails sinkServiceDetails) {
        this.gatewayProcessingUnit = gatewayProcessingUnit;
        this.sinkServiceDetails = sinkServiceDetails;
    }

    @Override
    public GatewayProcessingUnit getGatewayProcessingUnit() {
        return this.gatewayProcessingUnit;
    }

    @Override
    public void enableIncomingReplication() {
        HashMap<String, Object> namedArgs = new HashMap<String, Object>();
        namedArgs.put("enableIncomingReplication", "");
        try {
            ((InternalProcessingUnitInstance)this.gatewayProcessingUnit.getProcessingUnitInstance()).invoke("sink", namedArgs).get();
        }
        catch (InterruptedException e) {
            throw new AdminException("Failed to enable incoming replication of sink", e);
        }
        catch (ExecutionException e) {
            throw new AdminException("Failed to enable incoming replication of sink", e);
        }
    }

    @Override
    public GatewaySinkSource[] getSources() {
        String[] gatewaySourceNames = this.sinkServiceDetails.getGatewaySourceNames();
        GatewaySinkSource[] sources = new GatewaySinkSource[gatewaySourceNames.length];
        for (int i = 0; i < sources.length; ++i) {
            sources[i] = new DefaultGatewaySinkSource(gatewaySourceNames[i]);
        }
        return sources;
    }

    @Override
    public boolean containsSource(String sourceGatewayName) {
        String[] gatewaySourceNames = this.sinkServiceDetails.getGatewaySourceNames();
        return Arrays.asList(gatewaySourceNames).contains(sourceGatewayName);
    }

    @Override
    public GatewaySinkSource getSourceByName(String sourceGatewayName) {
        if (!this.containsSource(sourceGatewayName)) {
            return null;
        }
        return new DefaultGatewaySinkSource(sourceGatewayName);
    }

    @Override
    public boolean requiresBootstrapOnStartup() {
        return this.sinkServiceDetails.requiresBootstrap();
    }

    @Override
    public String getLocalSpaceUrl() {
        return this.sinkServiceDetails.getLocalSpaceUrl();
    }

    public class DefaultGatewaySinkSource
    implements GatewaySinkSource {
        private final String sourceGatewayName;

        public DefaultGatewaySinkSource(String sourceGatewayName) {
            this.sourceGatewayName = sourceGatewayName;
        }

        @Override
        public GatewaySink getSink() {
            return DefaultGatewaySink.this;
        }

        @Override
        public String getSourceGatewayName() {
            return this.sourceGatewayName;
        }

        @Override
        public BootstrapResult bootstrapFromGatewayAndWait() {
            return this.bootstrapFromGatewayAndWait(((InternalAdmin)DefaultGatewaySink.this.gatewayProcessingUnit.getAdmin()).getDefaultTimeout(), ((InternalAdmin)DefaultGatewaySink.this.gatewayProcessingUnit.getAdmin()).getDefaultTimeoutTimeUnit());
        }

        @Override
        public BootstrapResult bootstrapFromGatewayAndWait(long timeout, TimeUnit timeUnit) {
            HashMap<String, Object> namedArgs = new HashMap<String, Object>();
            namedArgs.put("bootstrapFromGateway", this.sourceGatewayName);
            namedArgs.put("bootstrapTimeout", timeUnit.toMillis(timeout));
            Future<Object> future = ((InternalProcessingUnitInstance)DefaultGatewaySink.this.gatewayProcessingUnit.getProcessingUnitInstance()).invoke("sink", namedArgs);
            try {
                future.get(timeout, timeUnit);
                return new BootstrapResult(){

                    @Override
                    public boolean isSucceeded() {
                        return true;
                    }

                    @Override
                    public Throwable getFailureCause() {
                        return null;
                    }
                };
            }
            catch (InterruptedException e) {
                return new BootstrapResult(){

                    @Override
                    public boolean isSucceeded() {
                        return false;
                    }

                    @Override
                    public Throwable getFailureCause() {
                        return e;
                    }
                };
            }
            catch (ExecutionException e) {
                return new BootstrapResult(){

                    @Override
                    public boolean isSucceeded() {
                        return false;
                    }

                    @Override
                    public Throwable getFailureCause() {
                        return e.getCause();
                    }
                };
            }
            catch (TimeoutException e) {
                return new BootstrapResult(){

                    @Override
                    public boolean isSucceeded() {
                        return false;
                    }

                    @Override
                    public Throwable getFailureCause() {
                        return e;
                    }
                };
            }
        }
    }
}

