/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.admin.internal.gateway;

import com.j_spaces.kernel.SizeConcurrentHashMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.openspaces.admin.Admin;
import org.openspaces.admin.gateway.Gateway;
import org.openspaces.admin.gateway.InternalGateways;
import org.openspaces.admin.gateway.events.DefaultGatewayAddedEventManager;
import org.openspaces.admin.gateway.events.DefaultGatewayRemovedEventManager;
import org.openspaces.admin.gateway.events.GatewayAddedEventListener;
import org.openspaces.admin.gateway.events.GatewayAddedEventManager;
import org.openspaces.admin.gateway.events.GatewayLifecycleEventListener;
import org.openspaces.admin.gateway.events.GatewayRemovedEventManager;
import org.openspaces.admin.gateway.events.InternalGatewayAddedEventManager;
import org.openspaces.admin.gateway.events.InternalGatewayRemovedEventManager;
import org.openspaces.admin.internal.admin.DefaultAdmin;

public class DefaultGateways
implements InternalGateways {
    private final DefaultAdmin admin;
    private final Map<String, Gateway> gateways = new SizeConcurrentHashMap();
    private final InternalGatewayAddedEventManager gatewayAddedEventManager;
    private final InternalGatewayRemovedEventManager gatewayRemovedEventManager;

    public DefaultGateways(DefaultAdmin admin) {
        this.admin = admin;
        this.gatewayAddedEventManager = new DefaultGatewayAddedEventManager(this);
        this.gatewayRemovedEventManager = new DefaultGatewayRemovedEventManager(this);
    }

    @Override
    public Admin getAdmin() {
        return this.admin;
    }

    @Override
    public Iterator<Gateway> iterator() {
        return Arrays.asList(this.getGateways()).iterator();
    }

    @Override
    public Gateway[] getGateways() {
        return this.gateways.values().toArray(new Gateway[this.gateways.size()]);
    }

    @Override
    public Gateway getGateway(String gatewayName) {
        return this.gateways.get(gatewayName);
    }

    @Override
    public Map<String, Gateway> getNames() {
        return Collections.unmodifiableMap(this.gateways);
    }

    @Override
    public Gateway waitFor(String gatewayName) {
        return this.waitFor(gatewayName, this.admin.getDefaultTimeout(), this.admin.getDefaultTimeoutTimeUnit());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Gateway waitFor(final String gatewayName, long timeout, TimeUnit timeUnit) {
        final CountDownLatch latch = new CountDownLatch(1);
        final AtomicReference ref = new AtomicReference();
        GatewayAddedEventListener added = new GatewayAddedEventListener(){

            @Override
            public void gatewayAdded(Gateway gateway) {
                if (gatewayName.equals(gateway.getName())) {
                    ref.set(gateway);
                    latch.countDown();
                }
            }
        };
        this.getGatewayAdded().add(added);
        try {
            latch.await(timeout, timeUnit);
            Gateway gateway = (Gateway)ref.get();
            return gateway;
        }
        catch (InterruptedException e) {
            Gateway gateway = null;
            return gateway;
        }
        finally {
            this.getGatewayAdded().remove(added);
        }
    }

    @Override
    public int getSize() {
        return this.gateways.size();
    }

    @Override
    public boolean isEmpty() {
        return this.gateways.isEmpty();
    }

    @Override
    public GatewayAddedEventManager getGatewayAdded() {
        return this.gatewayAddedEventManager;
    }

    @Override
    public GatewayRemovedEventManager getGatewayRemoved() {
        return this.gatewayRemovedEventManager;
    }

    @Override
    public void addLifecycleListener(GatewayLifecycleEventListener eventListener) {
        this.getGatewayAdded().add(eventListener);
        this.getGatewayRemoved().add(eventListener);
    }

    @Override
    public void removeLifecycleListener(GatewayLifecycleEventListener eventListener) {
        this.getGatewayAdded().remove(eventListener);
        this.getGatewayRemoved().remove(eventListener);
    }

    @Override
    public void addGateway(Gateway gateway) {
        this.assertStateChangesPermitted();
        String name = gateway.getName();
        Gateway existingGateway = this.gateways.put(name, gateway);
        if (existingGateway == null) {
            this.gatewayAddedEventManager.gatewayAdded(gateway);
        }
    }

    @Override
    public Gateway removeGateway(String name) {
        this.assertStateChangesPermitted();
        Gateway existingGateway = this.gateways.remove(name);
        if (existingGateway != null) {
            this.gatewayRemovedEventManager.gatewayRemoved(existingGateway);
        }
        return existingGateway;
    }

    private void assertStateChangesPermitted() {
        this.admin.assertStateChangesPermitted();
    }
}

