/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.admin.internal.gsa;

import com.gigaspaces.grid.gsa.AgentProcessDetails;
import com.gigaspaces.grid.gsa.AgentProcessesDetails;
import com.gigaspaces.grid.gsa.GSA;
import com.gigaspaces.internal.dump.InternalDumpProvider;
import com.gigaspaces.internal.jvm.JVMDetails;
import com.gigaspaces.internal.jvm.JVMStatistics;
import com.gigaspaces.internal.os.OSDetails;
import com.gigaspaces.internal.os.OSStatistics;
import com.gigaspaces.log.CompoundLogEntries;
import com.gigaspaces.log.LogEntries;
import com.gigaspaces.log.LogEntryMatcher;
import com.gigaspaces.log.LogProcessType;
import com.gigaspaces.lrmi.LRMIMonitoringDetails;
import com.gigaspaces.lrmi.nio.info.NIODetails;
import com.gigaspaces.lrmi.nio.info.NIOStatistics;
import com.gigaspaces.security.SecurityException;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import net.jini.core.lookup.ServiceID;
import org.openspaces.admin.AdminException;
import org.openspaces.admin.dump.DumpResult;
import org.openspaces.admin.esm.ElasticServiceManager;
import org.openspaces.admin.esm.ElasticServiceManagers;
import org.openspaces.admin.esm.events.ElasticServiceManagerAddedEventListener;
import org.openspaces.admin.gsa.ElasticServiceManagerOptions;
import org.openspaces.admin.gsa.GSAReservationId;
import org.openspaces.admin.gsa.GridServiceContainerOptions;
import org.openspaces.admin.gsa.GridServiceManagerOptions;
import org.openspaces.admin.gsa.GridServiceOptions;
import org.openspaces.admin.gsa.LookupServiceOptions;
import org.openspaces.admin.gsc.GridServiceContainer;
import org.openspaces.admin.gsc.GridServiceContainers;
import org.openspaces.admin.gsc.events.GridServiceContainerAddedEventListener;
import org.openspaces.admin.gsm.GridServiceManager;
import org.openspaces.admin.gsm.GridServiceManagers;
import org.openspaces.admin.gsm.events.GridServiceManagerAddedEventListener;
import org.openspaces.admin.internal.admin.InternalAdmin;
import org.openspaces.admin.internal.dump.InternalDumpResult;
import org.openspaces.admin.internal.esm.DefaultElasticServiceManagers;
import org.openspaces.admin.internal.esm.InternalElasticServiceManager;
import org.openspaces.admin.internal.esm.InternalElasticServiceManagers;
import org.openspaces.admin.internal.gsa.InternalGridServiceAgent;
import org.openspaces.admin.internal.gsc.DefaultGridServiceContainers;
import org.openspaces.admin.internal.gsc.InternalGridServiceContainer;
import org.openspaces.admin.internal.gsc.InternalGridServiceContainers;
import org.openspaces.admin.internal.gsm.DefaultGridServiceManagers;
import org.openspaces.admin.internal.gsm.InternalGridServiceManager;
import org.openspaces.admin.internal.gsm.InternalGridServiceManagers;
import org.openspaces.admin.internal.lus.DefaultLookupServices;
import org.openspaces.admin.internal.lus.InternalLookupService;
import org.openspaces.admin.internal.lus.InternalLookupServices;
import org.openspaces.admin.internal.pu.elastic.GridServiceContainerConfig;
import org.openspaces.admin.internal.support.AbstractGridComponent;
import org.openspaces.admin.internal.support.InternalAgentGridComponent;
import org.openspaces.admin.internal.support.NetworkExceptionHelper;
import org.openspaces.admin.lus.LookupService;
import org.openspaces.admin.lus.LookupServices;
import org.openspaces.admin.lus.events.LookupServiceAddedEventListener;
import org.openspaces.admin.zone.config.ExactZonesConfig;
import org.openspaces.admin.zone.config.ExactZonesConfigurer;

public class DefaultGridServiceAgent
extends AbstractGridComponent
implements InternalGridServiceAgent {
    private final ServiceID serviceID;
    private final GSA gsa;
    private volatile AgentProcessesDetails processesDetails;
    private ConcurrentHashMap<Integer, InternalAgentGridComponent> removedAgentGridComponents = new ConcurrentHashMap();
    private final InternalGridServiceContainers gridServiceContainers;
    private final InternalGridServiceManagers gridServiceManagers;
    private final InternalLookupServices lookupServices;
    private final InternalElasticServiceManagers elasticServiceManagers;
    private static final String RESERVATION_PROPERTY = "com.gs.agent.reservationid";

    public DefaultGridServiceAgent(ServiceID serviceID, GSA gsa, InternalAdmin admin, AgentProcessesDetails processesDetails, JVMDetails jvmDetails) {
        super(admin, jvmDetails);
        this.serviceID = serviceID;
        this.gsa = gsa;
        this.processesDetails = processesDetails;
        this.gridServiceContainers = new DefaultGridServiceContainers(admin);
        this.gridServiceManagers = new DefaultGridServiceManagers(admin);
        this.lookupServices = new DefaultLookupServices(admin);
        this.elasticServiceManagers = new DefaultElasticServiceManagers(admin);
    }

    @Override
    public String getUid() {
        return this.serviceID.toString();
    }

    @Override
    public AgentProcessesDetails getProcessesDetails() {
        return this.processesDetails;
    }

    @Override
    public void setProcessesDetails(AgentProcessesDetails processesDetails) {
        this.assertStateChangesPermitted();
        this.processesDetails = processesDetails;
        HashMap<Integer, AgentProcessDetails> agentIds = new HashMap<Integer, AgentProcessDetails>();
        for (AgentProcessDetails p : processesDetails.getProcessDetails()) {
            agentIds.put(p.getAgentId(), p);
        }
        HashSet<InternalAgentGridComponent> confirmedRemovedProcesses = new HashSet<InternalAgentGridComponent>();
        for (InternalAgentGridComponent c : this.removedAgentGridComponents.values()) {
            AgentProcessDetails pdetails = (AgentProcessDetails)agentIds.get(c.getAgentId());
            if (pdetails != null && pdetails.getProcessId() == c.getVirtualMachine().getDetails().getPid()) continue;
            confirmedRemovedProcesses.add(c);
        }
        for (InternalAgentGridComponent confirmedRemovedProcess : confirmedRemovedProcesses) {
            this.removedAgentGridComponents.remove(confirmedRemovedProcess.getAgentId());
        }
    }

    @Override
    public ServiceID getServiceID() {
        return this.serviceID;
    }

    @Override
    public GSA getGSA() {
        return this.gsa;
    }

    @Override
    public int startGridService(GridServiceOptions options) {
        try {
            return this.gsa.startProcess(options.getOptions());
        }
        catch (SecurityException se) {
            throw new AdminException("No privileges to start a service", se);
        }
        catch (IOException e) {
            throw new AdminException("Failed to start Grid Service", e);
        }
    }

    @Override
    public void killByAgentId(int agentId) {
        try {
            this.gsa.killProcess(agentId);
        }
        catch (SecurityException se) {
            throw new AdminException("No privileges to kill a service", se);
        }
        catch (IOException e) {
            throw new AdminException("Failed to kill agent", e);
        }
    }

    @Override
    public void startGridService(GridServiceManagerOptions options) {
        this.internalStartGridService(options);
    }

    @Override
    public LogEntries logEntries(LogProcessType type, long pid, LogEntryMatcher matcher) {
        try {
            return this.gsa.logEntries(type, pid, matcher);
        }
        catch (IOException e) {
            throw new AdminException("Failed to retrieve logs", e);
        }
    }

    @Override
    public DumpResult generateDump(String cause, Map<String, Object> context) throws AdminException {
        try {
            return new InternalDumpResult(this, (InternalDumpProvider)this.gsa, this.gsa.generateDump(cause, context));
        }
        catch (Exception e) {
            throw new AdminException("Failed to generate dump", e);
        }
    }

    @Override
    public DumpResult generateDump(String cause, Map<String, Object> context, String ... processor) throws AdminException {
        try {
            return new InternalDumpResult(this, (InternalDumpProvider)this.gsa, this.gsa.generateDump(cause, context, processor));
        }
        catch (Exception e) {
            throw new AdminException("Failed to generate dump", e);
        }
    }

    @Override
    public CompoundLogEntries liveLogEntries(LogEntryMatcher matcher) {
        ArrayList<LogProcessType> types = new ArrayList<LogProcessType>();
        ArrayList<Long> pids = new ArrayList<Long>();
        for (ElasticServiceManager esm : this.admin.getElasticServiceManagers()) {
            if (esm.getGridServiceAgent() == null || esm.getGridServiceAgent() != this) continue;
            types.add(LogProcessType.ESM);
            pids.add(esm.getVirtualMachine().getDetails().getPid());
        }
        for (GridServiceManager gsm : this.admin.getGridServiceManagers()) {
            if (gsm.getGridServiceAgent() == null || gsm.getGridServiceAgent() != this) continue;
            types.add(LogProcessType.GSM);
            pids.add(gsm.getVirtualMachine().getDetails().getPid());
        }
        for (GridServiceContainer gsc : this.admin.getGridServiceContainers()) {
            if (gsc.getGridServiceAgent() == null || gsc.getGridServiceAgent() != this) continue;
            types.add(LogProcessType.GSC);
            pids.add(gsc.getVirtualMachine().getDetails().getPid());
        }
        for (LookupService lus : this.admin.getLookupServices()) {
            if (lus.getGridServiceAgent() == null || lus.getGridServiceAgent() != this) continue;
            types.add(LogProcessType.LUS);
            pids.add(lus.getVirtualMachine().getDetails().getPid());
        }
        try {
            long[] lPids = new long[pids.size()];
            for (int i = 0; i < lPids.length; ++i) {
                lPids[i] = (Long)pids.get(i);
            }
            return this.gsa.logEntries(types.toArray(new LogProcessType[types.size()]), lPids, matcher);
        }
        catch (IOException e) {
            throw new AdminException("Failed to retrieve logs", e);
        }
    }

    @Override
    public CompoundLogEntries allLogEntries(LogProcessType type, LogEntryMatcher matcher) {
        try {
            return this.gsa.logEntries(type, matcher);
        }
        catch (IOException e) {
            throw new AdminException("Failed to retrieve logs", e);
        }
    }

    private int internalStartGridService(GridServiceManagerOptions options) {
        try {
            return this.gsa.startProcess(options.getOptions());
        }
        catch (SecurityException se) {
            throw new AdminException("No privileges to start a GSM", se);
        }
        catch (IOException e) {
            throw new AdminException("Failed to start GSM", e);
        }
    }

    @Override
    public GridServiceManager startGridServiceAndWait(GridServiceManagerOptions options) {
        return this.startGridServiceAndWait(options, this.admin.getDefaultTimeout(), this.admin.getDefaultTimeoutTimeUnit());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GridServiceManager startGridServiceAndWait(GridServiceManagerOptions options, long timeout, TimeUnit timeUnit) {
        final int agentId = this.internalStartGridService(options);
        final CountDownLatch latch = new CountDownLatch(1);
        final AtomicReference ref = new AtomicReference();
        GridServiceManagerAddedEventListener added = new GridServiceManagerAddedEventListener(){

            @Override
            public void gridServiceManagerAdded(GridServiceManager gridServiceManager) {
                String agentUid = ((InternalGridServiceManager)gridServiceManager).getAgentUid();
                if (agentUid != null && agentUid.equals(DefaultGridServiceAgent.this.getUid()) && agentId == gridServiceManager.getAgentId()) {
                    ref.set(gridServiceManager);
                    latch.countDown();
                }
            }
        };
        this.getAdmin().getGridServiceManagers().getGridServiceManagerAdded().add(added);
        try {
            latch.await(timeout, timeUnit);
            GridServiceManager gridServiceManager = (GridServiceManager)ref.get();
            return gridServiceManager;
        }
        catch (InterruptedException e) {
            GridServiceManager gridServiceManager = null;
            return gridServiceManager;
        }
        finally {
            this.getAdmin().getGridServiceManagers().getGridServiceManagerAdded().remove(added);
        }
    }

    @Override
    public void startGridService(ElasticServiceManagerOptions options) {
        this.internalStartGridService(options);
    }

    public int internalStartGridService(ElasticServiceManagerOptions options) {
        try {
            return this.gsa.startProcess(options.getOptions());
        }
        catch (SecurityException se) {
            throw new AdminException("No privileges to start an ESM", se);
        }
        catch (IOException e) {
            throw new AdminException("Failed to start ESM", e);
        }
    }

    @Override
    public ElasticServiceManager startGridServiceAndWait(ElasticServiceManagerOptions options) {
        return this.startGridServiceAndWait(options, this.admin.getDefaultTimeout(), this.admin.getDefaultTimeoutTimeUnit());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ElasticServiceManager startGridServiceAndWait(ElasticServiceManagerOptions options, long timeout, TimeUnit timeUnit) {
        final int agentId = this.internalStartGridService(options);
        final CountDownLatch latch = new CountDownLatch(1);
        final AtomicReference ref = new AtomicReference();
        ElasticServiceManagerAddedEventListener added = new ElasticServiceManagerAddedEventListener(){

            @Override
            public void elasticServiceManagerAdded(ElasticServiceManager elasticServiceManager) {
                String agentUid = ((InternalElasticServiceManager)elasticServiceManager).getAgentUid();
                if (agentUid != null && agentUid.equals(DefaultGridServiceAgent.this.getUid()) && agentId == elasticServiceManager.getAgentId()) {
                    ref.set(elasticServiceManager);
                    latch.countDown();
                }
            }
        };
        this.getAdmin().getElasticServiceManagers().getElasticServiceManagerAdded().add(added);
        try {
            latch.await(timeout, timeUnit);
            ElasticServiceManager elasticServiceManager = (ElasticServiceManager)ref.get();
            return elasticServiceManager;
        }
        catch (InterruptedException e) {
            ElasticServiceManager elasticServiceManager = null;
            return elasticServiceManager;
        }
        finally {
            this.getAdmin().getElasticServiceManagers().getElasticServiceManagerAdded().remove(added);
        }
    }

    @Override
    public void startGridService(GridServiceContainerOptions options) {
        this.internalStartGridService(options);
    }

    public int internalStartGridService(GridServiceContainerOptions options) {
        try {
            return this.gsa.startProcess(options.getOptions());
        }
        catch (SecurityException se) {
            throw new AdminException("No privileges to start a GSC", se);
        }
        catch (IOException e) {
            throw new AdminException("Failed to start GSC", e);
        }
    }

    @Override
    public int internalStartGridService(GridServiceContainerConfig options) {
        try {
            return this.gsa.startProcess(options.getOptions());
        }
        catch (SecurityException se) {
            throw new AdminException("No privileges to start a GSC", se);
        }
        catch (IOException e) {
            throw new AdminException("Failed to start GSC", e);
        }
    }

    @Override
    public GridServiceContainer startGridServiceAndWait(GridServiceContainerOptions options) {
        return this.startGridServiceAndWait(options, this.admin.getDefaultTimeout(), this.admin.getDefaultTimeoutTimeUnit());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GridServiceContainer startGridServiceAndWait(GridServiceContainerOptions options, long timeout, TimeUnit timeUnit) {
        final int agentId = this.internalStartGridService(options);
        final CountDownLatch latch = new CountDownLatch(1);
        final AtomicReference ref = new AtomicReference();
        GridServiceContainerAddedEventListener added = new GridServiceContainerAddedEventListener(){

            @Override
            public void gridServiceContainerAdded(GridServiceContainer gridServiceContainer) {
                String agentUid = ((InternalGridServiceContainer)gridServiceContainer).getAgentUid();
                if (agentUid != null && agentUid.equals(DefaultGridServiceAgent.this.getUid()) && agentId == gridServiceContainer.getAgentId()) {
                    ref.set(gridServiceContainer);
                    latch.countDown();
                }
            }
        };
        this.getAdmin().getGridServiceContainers().getGridServiceContainerAdded().add(added);
        try {
            latch.await(timeout, timeUnit);
            GridServiceContainer gridServiceContainer = (GridServiceContainer)ref.get();
            return gridServiceContainer;
        }
        catch (InterruptedException e) {
            GridServiceContainer gridServiceContainer = null;
            return gridServiceContainer;
        }
        finally {
            this.getAdmin().getGridServiceContainers().getGridServiceContainerAdded().remove(added);
        }
    }

    @Override
    public void startGridService(LookupServiceOptions options) {
        this.internalStartGridService(options);
    }

    public int internalStartGridService(LookupServiceOptions options) {
        try {
            return this.gsa.startProcess(options.getOptions());
        }
        catch (SecurityException se) {
            throw new AdminException("No privileges to start a Lookup Service", se);
        }
        catch (IOException e) {
            throw new AdminException("Failed to start LUS", e);
        }
    }

    @Override
    public LookupService startGridServiceAndWait(LookupServiceOptions options) {
        return this.startGridServiceAndWait(options, this.admin.getDefaultTimeout(), this.admin.getDefaultTimeoutTimeUnit());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LookupService startGridServiceAndWait(LookupServiceOptions options, long timeout, TimeUnit timeUnit) {
        final int agentId = this.internalStartGridService(options);
        final CountDownLatch latch = new CountDownLatch(1);
        final AtomicReference ref = new AtomicReference();
        LookupServiceAddedEventListener added = new LookupServiceAddedEventListener(){

            @Override
            public void lookupServiceAdded(LookupService lookupService) {
                String agentUid = ((InternalLookupService)lookupService).getAgentUid();
                if (agentUid != null && agentUid.equals(DefaultGridServiceAgent.this.getUid()) && agentId == lookupService.getAgentId()) {
                    ref.set(lookupService);
                    latch.countDown();
                }
            }
        };
        this.getAdmin().getLookupServices().getLookupServiceAdded().add(added);
        try {
            latch.await(timeout, timeUnit);
            LookupService lookupService = (LookupService)ref.get();
            return lookupService;
        }
        catch (InterruptedException e) {
            LookupService lookupService = null;
            return lookupService;
        }
        finally {
            this.getAdmin().getLookupServices().getLookupServiceAdded().remove(added);
        }
    }

    @Override
    public void kill(InternalAgentGridComponent agentGridComponent) {
        try {
            this.gsa.killProcess(agentGridComponent.getAgentId());
        }
        catch (SecurityException se) {
            throw new AdminException("No privileges to kill", se);
        }
        catch (RemoteException e) {
            throw new AdminException("Failed to kill [" + agentGridComponent.getUid() + "]", e);
        }
    }

    @Override
    public void restart(InternalAgentGridComponent agentGridComponent) {
        try {
            this.gsa.restartProcess(agentGridComponent.getAgentId());
        }
        catch (SecurityException se) {
            throw new AdminException("No privileges to restart", se);
        }
        catch (IOException e) {
            throw new AdminException("Failed to restart [" + agentGridComponent.getUid() + "]", e);
        }
    }

    @Override
    public void shutdown() {
        block2: {
            try {
                this.gsa.shutdown();
            }
            catch (RemoteException e) {
                if (NetworkExceptionHelper.isConnectOrCloseException(e)) break block2;
                throw new AdminException("Failed to shutdown GSA", e);
            }
        }
    }

    @Override
    public LogEntries logEntries(LogEntryMatcher matcher) throws AdminException {
        return this.logEntriesDirect(matcher);
    }

    @Override
    public LogEntries logEntriesDirect(LogEntryMatcher matcher) throws AdminException {
        try {
            return this.gsa.logEntriesDirect(matcher);
        }
        catch (IOException e) {
            throw new AdminException("Failed to get log", e);
        }
    }

    @Override
    public void reloadMetricConfiguration() throws AdminException {
        try {
            this.gsa.reloadMetricConfiguration();
        }
        catch (RemoteException e) {
            throw new AdminException("Failed to reload metric configuration", e);
        }
    }

    @Override
    public NIODetails getNIODetails() throws RemoteException {
        return this.gsa.getNIODetails();
    }

    @Override
    public NIOStatistics getNIOStatistics() throws RemoteException {
        return this.gsa.getNIOStatistics();
    }

    @Override
    public void enableLRMIMonitoring() throws RemoteException {
        this.gsa.enableLRMIMonitoring();
    }

    @Override
    public void disableLRMIMonitoring() throws RemoteException {
        this.gsa.disableLRMIMonitoring();
    }

    @Override
    public LRMIMonitoringDetails fetchLRMIMonitoringDetails() throws RemoteException {
        return this.gsa.fetchLRMIMonitoringDetails();
    }

    @Override
    public long getCurrentTimeInMillis() throws RemoteException {
        return this.gsa.getCurrentTimestamp();
    }

    @Override
    public OSDetails getOSDetails() throws RemoteException {
        return this.gsa.getOSDetails();
    }

    @Override
    public OSStatistics getOSStatistics() throws RemoteException {
        return this.gsa.getOSStatistics();
    }

    @Override
    public JVMStatistics getJVMStatistics() throws RemoteException {
        return this.gsa.getJVMStatistics();
    }

    @Override
    public void runGc() throws RemoteException {
        this.gsa.runGc();
    }

    @Override
    public void removeAgentGridComponent(InternalAgentGridComponent agentGridComponent) {
        this.assertStateChangesPermitted();
        this.removedAgentGridComponents.put(agentGridComponent.getAgentId(), agentGridComponent);
        if (agentGridComponent instanceof GridServiceContainer) {
            this.gridServiceContainers.removeGridServiceContainer(agentGridComponent.getUid());
        } else if (agentGridComponent instanceof GridServiceManager) {
            this.gridServiceManagers.removeGridServiceManager(agentGridComponent.getUid());
        } else if (agentGridComponent instanceof LookupService) {
            this.lookupServices.removeLookupService(agentGridComponent.getUid());
        } else if (agentGridComponent instanceof ElasticServiceManager) {
            this.elasticServiceManagers.removeElasticServiceManager(agentGridComponent.getUid());
        }
    }

    @Override
    public void addAgentGridComponent(InternalAgentGridComponent agentGridComponent) {
        this.assertStateChangesPermitted();
        this.removedAgentGridComponents.remove(agentGridComponent.getAgentId());
        if (agentGridComponent instanceof GridServiceContainer) {
            this.gridServiceContainers.addGridServiceContainer((InternalGridServiceContainer)agentGridComponent);
        } else if (agentGridComponent instanceof GridServiceManager) {
            this.gridServiceManagers.addGridServiceManager((InternalGridServiceManager)agentGridComponent);
        } else if (agentGridComponent instanceof LookupService) {
            this.lookupServices.addLookupService((InternalLookupService)agentGridComponent);
        } else if (agentGridComponent instanceof ElasticServiceManager) {
            this.elasticServiceManagers.addElasticServiceManager((InternalElasticServiceManager)agentGridComponent);
        }
    }

    @Override
    public InternalAgentGridComponent[] getUnconfirmedRemovedAgentGridComponents() {
        ArrayList<InternalAgentGridComponent> values = new ArrayList<InternalAgentGridComponent>(this.removedAgentGridComponents.values());
        return values.toArray(new InternalAgentGridComponent[values.size()]);
    }

    @Override
    public ExactZonesConfig getExactZones() {
        return ((ExactZonesConfigurer)new ExactZonesConfigurer().addZones(this.getZones().keySet())).create();
    }

    @Override
    public GridServiceContainers getGridServiceContainers() {
        return this.gridServiceContainers;
    }

    @Override
    public GridServiceManagers getGridServiceManagers() {
        return this.gridServiceManagers;
    }

    @Override
    public ElasticServiceManagers getElasticServiceManagers() {
        return this.elasticServiceManagers;
    }

    @Override
    public LookupServices getLookupServices() {
        return this.lookupServices;
    }

    @Override
    public GSAReservationId getReservationId() {
        String reservationId = this.getVirtualMachine().getDetails().getSystemProperties().get(RESERVATION_PROPERTY);
        if (reservationId == null) {
            return null;
        }
        return new GSAReservationId(reservationId);
    }
}

