/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.admin.internal.gsa;

import com.j_spaces.kernel.SizeConcurrentHashMap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.openspaces.admin.Admin;
import org.openspaces.admin.AdminException;
import org.openspaces.admin.dump.CompoundDumpResult;
import org.openspaces.admin.dump.DumpResult;
import org.openspaces.admin.gsa.GSAReservationId;
import org.openspaces.admin.gsa.GridServiceAgent;
import org.openspaces.admin.gsa.events.ElasticGridServiceAgentProvisioningFailureEvent;
import org.openspaces.admin.gsa.events.ElasticGridServiceAgentProvisioningFailureEventManager;
import org.openspaces.admin.gsa.events.ElasticGridServiceAgentProvisioningProgressChangedEvent;
import org.openspaces.admin.gsa.events.ElasticGridServiceAgentProvisioningProgressChangedEventManager;
import org.openspaces.admin.gsa.events.GridServiceAgentAddedEventListener;
import org.openspaces.admin.gsa.events.GridServiceAgentAddedEventManager;
import org.openspaces.admin.gsa.events.GridServiceAgentLifecycleEventListener;
import org.openspaces.admin.gsa.events.GridServiceAgentRemovedEventListener;
import org.openspaces.admin.gsa.events.GridServiceAgentRemovedEventManager;
import org.openspaces.admin.internal.admin.InternalAdmin;
import org.openspaces.admin.internal.gsa.InternalGridServiceAgent;
import org.openspaces.admin.internal.gsa.InternalGridServiceAgents;
import org.openspaces.admin.internal.gsa.events.DefaultElasticGridServiceAgentProvisioningFailureEventManager;
import org.openspaces.admin.internal.gsa.events.DefaultElasticGridServiceAgentProvisioningProgressChangedEventManager;
import org.openspaces.admin.internal.gsa.events.DefaultGridServiceAgentAddedEventManager;
import org.openspaces.admin.internal.gsa.events.DefaultGridServiceAgentRemovedEventManager;
import org.openspaces.admin.internal.gsa.events.InternalElasticGridServiceAgentProvisioningFailureEventManager;
import org.openspaces.admin.internal.gsa.events.InternalElasticGridServiceAgentProvisioningProgressChangedEventManager;
import org.openspaces.admin.internal.gsa.events.InternalGridServiceAgentAddedEventManager;
import org.openspaces.admin.internal.gsa.events.InternalGridServiceAgentRemovedEventManager;
import org.openspaces.admin.pu.elastic.events.ElasticProcessingUnitEvent;

public class DefaultGridServiceAgents
implements InternalGridServiceAgents {
    private final InternalAdmin admin;
    private final Map<String, GridServiceAgent> agents = new SizeConcurrentHashMap();
    private final Map<String, GridServiceAgent> agentsByHostAddress = new SizeConcurrentHashMap();
    private final Map<String, GridServiceAgent> agentsByHostNames = new SizeConcurrentHashMap();
    private final InternalGridServiceAgentAddedEventManager gridServiceAgentAddedEventManager;
    private final InternalGridServiceAgentRemovedEventManager gridServiceAgentRemovedEventManager;
    private final InternalElasticGridServiceAgentProvisioningFailureEventManager elasticGridServiceAgentProvisioningFailureEventManager;
    private final InternalElasticGridServiceAgentProvisioningProgressChangedEventManager elasticGridServiceAgentProvisioningProgressChangedEventManager;

    public DefaultGridServiceAgents(InternalAdmin admin) {
        this.admin = admin;
        this.gridServiceAgentAddedEventManager = new DefaultGridServiceAgentAddedEventManager(this);
        this.gridServiceAgentRemovedEventManager = new DefaultGridServiceAgentRemovedEventManager(this);
        this.elasticGridServiceAgentProvisioningFailureEventManager = new DefaultElasticGridServiceAgentProvisioningFailureEventManager(admin);
        this.elasticGridServiceAgentProvisioningProgressChangedEventManager = new DefaultElasticGridServiceAgentProvisioningProgressChangedEventManager(admin);
    }

    @Override
    public Admin getAdmin() {
        return this.admin;
    }

    @Override
    public GridServiceAgent[] getAgents() {
        return this.agents.values().toArray(new GridServiceAgent[0]);
    }

    @Override
    public GridServiceAgent getAgentByUID(String uid) {
        return this.agents.get(uid);
    }

    @Override
    public Map<String, GridServiceAgent> getUids() {
        return Collections.unmodifiableMap(this.agents);
    }

    @Override
    public Map<String, GridServiceAgent> getHostAddress() {
        return Collections.unmodifiableMap(this.agentsByHostAddress);
    }

    @Override
    public Map<String, GridServiceAgent> getHostNames() {
        return Collections.unmodifiableMap(this.agentsByHostNames);
    }

    @Override
    public int getSize() {
        return this.agents.size();
    }

    @Override
    public boolean isEmpty() {
        return this.agents.isEmpty();
    }

    @Override
    public Iterator<GridServiceAgent> iterator() {
        return Collections.unmodifiableCollection(this.agents.values()).iterator();
    }

    @Override
    public GridServiceAgent waitForAtLeastOne() {
        return this.waitForAtLeastOne(this.admin.getDefaultTimeout(), this.admin.getDefaultTimeoutTimeUnit());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GridServiceAgent waitForAtLeastOne(long timeout, TimeUnit timeUnit) {
        final CountDownLatch latch = new CountDownLatch(1);
        final AtomicReference ref = new AtomicReference();
        GridServiceAgentAddedEventListener added = new GridServiceAgentAddedEventListener(){

            @Override
            public void gridServiceAgentAdded(GridServiceAgent gridServiceAgent) {
                ref.set(gridServiceAgent);
                latch.countDown();
            }
        };
        this.getGridServiceAgentAdded().add(added);
        try {
            latch.await(timeout, timeUnit);
            GridServiceAgent gridServiceAgent = (GridServiceAgent)ref.get();
            return gridServiceAgent;
        }
        catch (InterruptedException e) {
            GridServiceAgent gridServiceAgent = null;
            return gridServiceAgent;
        }
        finally {
            this.getGridServiceAgentAdded().remove(added);
        }
    }

    @Override
    public boolean waitFor(int numberOfAgents) {
        return this.waitFor(numberOfAgents, this.admin.getDefaultTimeout(), this.admin.getDefaultTimeoutTimeUnit());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean waitFor(int numberOfAgents, long timeout, TimeUnit timeUnit) {
        if (numberOfAgents == 0) {
            final CountDownLatch latch = new CountDownLatch(this.getSize());
            GridServiceAgentRemovedEventListener removed = new GridServiceAgentRemovedEventListener(){

                @Override
                public void gridServiceAgentRemoved(GridServiceAgent gridServiceAgent) {
                    latch.countDown();
                }
            };
            this.getGridServiceAgentRemoved().remove(removed);
            try {
                boolean bl = latch.await(timeout, timeUnit);
                return bl;
            }
            catch (InterruptedException e) {
                boolean bl = false;
                return bl;
            }
            finally {
                this.getGridServiceAgentRemoved().remove(removed);
            }
        }
        final CountDownLatch latch = new CountDownLatch(numberOfAgents);
        GridServiceAgentAddedEventListener added = new GridServiceAgentAddedEventListener(){

            @Override
            public void gridServiceAgentAdded(GridServiceAgent gridServiceAgent) {
                latch.countDown();
            }
        };
        this.getGridServiceAgentAdded().add(added);
        try {
            boolean e = latch.await(timeout, timeUnit);
            return e;
        }
        catch (InterruptedException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            this.getGridServiceAgentAdded().remove(added);
        }
    }

    @Override
    public GridServiceAgentAddedEventManager getGridServiceAgentAdded() {
        return this.gridServiceAgentAddedEventManager;
    }

    @Override
    public GridServiceAgentRemovedEventManager getGridServiceAgentRemoved() {
        return this.gridServiceAgentRemovedEventManager;
    }

    @Override
    public void addLifecycleListener(GridServiceAgentLifecycleEventListener eventListener) {
        this.gridServiceAgentAddedEventManager.add(eventListener);
        this.gridServiceAgentRemovedEventManager.add(eventListener);
    }

    @Override
    public void removeLifecycleListener(GridServiceAgentLifecycleEventListener eventListener) {
        this.gridServiceAgentAddedEventManager.remove(eventListener);
        this.gridServiceAgentRemovedEventManager.remove(eventListener);
    }

    @Override
    public void addGridServiceAgent(InternalGridServiceAgent gridServiceAgent) {
        this.assertStateChangesPermitted();
        GridServiceAgent existing = this.agents.put(gridServiceAgent.getUid(), gridServiceAgent);
        this.agentsByHostAddress.put(gridServiceAgent.getTransport().getHostAddress(), gridServiceAgent);
        this.agentsByHostNames.put(gridServiceAgent.getTransport().getHostName(), gridServiceAgent);
        if (existing == null) {
            this.gridServiceAgentAddedEventManager.gridServiceAgentAdded(gridServiceAgent);
        }
    }

    @Override
    public InternalGridServiceAgent removeGridServiceAgent(String uid) {
        this.assertStateChangesPermitted();
        InternalGridServiceAgent existing = (InternalGridServiceAgent)this.agents.remove(uid);
        if (existing != null) {
            this.agentsByHostAddress.remove(existing.getTransport().getHostAddress());
            this.agentsByHostNames.remove(existing.getTransport().getHostName());
            this.gridServiceAgentRemovedEventManager.gridServiceAgentRemoved(existing);
        }
        return existing;
    }

    @Override
    public DumpResult generateDump(String cause, Map<String, Object> context) throws AdminException {
        return this.generateDump(cause, context, null);
    }

    @Override
    public DumpResult generateDump(String cause, Map<String, Object> context, String ... processor) throws AdminException {
        CompoundDumpResult dumpResult = new CompoundDumpResult();
        for (GridServiceAgent gsa : this) {
            dumpResult.add(gsa.generateDump(cause, context, processor));
        }
        return dumpResult;
    }

    private void assertStateChangesPermitted() {
        this.admin.assertStateChangesPermitted();
    }

    @Override
    public ElasticGridServiceAgentProvisioningFailureEventManager getElasticGridServiceAgentProvisioningFailure() {
        return this.elasticGridServiceAgentProvisioningFailureEventManager;
    }

    @Override
    public ElasticGridServiceAgentProvisioningProgressChangedEventManager getElasticGridServiceAgentProvisioningProgressChanged() {
        return this.elasticGridServiceAgentProvisioningProgressChangedEventManager;
    }

    @Override
    public void processElasticScaleStrategyEvent(ElasticProcessingUnitEvent event) {
        if (event instanceof ElasticGridServiceAgentProvisioningFailureEvent) {
            this.elasticGridServiceAgentProvisioningFailureEventManager.elasticGridServiceAgentProvisioningFailure((ElasticGridServiceAgentProvisioningFailureEvent)event);
        } else if (event instanceof ElasticGridServiceAgentProvisioningProgressChangedEvent) {
            this.elasticGridServiceAgentProvisioningProgressChangedEventManager.elasticGridServiceAgentProvisioningProgressChanged((ElasticGridServiceAgentProvisioningProgressChangedEvent)event);
        }
    }

    @Override
    public Map<GSAReservationId, Collection<GridServiceAgent>> getAgentsGroupByReservationId() {
        HashMap<GSAReservationId, Collection<GridServiceAgent>> agentsByReservationId = new HashMap<GSAReservationId, Collection<GridServiceAgent>>();
        for (GridServiceAgent agent : this.agents.values()) {
            GSAReservationId reservationId = ((InternalGridServiceAgent)agent).getReservationId();
            if (reservationId == null) continue;
            HashSet<GridServiceAgent> reservedAgents = (HashSet<GridServiceAgent>)agentsByReservationId.get(reservationId);
            if (reservedAgents == null) {
                reservedAgents = new HashSet<GridServiceAgent>();
                agentsByReservationId.put(reservationId, reservedAgents);
            }
            reservedAgents.add(agent);
        }
        return agentsByReservationId;
    }
}

