/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.admin.internal.gsa.events;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.openspaces.admin.gsa.GridServiceAgent;
import org.openspaces.admin.gsa.events.GridServiceAgentAddedEventListener;
import org.openspaces.admin.internal.admin.InternalAdmin;
import org.openspaces.admin.internal.gsa.InternalGridServiceAgents;
import org.openspaces.admin.internal.gsa.events.ClosureGridServiceAgentAddedEventListener;
import org.openspaces.admin.internal.gsa.events.InternalGridServiceAgentAddedEventManager;
import org.openspaces.admin.internal.support.GroovyHelper;

public class DefaultGridServiceAgentAddedEventManager
implements InternalGridServiceAgentAddedEventManager {
    private final InternalGridServiceAgents gridServiceAgents;
    private final InternalAdmin admin;
    private final List<GridServiceAgentAddedEventListener> listeners = new CopyOnWriteArrayList<GridServiceAgentAddedEventListener>();

    public DefaultGridServiceAgentAddedEventManager(InternalGridServiceAgents gridServiceAgents) {
        this.gridServiceAgents = gridServiceAgents;
        this.admin = (InternalAdmin)gridServiceAgents.getAdmin();
    }

    @Override
    public void gridServiceAgentAdded(final GridServiceAgent gridServiceAgent) {
        for (final GridServiceAgentAddedEventListener listener : this.listeners) {
            this.admin.pushEvent(listener, new Runnable(){

                @Override
                public void run() {
                    listener.gridServiceAgentAdded(gridServiceAgent);
                }
            });
        }
    }

    @Override
    public void add(final GridServiceAgentAddedEventListener eventListener, boolean includeExisting) {
        if (includeExisting) {
            this.admin.raiseEvent(eventListener, new Runnable(){

                @Override
                public void run() {
                    for (GridServiceAgent gridServiceAgent : DefaultGridServiceAgentAddedEventManager.this.gridServiceAgents) {
                        eventListener.gridServiceAgentAdded(gridServiceAgent);
                    }
                }
            });
        }
        this.listeners.add(eventListener);
    }

    @Override
    public void add(GridServiceAgentAddedEventListener eventListener) {
        this.add(eventListener, true);
    }

    @Override
    public void remove(GridServiceAgentAddedEventListener eventListener) {
        this.listeners.remove(eventListener);
    }

    public void plus(Object eventListener) {
        if (GroovyHelper.isClosure(eventListener)) {
            this.add(new ClosureGridServiceAgentAddedEventListener(eventListener));
        } else {
            this.add((GridServiceAgentAddedEventListener)eventListener);
        }
    }

    public void leftShift(Object eventListener) {
        this.plus(eventListener);
    }

    public void minus(Object eventListener) {
        if (GroovyHelper.isClosure(eventListener)) {
            this.remove(new ClosureGridServiceAgentAddedEventListener(eventListener));
        } else {
            this.remove((GridServiceAgentAddedEventListener)eventListener);
        }
    }

    public void rightShift(Object eventListener) {
        this.minus(eventListener);
    }
}

