/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.admin.internal.gsa.events;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.openspaces.admin.gsa.GridServiceAgent;
import org.openspaces.admin.gsa.events.GridServiceAgentRemovedEventListener;
import org.openspaces.admin.internal.admin.InternalAdmin;
import org.openspaces.admin.internal.gsa.InternalGridServiceAgents;
import org.openspaces.admin.internal.gsa.events.ClosureGridServiceAgentRemovedEventListener;
import org.openspaces.admin.internal.gsa.events.InternalGridServiceAgentRemovedEventManager;
import org.openspaces.admin.internal.support.GroovyHelper;

public class DefaultGridServiceAgentRemovedEventManager
implements InternalGridServiceAgentRemovedEventManager {
    private final InternalGridServiceAgents gridServiceAgents;
    private final InternalAdmin admin;
    private final List<GridServiceAgentRemovedEventListener> listeners = new CopyOnWriteArrayList<GridServiceAgentRemovedEventListener>();

    public DefaultGridServiceAgentRemovedEventManager(InternalGridServiceAgents gridServiceAgents) {
        this.gridServiceAgents = gridServiceAgents;
        this.admin = (InternalAdmin)gridServiceAgents.getAdmin();
    }

    @Override
    public void gridServiceAgentRemoved(final GridServiceAgent gridServiceAgent) {
        for (final GridServiceAgentRemovedEventListener listener : this.listeners) {
            this.admin.pushEvent(listener, new Runnable(){

                @Override
                public void run() {
                    listener.gridServiceAgentRemoved(gridServiceAgent);
                }
            });
        }
    }

    @Override
    public void add(GridServiceAgentRemovedEventListener eventListener) {
        this.listeners.add(eventListener);
    }

    @Override
    public void remove(GridServiceAgentRemovedEventListener eventListener) {
        this.listeners.remove(eventListener);
    }

    public void plus(Object eventListener) {
        if (GroovyHelper.isClosure(eventListener)) {
            this.add(new ClosureGridServiceAgentRemovedEventListener(eventListener));
        } else {
            this.add((GridServiceAgentRemovedEventListener)eventListener);
        }
    }

    public void leftShift(Object eventListener) {
        this.plus(eventListener);
    }

    public void minus(Object eventListener) {
        if (GroovyHelper.isClosure(eventListener)) {
            this.remove(new ClosureGridServiceAgentRemovedEventListener(eventListener));
        } else {
            this.remove((GridServiceAgentRemovedEventListener)eventListener);
        }
    }

    public void rightShift(Object eventListener) {
        this.minus(eventListener);
    }
}

