/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.admin.internal.gsc;

import com.gigaspaces.grid.gsc.GSC;
import com.gigaspaces.internal.dump.InternalDumpProvider;
import com.gigaspaces.internal.jvm.JVMDetails;
import com.gigaspaces.internal.jvm.JVMStatistics;
import com.gigaspaces.internal.os.OSDetails;
import com.gigaspaces.internal.os.OSStatistics;
import com.gigaspaces.log.LogEntries;
import com.gigaspaces.log.LogEntryMatcher;
import com.gigaspaces.log.LogProcessType;
import com.gigaspaces.lrmi.LRMIMonitoringDetails;
import com.gigaspaces.lrmi.nio.info.NIODetails;
import com.gigaspaces.lrmi.nio.info.NIOStatistics;
import com.gigaspaces.security.SecurityException;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import net.jini.core.lookup.ServiceID;
import org.jini.rio.core.provision.ServiceRecord;
import org.openspaces.admin.AdminException;
import org.openspaces.admin.dump.DumpResult;
import org.openspaces.admin.internal.admin.InternalAdmin;
import org.openspaces.admin.internal.dump.InternalDumpResult;
import org.openspaces.admin.internal.gsc.InternalGridServiceContainer;
import org.openspaces.admin.internal.pu.DefaultProcessingUnitInstances;
import org.openspaces.admin.internal.pu.InternalProcessingUnitInstances;
import org.openspaces.admin.internal.support.AbstractAgentGridComponent;
import org.openspaces.admin.pu.ProcessingUnitInstance;
import org.openspaces.admin.pu.events.ProcessingUnitInstanceAddedEventListener;
import org.openspaces.admin.pu.events.ProcessingUnitInstanceAddedEventManager;
import org.openspaces.admin.pu.events.ProcessingUnitInstanceLifecycleEventListener;
import org.openspaces.admin.pu.events.ProcessingUnitInstanceRemovedEventManager;
import org.openspaces.admin.zone.config.ExactZonesConfig;
import org.openspaces.admin.zone.config.ExactZonesConfigurer;

public class DefaultGridServiceContainer
extends AbstractAgentGridComponent
implements InternalGridServiceContainer {
    private final ServiceID serviceID;
    private final GSC gsc;
    private final InternalProcessingUnitInstances processingUnitInstances;
    private volatile String id;

    public DefaultGridServiceContainer(ServiceID serviceID, GSC gsc, InternalAdmin admin, int agentId, String agentUid, JVMDetails jvmDetails) {
        super(admin, agentId, agentUid, jvmDetails);
        this.serviceID = serviceID;
        this.gsc = gsc;
        this.processingUnitInstances = new DefaultProcessingUnitInstances(admin);
    }

    @Override
    public String getId() {
        if (this.id == null) {
            this.id = this.getMachine().getHostName() + "~" + this.getVirtualMachine().getDetails().getPid();
        }
        return this.id;
    }

    @Override
    public String getUid() {
        return this.serviceID.toString();
    }

    @Override
    public ServiceID getServiceID() {
        return this.serviceID;
    }

    @Override
    public GSC getGSC() {
        return this.gsc;
    }

    @Override
    public Iterator<ProcessingUnitInstance> iterator() {
        return this.processingUnitInstances.getInstancesIt();
    }

    @Override
    public ProcessingUnitInstance[] getProcessingUnitInstances() {
        return this.processingUnitInstances.getInstances();
    }

    @Override
    public ProcessingUnitInstance[] getProcessingUnitInstances(String processingUnitName) {
        return this.processingUnitInstances.getInstances(processingUnitName);
    }

    @Override
    public ProcessingUnitInstance getProcessingUnitInstanceByUID(String processingUnitInstanceUid) {
        ProcessingUnitInstance processingUnitInstance = this.processingUnitInstances.getInstanceByUID(processingUnitInstanceUid);
        return processingUnitInstance;
    }

    @Override
    public boolean contains(ProcessingUnitInstance processingUnitInstance) {
        return this.processingUnitInstances.contains(processingUnitInstance);
    }

    @Override
    public boolean waitFor(int numberOfProcessingUnitInstances) {
        return this.waitFor(numberOfProcessingUnitInstances, this.admin.getDefaultTimeout(), this.admin.getDefaultTimeoutTimeUnit());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean waitFor(int numberOfProcessingUnitInstances, long timeout, TimeUnit timeUnit) {
        final CountDownLatch latch = new CountDownLatch(numberOfProcessingUnitInstances);
        ProcessingUnitInstanceAddedEventListener added = new ProcessingUnitInstanceAddedEventListener(){

            @Override
            public void processingUnitInstanceAdded(ProcessingUnitInstance processingUnitInstance) {
                latch.countDown();
            }
        };
        this.getProcessingUnitInstanceAdded().add(added);
        try {
            boolean bl = latch.await(timeout, timeUnit);
            return bl;
        }
        catch (InterruptedException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            this.getProcessingUnitInstanceAdded().remove(added);
        }
    }

    @Override
    public boolean waitFor(String processingUnitName, int numberOfProcessingUnitInstances) {
        return this.waitFor(processingUnitName, numberOfProcessingUnitInstances, this.admin.getDefaultTimeout(), this.admin.getDefaultTimeoutTimeUnit());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean waitFor(final String processingUnitName, int numberOfProcessingUnitInstances, long timeout, TimeUnit timeUnit) {
        final CountDownLatch latch = new CountDownLatch(numberOfProcessingUnitInstances);
        ProcessingUnitInstanceAddedEventListener added = new ProcessingUnitInstanceAddedEventListener(){

            @Override
            public void processingUnitInstanceAdded(ProcessingUnitInstance processingUnitInstance) {
                if (processingUnitInstance.getName().equals(processingUnitName)) {
                    latch.countDown();
                }
            }
        };
        this.getProcessingUnitInstanceAdded().add(added);
        try {
            boolean bl = latch.await(timeout, timeUnit);
            return bl;
        }
        catch (InterruptedException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            this.getProcessingUnitInstanceAdded().remove(added);
        }
    }

    @Override
    public void addProcessingUnitInstance(ProcessingUnitInstance processingUnitInstance) {
        this.assertStateChangesPermitted();
        this.processingUnitInstances.addInstance(processingUnitInstance);
    }

    @Override
    public void removeProcessingUnitInstance(String uid) {
        this.assertStateChangesPermitted();
        this.processingUnitInstances.removeInstance(uid);
    }

    @Override
    public ProcessingUnitInstanceAddedEventManager getProcessingUnitInstanceAdded() {
        return this.processingUnitInstances.getProcessingUnitInstanceAdded();
    }

    @Override
    public ProcessingUnitInstanceRemovedEventManager getProcessingUnitInstanceRemoved() {
        return this.processingUnitInstances.getProcessingUnitInstanceRemoved();
    }

    @Override
    public void addProcessingUnitInstanceLifecycleEventListener(ProcessingUnitInstanceLifecycleEventListener eventListener) {
        this.processingUnitInstances.addProcessingUnitInstanceLifecycleEventListener(eventListener);
    }

    @Override
    public void removeProcessingUnitInstanceLifecycleEventListener(ProcessingUnitInstanceLifecycleEventListener eventListener) {
        this.processingUnitInstances.removeProcessingUnitInstanceLifecycleEventListener(eventListener);
    }

    @Override
    public LogEntries logEntries(LogEntryMatcher matcher) throws AdminException {
        if (this.getGridServiceAgent() != null) {
            return this.getGridServiceAgent().logEntries(LogProcessType.GSC, this.getVirtualMachine().getDetails().getPid(), matcher);
        }
        return this.logEntriesDirect(matcher);
    }

    @Override
    public LogEntries logEntriesDirect(LogEntryMatcher matcher) throws AdminException {
        try {
            return this.gsc.logEntriesDirect(matcher);
        }
        catch (IOException e) {
            throw new AdminException("Failed to get log", e);
        }
    }

    @Override
    public void reloadMetricConfiguration() throws AdminException {
        try {
            this.gsc.reloadMetricConfiguration();
        }
        catch (RemoteException e) {
            throw new AdminException("Failed to reload metric configuration", e);
        }
    }

    @Override
    public DumpResult generateDump(String cause, Map<String, Object> context) throws AdminException {
        try {
            return new InternalDumpResult(this, (InternalDumpProvider)this.gsc, this.gsc.generateDump(cause, context));
        }
        catch (Exception e) {
            throw new AdminException("Failed to generate dump", e);
        }
    }

    @Override
    public DumpResult generateDump(String cause, Map<String, Object> context, String ... processor) throws AdminException {
        try {
            return new InternalDumpResult(this, (InternalDumpProvider)this.gsc, this.gsc.generateDump(cause, context, processor));
        }
        catch (Exception e) {
            throw new AdminException("Failed to generate dump", e);
        }
    }

    @Override
    public NIODetails getNIODetails() throws RemoteException {
        return this.gsc.getNIODetails();
    }

    @Override
    public NIOStatistics getNIOStatistics() throws RemoteException {
        return this.gsc.getNIOStatistics();
    }

    @Override
    public void enableLRMIMonitoring() throws RemoteException {
        this.gsc.enableLRMIMonitoring();
    }

    @Override
    public void disableLRMIMonitoring() throws RemoteException {
        this.gsc.disableLRMIMonitoring();
    }

    @Override
    public LRMIMonitoringDetails fetchLRMIMonitoringDetails() throws RemoteException {
        return this.gsc.fetchLRMIMonitoringDetails();
    }

    @Override
    public long getCurrentTimeInMillis() throws RemoteException {
        return this.gsc.getCurrentTimestamp();
    }

    @Override
    public OSDetails getOSDetails() throws RemoteException {
        return this.gsc.getOSDetails();
    }

    @Override
    public OSStatistics getOSStatistics() throws RemoteException {
        return this.gsc.getOSStatistics();
    }

    @Override
    public JVMStatistics getJVMStatistics() throws RemoteException {
        return this.gsc.getJVMStatistics();
    }

    @Override
    public void runGc() throws RemoteException {
        this.gsc.runGc();
    }

    @Override
    public boolean hasProcessingUnitInstances() {
        try {
            return this.gsc.getServiceRecords(3).length > 0;
        }
        catch (SecurityException se) {
            throw new AdminException("No privileges to check if container has processing unit instances", se);
        }
        catch (RemoteException e) {
            throw new AdminException("Failed to check if container has processing unit instances", e);
        }
    }

    @Override
    public String[] getUnconfirmedRemovedProcessingUnitInstancesUid() {
        try {
            ServiceRecord[] serviceRecords = this.gsc.getServiceRecords(3);
            ArrayList<String> removedInstancesUid = new ArrayList<String>();
            for (ServiceRecord serviceRecord : serviceRecords) {
                String uuid = serviceRecord.getServiceID().toString();
                ProcessingUnitInstance instance = this.processingUnitInstances.getInstanceByUID(uuid);
                if (instance != null) continue;
                removedInstancesUid.add(uuid);
            }
            return removedInstancesUid.toArray(new String[removedInstancesUid.size()]);
        }
        catch (SecurityException se) {
            throw new AdminException("No privileges to check if container has removed processing unit instances", se);
        }
        catch (RemoteException e) {
            throw new AdminException("Failed to check if container has processing unit instances", e);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultGridServiceContainer that = (DefaultGridServiceContainer)o;
        return this.serviceID.equals((Object)that.serviceID);
    }

    public int hashCode() {
        return this.serviceID.hashCode();
    }

    @Override
    public ExactZonesConfig getExactZones() {
        return ((ExactZonesConfigurer)new ExactZonesConfigurer().addZones(this.getZones().keySet())).create();
    }
}

