/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.admin.internal.gsc;

import com.j_spaces.kernel.SizeConcurrentHashMap;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.openspaces.admin.Admin;
import org.openspaces.admin.AdminException;
import org.openspaces.admin.dump.CompoundDumpResult;
import org.openspaces.admin.dump.DumpResult;
import org.openspaces.admin.gsc.GridServiceContainer;
import org.openspaces.admin.gsc.events.ElasticGridServiceContainerProvisioningFailureEvent;
import org.openspaces.admin.gsc.events.ElasticGridServiceContainerProvisioningFailureEventManager;
import org.openspaces.admin.gsc.events.ElasticGridServiceContainerProvisioningProgressChangedEvent;
import org.openspaces.admin.gsc.events.ElasticGridServiceContainerProvisioningProgressChangedEventManager;
import org.openspaces.admin.gsc.events.GridServiceContainerAddedEventListener;
import org.openspaces.admin.gsc.events.GridServiceContainerAddedEventManager;
import org.openspaces.admin.gsc.events.GridServiceContainerLifecycleEventListener;
import org.openspaces.admin.gsc.events.GridServiceContainerRemovedEventListener;
import org.openspaces.admin.gsc.events.GridServiceContainerRemovedEventManager;
import org.openspaces.admin.internal.admin.InternalAdmin;
import org.openspaces.admin.internal.gsa.events.InternalElasticGridServiceContainerProvisioningFailureEventManager;
import org.openspaces.admin.internal.gsc.InternalGridServiceContainer;
import org.openspaces.admin.internal.gsc.InternalGridServiceContainers;
import org.openspaces.admin.internal.gsc.events.DefaultElasticGridServiceContainerProvisioningFailureEventManager;
import org.openspaces.admin.internal.gsc.events.DefaultElasticGridServiceContainerProvisioningProgressChangedEventManager;
import org.openspaces.admin.internal.gsc.events.DefaultGridServiceContainerAddedEventManager;
import org.openspaces.admin.internal.gsc.events.DefaultGridServiceContainerRemovedEventManager;
import org.openspaces.admin.internal.gsc.events.InternalElasticGridServiceContainerProvisioningProgressChangedEventManager;
import org.openspaces.admin.internal.gsc.events.InternalGridServiceContainerAddedEventManager;
import org.openspaces.admin.internal.gsc.events.InternalGridServiceContainerRemovedEventManager;
import org.openspaces.admin.pu.elastic.events.ElasticProcessingUnitEvent;

public class DefaultGridServiceContainers
implements InternalGridServiceContainers {
    private final InternalAdmin admin;
    private final Map<String, GridServiceContainer> containers = new SizeConcurrentHashMap();
    private final InternalGridServiceContainerAddedEventManager gridServiceContainerAddedEventManager;
    private final InternalGridServiceContainerRemovedEventManager gridServiceContainerRemovedEventManager;
    private final InternalElasticGridServiceContainerProvisioningFailureEventManager elasticGridServiceContainerProvisioningFailureEventManager;
    private final InternalElasticGridServiceContainerProvisioningProgressChangedEventManager elasticGridServiceContainerProvisioningProgressChangedEventManager;

    public DefaultGridServiceContainers(InternalAdmin admin) {
        this.admin = admin;
        this.gridServiceContainerAddedEventManager = new DefaultGridServiceContainerAddedEventManager(this);
        this.gridServiceContainerRemovedEventManager = new DefaultGridServiceContainerRemovedEventManager(this);
        this.elasticGridServiceContainerProvisioningFailureEventManager = new DefaultElasticGridServiceContainerProvisioningFailureEventManager(admin);
        this.elasticGridServiceContainerProvisioningProgressChangedEventManager = new DefaultElasticGridServiceContainerProvisioningProgressChangedEventManager(admin);
    }

    @Override
    public Admin getAdmin() {
        return this.admin;
    }

    @Override
    public GridServiceContainerAddedEventManager getGridServiceContainerAdded() {
        return this.gridServiceContainerAddedEventManager;
    }

    @Override
    public GridServiceContainerRemovedEventManager getGridServiceContainerRemoved() {
        return this.gridServiceContainerRemovedEventManager;
    }

    @Override
    public GridServiceContainer[] getContainers() {
        return this.containers.values().toArray(new GridServiceContainer[0]);
    }

    @Override
    public GridServiceContainer getContainerByUID(String uid) {
        return this.containers.get(uid);
    }

    @Override
    public Map<String, GridServiceContainer> getUids() {
        return Collections.unmodifiableMap(this.containers);
    }

    @Override
    public int getSize() {
        return this.containers.size();
    }

    @Override
    public boolean isEmpty() {
        return this.containers.isEmpty();
    }

    @Override
    public boolean waitFor(int numberOfGridServiceContainers) {
        return this.waitFor(numberOfGridServiceContainers, this.admin.getDefaultTimeout(), this.admin.getDefaultTimeoutTimeUnit());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean waitFor(int numberOfGridServiceContainers, long timeout, TimeUnit timeUnit) {
        if (numberOfGridServiceContainers == 0) {
            final CountDownLatch latch = new CountDownLatch(this.getSize());
            GridServiceContainerRemovedEventListener removed = new GridServiceContainerRemovedEventListener(){

                @Override
                public void gridServiceContainerRemoved(GridServiceContainer gridServiceContainer) {
                    latch.countDown();
                }
            };
            this.getGridServiceContainerRemoved().add(removed);
            try {
                boolean bl = latch.await(timeout, timeUnit);
                return bl;
            }
            catch (InterruptedException e) {
                boolean bl = false;
                return bl;
            }
            finally {
                this.getGridServiceContainerRemoved().remove(removed);
            }
        }
        final CountDownLatch latch = new CountDownLatch(numberOfGridServiceContainers);
        GridServiceContainerAddedEventListener added = new GridServiceContainerAddedEventListener(){

            @Override
            public void gridServiceContainerAdded(GridServiceContainer gridServiceContainer) {
                latch.countDown();
            }
        };
        this.getGridServiceContainerAdded().add(added);
        try {
            boolean e = latch.await(timeout, timeUnit);
            return e;
        }
        catch (InterruptedException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            this.getGridServiceContainerAdded().remove(added);
        }
    }

    @Override
    public void addLifecycleListener(GridServiceContainerLifecycleEventListener eventListener) {
        this.getGridServiceContainerAdded().add(eventListener);
        this.getGridServiceContainerRemoved().add(eventListener);
    }

    @Override
    public void removeLifecycleListener(GridServiceContainerLifecycleEventListener eventListener) {
        this.getGridServiceContainerAdded().remove(eventListener);
        this.getGridServiceContainerRemoved().remove(eventListener);
    }

    @Override
    public Iterator<GridServiceContainer> iterator() {
        return Collections.unmodifiableCollection(this.containers.values()).iterator();
    }

    @Override
    public void addGridServiceContainer(InternalGridServiceContainer gridServiceContainer) {
        this.assertStateChangesPermitted();
        GridServiceContainer existingGSC = this.containers.put(gridServiceContainer.getUid(), gridServiceContainer);
        if (existingGSC == null) {
            this.gridServiceContainerAddedEventManager.gridServiceContainerAdded(gridServiceContainer);
        }
    }

    @Override
    public InternalGridServiceContainer removeGridServiceContainer(String uid) {
        this.assertStateChangesPermitted();
        InternalGridServiceContainer existingGSC = (InternalGridServiceContainer)this.containers.remove(uid);
        if (existingGSC != null) {
            this.gridServiceContainerRemovedEventManager.gridServiceContainerRemoved(existingGSC);
        }
        return existingGSC;
    }

    @Override
    public DumpResult generateDump(String cause, Map<String, Object> context) throws AdminException {
        return this.generateDump(cause, context, null);
    }

    @Override
    public DumpResult generateDump(String cause, Map<String, Object> context, String ... processor) throws AdminException {
        CompoundDumpResult dumpResult = new CompoundDumpResult();
        for (GridServiceContainer gsc : this) {
            dumpResult.add(gsc.generateDump(cause, context, processor));
        }
        return dumpResult;
    }

    private void assertStateChangesPermitted() {
        this.admin.assertStateChangesPermitted();
    }

    @Override
    public ElasticGridServiceContainerProvisioningFailureEventManager getElasticGridServiceContainerProvisioningFailure() {
        return this.elasticGridServiceContainerProvisioningFailureEventManager;
    }

    @Override
    public ElasticGridServiceContainerProvisioningProgressChangedEventManager getElasticGridServiceContainerProvisioningProgressChanged() {
        return this.elasticGridServiceContainerProvisioningProgressChangedEventManager;
    }

    @Override
    public void processElasticScaleStrategyEvent(ElasticProcessingUnitEvent event) {
        if (event instanceof ElasticGridServiceContainerProvisioningFailureEvent) {
            this.elasticGridServiceContainerProvisioningFailureEventManager.elasticGridServiceContainerProvisioningFailure((ElasticGridServiceContainerProvisioningFailureEvent)event);
        } else if (event instanceof ElasticGridServiceContainerProvisioningProgressChangedEvent) {
            this.elasticGridServiceContainerProvisioningProgressChangedEventManager.elasticGridServiceContainerProvisioningProgressChanged((ElasticGridServiceContainerProvisioningProgressChangedEvent)event);
        }
    }
}

