/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.admin.internal.gsc.events;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.openspaces.admin.gsc.GridServiceContainer;
import org.openspaces.admin.gsc.events.GridServiceContainerAddedEventListener;
import org.openspaces.admin.internal.admin.InternalAdmin;
import org.openspaces.admin.internal.gsc.InternalGridServiceContainers;
import org.openspaces.admin.internal.gsc.events.ClosureGridServiceContainerAddedEventListener;
import org.openspaces.admin.internal.gsc.events.InternalGridServiceContainerAddedEventManager;
import org.openspaces.admin.internal.support.GroovyHelper;

public class DefaultGridServiceContainerAddedEventManager
implements InternalGridServiceContainerAddedEventManager {
    private final InternalGridServiceContainers gridServiceContainers;
    private final InternalAdmin admin;
    private final List<GridServiceContainerAddedEventListener> listeners = new CopyOnWriteArrayList<GridServiceContainerAddedEventListener>();

    public DefaultGridServiceContainerAddedEventManager(InternalGridServiceContainers gridServiceContainers) {
        this.gridServiceContainers = gridServiceContainers;
        this.admin = (InternalAdmin)gridServiceContainers.getAdmin();
    }

    @Override
    public void gridServiceContainerAdded(final GridServiceContainer gridServiceContainer) {
        for (final GridServiceContainerAddedEventListener listener : this.listeners) {
            this.admin.pushEvent(listener, new Runnable(){

                @Override
                public void run() {
                    listener.gridServiceContainerAdded(gridServiceContainer);
                }
            });
        }
    }

    @Override
    public void add(final GridServiceContainerAddedEventListener eventListener, boolean includeExisting) {
        if (includeExisting) {
            this.admin.raiseEvent(eventListener, new Runnable(){

                @Override
                public void run() {
                    for (GridServiceContainer gridServiceContainer : DefaultGridServiceContainerAddedEventManager.this.gridServiceContainers) {
                        eventListener.gridServiceContainerAdded(gridServiceContainer);
                    }
                }
            });
        }
        this.listeners.add(eventListener);
    }

    @Override
    public void add(GridServiceContainerAddedEventListener eventListener) {
        this.add(eventListener, true);
    }

    @Override
    public void remove(GridServiceContainerAddedEventListener eventListener) {
        this.listeners.remove(eventListener);
    }

    public void plus(Object eventListener) {
        if (GroovyHelper.isClosure(eventListener)) {
            this.add(new ClosureGridServiceContainerAddedEventListener(eventListener));
        } else {
            this.add((GridServiceContainerAddedEventListener)eventListener);
        }
    }

    public void leftShift(Object eventListener) {
        this.plus(eventListener);
    }

    public void minus(Object eventListener) {
        if (GroovyHelper.isClosure(eventListener)) {
            this.remove(new ClosureGridServiceContainerAddedEventListener(eventListener));
        } else {
            this.remove((GridServiceContainerAddedEventListener)eventListener);
        }
    }

    public void rightShift(Object eventListener) {
        this.minus(eventListener);
    }
}

