/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.admin.internal.gsc.events;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.openspaces.admin.gsc.GridServiceContainer;
import org.openspaces.admin.gsc.events.GridServiceContainerRemovedEventListener;
import org.openspaces.admin.internal.admin.InternalAdmin;
import org.openspaces.admin.internal.gsc.InternalGridServiceContainers;
import org.openspaces.admin.internal.gsc.events.ClosureGridServiceContainerRemovedEventListener;
import org.openspaces.admin.internal.gsc.events.InternalGridServiceContainerRemovedEventManager;
import org.openspaces.admin.internal.support.GroovyHelper;

public class DefaultGridServiceContainerRemovedEventManager
implements InternalGridServiceContainerRemovedEventManager {
    private final InternalGridServiceContainers gridServiceContainers;
    private final InternalAdmin admin;
    private final List<GridServiceContainerRemovedEventListener> listeners = new CopyOnWriteArrayList<GridServiceContainerRemovedEventListener>();

    public DefaultGridServiceContainerRemovedEventManager(InternalGridServiceContainers gridServiceContainers) {
        this.gridServiceContainers = gridServiceContainers;
        this.admin = (InternalAdmin)gridServiceContainers.getAdmin();
    }

    @Override
    public void gridServiceContainerRemoved(final GridServiceContainer gridServiceContainer) {
        for (final GridServiceContainerRemovedEventListener listener : this.listeners) {
            this.admin.pushEvent(listener, new Runnable(){

                @Override
                public void run() {
                    listener.gridServiceContainerRemoved(gridServiceContainer);
                }
            });
        }
    }

    @Override
    public void add(GridServiceContainerRemovedEventListener eventListener) {
        this.listeners.add(eventListener);
    }

    @Override
    public void remove(GridServiceContainerRemovedEventListener eventListener) {
        this.listeners.remove(eventListener);
    }

    public void plus(Object eventListener) {
        if (GroovyHelper.isClosure(eventListener)) {
            this.add(new ClosureGridServiceContainerRemovedEventListener(eventListener));
        } else {
            this.add((GridServiceContainerRemovedEventListener)eventListener);
        }
    }

    public void leftShift(Object eventListener) {
        this.plus(eventListener);
    }

    public void minus(Object eventListener) {
        if (GroovyHelper.isClosure(eventListener)) {
            this.remove(new ClosureGridServiceContainerRemovedEventListener(eventListener));
        } else {
            this.remove((GridServiceContainerRemovedEventListener)eventListener);
        }
    }

    public void rightShift(Object eventListener) {
        this.minus(eventListener);
    }
}

