/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.admin.internal.gsm;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.grid.gsm.GSM;
import com.gigaspaces.internal.dump.InternalDumpProvider;
import com.gigaspaces.internal.jvm.JVMDetails;
import com.gigaspaces.internal.jvm.JVMStatistics;
import com.gigaspaces.internal.os.OSDetails;
import com.gigaspaces.internal.os.OSStatistics;
import com.gigaspaces.internal.quiesce.InternalQuiesceDetails;
import com.gigaspaces.internal.quiesce.InternalQuiesceRequest;
import com.gigaspaces.internal.utils.StringUtils;
import com.gigaspaces.log.LogEntries;
import com.gigaspaces.log.LogEntryMatcher;
import com.gigaspaces.log.LogProcessType;
import com.gigaspaces.lrmi.LRMIMonitoringDetails;
import com.gigaspaces.lrmi.nio.info.NIODetails;
import com.gigaspaces.lrmi.nio.info.NIOStatistics;
import com.gigaspaces.security.SecurityException;
import com.gigaspaces.security.directory.User;
import com.gigaspaces.security.directory.UserDetails;
import com.gigaspaces.start.SystemInfo;
import com.gigaspaces.start.manager.XapManagerClusterInfo;
import com.gigaspaces.start.manager.XapManagerConfig;
import com.gigaspaces.time.SystemTime;
import com.j_spaces.kernel.JSpaceUtilities;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import net.jini.core.discovery.LookupLocator;
import net.jini.core.lookup.ServiceID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jini.rio.core.OperationalString;
import org.jini.rio.monitor.ProvisionMonitorAdmin;
import org.jini.rio.monitor.event.Events;
import org.openspaces.admin.AdminAware;
import org.openspaces.admin.AdminException;
import org.openspaces.admin.GridComponent;
import org.openspaces.admin.application.Application;
import org.openspaces.admin.application.ApplicationAlreadyDeployedException;
import org.openspaces.admin.application.ApplicationDeployment;
import org.openspaces.admin.application.config.ApplicationConfig;
import org.openspaces.admin.dump.DumpResult;
import org.openspaces.admin.gsc.GridServiceContainer;
import org.openspaces.admin.gsm.GridServiceManager;
import org.openspaces.admin.internal.admin.InternalAdmin;
import org.openspaces.admin.internal.dump.InternalDumpResult;
import org.openspaces.admin.internal.esm.InternalElasticServiceManager;
import org.openspaces.admin.internal.gsc.InternalGridServiceContainer;
import org.openspaces.admin.internal.gsm.InternalGridServiceManager;
import org.openspaces.admin.internal.pu.InternalProcessingUnitInstance;
import org.openspaces.admin.internal.support.AbstractAgentGridComponent;
import org.openspaces.admin.internal.support.NetworkExceptionHelper;
import org.openspaces.admin.memcached.MemcachedDeployment;
import org.openspaces.admin.pu.ProcessingUnit;
import org.openspaces.admin.pu.ProcessingUnitAlreadyDeployedException;
import org.openspaces.admin.pu.ProcessingUnitDeployment;
import org.openspaces.admin.pu.ProcessingUnitInstance;
import org.openspaces.admin.pu.config.ProcessingUnitConfig;
import org.openspaces.admin.pu.config.UserDetailsConfig;
import org.openspaces.admin.pu.elastic.ElasticStatefulProcessingUnitDeployment;
import org.openspaces.admin.pu.elastic.ElasticStatelessProcessingUnitDeployment;
import org.openspaces.admin.pu.elastic.config.ScaleStrategyConfig;
import org.openspaces.admin.pu.events.ProcessingUnitAddedEventListener;
import org.openspaces.admin.pu.events.ProcessingUnitRemovedEventListener;
import org.openspaces.admin.pu.topology.ElasticStatefulProcessingUnitConfigHolder;
import org.openspaces.admin.pu.topology.ProcessingUnitConfigHolder;
import org.openspaces.admin.pu.topology.ProcessingUnitDeploymentTopology;
import org.openspaces.admin.quiesce.QuiesceDetails;
import org.openspaces.admin.quiesce.QuiesceRequest;
import org.openspaces.admin.space.ElasticSpaceDeployment;
import org.openspaces.admin.space.SpaceDeployment;
import org.openspaces.admin.space.SpaceInstance;
import org.openspaces.core.util.FileUtils;
import org.openspaces.pu.container.servicegrid.deploy.Deploy;
import org.openspaces.pu.container.support.BeanLevelPropertiesParser;

public class DefaultGridServiceManager
extends AbstractAgentGridComponent
implements InternalGridServiceManager {
    private static final Log logger = LogFactory.getLog(DefaultGridServiceManager.class);
    private final ServiceID serviceID;
    private final GSM gsm;
    private final ProvisionMonitorAdmin gsmAdmin;
    private long eventsCursor = 0L;
    private final Collection<XapManagerConfig> xapManagerConfigs;

    public DefaultGridServiceManager(ServiceID serviceID, GSM gsm, InternalAdmin admin, int agentId, String agentUid, JVMDetails jvmDetails) throws RemoteException {
        super(admin, agentId, agentUid, jvmDetails);
        this.serviceID = serviceID;
        this.gsm = gsm;
        this.gsmAdmin = (ProvisionMonitorAdmin)gsm.getAdmin();
        String managerServers = (String)jvmDetails.getEnvironmentVariables().get("XAP_MANAGER_SERVERS");
        this.xapManagerConfigs = XapManagerClusterInfo.parseServersEnvVar((String)managerServers);
    }

    @Override
    public String getUid() {
        return this.serviceID.toString();
    }

    @Override
    public ServiceID getServiceID() {
        return this.serviceID;
    }

    @Override
    public GSM getGSM() {
        return this.gsm;
    }

    @Override
    public ProvisionMonitorAdmin getGSMAdmin() {
        return this.gsmAdmin;
    }

    @Override
    public ProcessingUnit deploy(SpaceDeployment deployment) {
        return this.deploy(deployment, this.admin.getDefaultTimeout(), this.admin.getDefaultTimeoutTimeUnit());
    }

    @Override
    public ProcessingUnit deploy(SpaceDeployment deployment, long timeout, TimeUnit timeUnit) {
        return this.deploy(deployment.create(), timeout, timeUnit);
    }

    @Override
    public ProcessingUnit deploy(ProcessingUnitDeployment deployment) {
        return this.deploy(deployment, this.admin.getDefaultTimeout(), this.admin.getDefaultTimeoutTimeUnit());
    }

    @Override
    public ProcessingUnit deploy(MemcachedDeployment deployment) {
        return this.deploy(deployment, this.admin.getDefaultTimeout(), this.admin.getDefaultTimeoutTimeUnit());
    }

    @Override
    public ProcessingUnit deploy(MemcachedDeployment deployment, long timeout, TimeUnit timeUnit) {
        return this.deploy(deployment.create(), timeout, timeUnit);
    }

    @Override
    public ProcessingUnit deploy(ProcessingUnitDeployment deployment, long timeout, TimeUnit timeUnit) {
        String applicationName = null;
        return this.deploy(deployment, applicationName, timeout, timeUnit);
    }

    private ProcessingUnit deploy(ProcessingUnitDeployment deployment, String applicationName, long timeout, TimeUnit timeUnit) {
        return this.deploy(deployment.create(), applicationName, timeout, timeUnit);
    }

    @Override
    public ProcessingUnit deploy(ProcessingUnitConfigHolder puConfigHolder) {
        return this.deploy(puConfigHolder, this.admin.getDefaultTimeout(), this.admin.getDefaultTimeoutTimeUnit());
    }

    @Override
    public ProcessingUnit deploy(ProcessingUnitConfigHolder puConfigHolder, long timeout, TimeUnit timeUnit) {
        String applicationName = null;
        return this.deploy(puConfigHolder, applicationName, timeout, timeUnit);
    }

    private ProcessingUnit deploy(ProcessingUnitConfigHolder puConfigHolder, String applicationName, long timeout, TimeUnit timeUnit) {
        return this.deploy(this.toProcessingUnitConfig(puConfigHolder), applicationName, timeout, timeUnit);
    }

    @InternalApi
    public static OperationalString toOperationalString(Properties p) throws Exception {
        ProcessingUnitDeploymentTopology deployment;
        String name = p.getProperty("name");
        int partitions = Integer.parseInt(p.getProperty("partitions", "0"));
        int instances = Integer.parseInt(p.getProperty("instances", "0"));
        String schema = p.getProperty("schema");
        boolean ha = Boolean.parseBoolean(p.getProperty("ha", "false"));
        int backups = ha ? 1 : 0;
        String puResource = p.getProperty("pu.resourceUrl");
        String puProperties = p.getProperty("pu.properties");
        if (instances == 0) {
            instances = 1;
        }
        if (puResource != null && !puResource.isEmpty()) {
            ProcessingUnitDeployment processingUnitDeployment = new ProcessingUnitDeployment(puResource).name(name);
            if (partitions > 0) {
                processingUnitDeployment.partitioned(partitions, backups);
            } else {
                processingUnitDeployment.numberOfInstances(instances);
                if (schema != null && !schema.isEmpty()) {
                    processingUnitDeployment.clusterSchema(schema);
                }
            }
            deployment = processingUnitDeployment;
        } else {
            SpaceDeployment spaceDeployment = new SpaceDeployment(name);
            if (partitions > 0) {
                spaceDeployment.partitioned(partitions, backups);
            } else {
                spaceDeployment.numberOfInstances(instances);
                if (schema != null && !schema.isEmpty()) {
                    spaceDeployment.clusterSchema(schema);
                }
            }
            deployment = spaceDeployment;
        }
        ProcessingUnitConfig processingUnitConfig = deployment.create().toProcessingUnitConfig();
        if (puProperties != null && !puProperties.isEmpty()) {
            HashMap<String, String> paramsMap = new HashMap<String, String>();
            BeanLevelPropertiesParser.loadParams((String)puProperties, paramsMap);
            processingUnitConfig.addContextProperties(paramsMap);
        }
        String[] groups = SystemInfo.singleton().lookup().groupsArray();
        LookupLocator[] locators = SystemInfo.singleton().lookup().locatorsArray();
        return DefaultGridServiceManager.toOperationalString(new Deploy().disableGSM(), processingUnitConfig, null, groups, locators, null);
    }

    private static OperationalString toOperationalString(Deploy deploy, ProcessingUnitConfig puConfig, String applicationName, String[] groups, LookupLocator[] locators, GSM gsm) throws Exception {
        UserDetailsConfig userDetailsConfig;
        Deploy.setDisableInfoLogging(true);
        deploy.setGroups(groups);
        StringBuilder locatorsString = new StringBuilder();
        for (LookupLocator locator : locators) {
            locatorsString.append(locator).append(',');
        }
        deploy.setLocators(locatorsString.toString());
        deploy.initializeDiscovery(gsm);
        if (puConfig.getSecured() != null) {
            deploy.setSecured(puConfig.getSecured());
        }
        if ((userDetailsConfig = puConfig.getUserDetails()) != null) {
            deploy.setUserDetails((UserDetails)new User(userDetailsConfig.getUsername(), userDetailsConfig.getPassword()));
        }
        deploy.setApplicationName(applicationName);
        return deploy.buildOperationalString(puConfig.toDeploymentOptions());
    }

    private ProcessingUnit deploy(ProcessingUnitConfig puConfig, String applicationName, long timeout, TimeUnit timeUnit) {
        OperationalString operationalString;
        long end = SystemTime.timeMillis() + timeUnit.toMillis(timeout);
        try {
            operationalString = DefaultGridServiceManager.toOperationalString(new Deploy(), puConfig, applicationName, this.getAdmin().getGroups(), this.getAdmin().getLocators(), this.gsm);
        }
        catch (Exception e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Failed building deployment of [" + puConfig.getProcessingUnit() + "] "), (Throwable)e);
            }
            throw new AdminException("Failed building deployment of [" + puConfig.getProcessingUnit() + "]", e);
        }
        boolean alreadyDeployed = false;
        try {
            alreadyDeployed = this.getGSMAdmin().hasDeployed(operationalString.getName());
        }
        catch (Exception e) {
            throw new AdminException("Failed to check if processing unit [" + operationalString.getName() + "] is deployed", e);
        }
        if (alreadyDeployed) {
            throw new ProcessingUnitAlreadyDeployedException(operationalString.getName());
        }
        final AtomicReference ref = new AtomicReference();
        final CountDownLatch latch = new CountDownLatch(1);
        ProcessingUnitAddedEventListener added = new ProcessingUnitAddedEventListener(){

            @Override
            public void processingUnitAdded(ProcessingUnit processingUnit) {
                if (operationalString.getName().equals(processingUnit.getName())) {
                    ref.set(processingUnit);
                    latch.countDown();
                }
            }
        };
        this.getAdmin().getProcessingUnits().getProcessingUnitAdded().add(added);
        ProcessingUnit pu = null;
        try {
            this.getGSMAdmin().deploy(operationalString);
            latch.await(timeout, timeUnit);
            pu = (ProcessingUnit)ref.get();
        }
        catch (SecurityException se) {
            throw new AdminException("No privileges to deploy a processing unit", se);
        }
        catch (Exception e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Failed to deploy [" + puConfig.getProcessingUnit() + "]"), (Throwable)e);
            }
            throw new AdminException("Failed to deploy [" + puConfig.getProcessingUnit() + "]", e);
        }
        finally {
            Deploy.setDisableInfoLogging(false);
            this.getAdmin().getProcessingUnits().getProcessingUnitAdded().remove(added);
        }
        if (!puConfig.getElasticProperties().isEmpty()) {
            InternalGridServiceManager gridServiceManager;
            while (!(SystemTime.timeMillis() >= end || (gridServiceManager = (InternalGridServiceManager)pu.getManagingGridServiceManager()) != null && gridServiceManager.isManagedByElasticServiceManager(pu))) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    break;
                }
            }
        }
        return pu;
    }

    @Override
    public void undeploy(String processingUnitName) {
        this.undeployProcessingUnit(processingUnitName);
    }

    @Override
    public void undeployProcessingUnit(String processingUnitName) {
        try {
            this.getGSMAdmin().undeploy(processingUnitName);
        }
        catch (SecurityException se) {
            throw new AdminException("No privileges to undeploy a processing unit", se);
        }
        catch (Exception e) {
            throw new AdminException("Failed to undeploy processing unit [" + processingUnitName + "]", e);
        }
        for (GridServiceManager manager : this.admin.getGridServiceManagers()) {
            if (manager == this) continue;
            try {
                ((InternalGridServiceManager)manager).getGSMAdmin().removeUndeployed(processingUnitName);
            }
            catch (Exception exception) {}
        }
        if (!SystemInfo.singleton().getManagerClusterInfo().isEmpty() && SystemInfo.singleton().getManagerClusterInfo().getServers().length > this.admin.getGridServiceManagers().getSize()) {
            logger.warn((Object)("Some managers may not be available, and the undeployment process of [" + processingUnitName + "] may not succeed."));
        }
    }

    @Override
    public void destroyInstance(ProcessingUnitInstance processingUnitInstance) {
        block3: {
            try {
                this.gsm.destroy(processingUnitInstance.getProcessingUnit().getName(), ((InternalProcessingUnitInstance)processingUnitInstance).getServiceID());
            }
            catch (SecurityException se) {
                throw new AdminException("No privileges to destroy a processing unit instance", se);
            }
            catch (Exception e) {
                if (NetworkExceptionHelper.isConnectOrCloseException(e)) break block3;
                throw new AdminException("Failed to destroy processing unit instance", e);
            }
        }
    }

    @Override
    public boolean decrementPlannedInstances(ProcessingUnit processingUnit) {
        if (!processingUnit.canDecrementInstance()) {
            throw new AdminException("Processing unit does not allow to decrement instances on it");
        }
        try {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Decrementing planned instance if pending of " + processingUnit.getName()));
            }
            return this.gsm.decrementPlannedIfPending(processingUnit.getName());
        }
        catch (SecurityException se) {
            throw new AdminException("No privileges to decrement a processing unit instance", se);
        }
        catch (Exception e) {
            if (NetworkExceptionHelper.isConnectOrCloseException(e)) {
                return true;
            }
            throw new AdminException("Failed to decrement processing unit instance", e);
        }
    }

    @Override
    public void decrementInstance(ProcessingUnitInstance processingUnitInstance) {
        block5: {
            if (!processingUnitInstance.getProcessingUnit().canDecrementInstance()) {
                throw new AdminException("Processing unit does not allow to decrement instances on it");
            }
            try {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Decrementing instance " + ((InternalProcessingUnitInstance)processingUnitInstance).getServiceID() + " of " + processingUnitInstance.getProcessingUnit().getName()));
                }
                this.gsm.decrement(processingUnitInstance.getProcessingUnit().getName(), ((InternalProcessingUnitInstance)processingUnitInstance).getServiceID(), true);
            }
            catch (SecurityException se) {
                throw new AdminException("No privileges to decrement a processing unit instance", se);
            }
            catch (Exception e) {
                if (NetworkExceptionHelper.isConnectOrCloseException(e)) break block5;
                throw new AdminException("Failed to destroy processing unit instance", e);
            }
        }
    }

    @Override
    public void incrementInstance(ProcessingUnit processingUnit) {
        block5: {
            if (!processingUnit.canIncrementInstance()) {
                throw new AdminException("Processing unit does not allow to increment instances on it");
            }
            try {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Incrementing instance of " + processingUnit.getName()));
                }
                this.gsm.increment(processingUnit.getName(), null);
            }
            catch (SecurityException se) {
                throw new AdminException("No privileges to increment a processing unit instance", se);
            }
            catch (Exception e) {
                if (NetworkExceptionHelper.isConnectOrCloseException(e)) break block5;
                throw new AdminException("Failed to increment processing unit instance", e);
            }
        }
    }

    @Override
    public void relocate(ProcessingUnitInstance processingUnitInstance, GridServiceContainer gridServiceContainer) {
        try {
            this.gsm.relocate(processingUnitInstance.getProcessingUnit().getName(), ((InternalProcessingUnitInstance)processingUnitInstance).getServiceID(), gridServiceContainer == null ? null : ((InternalGridServiceContainer)gridServiceContainer).getServiceID(), null);
        }
        catch (SecurityException se) {
            throw new AdminException("No privileges to relocate a processing unit instance " + processingUnitInstance.getProcessingUnitInstanceName(), se);
        }
        catch (Exception e) {
            String gsc = "GSC-" + gridServiceContainer.getAgentId() + "[" + gridServiceContainer.getVirtualMachine().getDetails().getPid() + "]@" + gridServiceContainer.getMachine().getHostName();
            throw new AdminException("Failed to relocate processing unit instance " + processingUnitInstance.getProcessingUnitInstanceName() + " to " + gsc, e);
        }
    }

    @Override
    public LogEntries logEntries(LogEntryMatcher matcher) throws AdminException {
        if (this.getGridServiceAgent() != null) {
            return this.getGridServiceAgent().logEntries(LogProcessType.GSM, this.getVirtualMachine().getDetails().getPid(), matcher);
        }
        return this.logEntriesDirect(matcher);
    }

    @Override
    public LogEntries logEntriesDirect(LogEntryMatcher matcher) throws AdminException {
        try {
            return this.gsm.logEntriesDirect(matcher);
        }
        catch (IOException e) {
            throw new AdminException("Failed to get log", e);
        }
    }

    @Override
    public void reloadMetricConfiguration() throws AdminException {
        try {
            this.gsm.reloadMetricConfiguration();
        }
        catch (RemoteException e) {
            throw new AdminException("Failed to reload metric configuration", e);
        }
    }

    @Override
    public DumpResult generateDump(String cause, Map<String, Object> context) throws AdminException {
        try {
            return new InternalDumpResult(this, (InternalDumpProvider)this.gsm, this.gsm.generateDump(cause, context));
        }
        catch (Exception e) {
            throw new AdminException("Failed to generate dump", e);
        }
    }

    @Override
    public DumpResult generateDump(String cause, Map<String, Object> context, String ... processors) throws AdminException {
        try {
            return new InternalDumpResult(this, (InternalDumpProvider)this.gsm, this.gsm.generateDump(cause, context, processors));
        }
        catch (Exception e) {
            throw new AdminException("Failed to generate dump", e);
        }
    }

    @Override
    public NIODetails getNIODetails() throws RemoteException {
        return this.gsm.getNIODetails();
    }

    @Override
    public NIOStatistics getNIOStatistics() throws RemoteException {
        return this.gsm.getNIOStatistics();
    }

    @Override
    public void enableLRMIMonitoring() throws RemoteException {
        this.gsm.enableLRMIMonitoring();
    }

    @Override
    public void disableLRMIMonitoring() throws RemoteException {
        this.gsm.disableLRMIMonitoring();
    }

    @Override
    public LRMIMonitoringDetails fetchLRMIMonitoringDetails() throws RemoteException {
        return this.gsm.fetchLRMIMonitoringDetails();
    }

    @Override
    public long getCurrentTimeInMillis() throws RemoteException {
        return this.gsm.getCurrentTimestamp();
    }

    @Override
    public OSDetails getOSDetails() throws RemoteException {
        return this.gsm.getOSDetails();
    }

    @Override
    public OSStatistics getOSStatistics() throws RemoteException {
        return this.gsm.getOSStatistics();
    }

    @Override
    public JVMStatistics getJVMStatistics() throws RemoteException {
        return this.gsm.getJVMStatistics();
    }

    @Override
    public void runGc() throws RemoteException {
        this.gsm.runGc();
    }

    @Override
    public String[] listDeployDir() {
        ArrayList<String> result = new ArrayList<String>();
        try {
            String line;
            String deployUrl = this.gsmAdmin.getDeployURL();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("deployUrl:" + deployUrl));
            }
            URL listPU = new URL(new URL(deployUrl), "list-pu");
            BufferedReader reader = new BufferedReader(new InputStreamReader(listPU.openStream()));
            while ((line = reader.readLine()) != null) {
                StringTokenizer tokenizer = new StringTokenizer(line, "\t");
                String puName = tokenizer.nextToken();
                result.add(puName);
            }
        }
        catch (IOException io) {
            throw new AdminException("Failed to retrieve processing units available under [GS ROOT]/deploy directory", io);
        }
        return result.toArray(new String[0]);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultGridServiceManager that = (DefaultGridServiceManager)o;
        return this.serviceID.equals((Object)that.serviceID);
    }

    public int hashCode() {
        return this.serviceID.hashCode();
    }

    @Override
    public boolean isDeployed(String processingUnitName) {
        try {
            return this.gsmAdmin.hasDeployed(processingUnitName);
        }
        catch (Exception e) {
            throw new AdminException("Failed to check if processing unit [" + processingUnitName + "] deployed", e);
        }
    }

    @Override
    public ProcessingUnit deploy(ElasticSpaceDeployment deployment) throws ProcessingUnitAlreadyDeployedException {
        return this.deploy(deployment.create(), this.admin.getDefaultTimeout(), this.admin.getDefaultTimeoutTimeUnit());
    }

    @Override
    public ProcessingUnit deploy(ElasticSpaceDeployment deployment, long timeout, TimeUnit timeUnit) throws ProcessingUnitAlreadyDeployedException {
        return this.deploy(deployment.create(), timeout, timeUnit);
    }

    @Override
    public ProcessingUnit deploy(ElasticStatefulProcessingUnitDeployment deployment) throws ProcessingUnitAlreadyDeployedException {
        return this.deploy(deployment, this.admin.getDefaultTimeout(), this.admin.getDefaultTimeoutTimeUnit());
    }

    @Override
    public ProcessingUnit deploy(ElasticStatefulProcessingUnitDeployment deployment, long timeout, TimeUnit timeUnit) throws ProcessingUnitAlreadyDeployedException {
        return this.deploy(deployment.create(), timeout, timeUnit);
    }

    @Override
    public ProcessingUnit deploy(ElasticStatelessProcessingUnitDeployment deployment) throws ProcessingUnitAlreadyDeployedException {
        return this.deploy(deployment, this.admin.getDefaultTimeout(), this.admin.getDefaultTimeoutTimeUnit());
    }

    @Override
    public ProcessingUnit deploy(ElasticStatelessProcessingUnitDeployment deployment, long timeout, TimeUnit timeUnit) throws ProcessingUnitAlreadyDeployedException {
        return this.deploy(deployment.create(), timeout, timeUnit);
    }

    @Override
    public void setProcessingUnitElasticProperties(ProcessingUnit pu, Map<String, String> properties) {
        this.getElasticServiceManager().setProcessingUnitElasticProperties(pu, properties);
    }

    @Override
    public void setProcessingUnitScaleStrategyConfig(ProcessingUnit pu, ScaleStrategyConfig scaleStrategyConfig) {
        this.getElasticServiceManager().setProcessingUnitScaleStrategyConfig(pu, scaleStrategyConfig);
    }

    @Override
    public void updateProcessingUnitElasticPropertiesOnGsm(ProcessingUnit pu, Map<String, String> elasticProperties) {
        try {
            this.gsm.updateElasticProperties(pu.getName(), elasticProperties);
        }
        catch (Exception e) {
            throw new AdminException("Failed to update processing unit [" + pu.getName() + "] elastic properties state at the gsm", e);
        }
    }

    private InternalElasticServiceManager getElasticServiceManager() {
        if (this.admin.getElasticServiceManagers().getSize() != 1) {
            throw new AdminException("ElasticScaleHandler requires exactly one ESM server running.");
        }
        InternalElasticServiceManager esm = (InternalElasticServiceManager)this.admin.getElasticServiceManagers().getManagers()[0];
        return esm;
    }

    @Override
    public ScaleStrategyConfig getProcessingUnitScaleStrategyConfig(ProcessingUnit pu) {
        if (this.admin.getElasticServiceManagers().isEmpty()) {
            return null;
        }
        return this.getElasticServiceManager().getProcessingUnitScaleStrategyConfig(pu);
    }

    @Override
    public boolean isManagedByElasticServiceManager(ProcessingUnit pu) {
        if (this.admin.getElasticServiceManagers().isEmpty()) {
            return false;
        }
        return this.getElasticServiceManager().isManagingProcessingUnit(pu);
    }

    @Override
    public boolean isManagedByElasticServiceManagerAndScaleNotInProgress(ProcessingUnit pu) {
        if (this.admin.getElasticServiceManagers().isEmpty()) {
            return false;
        }
        return this.getElasticServiceManager().isManagingProcessingUnitAndScaleNotInProgress(pu);
    }

    @Override
    public Application deploy(ApplicationDeployment deployment) throws ApplicationAlreadyDeployedException, ProcessingUnitAlreadyDeployedException {
        return this.deploy(deployment, this.admin.getDefaultTimeout(), this.admin.getDefaultTimeoutTimeUnit());
    }

    @Override
    public Application deploy(ApplicationConfig applicationConfig) throws ApplicationAlreadyDeployedException, ProcessingUnitAlreadyDeployedException {
        return this.deploy(applicationConfig, this.admin.getDefaultTimeout(), this.admin.getDefaultTimeoutTimeUnit());
    }

    @Override
    public Application deploy(ApplicationDeployment applicationDeployment, long timeout, TimeUnit timeUnit) throws ApplicationAlreadyDeployedException, ProcessingUnitAlreadyDeployedException {
        return this.deploy(applicationDeployment.create(), timeout, timeUnit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Application deploy(ApplicationConfig applicationConfig, long timeout, TimeUnit timeUnit) throws ApplicationAlreadyDeployedException, ProcessingUnitAlreadyDeployedException {
        long end = SystemTime.timeMillis() + timeUnit.toMillis(timeout);
        String applicationName = applicationConfig.getName();
        if (applicationName == null) {
            throw new IllegalArgumentException("Application Name cannot be null");
        }
        if (applicationName.length() == 0) {
            throw new IllegalArgumentException("Application Name cannot be an empty string");
        }
        if (this.admin.getApplications().getApplication(applicationName) != null) {
            throw new ApplicationAlreadyDeployedException(applicationName);
        }
        ProcessingUnitConfigHolder[] processingUnitConfigHolders = applicationConfig.getProcessingUnits();
        if (processingUnitConfigHolders.length == 0) {
            throw new AdminException("Application must contain at least one processing unit.");
        }
        File tempDirectory = null;
        File jarsDirectory = applicationConfig.getJarsDirectoryOrZip();
        if (jarsDirectory != null && jarsDirectory.isFile()) {
            jarsDirectory = tempDirectory = FileUtils.unzipToTempFolder((File)applicationConfig.getJarsDirectoryOrZip());
        }
        try {
            boolean timedOut = false;
            HashSet<String> deployedPuNames = new HashSet<String>();
            for (ProcessingUnitConfigHolder puConfigHolder : processingUnitConfigHolders) {
                try {
                    ProcessingUnit pu;
                    boolean isAddDirectory;
                    long remaining = end - SystemTime.timeMillis();
                    if (remaining <= 0L) {
                        timedOut = true;
                        break;
                    }
                    ProcessingUnitConfig puConfig = this.toProcessingUnitConfig(puConfigHolder);
                    boolean isAbsolutePath = new File(puConfig.getProcessingUnit()).isAbsolute();
                    boolean isRelativeToGSHomedir = puConfig.getProcessingUnit().trim().startsWith("/");
                    boolean bl = isAddDirectory = !isAbsolutePath && !isRelativeToGSHomedir;
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("puConfig.getProcessingUnit()=" + puConfig.getProcessingUnit() + " isAbsolutePath=" + isAbsolutePath + " isRelativeToGSHomedir=" + isRelativeToGSHomedir + " isAddDirectory=" + isAddDirectory));
                    }
                    if (jarsDirectory != null && isAddDirectory) {
                        File jar = new File(jarsDirectory, puConfig.getProcessingUnit());
                        puConfig.setProcessingUnit(jar.getAbsolutePath());
                    }
                    if ((pu = this.deploy(puConfig, applicationName, remaining, TimeUnit.MILLISECONDS)) == null) {
                        timedOut = true;
                        break;
                    }
                    deployedPuNames.add(pu.getName());
                }
                catch (ProcessingUnitAlreadyDeployedException e) {
                    if (deployedPuNames.contains(e.getProcessingUnitName())) {
                        throw new AdminException("Application deployment contains two Processing Units with the same name " + e.getProcessingUnitName(), e);
                    }
                    ProcessingUnit otherPu = this.admin.getProcessingUnits().getProcessingUnit(e.getProcessingUnitName());
                    if (otherPu != null && otherPu.getApplication() != null && otherPu.getApplication().getName().equals(applicationName)) {
                        throw new ApplicationAlreadyDeployedException(applicationName, e);
                    }
                    throw e;
                }
            }
            if (timedOut) {
                Application application = null;
                return application;
            }
            Application application = this.admin.getApplications().getApplication(applicationName);
            return application;
        }
        finally {
            if (tempDirectory != null) {
                try {
                    FileUtils.deleteFileOrDirectory((File)tempDirectory);
                }
                catch (RuntimeException e) {
                    logger.warn((Object)("Failed to delete " + tempDirectory + " will attempt to delete on exit"), (Throwable)e);
                    tempDirectory.deleteOnExit();
                }
            }
        }
    }

    @Override
    public boolean isActiveManager() {
        try {
            return this.gsm.isManaging();
        }
        catch (RemoteException e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"isActiveManager() caught exception", (Throwable)e);
            }
            return false;
        }
    }

    @Override
    public boolean deleteResource(String resourceName) {
        try {
            return this.gsm.deleteResource(resourceName);
        }
        catch (RemoteException e) {
            return false;
        }
    }

    private ProcessingUnitConfig toProcessingUnitConfig(ProcessingUnitConfigHolder puConfigHolder) {
        if (puConfigHolder instanceof ElasticStatefulProcessingUnitConfigHolder) {
            ((ElasticStatefulProcessingUnitConfigHolder)puConfigHolder).setAdmin(this.admin);
        }
        ProcessingUnitConfig puConfig = puConfigHolder.toProcessingUnitConfig();
        return puConfig;
    }

    @Override
    public boolean undeployProcessingUnitsAndWait(ProcessingUnit[] processingUnits, long timeout, TimeUnit timeUnit) {
        try {
            this.undeployProcessingUnitsAndWaitInternal(processingUnits, timeout, timeUnit);
            return true;
        }
        catch (TimeoutException e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Failed undeploying processing units " + this.processingUnitsToString(processingUnits)), (Throwable)e);
            }
            return false;
        }
        catch (InterruptedException e) {
            throw new AdminException("Failed undeploying processing units " + this.processingUnitsToString(processingUnits), e);
        }
    }

    private String processingUnitsToString(ProcessingUnit[] processingUnits) {
        Object[] puNames = new String[processingUnits.length];
        for (int i = 0; i < processingUnits.length; ++i) {
            puNames[i] = processingUnits[i].getName();
        }
        return StringUtils.arrayToCommaDelimitedString((Object[])puNames);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void undeployProcessingUnitsAndWaitInternal(ProcessingUnit[] processingUnits, long timeout, TimeUnit timeUnit) throws TimeoutException, InterruptedException {
        long end = SystemTime.timeMillis() + timeUnit.toMillis(timeout);
        ArrayList<GridServiceContainer> containersPendingRemoval = new ArrayList<GridServiceContainer>();
        ArrayList<ProcessingUnitInstance> puInstancesPendingRemoval = new ArrayList<ProcessingUnitInstance>();
        ArrayList<SpaceInstance> spaceInstancesPendingRemoval = new ArrayList<SpaceInstance>();
        for (ProcessingUnit pu : processingUnits) {
            for (GridServiceContainer container : this.admin.getGridServiceContainers()) {
                ProcessingUnitInstance[] processingUnitInstances = container.getProcessingUnitInstances(pu.getName());
                if (processingUnitInstances.length <= 0) continue;
                puInstancesPendingRemoval.addAll(Arrays.asList(processingUnitInstances));
                for (ProcessingUnitInstance puInstance : processingUnitInstances) {
                    SpaceInstance spaceInstance = puInstance.getSpaceInstance();
                    if (spaceInstance == null) continue;
                    spaceInstancesPendingRemoval.add(spaceInstance);
                }
                if (!this.isManagedByElasticServiceManager(pu)) continue;
                containersPendingRemoval.add(container);
            }
        }
        final HashMap<String, CountDownLatch> latches = new HashMap<String, CountDownLatch>();
        for (ProcessingUnit pu : processingUnits) {
            latches.put(pu.getName(), new CountDownLatch(1));
        }
        ProcessingUnitRemovedEventListener listener = new ProcessingUnitRemovedEventListener(){

            @Override
            public void processingUnitRemoved(ProcessingUnit removedPu) {
                CountDownLatch latch = (CountDownLatch)latches.get(removedPu.getName());
                if (latch != null) {
                    latch.countDown();
                }
            }
        };
        this.admin.getProcessingUnits().getProcessingUnitRemoved().add(listener);
        try {
            for (final ProcessingUnit pu : processingUnits) {
                long gsmTimeout = end - SystemTime.timeMillis();
                if (gsmTimeout < 0L) {
                    throw new TimeoutException("Timeout expired before udeploying processing unit " + pu);
                }
                final InternalGridServiceManager managingGsm = (InternalGridServiceManager)pu.waitForManaged(gsmTimeout, TimeUnit.MILLISECONDS);
                if (managingGsm == null) {
                    throw new TimeoutException("Timeout expired while waiting for GSM that manages processing unit " + pu);
                }
                this.admin.scheduleAdminOperation(new Runnable(){

                    @Override
                    public void run() {
                        if (pu.isManaged()) {
                            pu.getManagingGridServiceManager().undeploy(pu.getName());
                        } else {
                            managingGsm.undeployProcessingUnit(pu.getName());
                        }
                    }
                });
            }
            for (final ProcessingUnit pu : processingUnits) {
                long puRemovedTimeout = end - SystemTime.timeMillis();
                if (puRemovedTimeout < 0L) {
                    throw new TimeoutException("Timeout expired before waiting for processing unit " + pu + " to undeploy");
                }
                if (((CountDownLatch)latches.get(pu.getName())).await(puRemovedTimeout, TimeUnit.MILLISECONDS)) continue;
                throw new TimeoutException("Timeout expired while waiting for processing unit " + pu + " to undeploy");
            }
        }
        finally {
            this.admin.getProcessingUnits().getProcessingUnitRemoved().remove(listener);
        }
        while (true) {
            try {
                this.verifyUndeployComplete(processingUnits);
                this.verifyNotDiscovered(puInstancesPendingRemoval);
                this.verifyNotDiscovered(spaceInstancesPendingRemoval);
                this.verifyNotDiscovered(containersPendingRemoval);
                this.verifyInstancesNotUndeploying(puInstancesPendingRemoval);
                this.verifyOrphanInstancesNotDeploying(processingUnits);
                this.verifyOrphanInstancesNotDeployed(processingUnits);
            }
            catch (TimeoutException e) {
                long sleepDuration = end - SystemTime.timeMillis();
                if (sleepDuration < 0L) {
                    if (System.getenv().containsKey("DEV_ENV")) {
                        logger.info((Object)("undeployProcessingUnitsAndWaitInternal: " + JSpaceUtilities.getStackTrace((Throwable)e)));
                    }
                    throw e;
                }
                Thread.sleep(Math.min(1000L, sleepDuration));
                continue;
            }
            break;
        }
    }

    private void verifyOrphanInstancesNotDeployed(ProcessingUnit[] processingUnits) throws TimeoutException {
        ProcessingUnitInstance[] orphanProcessingUnitInstances = this.admin.getOrphanProcessingUnitInstances();
        HashSet<String> puNames = new HashSet<String>();
        for (ProcessingUnit processingUnit : processingUnits) {
            puNames.add(processingUnit.getName());
        }
        for (AdminAware adminAware : orphanProcessingUnitInstances) {
            String puName = adminAware.getName();
            if (!puNames.contains(puName)) continue;
            throw new TimeoutException("Orphan instance still being deployed. " + adminAware.getProcessingUnitInstanceName());
        }
    }

    private void verifyOrphanInstancesNotDeploying(ProcessingUnit[] processingUnits) throws TimeoutException {
        try {
            for (ProcessingUnit pu : processingUnits) {
                if (!this.gsm.isOrphanInstancesBeingProvisioned(pu.getName())) continue;
                throw new TimeoutException(pu.getName() + " has orphan instances still being deployed.");
            }
        }
        catch (RemoteException e) {
            throw new AdminException("Failed to check with gsm if orphan instances are being provisioned or not", e);
        }
    }

    private void verifyInstancesNotUndeploying(List<ProcessingUnitInstance> instancesPendingRemoval) throws TimeoutException {
        for (ProcessingUnitInstance instance : instancesPendingRemoval) {
            if (!this.isProcessingUnitInstanceUndeploying(instance)) continue;
            throw new TimeoutException("Instance " + instance.getProcessingUnitInstanceName() + " UID=" + instance.getUid() + " is still undeploying.");
        }
    }

    private boolean isProcessingUnitInstanceUndeploying(ProcessingUnitInstance instance) {
        boolean isUndeploying = false;
        try {
            isUndeploying = ((InternalProcessingUnitInstance)instance).isUndeploying();
        }
        catch (AdminException adminException) {
            // empty catch block
        }
        return isUndeploying;
    }

    private void verifyUndeployComplete(ProcessingUnit[] processingUnits) throws TimeoutException {
        for (ProcessingUnit pu : processingUnits) {
            int numberOfInstances = pu.getInstances().length;
            if (numberOfInstances > 0) {
                throw new TimeoutException(pu.getName() + " is still undeploying " + numberOfInstances + " instances");
            }
            if (pu.getSpace() != null) {
                throw new TimeoutException(pu.getName() + " still has an embedded space");
            }
            if (!this.isManagedByElasticServiceManager(pu)) continue;
            throw new TimeoutException(pu.getName() + " undeployment is in progress (removing containers and machines if applicable)");
        }
    }

    private void verifyNotDiscovered(Iterable<? extends GridComponent> componentsPendingShutdown) throws TimeoutException {
        for (GridComponent gridComponent : componentsPendingShutdown) {
            if (!gridComponent.isDiscovered()) continue;
            throw new TimeoutException(gridComponent.getUid() + " is still discovered");
        }
    }

    @Override
    public ProcessingUnit deploy(Application application, ProcessingUnitDeploymentTopology deploymentTopology, long timeout, TimeUnit timeUnit) {
        ProcessingUnitConfigHolder configFactory = deploymentTopology.create();
        return this.deploy(configFactory, application.getName(), timeout, timeUnit);
    }

    @Override
    public String getCodeBaseURL() {
        try {
            return this.gsmAdmin.getDeployURL();
        }
        catch (RemoteException re) {
            throw new AdminException("Failed to retrieve codebase URL, A remote problem occurred.", re);
        }
    }

    @Override
    public Events getEvents(int maxEvents) {
        Events events = this.gsm.getEvents(this.eventsCursor, maxEvents);
        this.eventsCursor = events.getNextCursor();
        return events;
    }

    @Override
    public InternalQuiesceDetails quiesce(ProcessingUnit processingUnit, QuiesceRequest request) {
        try {
            return this.gsm.quiesce(processingUnit.getName(), new InternalQuiesceRequest(request.getDescription()));
        }
        catch (SecurityException se) {
            throw new AdminException("No privileges to execute quiesce on processing unit " + processingUnit.getName(), se);
        }
        catch (Exception e) {
            throw new AdminException("Failed to execute quiesce on " + processingUnit.getName(), e);
        }
    }

    @Override
    public void unquiesce(ProcessingUnit processingUnit, QuiesceRequest request) {
        try {
            this.gsm.unquiesce(processingUnit.getName(), new InternalQuiesceRequest(request.getDescription()));
        }
        catch (SecurityException se) {
            throw new AdminException("No privileges to execute quiesce on processing unit " + processingUnit.getName(), se);
        }
        catch (Exception e) {
            throw new AdminException("Failed to execute quiesce on " + processingUnit.getName(), e);
        }
    }

    @Override
    public QuiesceDetails getQuiesceDetails(ProcessingUnit processingUnit) {
        try {
            InternalQuiesceDetails quiesceDetails = this.gsm.getQuiesceDetails(processingUnit.getName());
            return new QuiesceDetails(quiesceDetails.getStatus(), quiesceDetails.getDescription(), quiesceDetails.getInstancesState());
        }
        catch (SecurityException se) {
            throw new AdminException("No privileges to request quiesceDetails on processing unit " + processingUnit.getName(), se);
        }
        catch (Exception e) {
            throw new AdminException("Failed to request quiesceDetails unit " + processingUnit.getName(), e);
        }
    }

    @Override
    public XapManagerConfig[] managersConfig() {
        return this.xapManagerConfigs.toArray(new XapManagerConfig[this.xapManagerConfigs.size()]);
    }
}

