/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.admin.internal.gsm;

import com.gigaspaces.internal.jvm.JVMDetails;
import com.gigaspaces.time.SystemTime;
import com.j_spaces.kernel.SizeConcurrentHashMap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.openspaces.admin.Admin;
import org.openspaces.admin.AdminException;
import org.openspaces.admin.application.Application;
import org.openspaces.admin.application.ApplicationAlreadyDeployedException;
import org.openspaces.admin.application.ApplicationDeployment;
import org.openspaces.admin.application.config.ApplicationConfig;
import org.openspaces.admin.dump.CompoundDumpResult;
import org.openspaces.admin.dump.DumpResult;
import org.openspaces.admin.gsm.GridServiceManager;
import org.openspaces.admin.gsm.events.GridServiceManagerAddedEventListener;
import org.openspaces.admin.gsm.events.GridServiceManagerAddedEventManager;
import org.openspaces.admin.gsm.events.GridServiceManagerLifecycleEventListener;
import org.openspaces.admin.gsm.events.GridServiceManagerRemovedEventListener;
import org.openspaces.admin.gsm.events.GridServiceManagerRemovedEventManager;
import org.openspaces.admin.internal.admin.InternalAdmin;
import org.openspaces.admin.internal.gsm.InternalGridServiceManager;
import org.openspaces.admin.internal.gsm.InternalGridServiceManagers;
import org.openspaces.admin.internal.gsm.events.DefaultGridServiceManagerAddedEventManager;
import org.openspaces.admin.internal.gsm.events.DefaultGridServiceManagerRemovedEventManager;
import org.openspaces.admin.internal.gsm.events.InternalGridServiceManagerAddedEventManager;
import org.openspaces.admin.internal.gsm.events.InternalGridServiceManagerRemovedEventManager;
import org.openspaces.admin.memcached.MemcachedDeployment;
import org.openspaces.admin.pu.ProcessingUnit;
import org.openspaces.admin.pu.ProcessingUnitAlreadyDeployedException;
import org.openspaces.admin.pu.ProcessingUnitDeployment;
import org.openspaces.admin.pu.elastic.ElasticStatefulProcessingUnitDeployment;
import org.openspaces.admin.pu.elastic.ElasticStatelessProcessingUnitDeployment;
import org.openspaces.admin.pu.topology.ProcessingUnitDeploymentTopology;
import org.openspaces.admin.space.ElasticSpaceDeployment;
import org.openspaces.admin.space.SpaceDeployment;
import org.openspaces.security.AdminFilterHelper;

public class DefaultGridServiceManagers
implements InternalGridServiceManagers {
    private final InternalAdmin admin;
    private final Map<String, GridServiceManager> gridServiceManagersByUID = new SizeConcurrentHashMap();
    private final InternalGridServiceManagerAddedEventManager gridServiceManagerAddedEventManager;
    private final InternalGridServiceManagerRemovedEventManager gridServiceManagerRemovedEventManager;

    public DefaultGridServiceManagers(InternalAdmin admin) {
        this.admin = admin;
        this.gridServiceManagerAddedEventManager = new DefaultGridServiceManagerAddedEventManager(this);
        this.gridServiceManagerRemovedEventManager = new DefaultGridServiceManagerRemovedEventManager(this);
    }

    @Override
    public Admin getAdmin() {
        return this.admin;
    }

    @Override
    public GridServiceManagerAddedEventManager getGridServiceManagerAdded() {
        return this.gridServiceManagerAddedEventManager;
    }

    @Override
    public GridServiceManagerRemovedEventManager getGridServiceManagerRemoved() {
        return this.gridServiceManagerRemovedEventManager;
    }

    @Override
    public GridServiceManager[] getManagers() {
        Collection<GridServiceManager> values = this.gridServiceManagersByUID.values();
        LinkedList<GridServiceManager> filteredManagers = new LinkedList<GridServiceManager>();
        for (GridServiceManager gsm : values) {
            if (!this.accept((InternalGridServiceManager)gsm)) continue;
            filteredManagers.add(gsm);
        }
        return filteredManagers.toArray(new GridServiceManager[filteredManagers.size()]);
    }

    @Override
    public GridServiceManager[] getManagersNonFiltered() {
        return this.gridServiceManagersByUID.values().toArray(new GridServiceManager[0]);
    }

    @Override
    public GridServiceManager getManagerByUID(String uid) {
        GridServiceManager gridServiceManager = this.gridServiceManagersByUID.get(uid);
        if (gridServiceManager != null && !this.accept((InternalGridServiceManager)gridServiceManager)) {
            gridServiceManager = null;
        }
        return gridServiceManager;
    }

    @Override
    public Map<String, GridServiceManager> getUids() {
        Set<Map.Entry<String, GridServiceManager>> entrySet = this.gridServiceManagersByUID.entrySet();
        HashMap<String, GridServiceManager> filteredManageresMap = new HashMap<String, GridServiceManager>();
        for (Map.Entry<String, GridServiceManager> entry : entrySet) {
            GridServiceManager gsm = entry.getValue();
            if (!this.accept((InternalGridServiceManager)gsm)) continue;
            filteredManageresMap.put(entry.getKey(), gsm);
        }
        return filteredManageresMap;
    }

    @Override
    public int getSize() {
        return this.getManagers().length;
    }

    @Override
    public boolean isEmpty() {
        return this.getSize() == 0;
    }

    @Override
    public GridServiceManager waitForAtLeastOne() {
        return this.waitForAtLeastOne(this.admin.getDefaultTimeout(), this.admin.getDefaultTimeoutTimeUnit());
    }

    @Override
    public GridServiceManager waitForActiveManager() {
        return this.waitForActiveManager(this.admin.getDefaultTimeout(), this.admin.getDefaultTimeoutTimeUnit());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public GridServiceManager waitForActiveManager(long timeout, TimeUnit timeUnit) {
        long endTime = SystemTime.timeMillis() + timeUnit.toMillis(timeout);
        while (true) {
            for (GridServiceManager manager : this.gridServiceManagersByUID.values()) {
                if (!manager.isActiveManager()) continue;
                return manager;
            }
            try {
                long duration = Math.min(1000L, endTime - SystemTime.timeMillis());
                if (duration <= 0L) {
                    return null;
                }
                Thread.sleep(duration);
            }
            catch (InterruptedException e) {
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GridServiceManager waitForAtLeastOne(long timeout, TimeUnit timeUnit) {
        GridServiceManager gsm = this.getGridServiceManager();
        if (gsm == null) {
            final CountDownLatch latch = new CountDownLatch(1);
            final AtomicReference ref = new AtomicReference();
            GridServiceManagerAddedEventListener added = new GridServiceManagerAddedEventListener(){

                @Override
                public void gridServiceManagerAdded(GridServiceManager gridServiceManager) {
                    ref.set(gridServiceManager);
                    latch.countDown();
                }
            };
            this.getGridServiceManagerAdded().add(added);
            try {
                latch.await(timeout, timeUnit);
                gsm = (GridServiceManager)ref.get();
            }
            catch (InterruptedException interruptedException) {
            }
            finally {
                this.getGridServiceManagerAdded().remove(added);
            }
        }
        return gsm;
    }

    @Override
    public boolean waitFor(int numberOfGridServiceManagers) {
        return this.waitFor(numberOfGridServiceManagers, this.admin.getDefaultTimeout(), this.admin.getDefaultTimeoutTimeUnit());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean waitFor(int numberOfGridServiceManagers, long timeout, TimeUnit timeUnit) {
        if (numberOfGridServiceManagers == 0) {
            final CountDownLatch latch = new CountDownLatch(this.getSize());
            GridServiceManagerRemovedEventListener removed = new GridServiceManagerRemovedEventListener(){

                @Override
                public void gridServiceManagerRemoved(GridServiceManager gridServiceManager) {
                    latch.countDown();
                }
            };
            this.getGridServiceManagerRemoved().add(removed);
            try {
                boolean bl = latch.await(timeout, timeUnit);
                return bl;
            }
            catch (InterruptedException e) {
                boolean bl = false;
                return bl;
            }
            finally {
                this.getGridServiceManagerRemoved().remove(removed);
            }
        }
        final CountDownLatch latch = new CountDownLatch(numberOfGridServiceManagers);
        GridServiceManagerAddedEventListener added = new GridServiceManagerAddedEventListener(){

            @Override
            public void gridServiceManagerAdded(GridServiceManager gridServiceManager) {
                latch.countDown();
            }
        };
        this.getGridServiceManagerAdded().add(added);
        try {
            boolean e = latch.await(timeout, timeUnit);
            return e;
        }
        catch (InterruptedException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            this.getGridServiceManagerAdded().remove(added);
        }
    }

    @Override
    public ProcessingUnit deploy(ProcessingUnitDeployment deployment) {
        GridServiceManager gridServiceManager = this.getGridServiceManager();
        if (gridServiceManager == null) {
            throw new AdminException("No Grid Service Manager found to deploy [" + deployment.getProcessingUnit() + "]");
        }
        return gridServiceManager.deploy(deployment);
    }

    @Override
    public ProcessingUnit deploy(ProcessingUnitDeployment deployment, long timeout, TimeUnit timeUnit) {
        GridServiceManager gridServiceManager = this.getGridServiceManager();
        if (gridServiceManager == null) {
            throw new AdminException("No Grid Service Manager found to deploy [" + deployment.getProcessingUnit() + "]");
        }
        return gridServiceManager.deploy(deployment, timeout, timeUnit);
    }

    @Override
    public ProcessingUnit deploy(SpaceDeployment deployment) {
        GridServiceManager gridServiceManager = this.getGridServiceManager();
        if (gridServiceManager == null) {
            throw new AdminException("No Grid Service Manager found to deploy [" + deployment.getSpaceName() + "]");
        }
        return gridServiceManager.deploy(deployment);
    }

    @Override
    public ProcessingUnit deploy(SpaceDeployment deployment, long timeout, TimeUnit timeUnit) {
        GridServiceManager gridServiceManager = this.getGridServiceManager();
        if (gridServiceManager == null) {
            throw new AdminException("No Grid Service Manager found to deploy [" + deployment.getSpaceName() + "]");
        }
        return gridServiceManager.deploy(deployment, timeout, timeUnit);
    }

    @Override
    public ProcessingUnit deploy(MemcachedDeployment deployment, long timeout, TimeUnit timeUnit) {
        GridServiceManager gridServiceManager = this.getGridServiceManager();
        if (gridServiceManager == null) {
            throw new AdminException("No Grid Service Manager found to deploy [" + deployment.getSpaceUrl() + "]");
        }
        return gridServiceManager.deploy(deployment, timeout, timeUnit);
    }

    @Override
    public ProcessingUnit deploy(MemcachedDeployment deployment) {
        GridServiceManager gridServiceManager = this.getGridServiceManager();
        if (gridServiceManager == null) {
            throw new AdminException("No Grid Service Manager found to deploy [" + deployment.getSpaceUrl() + "]");
        }
        return gridServiceManager.deploy(deployment);
    }

    @Override
    public ProcessingUnit deploy(ElasticSpaceDeployment deployment) throws ProcessingUnitAlreadyDeployedException {
        GridServiceManager gridServiceManager = this.getGridServiceManager();
        if (gridServiceManager == null) {
            throw new AdminException("No Grid Service Manager found to deploy [" + deployment.create().getProcessingUnit() + "]");
        }
        return gridServiceManager.deploy(deployment);
    }

    @Override
    public ProcessingUnit deploy(ElasticSpaceDeployment deployment, long timeout, TimeUnit timeUnit) throws ProcessingUnitAlreadyDeployedException {
        GridServiceManager gridServiceManager = this.getGridServiceManager();
        if (gridServiceManager == null) {
            throw new AdminException("No Grid Service Manager found to deploy [" + deployment.create().getProcessingUnit() + "]");
        }
        return gridServiceManager.deploy(deployment, timeout, timeUnit);
    }

    @Override
    public ProcessingUnit deploy(ElasticStatefulProcessingUnitDeployment deployment) throws ProcessingUnitAlreadyDeployedException {
        return this.deploy(deployment, this.admin.getDefaultTimeout(), this.admin.getDefaultTimeoutTimeUnit());
    }

    @Override
    public ProcessingUnit deploy(ElasticStatefulProcessingUnitDeployment deployment, long timeout, TimeUnit timeUnit) throws ProcessingUnitAlreadyDeployedException {
        GridServiceManager gridServiceManager = this.getGridServiceManager();
        if (gridServiceManager == null) {
            throw new AdminException("No Grid Service Manager found to deploy [" + deployment.create().getProcessingUnit() + "]");
        }
        return gridServiceManager.deploy(deployment, timeout, timeUnit);
    }

    @Override
    public ProcessingUnit deploy(ElasticStatelessProcessingUnitDeployment deployment) throws ProcessingUnitAlreadyDeployedException {
        return this.deploy(deployment, this.admin.getDefaultTimeout(), this.admin.getDefaultTimeoutTimeUnit());
    }

    @Override
    public ProcessingUnit deploy(ElasticStatelessProcessingUnitDeployment deployment, long timeout, TimeUnit timeUnit) throws ProcessingUnitAlreadyDeployedException {
        GridServiceManager gridServiceManager = this.getGridServiceManager();
        if (gridServiceManager == null) {
            throw new AdminException("No Grid Service Manager found to deploy [" + deployment.create().getProcessingUnit() + "]");
        }
        return gridServiceManager.deploy(deployment, timeout, timeUnit);
    }

    @Override
    public Application deploy(ApplicationDeployment deployment) throws ApplicationAlreadyDeployedException, ProcessingUnitAlreadyDeployedException {
        return this.deploy(deployment, this.admin.getDefaultTimeout(), this.admin.getDefaultTimeoutTimeUnit());
    }

    @Override
    public Application deploy(ApplicationDeployment deployment, long timeout, TimeUnit timeUnit) throws ApplicationAlreadyDeployedException, ProcessingUnitAlreadyDeployedException {
        GridServiceManager gridServiceManager = this.getGridServiceManager();
        if (gridServiceManager == null) {
            throw new AdminException("No Grid Service Manager found to deploy [" + deployment.create().getName() + "]");
        }
        return gridServiceManager.deploy(deployment, timeout, timeUnit);
    }

    private GridServiceManager getGridServiceManager() {
        Iterator<GridServiceManager> it = this.iterator();
        if (it.hasNext()) {
            return it.next();
        }
        return null;
    }

    @Override
    public void addLifecycleListener(GridServiceManagerLifecycleEventListener eventListener) {
        this.getGridServiceManagerAdded().add(eventListener);
        this.getGridServiceManagerRemoved().add(eventListener);
    }

    @Override
    public void removeLifecycleListener(GridServiceManagerLifecycleEventListener eventListener) {
        this.getGridServiceManagerAdded().remove(eventListener);
        this.getGridServiceManagerRemoved().remove(eventListener);
    }

    @Override
    public Iterator<GridServiceManager> iterator() {
        return Collections.unmodifiableCollection(this.getUids().values()).iterator();
    }

    @Override
    public void addGridServiceManager(InternalGridServiceManager gridServiceManager) {
        this.assertStateChangePermitted();
        if (gridServiceManager == null) {
            throw new IllegalArgumentException("gridServiceManager cannot be null");
        }
        GridServiceManager existingGSM = this.gridServiceManagersByUID.put(gridServiceManager.getUid(), gridServiceManager);
        if (existingGSM == null && this.accept(gridServiceManager)) {
            this.gridServiceManagerAddedEventManager.gridServiceManagerAdded(gridServiceManager);
        }
    }

    @Override
    public InternalGridServiceManager removeGridServiceManager(String uid) {
        this.assertStateChangePermitted();
        InternalGridServiceManager existingGSM = (InternalGridServiceManager)this.gridServiceManagersByUID.remove(uid);
        if (existingGSM != null && this.accept(existingGSM)) {
            this.gridServiceManagerRemovedEventManager.gridServiceManagerRemoved(existingGSM);
        }
        return existingGSM;
    }

    @Override
    public InternalGridServiceManager replaceGridServiceManager(InternalGridServiceManager gridServiceManager) {
        this.assertStateChangePermitted();
        return (InternalGridServiceManager)this.gridServiceManagersByUID.put(gridServiceManager.getUid(), gridServiceManager);
    }

    @Override
    public DumpResult generateDump(String cause, Map<String, Object> context) throws AdminException {
        return this.generateDump(cause, context, null);
    }

    @Override
    public DumpResult generateDump(String cause, Map<String, Object> context, String ... processor) throws AdminException {
        CompoundDumpResult dumpResult = new CompoundDumpResult();
        for (GridServiceManager gsm : this) {
            dumpResult.add(gsm.generateDump(cause, context, processor));
        }
        return dumpResult;
    }

    private void assertStateChangePermitted() {
        this.admin.assertStateChangesPermitted();
    }

    @Override
    public boolean undeployProcessingUnitsAndWait(ProcessingUnit[] processingUnits, long timeout, TimeUnit timeUnit) {
        if (processingUnits.length == 0) {
            return true;
        }
        long end = SystemTime.timeMillis() + timeUnit.toMillis(timeout);
        InternalGridServiceManager gridServiceManager = (InternalGridServiceManager)this.waitForAtLeastOne(timeout, timeUnit);
        if (gridServiceManager == null) {
            throw new AdminException("Timeout waiting for Grid Service Manager when undeploying [" + processingUnits[0].getName() + "]. Timeout is " + timeout + " " + (Object)((Object)timeUnit));
        }
        long remaining = Math.max(0L, end - SystemTime.timeMillis());
        return gridServiceManager.undeployProcessingUnitsAndWait(processingUnits, remaining, TimeUnit.MILLISECONDS);
    }

    @Override
    public ProcessingUnit deploy(Application application, ProcessingUnitDeploymentTopology puDeploymentTopology, long timeout, TimeUnit timeUnit) {
        InternalGridServiceManager gridServiceManager = (InternalGridServiceManager)this.getGridServiceManager();
        if (gridServiceManager == null) {
            throw new AdminException("Cannot deploy processing unit since no Grid Service Manager was discovered.");
        }
        return gridServiceManager.deploy(application, puDeploymentTopology, timeout, timeUnit);
    }

    @Override
    public Application deploy(ApplicationConfig applicationConfig) {
        InternalGridServiceManager gridServiceManager = (InternalGridServiceManager)this.getGridServiceManager();
        if (gridServiceManager == null) {
            throw new AdminException("No Grid Service Manager found to deploy [" + applicationConfig.getName() + "]");
        }
        return gridServiceManager.deploy(applicationConfig);
    }

    @Override
    public Application deploy(ApplicationConfig applicationConfig, long timeout, TimeUnit timeUnit) throws ApplicationAlreadyDeployedException, ProcessingUnitAlreadyDeployedException {
        InternalGridServiceManager gridServiceManager = (InternalGridServiceManager)this.getGridServiceManager();
        if (gridServiceManager == null) {
            throw new AdminException("No Grid Service Manager found to deploy [" + applicationConfig.getName() + "]");
        }
        return gridServiceManager.deploy(applicationConfig, timeout, timeUnit);
    }

    private boolean accept(InternalGridServiceManager gridServiceManager) {
        if (gridServiceManager == null) {
            throw new IllegalArgumentException("gridServiceManager cannot be null");
        }
        JVMDetails jvmDetails = gridServiceManager.getJVMDetails();
        boolean isAcceptJvm = AdminFilterHelper.acceptJvm(this.admin.getAdminFilter(), jvmDetails);
        return isAcceptJvm;
    }
}

