/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.admin.internal.gsm.events;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.openspaces.admin.gsm.GridServiceManager;
import org.openspaces.admin.gsm.events.GridServiceManagerAddedEventListener;
import org.openspaces.admin.internal.admin.InternalAdmin;
import org.openspaces.admin.internal.gsm.InternalGridServiceManagers;
import org.openspaces.admin.internal.gsm.events.ClosureGridServiceManagerAddedEventListener;
import org.openspaces.admin.internal.gsm.events.InternalGridServiceManagerAddedEventManager;
import org.openspaces.admin.internal.support.GroovyHelper;

public class DefaultGridServiceManagerAddedEventManager
implements InternalGridServiceManagerAddedEventManager {
    private final InternalGridServiceManagers gridServiceManagers;
    private final InternalAdmin admin;
    private final List<GridServiceManagerAddedEventListener> listeners = new CopyOnWriteArrayList<GridServiceManagerAddedEventListener>();

    public DefaultGridServiceManagerAddedEventManager(InternalGridServiceManagers gridServiceManagers) {
        this.gridServiceManagers = gridServiceManagers;
        this.admin = (InternalAdmin)gridServiceManagers.getAdmin();
    }

    @Override
    public void gridServiceManagerAdded(final GridServiceManager gridServiceManager) {
        for (final GridServiceManagerAddedEventListener listener : this.listeners) {
            this.admin.pushEvent(listener, new Runnable(){

                @Override
                public void run() {
                    listener.gridServiceManagerAdded(gridServiceManager);
                }
            });
        }
    }

    @Override
    public void add(final GridServiceManagerAddedEventListener eventListener, boolean includeExisting) {
        if (includeExisting) {
            this.admin.raiseEvent(eventListener, new Runnable(){

                @Override
                public void run() {
                    for (GridServiceManager gridServiceManager : DefaultGridServiceManagerAddedEventManager.this.gridServiceManagers) {
                        eventListener.gridServiceManagerAdded(gridServiceManager);
                    }
                }
            });
        }
        this.listeners.add(eventListener);
    }

    @Override
    public void add(GridServiceManagerAddedEventListener eventListener) {
        this.add(eventListener, true);
    }

    @Override
    public void remove(GridServiceManagerAddedEventListener eventListener) {
        this.listeners.remove(eventListener);
    }

    public void plus(Object eventListener) {
        if (GroovyHelper.isClosure(eventListener)) {
            this.add(new ClosureGridServiceManagerAddedEventListener(eventListener));
        } else {
            this.add((GridServiceManagerAddedEventListener)eventListener);
        }
    }

    public void leftShift(Object eventListener) {
        this.plus(eventListener);
    }

    public void minus(Object eventListener) {
        if (GroovyHelper.isClosure(eventListener)) {
            this.remove(new ClosureGridServiceManagerAddedEventListener(eventListener));
        } else {
            this.remove((GridServiceManagerAddedEventListener)eventListener);
        }
    }

    public void rightShift(Object eventListener) {
        this.minus(eventListener);
    }
}

