/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.admin.internal.gsm.events;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.openspaces.admin.gsm.GridServiceManager;
import org.openspaces.admin.gsm.events.GridServiceManagerRemovedEventListener;
import org.openspaces.admin.internal.admin.InternalAdmin;
import org.openspaces.admin.internal.gsm.InternalGridServiceManagers;
import org.openspaces.admin.internal.gsm.events.ClosureGridServiceManagerRemovedEventListener;
import org.openspaces.admin.internal.gsm.events.InternalGridServiceManagerRemovedEventManager;
import org.openspaces.admin.internal.support.GroovyHelper;

public class DefaultGridServiceManagerRemovedEventManager
implements InternalGridServiceManagerRemovedEventManager {
    private final InternalGridServiceManagers gridServiceManagers;
    private final InternalAdmin admin;
    private final List<GridServiceManagerRemovedEventListener> listeners = new CopyOnWriteArrayList<GridServiceManagerRemovedEventListener>();

    public DefaultGridServiceManagerRemovedEventManager(InternalGridServiceManagers gridServiceManagers) {
        this.gridServiceManagers = gridServiceManagers;
        this.admin = (InternalAdmin)gridServiceManagers.getAdmin();
    }

    @Override
    public void gridServiceManagerRemoved(final GridServiceManager GridServiceManager2) {
        for (final GridServiceManagerRemovedEventListener listener : this.listeners) {
            this.admin.pushEvent(listener, new Runnable(){

                @Override
                public void run() {
                    listener.gridServiceManagerRemoved(GridServiceManager2);
                }
            });
        }
    }

    @Override
    public void add(GridServiceManagerRemovedEventListener eventListener) {
        this.listeners.add(eventListener);
    }

    @Override
    public void remove(GridServiceManagerRemovedEventListener eventListener) {
        this.listeners.remove(eventListener);
    }

    public void plus(Object eventListener) {
        if (GroovyHelper.isClosure(eventListener)) {
            this.add(new ClosureGridServiceManagerRemovedEventListener(eventListener));
        } else {
            this.add((GridServiceManagerRemovedEventListener)eventListener);
        }
    }

    public void leftShift(Object eventListener) {
        this.plus(eventListener);
    }

    public void minus(Object eventListener) {
        if (GroovyHelper.isClosure(eventListener)) {
            this.remove(new ClosureGridServiceManagerRemovedEventListener(eventListener));
        } else {
            this.remove((GridServiceManagerRemovedEventListener)eventListener);
        }
    }

    public void rightShift(Object eventListener) {
        this.minus(eventListener);
    }
}

