/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.admin.internal.lus;

import com.gigaspaces.internal.dump.InternalDumpProvider;
import com.gigaspaces.internal.jvm.JVMDetails;
import com.gigaspaces.internal.jvm.JVMInfoProvider;
import com.gigaspaces.internal.jvm.JVMStatistics;
import com.gigaspaces.internal.log.InternalLogHelper;
import com.gigaspaces.internal.log.InternalLogProvider;
import com.gigaspaces.internal.os.OSDetails;
import com.gigaspaces.internal.os.OSInfoProvider;
import com.gigaspaces.internal.os.OSStatistics;
import com.gigaspaces.log.LogEntries;
import com.gigaspaces.log.LogEntryMatcher;
import com.gigaspaces.log.LogProcessType;
import com.gigaspaces.lrmi.LRMIMonitoringDetails;
import com.gigaspaces.lrmi.nio.info.NIODetails;
import com.gigaspaces.lrmi.nio.info.NIOInfoProvider;
import com.gigaspaces.lrmi.nio.info.NIOStatistics;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.Map;
import net.jini.core.discovery.LookupLocator;
import net.jini.core.lookup.ServiceID;
import net.jini.core.lookup.ServiceRegistrar;
import org.openspaces.admin.AdminException;
import org.openspaces.admin.dump.DumpResult;
import org.openspaces.admin.internal.admin.InternalAdmin;
import org.openspaces.admin.internal.dump.InternalDumpResult;
import org.openspaces.admin.internal.lus.InternalLookupService;
import org.openspaces.admin.internal.support.AbstractAgentGridComponent;

public class DefaultLookupService
extends AbstractAgentGridComponent
implements InternalLookupService {
    private final ServiceRegistrar registrar;
    private final ServiceID serviceID;

    public DefaultLookupService(ServiceRegistrar registrar, ServiceID serviceID, InternalAdmin admin, int agentId, String agentUid, JVMDetails jvmDetails) {
        super(admin, agentId, agentUid, jvmDetails);
        this.registrar = registrar;
        this.serviceID = serviceID;
    }

    @Override
    public String getUid() {
        return this.getServiceID().toString();
    }

    @Override
    public ServiceID getServiceID() {
        return this.serviceID;
    }

    @Override
    public String[] getLookupGroups() {
        try {
            return this.registrar.getGroups();
        }
        catch (RemoteException e) {
            throw new AdminException("Failed to get groups", e);
        }
    }

    @Override
    public LookupLocator getLookupLocator() {
        try {
            return this.registrar.getLocator();
        }
        catch (RemoteException e) {
            throw new AdminException("Failed to get locator", e);
        }
    }

    @Override
    public ServiceRegistrar getRegistrar() {
        return this.registrar;
    }

    @Override
    public LogEntries logEntries(LogEntryMatcher matcher) throws AdminException {
        if (this.getGridServiceAgent() != null) {
            return this.getGridServiceAgent().logEntries(LogProcessType.LUS, this.getVirtualMachine().getDetails().getPid(), matcher);
        }
        return this.logEntriesDirect(matcher);
    }

    @Override
    public LogEntries logEntriesDirect(LogEntryMatcher matcher) throws AdminException {
        try {
            return InternalLogHelper.clientSideProcess((LogEntryMatcher)matcher, (LogEntries)((InternalLogProvider)this.registrar.getRegistrar()).logEntriesDirect(matcher));
        }
        catch (IOException e) {
            throw new AdminException("Failed to get log", e);
        }
    }

    @Override
    public void reloadMetricConfiguration() throws AdminException {
        try {
            ((InternalDumpProvider)this.registrar.getRegistrar()).reloadMetricConfiguration();
        }
        catch (RemoteException e) {
            throw new AdminException("Failed to reload metric configuration", e);
        }
    }

    @Override
    public DumpResult generateDump(String cause, Map<String, Object> context) throws AdminException {
        try {
            return new InternalDumpResult(this, (InternalDumpProvider)this.registrar.getRegistrar(), ((InternalDumpProvider)this.registrar.getRegistrar()).generateDump(cause, context));
        }
        catch (Exception e) {
            throw new AdminException("Failed to generate dump", e);
        }
    }

    @Override
    public DumpResult generateDump(String cause, Map<String, Object> context, String ... processors) throws AdminException {
        try {
            return new InternalDumpResult(this, (InternalDumpProvider)this.registrar.getRegistrar(), ((InternalDumpProvider)this.registrar.getRegistrar()).generateDump(cause, context, processors));
        }
        catch (Exception e) {
            throw new AdminException("Failed to generate dump", e);
        }
    }

    @Override
    public NIODetails getNIODetails() throws RemoteException {
        return ((NIOInfoProvider)this.registrar.getRegistrar()).getNIODetails();
    }

    @Override
    public NIOStatistics getNIOStatistics() throws RemoteException {
        return ((NIOInfoProvider)this.registrar.getRegistrar()).getNIOStatistics();
    }

    @Override
    public void enableLRMIMonitoring() throws RemoteException {
        ((NIOInfoProvider)this.registrar.getRegistrar()).enableLRMIMonitoring();
    }

    @Override
    public void disableLRMIMonitoring() throws RemoteException {
        ((NIOInfoProvider)this.registrar.getRegistrar()).disableLRMIMonitoring();
    }

    @Override
    public LRMIMonitoringDetails fetchLRMIMonitoringDetails() throws RemoteException {
        return ((NIOInfoProvider)this.registrar.getRegistrar()).fetchLRMIMonitoringDetails();
    }

    @Override
    public long getCurrentTimeInMillis() throws RemoteException {
        return ((OSInfoProvider)this.registrar.getRegistrar()).getCurrentTimestamp();
    }

    @Override
    public OSDetails getOSDetails() throws RemoteException {
        return ((OSInfoProvider)this.registrar.getRegistrar()).getOSDetails();
    }

    @Override
    public OSStatistics getOSStatistics() throws RemoteException {
        return ((OSInfoProvider)this.registrar.getRegistrar()).getOSStatistics();
    }

    @Override
    public JVMStatistics getJVMStatistics() throws RemoteException {
        return ((JVMInfoProvider)this.registrar.getRegistrar()).getJVMStatistics();
    }

    @Override
    public void runGc() throws RemoteException {
        ((JVMInfoProvider)this.registrar.getRegistrar()).runGc();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultLookupService that = (DefaultLookupService)o;
        return this.serviceID.equals((Object)that.serviceID);
    }

    public int hashCode() {
        return this.serviceID.hashCode();
    }
}

