/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.admin.internal.lus;

import com.j_spaces.kernel.SizeConcurrentHashMap;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.openspaces.admin.Admin;
import org.openspaces.admin.AdminException;
import org.openspaces.admin.dump.CompoundDumpResult;
import org.openspaces.admin.dump.DumpResult;
import org.openspaces.admin.internal.admin.InternalAdmin;
import org.openspaces.admin.internal.lus.InternalLookupService;
import org.openspaces.admin.internal.lus.InternalLookupServices;
import org.openspaces.admin.internal.lus.events.DefaultLookupServiceAddedEventManager;
import org.openspaces.admin.internal.lus.events.DefaultLookupServiceRemovedEventManager;
import org.openspaces.admin.internal.lus.events.InternalLookupServiceAddedEventManager;
import org.openspaces.admin.internal.lus.events.InternalLookupServiceRemovedEventManager;
import org.openspaces.admin.lus.LookupService;
import org.openspaces.admin.lus.events.LookupServiceAddedEventListener;
import org.openspaces.admin.lus.events.LookupServiceAddedEventManager;
import org.openspaces.admin.lus.events.LookupServiceLifecycleEventListener;
import org.openspaces.admin.lus.events.LookupServiceRemovedEventListener;
import org.openspaces.admin.lus.events.LookupServiceRemovedEventManager;

public class DefaultLookupServices
implements InternalLookupServices {
    private final InternalAdmin admin;
    private final Map<String, LookupService> lookupServiceMap = new SizeConcurrentHashMap();
    private final InternalLookupServiceAddedEventManager lookupServiceAddedEventManager;
    private final InternalLookupServiceRemovedEventManager lookupServiceRemovedEventManager;

    public DefaultLookupServices(InternalAdmin admin) {
        this.admin = admin;
        this.lookupServiceAddedEventManager = new DefaultLookupServiceAddedEventManager(this);
        this.lookupServiceRemovedEventManager = new DefaultLookupServiceRemovedEventManager(this);
    }

    @Override
    public Admin getAdmin() {
        return this.admin;
    }

    @Override
    public LookupService[] getLookupServices() {
        return this.lookupServiceMap.values().toArray(new InternalLookupService[0]);
    }

    @Override
    public Iterator<LookupService> iterator() {
        return Collections.unmodifiableCollection(this.lookupServiceMap.values()).iterator();
    }

    @Override
    public LookupService getLookupServiceByUID(String id) {
        return this.lookupServiceMap.get(id);
    }

    @Override
    public Map<String, LookupService> getUids() {
        return Collections.unmodifiableMap(this.lookupServiceMap);
    }

    @Override
    public int getSize() {
        return this.lookupServiceMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.lookupServiceMap.isEmpty();
    }

    @Override
    public boolean waitFor(int numberOfLookupServices) {
        return this.waitFor(numberOfLookupServices, this.admin.getDefaultTimeout(), this.admin.getDefaultTimeoutTimeUnit());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean waitFor(int numberOfLookupServices, long timeout, TimeUnit timeUnit) {
        if (numberOfLookupServices == 0) {
            final CountDownLatch latch = new CountDownLatch(this.getSize());
            LookupServiceRemovedEventListener removed = new LookupServiceRemovedEventListener(){

                @Override
                public void lookupServiceRemoved(LookupService lookupService) {
                    latch.countDown();
                }
            };
            this.getLookupServiceRemoved().add(removed);
            try {
                boolean bl = latch.await(timeout, timeUnit);
                return bl;
            }
            catch (InterruptedException e) {
                boolean bl = false;
                return bl;
            }
            finally {
                this.getLookupServiceRemoved().remove(removed);
            }
        }
        final CountDownLatch latch = new CountDownLatch(numberOfLookupServices);
        LookupServiceAddedEventListener added = new LookupServiceAddedEventListener(){

            @Override
            public void lookupServiceAdded(LookupService lookupService) {
                latch.countDown();
            }
        };
        this.getLookupServiceAdded().add(added);
        try {
            boolean e = latch.await(timeout, timeUnit);
            return e;
        }
        catch (InterruptedException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            this.getLookupServiceAdded().remove(added);
        }
    }

    @Override
    public void addLifecycleListener(LookupServiceLifecycleEventListener eventListener) {
        this.getLookupServiceAdded().add(eventListener);
        this.getLookupServiceRemoved().add(eventListener);
    }

    @Override
    public void removeLifecycleListener(LookupServiceLifecycleEventListener eventListener) {
        this.getLookupServiceAdded().remove(eventListener);
        this.getLookupServiceRemoved().remove(eventListener);
    }

    @Override
    public void addLookupService(InternalLookupService lookupService) {
        this.assertStateChangesPermitted();
        LookupService existingLookupService = this.lookupServiceMap.put(lookupService.getUid(), lookupService);
        if (existingLookupService == null) {
            this.lookupServiceAddedEventManager.lookupServiceAdded(lookupService);
        }
    }

    @Override
    public InternalLookupService removeLookupService(String UID) {
        this.assertStateChangesPermitted();
        InternalLookupService existingLookupService = (InternalLookupService)this.lookupServiceMap.remove(UID);
        if (existingLookupService != null) {
            this.lookupServiceRemovedEventManager.lookupServiceRemoved(existingLookupService);
        }
        return existingLookupService;
    }

    @Override
    public LookupServiceAddedEventManager getLookupServiceAdded() {
        return this.lookupServiceAddedEventManager;
    }

    @Override
    public LookupServiceRemovedEventManager getLookupServiceRemoved() {
        return this.lookupServiceRemovedEventManager;
    }

    @Override
    public DumpResult generateDump(String cause, Map<String, Object> context) throws AdminException {
        return this.generateDump(cause, context, null);
    }

    @Override
    public DumpResult generateDump(String cause, Map<String, Object> context, String ... processor) throws AdminException {
        CompoundDumpResult dumpResult = new CompoundDumpResult();
        for (LookupService lus : this) {
            dumpResult.add(lus.generateDump(cause, context, processor));
        }
        return dumpResult;
    }

    private void assertStateChangesPermitted() {
        this.admin.assertStateChangesPermitted();
    }
}

