/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.admin.internal.lus.events;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.openspaces.admin.internal.admin.InternalAdmin;
import org.openspaces.admin.internal.lus.InternalLookupServices;
import org.openspaces.admin.internal.lus.events.ClosureLookupServiceAddedEventListener;
import org.openspaces.admin.internal.lus.events.InternalLookupServiceAddedEventManager;
import org.openspaces.admin.internal.support.GroovyHelper;
import org.openspaces.admin.lus.LookupService;
import org.openspaces.admin.lus.events.LookupServiceAddedEventListener;

public class DefaultLookupServiceAddedEventManager
implements InternalLookupServiceAddedEventManager {
    private final InternalLookupServices lookupServices;
    private final InternalAdmin admin;
    private final List<LookupServiceAddedEventListener> listeners = new CopyOnWriteArrayList<LookupServiceAddedEventListener>();

    public DefaultLookupServiceAddedEventManager(InternalLookupServices lookupServices) {
        this.lookupServices = lookupServices;
        this.admin = (InternalAdmin)lookupServices.getAdmin();
    }

    @Override
    public void lookupServiceAdded(final LookupService lookupService) {
        for (final LookupServiceAddedEventListener listener : this.listeners) {
            this.admin.pushEvent(listener, new Runnable(){

                @Override
                public void run() {
                    listener.lookupServiceAdded(lookupService);
                }
            });
        }
    }

    @Override
    public void add(final LookupServiceAddedEventListener eventListener, boolean includeExisting) {
        if (includeExisting) {
            this.admin.raiseEvent(eventListener, new Runnable(){

                @Override
                public void run() {
                    for (LookupService lookupService : DefaultLookupServiceAddedEventManager.this.lookupServices) {
                        eventListener.lookupServiceAdded(lookupService);
                    }
                }
            });
        }
        this.listeners.add(eventListener);
    }

    @Override
    public void add(LookupServiceAddedEventListener eventListener) {
        this.add(eventListener, true);
    }

    @Override
    public void remove(LookupServiceAddedEventListener eventListener) {
        this.listeners.remove(eventListener);
    }

    public void plus(Object eventListener) {
        if (GroovyHelper.isClosure(eventListener)) {
            this.add(new ClosureLookupServiceAddedEventListener(eventListener));
        } else {
            this.add((LookupServiceAddedEventListener)eventListener);
        }
    }

    public void leftShift(Object eventListener) {
        this.plus(eventListener);
    }

    public void minus(Object eventListener) {
        if (GroovyHelper.isClosure(eventListener)) {
            this.remove(new ClosureLookupServiceAddedEventListener(eventListener));
        } else {
            this.remove((LookupServiceAddedEventListener)eventListener);
        }
    }

    public void rightShift(Object eventListener) {
        this.minus(eventListener);
    }
}

