/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.admin.internal.lus.events;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.openspaces.admin.internal.admin.InternalAdmin;
import org.openspaces.admin.internal.lus.InternalLookupServices;
import org.openspaces.admin.internal.lus.events.ClosureLookupServiceRemovedEventListener;
import org.openspaces.admin.internal.lus.events.InternalLookupServiceRemovedEventManager;
import org.openspaces.admin.internal.support.GroovyHelper;
import org.openspaces.admin.lus.LookupService;
import org.openspaces.admin.lus.events.LookupServiceRemovedEventListener;

public class DefaultLookupServiceRemovedEventManager
implements InternalLookupServiceRemovedEventManager {
    private final InternalLookupServices lookupServices;
    private final InternalAdmin admin;
    private final List<LookupServiceRemovedEventListener> listeners = new CopyOnWriteArrayList<LookupServiceRemovedEventListener>();

    public DefaultLookupServiceRemovedEventManager(InternalLookupServices lookupServices) {
        this.lookupServices = lookupServices;
        this.admin = (InternalAdmin)lookupServices.getAdmin();
    }

    @Override
    public void lookupServiceRemoved(final LookupService lookupService) {
        for (final LookupServiceRemovedEventListener listener : this.listeners) {
            this.admin.pushEvent(listener, new Runnable(){

                @Override
                public void run() {
                    listener.lookupServiceRemoved(lookupService);
                }
            });
        }
    }

    @Override
    public void add(LookupServiceRemovedEventListener eventListener) {
        this.listeners.add(eventListener);
    }

    @Override
    public void remove(LookupServiceRemovedEventListener eventListener) {
        this.listeners.remove(eventListener);
    }

    public void plus(Object eventListener) {
        if (GroovyHelper.isClosure(eventListener)) {
            this.add(new ClosureLookupServiceRemovedEventListener(eventListener));
        } else {
            this.add((LookupServiceRemovedEventListener)eventListener);
        }
    }

    public void leftShift(Object eventListener) {
        this.plus(eventListener);
    }

    public void minus(Object eventListener) {
        if (GroovyHelper.isClosure(eventListener)) {
            this.remove(new ClosureLookupServiceRemovedEventListener(eventListener));
        } else {
            this.remove((LookupServiceRemovedEventListener)eventListener);
        }
    }

    public void rightShift(Object eventListener) {
        this.minus(eventListener);
    }
}

